/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.internal.preferences.DefaultPreferences;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class BundleDefaultPreferences
extends EclipsePreferences {
    private static final Set<String> LOADED_NODES = ConcurrentHashMap.newKeySet();
    private final String qualifier;
    private final int segmentCount;
    private IEclipsePreferences loadLevel;

    public BundleDefaultPreferences() {
        this(null, null);
    }

    private BundleDefaultPreferences(EclipsePreferences parent, String name) {
        super(parent, name);
        IPath path = IPath.fromOSString((String)this.absolutePath());
        this.segmentCount = path.segmentCount();
        this.qualifier = this.segmentCount > 1 && "bundle_defaults".equals(path.segment(0)) ? path.segment(1) : null;
    }

    @Override
    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            IEclipsePreferences node = this;
            int i = 2;
            while (i < this.segmentCount) {
                node = (IEclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    @Override
    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return LOADED_NODES.contains(node.name());
    }

    @Override
    protected void loaded() {
        LOADED_NODES.add(this.name());
    }

    @Override
    protected void load() {
        String relativePath = DefaultPreferences.getScopeRelativePath(this.absolutePath());
        if (relativePath != null) {
            PreferencesService.getDefault().getRootNode().node("default").node(relativePath);
        }
    }

    @Override
    protected EclipsePreferences internalCreate(EclipsePreferences nodeParent, String nodeName, Object context) {
        return new BundleDefaultPreferences(nodeParent, nodeName);
    }
}

