/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.sync.tests;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.oomph.setup.internal.sync.DataProvider;
import org.eclipse.oomph.setup.internal.sync.Synchronization;
import org.eclipse.oomph.setup.sync.tests.TestWorkstation;
import org.eclipse.oomph.tests.AbstractTest;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.junit.FixMethodOrder;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class SynchronizerTests
extends AbstractTest {
    private final Map<Integer, TestWorkstation> workstations = new HashMap<Integer, TestWorkstation>();
    private File sharedPreferences;

    private TestWorkstation WS(int id) throws Exception {
        TestWorkstation workstation = this.workstations.get(id);
        if (workstation == null) {
            workstation = new TestWorkstation(this.sharedPreferences, this.workstations, id);
            this.workstations.put(id, workstation);
        }
        return workstation;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.sharedPreferences = new File(PropertiesUtil.getTmpDir(), "shared-preferences.xml");
        IOUtil.deleteBestEffort((File)this.sharedPreferences, (boolean)false);
        this.workstations.clear();
    }

    public void tearDown() throws Exception {
        IOUtil.deleteBestEffort((File)this.sharedPreferences, (boolean)true);
        super.tearDown();
    }

    @Test
    public void test000() throws Exception {
        this.WS(1).commit().assertCount(0);
    }

    @Test
    public void test001_Set1_Sync1() throws Exception {
        this.WS(1).set("line.numbers", "true").save().commit().assertCount(1).assertSet("line.numbers", "true");
    }

    @Test
    public void test002_Set1_Sync1_Sync2() throws Exception {
        this.WS(1).set("line.numbers", "true").save().commit();
        this.WS(2).commit().assertCount(1).assertSet("line.numbers", "true");
    }

    @Test
    public void test003_Set1_Sync1_Sync2_Sync1() throws Exception {
        this.WS(1).set("line.numbers", "true").save().commit();
        this.WS(2).commit().assertCount(1).assertSet("line.numbers", "true");
        this.WS(1).commit().assertCount(1).assertSet("line.numbers", "true");
    }

    @Test
    public void test004_Set1_Sync1_Set2_Sync2() throws Exception {
        this.WS(1).set("line.numbers", "true").save().commit();
        this.WS(2).set("refresh.resources", "true").save().commit().assertCount(2).assertSet("line.numbers", "true").assertSet("refresh.resources", "true");
    }

    @Test
    public void test005_Set1_Sync1_Set2_Sync2_Sync1() throws Exception {
        this.WS(1).set("line.numbers", "true").save().commit();
        this.WS(2).set("refresh.resources", "true").save().commit().assertCount(2).assertSet("line.numbers", "true").assertSet("refresh.resources", "true");
        this.WS(1).commit().assertCount(2).assertSet("line.numbers", "true").assertSet("refresh.resources", "true");
    }

    @Test
    @Ignore
    public void test006_SameKey_SameValue() throws Exception {
        TestWorkstation.TestSynchronization sync1 = this.WS(1).set("property", "value").save().synchronize();
        this.WS(2).set("property", "value").save().commit().assertCount(1).assertSet("property", "value");
        sync1.commitFail(new TestWorkstation.FailureHandler(){

            @Override
            public void handleFailure(Exception t) throws Exception {
                SynchronizerTests.this.WS(1).commit().assertCount(1).assertSet("property", "value");
            }
        });
        this.WS(2).commit().assertCount(1).assertSet("property", "value");
    }

    @Test
    @Ignore
    public void test007_SameKey_Conflict_Sync() throws Exception {
        TestWorkstation.TestSynchronization sync1 = this.WS(1).set("property", "value1").save().synchronize();
        this.WS(2).set("property", "value2").save().commit().assertCount(1).assertSet("property", "value2");
        sync1.commitFail(new TestWorkstation.FailureHandler.Expect(DataProvider.NotCurrentException.class){

            @Override
            protected void handleFailure() throws Exception {
                SynchronizerTests.this.WS(1).commitFail(new TestWorkstation.FailureHandler.Expect(Synchronization.ConflictException.class));
            }
        });
    }

    @Test
    public void test008_SameKey_Conflict_Pick1() throws Exception {
        this.WS(1).set("property", "value1").save();
        this.WS(2).set("property", "value2").save().commit().assertCount(1).assertSet("property", "value2");
        this.WS(1).synchronize().pickLocal("property").commitAnd().assertCount(1).assertSet("property", "value1");
        this.WS(2).commit().assertCount(1).assertSet("property", "value1");
    }

    @Test
    public void test009_SameKey_Conflict_Pick2() throws Exception {
        this.WS(1).set("property", "value1").save();
        this.WS(2).set("property", "value2").save().commit().assertCount(1).assertSet("property", "value2");
        this.WS(1).synchronize().pickRemote("property").commitAnd().assertCount(1).assertSet("property", "value2");
        this.WS(2).commit().assertCount(1).assertSet("property", "value2");
    }

    @Test
    public void test010_Remove1_Sync1() throws Exception {
        this.WS(1).set("line.numbers", "true").set("refresh.resources", "true").save().commit().assertCount(2).assertSet("line.numbers", "true").assertSet("refresh.resources", "true");
        this.WS(1).remove("line.numbers").save().commit().assertCount(1).assertSet("refresh.resources", "true");
        this.WS(1).remove("refresh.resources").save().commit().assertCount(0);
    }

    @Test
    public void test011_Remove1_Sync1_Sync2() throws Exception {
        this.WS(1).set("line.numbers", "true").set("refresh.resources", "true").save().commit();
        this.WS(2).commit().assertCount(2).assertSet("line.numbers", "true").assertSet("refresh.resources", "true");
        this.WS(1).remove("line.numbers").save().commit().assertCount(1).assertSet("refresh.resources", "true");
        this.WS(2).commit().assertCount(1).assertSet("refresh.resources", "true");
        this.WS(1).remove("refresh.resources").save().commit().assertCount(0);
        this.WS(2).commit().assertCount(0);
    }

    @Test
    public void test012_Remove1_Remove2_Sync1_Sync2() throws Exception {
        this.WS(1).set("line.numbers", "true").set("refresh.resources", "true").save().commit();
        this.WS(2).commit().assertCount(2).assertSet("line.numbers", "true").assertSet("refresh.resources", "true");
        this.WS(1).remove("line.numbers").save().commit().assertCount(1).assertSet("refresh.resources", "true");
        this.WS(2).remove("line.numbers").save().commit().assertCount(1).assertSet("refresh.resources", "true");
    }

    @Test
    public void test013_Exclude() throws Exception {
        this.WS(1).set("line.numbers", "true").save().commit();
        this.WS(2).commit().assertCount(1);
        this.WS(2).set("refresh.resources", "true").save().synchronize().exclude("refresh.resources").commitAnd().assertCount(2).assertSet("line.numbers", "true").assertSet("refresh.resources", "true");
        this.WS(2).assertExcluded("refresh.resources");
        this.WS(1).commit().assertCount(1).assertSet("line.numbers", "true").assertExcluded("refresh.resources");
        this.WS(1).set("refresh.resources", "true").save().commit().assertCount(2).assertSet("line.numbers", "true").assertSet("refresh.resources", "true").assertExcluded("refresh.resources");
    }
}

