/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.wizards;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedColorRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.internal.ui.AccessUtil;
import org.eclipse.oomph.internal.ui.OomphAdapterFactoryContentProvider;
import org.eclipse.oomph.internal.ui.OomphDragAdapter;
import org.eclipse.oomph.internal.ui.OomphEditingDomain;
import org.eclipse.oomph.internal.ui.OomphTransferDelegate;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.InstallationTask;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.wizards.Messages;
import org.eclipse.oomph.setup.ui.wizards.SetupWizardPage;
import org.eclipse.oomph.ui.ButtonBar;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.oomph.ui.PropertiesViewer;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ConfirmationPage
extends SetupWizardPage {
    private static final Object INPUT = new Object();
    private static final Object ROOT_ELEMENT = new Object();
    private CheckboxTreeViewer viewer;
    private TreeViewer childrenViewer;
    private PropertiesViewer propertiesViewer;
    private Button showAllButton;
    private Button offlineButton;
    private Boolean offlineProperty;
    private Button mirrorsButton;
    private Boolean mirrorsProperty;
    private Button overwriteButton;
    private File lastConfigurationLocation;
    private boolean configurationLocationExists;
    private Button switchWorkspaceButton;
    private File currentWorkspaceLocation;
    private File newWorkspaceLocation;
    private boolean someTaskChecked;
    private ControlAdapter columnResizer;
    private AdapterFactoryLabelProvider.ColorProvider labelProvider;
    private EditingDomain domain;

    public ConfirmationPage() {
        super("ConfirmationPage");
        this.setTitle(Messages.ConfirmationPage_title);
        this.setDescription(Messages.ConfirmationPage_description);
    }

    @Override
    protected Control createUI(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)UIUtil.createGridLayout((int)1));
        SashForm horizontalSash = new SashForm(mainComposite, 65792);
        UIUtil.grabVertical((GridData)UIUtil.applyGridData((Control)horizontalSash));
        AccessUtil.setKey((Widget)horizontalSash, (Object)"hsash");
        this.fillCheckPane((Composite)horizontalSash);
        SashForm verticalSash = new SashForm((Composite)horizontalSash, 66048);
        AccessUtil.setKey((Widget)verticalSash, (Object)"vsash");
        this.fillChildrenPane(verticalSash);
        this.propertiesViewer = new PropertiesViewer((Composite)verticalSash, 2048);
        this.createContextMenu((StructuredViewer)this.propertiesViewer);
        this.addHelpCallout((Control)this.propertiesViewer.getTable(), 3);
        this.connectMasterDetail((TreeViewer)this.viewer, (Viewer)this.childrenViewer);
        this.connectMasterDetail((TreeViewer)this.viewer, (Viewer)this.propertiesViewer);
        this.connectMasterDetail(this.childrenViewer, (Viewer)this.propertiesViewer);
        horizontalSash.setWeights(new int[]{3, 2});
        this.setPageComplete(true);
        return mainComposite;
    }

    @Override
    protected void createCheckButtons(ButtonBar buttonBar) {
        this.showAllButton = buttonBar.addCheckButton(Messages.ConfirmationPage_showAllButton_text, Messages.ConfirmationPage_showAllButton_tooltip, false, "showAll");
        this.showAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfirmationPage.this.viewer.refresh();
                if (ConfirmationPage.this.showAllButton.getSelection()) {
                    ConfirmationPage.this.viewer.setExpandedState(ROOT_ELEMENT, true);
                }
            }
        });
        AccessUtil.setKey((Widget)this.showAllButton, (Object)"showAllTasks");
        this.offlineProperty = PropertiesUtil.getBoolean((String)"oomph.setup.offline");
        if (this.offlineProperty == null) {
            this.offlineButton = buttonBar.addCheckButton(Messages.ConfirmationPage_offlineButton_text, Messages.ConfirmationPage_offlineButton_tooltip, false, "toggleCommand:org.eclipse.oomph.ui.ToggleOfflineMode");
            AccessUtil.setKey((Widget)this.offlineButton, (Object)"offline");
        }
        this.mirrorsProperty = PropertiesUtil.getBoolean((String)"eclipse.p2.mirrors");
        if (this.mirrorsProperty == null) {
            this.mirrorsButton = buttonBar.addCheckButton(Messages.ConfirmationPage_mirrorsButton_text, Messages.ConfirmationPage_mirrorsButton_tooltip, true, "mirrors");
            AccessUtil.setKey((Widget)this.mirrorsButton, (Object)"mirrors");
        }
        if (this.getTrigger() == Trigger.BOOTSTRAP) {
            this.overwriteButton = buttonBar.addCheckButton(Messages.ConfirmationPage_overwriteButton_text, Messages.ConfirmationPage_overwriteButton_tooltip, false, null);
            this.overwriteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConfirmationPage.this.validate();
                }
            });
            AccessUtil.setKey((Widget)this.overwriteButton, (Object)"overwrite");
        } else if (this.getWorkspace() != null) {
            this.switchWorkspaceButton = buttonBar.addCheckButton(Messages.ConfirmationPage_switchWorkspaceButton_text, Messages.ConfirmationPage_switchWorkspaceButton_tooltip, false, null);
            this.switchWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConfirmationPage.this.validate();
                }
            });
            AccessUtil.setKey((Widget)this.switchWorkspaceButton, (Object)"switch");
        }
    }

    @Override
    public void enterPage(boolean forward) {
        if (forward) {
            this.initNeededSetupTasks();
            SetupTaskPerformer performer = this.getPerformer();
            this.viewer.setInput(INPUT);
            this.viewer.setSubtreeChecked(ROOT_ELEMENT, true);
            this.someTaskChecked = performer.getTriggeredSetupTasks().size() > 0;
            this.checkOverwrite();
            if (this.switchWorkspaceButton != null) {
                this.newWorkspaceLocation = performer.getWorkspaceLocation();
                URI currentWorkspaceLocationURI = CommonPlugin.resolve((URI)URI.createURI((String)Platform.getInstanceLocation().getURL().toString()));
                if (currentWorkspaceLocationURI.isFile()) {
                    this.currentWorkspaceLocation = new File(currentWorkspaceLocationURI.toFileString());
                    boolean workspaceLocationChanged = this.newWorkspaceLocation != null && !this.newWorkspaceLocation.equals(this.currentWorkspaceLocation);
                    this.switchWorkspaceButton.setVisible(workspaceLocationChanged);
                    this.viewer.getControl().setEnabled(!workspaceLocationChanged);
                }
            }
            this.validate();
            if (this.getTrigger() == Trigger.STARTUP || performer.isSkipConfirmation()) {
                this.gotoNextPage();
            }
        } else {
            HashSet<URI> checkedElements = new HashSet<URI>();
            SetupTaskPerformer performer = this.getPerformer();
            for (SetupTask setupTask : performer.getTriggeredSetupTasks()) {
                if (!this.viewer.getChecked((Object)setupTask)) continue;
                checkedElements.add(EcoreUtil.getURI((EObject)setupTask));
            }
            boolean hasSuccessfullyPerformed = performer.hasSuccessfullyPerformed();
            SetupWizardPage promptPage = (SetupWizardPage)this.getPreviousPage();
            promptPage.enterPage(false);
            promptPage.leavePage(true);
            this.initNeededSetupTasks();
            this.viewer.refresh();
            for (SetupTask setupTask : this.getPerformer().getTriggeredSetupTasks()) {
                if (!checkedElements.contains(EcoreUtil.getURI((EObject)setupTask))) continue;
                this.viewer.setChecked((Object)setupTask, true);
            }
            if (hasSuccessfullyPerformed) {
                this.lastConfigurationLocation = null;
                this.checkOverwrite();
            } else if (this.overwriteButton != null) {
                this.overwriteButton.setSelection(true);
            }
            this.updateCheckStates();
        }
        this.viewer.expandAll();
    }

    private void checkOverwrite() {
        if (this.overwriteButton != null) {
            File configurationLocation = this.getPerformer().getProductConfigurationLocation();
            if (!ObjectUtil.equals((Object)configurationLocation, (Object)this.lastConfigurationLocation)) {
                this.overwriteButton.setSelection(false);
                this.lastConfigurationLocation = configurationLocation;
            }
            this.configurationLocationExists = configurationLocation.exists();
            this.overwriteButton.setVisible(this.configurationLocationExists);
        }
    }

    private void initNeededSetupTasks() {
        try {
            this.getPerformer().initNeededSetupTasks((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception ex) {
            UIUtil.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.open((Throwable)ex);
                }
            });
        }
    }

    @Override
    public void leavePage(boolean forward) {
        if (forward) {
            if (this.switchWorkspaceButton != null && this.switchWorkspaceButton.getSelection()) {
                try {
                    Class<?>[] declaredClasses;
                    Class openWorkspaceActionClass = CommonPlugin.loadClass((String)"org.eclipse.ui.ide", (String)"org.eclipse.ui.internal.ide.actions.OpenWorkspaceAction");
                    Class chooseWorkspaceDataClass = CommonPlugin.loadClass((String)"org.eclipse.ui.ide", (String)"org.eclipse.ui.internal.ide.ChooseWorkspaceData");
                    Constructor chooseWorkspaceDataConstructor = ReflectUtil.getConstructor((Class)chooseWorkspaceDataClass, (Class[])new Class[]{String.class});
                    Object chooseWorkspaceData = chooseWorkspaceDataConstructor.newInstance(this.currentWorkspaceLocation.toString());
                    Object openWorkspaceAction = openWorkspaceActionClass.getConstructors()[0].newInstance(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                    Class<?>[] classArray = declaredClasses = openWorkspaceActionClass.getDeclaredClasses();
                    int n = declaredClasses.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<?> declaredClass = classArray[n2];
                        if ("WorkspaceMRUAction".equals(declaredClass.getSimpleName())) {
                            Constructor workspaceMRUActionConstructor = ReflectUtil.getConstructor(declaredClass, (Class[])new Class[]{openWorkspaceActionClass, String.class, chooseWorkspaceDataClass});
                            Action workspaceMRUAction = (Action)workspaceMRUActionConstructor.newInstance(openWorkspaceAction, this.newWorkspaceLocation.toString(), chooseWorkspaceData);
                            this.saveLocalFiles(this.getPerformer());
                            workspaceMRUAction.run();
                            this.getWizard().performCancel();
                            break;
                        }
                        ++n2;
                    }
                }
                catch (Exception ex) {
                    SetupUIPlugin.INSTANCE.log(ex);
                    ErrorDialog.open((Throwable)ex);
                }
            } else {
                EList neededSetupTasks = null;
                try {
                    SetupTaskPerformer performer = this.getPerformer();
                    performer.setMirrors(this.isMirrors());
                    performer.setOffline(this.isOffline());
                    Set<SetupTask> checkedTasks = this.getCheckedTasks();
                    neededSetupTasks = performer.initNeededSetupTasks((IProgressMonitor)new NullProgressMonitor());
                    neededSetupTasks.retainAll(checkedTasks);
                }
                catch (Exception ex) {
                    if (neededSetupTasks != null) {
                        neededSetupTasks.clear();
                    }
                    SetupUIPlugin.INSTANCE.log(ex);
                    ErrorDialog.open((Throwable)ex);
                }
            }
        }
    }

    private void saveLocalFiles(SetupTaskPerformer performer) throws Exception {
        User user = this.getUser();
        User originalUser = SetupContext.createUserOnly((ResourceSet)this.getResourceSet()).getUser();
        Workspace workspace = this.getWorkspace();
        Workspace copiedWorkspace = (Workspace)EcoreUtil.copy((EObject)workspace);
        CompoundTask workspaceRestrictedCompoundTask = null;
        TreeIterator it = user.eAllContents();
        while (it.hasNext()) {
            CompoundTask compoundTask;
            EObject eObject = (EObject)it.next();
            if (!(eObject instanceof CompoundTask) || !(compoundTask = (CompoundTask)eObject).getRestrictions().contains((Object)workspace)) continue;
            workspaceRestrictedCompoundTask = (CompoundTask)EcoreUtil.copy((EObject)compoundTask);
            break;
        }
        if (workspaceRestrictedCompoundTask == null) {
            throw new Exception("Workspace compound task could not be found");
        }
        URI workspaceResourceURI = URI.createFileURI((String)new File(performer.getWorkspaceLocation(), ".metadata/.plugins/org.eclipse.oomph.setup/workspace.setup").toString());
        Resource workspaceResource = this.getResourceSet().getResourceFactoryRegistry().getFactory(workspaceResourceURI).createResource(workspaceResourceURI);
        workspaceResource.getContents().add((Object)copiedWorkspace);
        BaseUtil.saveEObject((EObject)copiedWorkspace);
        workspaceRestrictedCompoundTask.getRestrictions().clear();
        workspaceRestrictedCompoundTask.getRestrictions().add((Object)copiedWorkspace);
        workspaceRestrictedCompoundTask.setName(this.labelProvider.getText((Object)copiedWorkspace));
        originalUser.getSetupTasks().add((Object)workspaceRestrictedCompoundTask);
        BaseUtil.saveEObject((EObject)originalUser);
    }

    private void fillCheckPane(Composite parent) {
        this.viewer = new CheckboxTreeViewer(parent, 2816);
        this.createContextMenu((StructuredViewer)this.viewer);
        Tree tree = this.viewer.getTree();
        tree.setLayoutData((Object)new GridData(1808));
        this.addHelpCallout((Control)tree, 1);
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return element == ConfirmationPage.this || element == ROOT_ELEMENT;
            }

            public Object getParent(Object element) {
                if (element instanceof SetupTask) {
                    return ROOT_ELEMENT;
                }
                if (element == ROOT_ELEMENT) {
                    return INPUT;
                }
                return null;
            }

            public Object[] getElements(Object element) {
                return this.getChildren(element);
            }

            public Object[] getChildren(Object element) {
                ArrayList<Object> children = new ArrayList<Object>();
                if (element == INPUT) {
                    children.add(ROOT_ELEMENT);
                } else if (element == ROOT_ELEMENT) {
                    children.addAll((Collection<Object>)(ConfirmationPage.this.isShowAll() ? ConfirmationPage.this.getPerformer().getTriggeredSetupTasks() : ConfirmationPage.this.getPerformer().getNeededTasks()));
                }
                return children.toArray();
            }
        });
        final Control viewerControl = this.viewer.getControl();
        Color normalForeground = viewerControl.getForeground();
        Color normalBackground = viewerControl.getBackground();
        final Color disabledForeground = ExtendedColorRegistry.INSTANCE.getColor(normalForeground, normalBackground, (Object)IItemColorProvider.GRAYED_OUT_COLOR);
        ComposedAdapterFactory adapterFactory = this.getAdapterFactory();
        this.labelProvider = new AdapterFactoryLabelProvider.ColorProvider((AdapterFactory)adapterFactory, normalForeground, normalBackground){

            public String getText(Object object) {
                if (object == ROOT_ELEMENT) {
                    InstallationTask installationTask;
                    Trigger trigger = ConfirmationPage.this.getTrigger();
                    String location = null;
                    if (trigger == Trigger.BOOTSTRAP && (installationTask = (InstallationTask)EcoreUtil.getObjectByType((Collection)ConfirmationPage.this.getPerformer().getTriggeredSetupTasks(), (EClassifier)SetupPackage.Literals.INSTALLATION_TASK)) != null) {
                        location = installationTask.getLocation();
                    }
                    return NLS.bind((String)(location == null ? Messages.ConfirmationPage_labelProvider_tasks : Messages.ConfirmationPage_labelProvider_tasks_for), (Object)StringUtil.cap((String)this.getText(trigger).toLowerCase()), location);
                }
                return super.getText(object);
            }

            public Image getImage(Object object) {
                if (object == ROOT_ELEMENT) {
                    Trigger trigger = ConfirmationPage.this.getTrigger();
                    String key = StringUtil.cap((String)trigger.toString().toLowerCase()) + "Trigger";
                    return SetupUIPlugin.INSTANCE.getSWTImage(key);
                }
                return super.getImage(object);
            }

            public Color getForeground(Object object) {
                return !(object instanceof SetupTask) || ConfirmationPage.this.getPerformer().getNeededTasks().contains(object) ? viewerControl.getForeground() : disabledForeground;
            }
        };
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                Object element = event.getElement();
                if (element == ROOT_ELEMENT) {
                    ConfirmationPage.this.viewer.setSubtreeChecked(ROOT_ELEMENT, checked);
                }
                ConfirmationPage.this.updateCheckStates();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element == ROOT_ELEMENT) {
                    ConfirmationPage.this.viewer.setExpandedState(ROOT_ELEMENT, !ConfirmationPage.this.viewer.getExpandedState(ROOT_ELEMENT));
                } else {
                    ConfirmationPage.this.viewer.setCheckedElements(new Object[]{element});
                    ConfirmationPage.this.updateCheckStates();
                }
            }
        });
    }

    private void createContextMenu(final StructuredViewer viewer) {
        if (this.domain == null) {
            this.domain = new OomphEditingDomain((AdapterFactory)this.getAdapterFactory(), (CommandStack)new BasicCommandStack(), new HashMap(), OomphTransferDelegate.DELEGATES);
        }
        final ISelectionProvider selectionProvider = new ISelectionProvider(){

            public ISelection getSelection() {
                Object[] selection = ((IStructuredSelection)viewer.getSelection()).toArray();
                int i = 0;
                while (i < selection.length) {
                    Object object = selection[i];
                    if (object instanceof Object[]) {
                        selection[i] = ((Object[])object)[1];
                    }
                    ++i;
                }
                return new StructuredSelection(selection);
            }

            public void setSelection(ISelection selection) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }
        };
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                final IStructuredSelection selection = (IStructuredSelection)selectionProvider.getSelection();
                Action copy = new Action(Messages.ConfirmationPage_copyAction_text){

                    public void run() {
                        (this).ConfirmationPage.this.domain.setClipboard((Collection)selection.toList());
                    }
                };
                copy.setEnabled(!selection.isEmpty());
                copy.setAccelerator((OS.INSTANCE.isMac() ? 0x400000 : 262144) | 0x43);
                manager.add((IAction)copy);
            }
        });
        contextMenu.setRemoveAllWhenShown(true);
        Control control = viewer.getControl();
        control.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && (e.stateMask & SWT.MODIFIER_MASK & (OS.INSTANCE.isMac() ? 0x400000 : 262144)) != 0) {
                    IStructuredSelection selection = (IStructuredSelection)selectionProvider.getSelection();
                    if (!selection.isEmpty()) {
                        ConfirmationPage.this.domain.setClipboard((Collection)selection.toList());
                    }
                    e.doit = false;
                }
            }
        });
        Menu menu = contextMenu.createContextMenu(control);
        control.setMenu(menu);
        int dndOperations = 1;
        List transfersList = OomphTransferDelegate.asTransfers((List)OomphTransferDelegate.DELEGATES);
        Transfer[] transfers = transfersList.toArray(new Transfer[transfersList.size()]);
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new OomphDragAdapter(this.domain, selectionProvider, (Collection)OomphTransferDelegate.DELEGATES));
    }

    private void fillChildrenPane(SashForm verticalSash) {
        this.childrenViewer = new TreeViewer((Composite)verticalSash, 2816);
        this.createContextMenu((StructuredViewer)this.childrenViewer);
        ComposedAdapterFactory adapterFactory = this.getAdapterFactory();
        this.childrenViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        this.childrenViewer.setContentProvider((IContentProvider)new OomphAdapterFactoryContentProvider((AdapterFactory)adapterFactory){

            public Object[] getElements(Object object) {
                ArrayList<Object> result = new ArrayList<Object>();
                Object[] objectArray = super.getElements(object);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    result.add(child);
                    ++n2;
                }
                return result.toArray();
            }
        });
        final Tree tree = this.childrenViewer.getTree();
        tree.setHeaderVisible(true);
        this.addHelpCallout((Control)tree, 2);
        final TreeColumn column = new TreeColumn(tree, 0);
        column.setText(Messages.ConfirmationPage_column_nestedElements);
        this.columnResizer = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (!tree.isDisposed()) {
                    try {
                        tree.setRedraw(false);
                        Rectangle clientArea = tree.getClientArea();
                        int clientWidth = clientArea.width - clientArea.x;
                        TreeItem[] items = tree.getItems();
                        if (items.length > 0 && !items[0].isDisposed()) {
                            column.pack();
                            int width = column.getWidth();
                            if (width < clientWidth) {
                                column.setWidth(clientWidth);
                            }
                        } else {
                            column.setWidth(clientWidth);
                        }
                    }
                    finally {
                        tree.setRedraw(true);
                    }
                }
            }
        };
        tree.addControlListener((ControlListener)this.columnResizer);
        tree.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConfirmationPage.this.columnResizer.controlResized(null);
            }
        });
        this.childrenViewer.setInput(new Object());
    }

    private void connectMasterDetail(final TreeViewer master, final Viewer detail) {
        master.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (detail != null) {
                    Object selection = ((IStructuredSelection)master.getSelection()).getFirstElement();
                    Control control = detail.getControl();
                    try {
                        control.setRedraw(false);
                        detail.setInput(selection);
                        ConfirmationPage.this.columnResizer.controlResized(null);
                    }
                    finally {
                        control.setRedraw(true);
                    }
                }
            }
        });
    }

    private Set<SetupTask> getCheckedTasks() {
        HashSet<SetupTask> tasks = new HashSet<SetupTask>();
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof SetupTask) {
                SetupTask task = (SetupTask)object;
                tasks.add(task);
            }
            ++n2;
        }
        return tasks;
    }

    private void updateCheckStates() {
        Set<SetupTask> checkedTasks = this.getCheckedTasks();
        int checked = checkedTasks.size();
        EList allTasks = this.isShowAll() ? this.getPerformer().getTriggeredSetupTasks() : this.getPerformer().getNeededTasks();
        int all = allTasks.size();
        this.viewer.setChecked(ROOT_ELEMENT, checked == all);
        checkedTasks.retainAll((Collection<?>)this.getPerformer().getNeededTasks());
        this.someTaskChecked = !checkedTasks.isEmpty();
        this.validate();
    }

    private void validate() {
        this.setErrorMessage(null);
        this.setPageComplete(false);
        if (this.switchWorkspaceButton != null && this.switchWorkspaceButton.isVisible() && this.switchWorkspaceButton.getSelection()) {
            this.setMessage(NLS.bind((String)Messages.ConfirmationPage_ideWillBeRestartedWithNewWorkspace, (Object)this.getPerformer().getWorkspaceLocation()), 2);
        } else {
            this.setMessage(null);
        }
        if (!this.someTaskChecked) {
            if (this.getWizard().getPerformer().getNeededTasks().size() == 0) {
                this.setMessage(Messages.ConfirmationPage_noTasksToPerform, 2);
            } else {
                this.setErrorMessage(Messages.ConfirmationPage_checkOneOrMoreTasksToContinue);
            }
            return;
        }
        if (this.configurationLocationExists && !this.overwriteButton.getSelection()) {
            this.setErrorMessage(NLS.bind((String)Messages.ConfirmationPage_error_folderExists, (Object)this.lastConfigurationLocation));
            return;
        }
        if (this.newWorkspaceLocation != null && !ObjectUtil.equals((Object)this.newWorkspaceLocation, (Object)this.currentWorkspaceLocation) && !this.switchWorkspaceButton.getSelection()) {
            this.setErrorMessage(NLS.bind((String)Messages.ConfirmationPage_error_workspaceLocationChanged, (Object)this.getPerformer().getWorkspaceLocation()));
            return;
        }
        this.setPageComplete(true);
        this.setButtonState(15, false);
    }

    private boolean isShowAll() {
        return this.showAllButton.getSelection();
    }

    private boolean isOffline() {
        return ConfirmationPage.getProperty("oomph.setup.offline.startup", this.offlineProperty, this.offlineButton);
    }

    private boolean isMirrors() {
        return ConfirmationPage.getProperty("oomph.setup.mirrors.startup", this.mirrorsProperty, this.mirrorsButton);
    }

    public static boolean getProperty(String propertyKey, Boolean property, final Button button) {
        if (PropertiesUtil.isProperty((String)propertyKey)) {
            return true;
        }
        if (property != null) {
            return property;
        }
        final boolean[] result = new boolean[1];
        UIUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                result[0] = button.getSelection();
            }
        });
        return result[0];
    }
}

