/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation;

import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.oomph.ui.DockableDialog;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class AbstractTableAction
extends Action {
    private static final boolean BROWSE_AVAILBLE = UIUtil.isBrowserAvailable();
    private IWorkbenchPart part;

    public AbstractTableAction(String text) {
        super(text, BROWSE_AVAILBLE ? 2 : 1);
    }

    public void setActivePart(IWorkbenchPart part) {
        TableDialog dialog;
        this.part = part;
        if (part != null && (dialog = (TableDialog)DockableDialog.getFor(this.getDialogClass(), (IWorkbenchWindow)part.getSite().getWorkbenchWindow())) != null) {
            dialog.getDockable().associate((IAction)this);
        }
    }

    public void run() {
        if (BROWSE_AVAILBLE) {
            if (this.isChecked()) {
                TableDialog dialog = (TableDialog)DockableDialog.openFor(this.getDialogClass(), this.getDialogFactory(), (IWorkbenchWindow)this.part.getSite().getWorkbenchWindow());
                dialog.getDockable().associate((IAction)this);
            } else {
                DockableDialog.closeFor(this.getDialogClass(), (IWorkbenchWindow)this.part.getSite().getWorkbenchWindow());
            }
        } else {
            try {
                String html = this.renderHTML();
                File tempFile = File.createTempFile("table", ".html");
                IOUtil.writeUTF8((File)tempFile, (String)html);
                OS.INSTANCE.openSystemBrowser(tempFile.toURI().toString());
            }
            catch (Exception ex) {
                ErrorDialog.open((Throwable)ex);
            }
        }
    }

    protected abstract <T extends TableDialog> Class<T> getDialogClass();

    protected abstract <T extends TableDialog> DockableDialog.Factory<T> getDialogFactory();

    protected abstract String renderHTML();

    static class TableDialog
    extends DockableDialog {
        private final AbstractTableAction tableAction;

        public TableDialog(IWorkbenchWindow workbenchWindow, AbstractTableAction tableAction) {
            super(workbenchWindow);
            this.tableAction = tableAction;
        }

        public boolean handleWorkbenchPart(IWorkbenchPart part) {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(this.tableAction.getText());
            String html = this.tableAction.renderHTML();
            Browser browser = new Browser(parent, 0);
            browser.setText(html);
            GridData layoutData = new GridData(1808);
            layoutData.heightHint = 800;
            layoutData.widthHint = 1000;
            browser.setLayoutData((Object)layoutData);
            TableDialog.applyDialogFont((Control)browser);
            return browser;
        }

        protected Control createButtonBar(Composite parent) {
            return null;
        }
    }
}

