/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.commands;

import java.util.Properties;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.internal.ProductProperties;

public class CopyBuildIdToClipboardHandler
extends AbstractHandler {
    private static final String OS_NAME = "os.name";
    private static final String OS_VERSION = "os.version";
    private static final String OSGI_ARCH = "osgi.arch";
    private static final String OSGI_WS = "osgi.ws";
    private static final String JAVA_VERSION = "java.version";
    private static final String JAVA_VENDOR = "java.vendor";
    private static final String JAVA_VENDOR_VERSION = "java.vendor.version=";
    private static final String JAVA_RUNTIME_VERSION = "java.runtime.version";
    private static final String SWT_GTK_VERSION = "org.eclipse.swt.internal.gtk.version";
    static final String SWT_WEBKITGTK_VERSION = "org.eclipse.swt.internal.webkitgtk.version";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String javaRuntimeVersion;
        String javaVendorVersion;
        String javaVendor;
        String webkitGtkVer;
        IProduct product = Platform.getProduct();
        if (product == null) {
            throw new ExecutionException("No product is defined.");
        }
        String aboutText = ProductProperties.getAboutText((IProduct)product);
        String[] lines = aboutText.split("\\r?\\n");
        if (lines.length <= 3) {
            throw new ExecutionException("Product About Text is not properly defined.");
        }
        Properties sp = System.getProperties();
        String osInfo = String.format("OS: %s, v.%s, %s / %s", sp.get(OS_NAME), sp.get(OS_VERSION), sp.get(OSGI_ARCH), sp.get(OSGI_WS));
        String gtkVer = sp.getProperty(SWT_GTK_VERSION);
        if (gtkVer != null) {
            osInfo = String.valueOf(osInfo) + String.format(" %s", gtkVer);
        }
        if ((webkitGtkVer = sp.getProperty(SWT_WEBKITGTK_VERSION)) != null) {
            osInfo = String.valueOf(osInfo) + String.format(", WebKit %s", webkitGtkVer);
        }
        if ((javaVendor = System.getProperty(JAVA_VENDOR)) != null) {
            osInfo = String.valueOf(osInfo) + String.format("%nJava vendor: %s", javaVendor);
        }
        if ((javaVendorVersion = System.getProperty(JAVA_VENDOR_VERSION)) != null) {
            osInfo = String.valueOf(osInfo) + String.format("%nJava vendor version: %s", javaVendorVersion);
        }
        if ((javaRuntimeVersion = System.getProperty(JAVA_RUNTIME_VERSION)) != null) {
            osInfo = String.valueOf(osInfo) + String.format("%nJava runtime version: %s", javaRuntimeVersion);
        }
        String javaVersion = System.getProperty(JAVA_VERSION);
        osInfo = String.valueOf(osInfo) + String.format("%nJava version: %s", javaVersion);
        String toCopy = String.format("%s%n%s%n%s%n%s%n", lines[0], lines[2], lines[3], osInfo);
        Clipboard clipboard = new Clipboard(null);
        try {
            TextTransfer textTransfer = TextTransfer.getInstance();
            Transfer[] transfers = new Transfer[]{textTransfer};
            Object[] data = new Object[]{toCopy};
            clipboard.setContents(data, transfers);
        }
        finally {
            clipboard.dispose();
        }
        return null;
    }
}

