/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.synchronizer;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.oomph.setup.internal.sync.SynchronizerCredentials;
import org.eclipse.oomph.setup.internal.sync.SynchronizerService;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.synchronizer.SynchronizerLoginComposite;
import org.eclipse.oomph.setup.ui.synchronizer.SynchronizerManager;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SynchronizerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.oomph.setup.SynchronizerPreferencePage";
    private Button enableButton;
    private TableCombo serviceCombo;
    private SynchronizerLoginComposite loginComposite;
    private boolean initialEnabled = SynchronizerManager.INSTANCE.isSyncEnabled();
    private SynchronizerService initialService = SynchronizerManager.INSTANCE.getService();
    private SynchronizerCredentials initialCredentials = this.initialService.getCredentials();
    private SynchronizerService currentService;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.loginComposite = new SynchronizerLoginComposite(parent, 0, 0, 0){

            protected void createUI(Composite parent, int columns) {
                SynchronizerPreferencePage.this.enableButton = new Button(parent, 32);
                SynchronizerPreferencePage.this.enableButton.setText("Synchronize with:");
                SynchronizerPreferencePage.this.enableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SynchronizerPreferencePage.this.updateEnablement();
                    }
                });
                SynchronizerPreferencePage.this.serviceCombo = new TableCombo(parent, 2056);
                SynchronizerPreferencePage.this.serviceCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, columns - 1, 1));
                SynchronizerPreferencePage.this.serviceCombo.defineColumns(2);
                SynchronizerPreferencePage.this.serviceCombo.setToolTipText("Select the service to synchronize with");
                Table table = SynchronizerPreferencePage.this.serviceCombo.getTable();
                table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (e.item instanceof TableItem) {
                            TableItem item = (TableItem)e.item;
                            SynchronizerPreferencePage.this.currentService = (SynchronizerService)item.getData();
                        }
                    }
                });
                SynchronizerService[] synchronizerServiceArray = SynchronizerService.Registry.INSTANCE.getServices();
                int n = synchronizerServiceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SynchronizerService service = synchronizerServiceArray[n2];
                    TableItem item = new TableItem(table, 0);
                    item.setData((Object)service);
                    item.setImage(0, SetupUIPlugin.INSTANCE.getSWTImage("sync/Remote"));
                    item.setText(0, service.getLabel());
                    item.setText(1, service.getServiceURI().toString());
                    ++n2;
                }
                super.createUI(parent, columns);
            }

            protected void validate() {
                SynchronizerPreferencePage.this.updateEnablement();
            }
        };
        this.enableButton.setSelection(this.initialEnabled);
        this.selectService(this.initialService);
        UIUtil.asyncExec((Runnable)new Runnable(){

            public void run() {
                SynchronizerPreferencePage.this.updateEnablement();
            }
        });
        return this.loginComposite;
    }

    protected void performDefaults() {
        this.enableButton.setSelection(this.initialEnabled);
        this.selectService(this.initialService);
        this.loginComposite.setCredentials(this.initialCredentials);
        super.performDefaults();
        this.updateEnablement();
    }

    protected void performApply() {
        super.performApply();
        this.updateEnablement();
    }

    public boolean performOk() {
        this.initialCredentials = this.loginComposite.getCredentials();
        this.currentService.setCredentials(this.initialCredentials);
        this.initialEnabled = this.enableButton.getSelection();
        SynchronizerManager.INSTANCE.setSyncEnabled(this.initialEnabled);
        this.initialService = this.currentService;
        SynchronizerManager.INSTANCE.setService(this.initialService);
        return super.performOk();
    }

    private boolean needsApply() {
        block6: {
            block5: {
                if (this.enableButton == null || this.enableButton.getSelection() == this.initialEnabled) break block5;
                return true;
            }
            if (ObjectUtil.equals((Object)this.currentService, (Object)this.initialService)) break block6;
            return true;
        }
        try {
            SynchronizerCredentials currentCredentials = this.loginComposite.getCredentials();
            if (!ObjectUtil.equals((Object)currentCredentials, (Object)this.initialCredentials)) {
                return true;
            }
        }
        catch (Exception ex) {
            SetupUIPlugin.INSTANCE.log(ex);
        }
        return false;
    }

    private void selectService(SynchronizerService service) {
        if (service != null) {
            Table table = this.serviceCombo.getTable();
            int i = 0;
            TableItem[] tableItemArray = table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                SynchronizerService itemService = (SynchronizerService)item.getData();
                if (ObjectUtil.equals((Object)itemService, (Object)service)) {
                    this.currentService = itemService;
                    this.serviceCombo.select(i);
                    this.loginComposite.setService(this.currentService);
                    return;
                }
                ++i;
                ++n2;
            }
            if (this.serviceCombo.getItemCount() != 0) {
                this.currentService = (SynchronizerService)table.getItem(0).getData();
                this.serviceCombo.select(0);
                this.loginComposite.setService(this.currentService);
                return;
            }
        }
        this.currentService = null;
        this.loginComposite.setService(null);
    }

    private void updateEnablement() {
        Button applyButton;
        boolean enabled = this.enableButton.getSelection();
        this.serviceCombo.setEnabled(enabled);
        this.loginComposite.setEnabled(enabled);
        boolean needsApply = this.needsApply();
        Button defaultsButton = this.getDefaultsButton();
        if (defaultsButton != null) {
            defaultsButton.setEnabled(needsApply);
        }
        if ((applyButton = this.getApplyButton()) != null) {
            applyButton.setEnabled(needsApply);
        }
    }
}

