/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ostools;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractLocationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        File location = AbstractLocationHandler.getLocation(selection);
        try {
            this.execute(location);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    protected abstract void execute(File var1) throws Exception;

    public static File getLocation(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            Object element = ssel.getFirstElement();
            return AbstractLocationHandler.getLocation(element);
        }
        return null;
    }

    private static File getLocation(Object element) {
        IContainer container = AbstractLocationHandler.getContainer(element);
        if (container != null) {
            return new File(container.getLocation().toOSString());
        }
        File directory = AbstractLocationHandler.getDirectory(element);
        if (directory != null) {
            return directory;
        }
        File workTree = AbstractLocationHandler.getWorkTree(element);
        if (workTree != null) {
            return workTree;
        }
        return null;
    }

    private static IContainer getContainer(Object element) {
        if (element instanceof IContainer) {
            return (IContainer)element;
        }
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        if (element instanceof IAdaptable) {
            Object adapter = ((IAdaptable)element).getAdapter(IResource.class);
            return AbstractLocationHandler.getContainer(adapter);
        }
        return null;
    }

    private static File getDirectory(Object element) {
        if (element instanceof File) {
            File file = (File)element;
            if (file.isDirectory()) {
                return file;
            }
            return file.getParentFile();
        }
        if (element instanceof IAdaptable) {
            Object adapter = ((IAdaptable)element).getAdapter(File.class);
            return AbstractLocationHandler.getDirectory(adapter);
        }
        return null;
    }

    private static File getWorkTree(Object element) {
        try {
            return GitHelper.getWorkTree(element);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static final class GitHelper {
        private GitHelper() {
        }

        public static File getWorkTree(Object element) {
            if (element instanceof Repository) {
                return ((Repository)element).getWorkTree();
            }
            if (element instanceof IAdaptable) {
                Object adapter = ((IAdaptable)element).getAdapter(Repository.class);
                return GitHelper.getWorkTree(adapter);
            }
            return null;
        }
    }
}

