/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.base.util.EAnnotations;
import org.eclipse.oomph.internal.ui.OomphEditingDomainActionBarContributor;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.InstallationTask;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.RedirectionTask;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.WorkspaceTask;
import org.eclipse.oomph.setup.impl.DynamicSetupTaskImpl;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.presentation.AbstractTableAction;
import org.eclipse.oomph.setup.presentation.EnablementAction;
import org.eclipse.oomph.setup.presentation.PreferenceCaptureDialog;
import org.eclipse.oomph.setup.presentation.SetupEditor;
import org.eclipse.oomph.setup.presentation.SetupEditorPlugin;
import org.eclipse.oomph.setup.ui.SetupEditorSupport;
import org.eclipse.oomph.setup.ui.recorder.RecorderManager;
import org.eclipse.oomph.setup.ui.recorder.RecorderTransaction;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.workingsets.WorkingSet;
import org.eclipse.oomph.workingsets.WorkingSetsPackage;
import org.eclipse.oomph.workingsets.presentation.WorkingSetsActionBarContributor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.keys.IBindingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetupActionBarContributor
extends OomphEditingDomainActionBarContributor
implements ISelectionChangedListener {
    private static final String ENABLEMENT_ITEM_PREFIX = String.valueOf(EnablementAction.class.getName()) + "-";
    private static final Comparator<? super IAction> ACTION_COMPARATOR = new Comparator<IAction>(){

        @Override
        public int compare(IAction a1, IAction a2) {
            return StringUtil.safe((String)a1.getText()).compareTo(StringUtil.safe((String)a2.getText()));
        }
    };
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action(SetupEditorPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                SetupActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                SetupEditorPlugin.INSTANCE.log(exception);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(SetupEditorPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return SetupActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (SetupActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)SetupActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected Collection<IAction> createChildActions;
    protected IMenuManager createChildMenuManager;
    protected Collection<IAction> createSiblingActions;
    protected IMenuManager createSiblingMenuManager;
    private final ToggleViewerInputAction toggleViewerInputAction = new ToggleViewerInputAction();
    private final PreferenceRecorderToolbarAction recordPreferencesAction = new PreferenceRecorderToolbarAction(true);
    private final PreferenceCaptureToolbarAction capturePreferencesAction = new PreferenceCaptureToolbarAction(false);
    private final PreferenceCaptureToolbarAction importPreferencesAction = new PreferenceCaptureToolbarAction(true);
    private final CommandTableAction commandTableAction = new CommandTableAction();
    private final EditorTableAction editorTableAction = new EditorTableAction();
    private final TestInstallAction testInstallAction = new TestInstallAction();
    private final OpenInSetupEditorAction openInSetupEditorAction = new OpenInSetupEditorAction();
    private final OpenInTextEditorAction openInTextEditorAction = new OpenInTextEditorAction();
    private RevertAction revertAction;
    private int lastSubMenuID;

    public SetupActionBarContributor() {
        super(1);
        this.loadResourceAction = new LoadResourceAction();
        this.validateAction = new ValidateAction();
        this.liveValidationAction = new DiagnosticDecorator.LiveValidator.LiveValidationAction(SetupEditorPlugin.getPlugin().getDialogSettings());
        this.controlAction = new ControlAction();
    }

    public final ToggleViewerInputAction getToggleViewerInputAction() {
        return this.toggleViewerInputAction;
    }

    public void init(IActionBars actionBars) {
        this.revertAction = new RevertAction();
        actionBars.setGlobalActionHandler(ActionFactory.REVERT.getId(), (IAction)this.revertAction);
        super.init(actionBars);
    }

    public void scheduleValidation() {
        this.liveValidationAction.run();
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("setup-settings"));
        toolBarManager.add((IAction)this.recordPreferencesAction);
        toolBarManager.add((IAction)this.capturePreferencesAction);
        toolBarManager.add((IAction)this.importPreferencesAction);
        toolBarManager.add((IAction)this.commandTableAction);
        toolBarManager.add((IAction)this.editorTableAction);
        toolBarManager.add((IAction)this.toggleViewerInputAction);
        super.contributeToToolBar(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator("setup-additions"));
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager(SetupEditorPlugin.INSTANCE.getString("_UI_SetupEditor_menu"), "org.eclipse.oomph.setupMenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(SetupEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(SetupEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)submenuManager);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        this.toggleViewerInputAction.setActiveWorkbenchPart((IWorkbenchPart)part);
        this.commandTableAction.setActivePart((IWorkbenchPart)part);
        this.editorTableAction.setActivePart((IWorkbenchPart)part);
        this.revertAction.setActiveWorkbenchPart((IWorkbenchPart)part);
        this.openInSetupEditorAction.setActiveWorkbenchPart((IWorkbenchPart)part);
        this.openInTextEditorAction.setActiveWorkbenchPart((IWorkbenchPart)part);
        this.capturePreferencesAction.setActiveWorkbenchPart((IWorkbenchPart)part);
        this.importPreferencesAction.setActiveWorkbenchPart((IWorkbenchPart)part);
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChangedGen(SelectionChangedEvent event) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
            newSiblingDescriptors = domain.getNewChildDescriptors(null, object);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionChangedGen(event);
        this.openInSetupEditorAction.selectionChanged(event);
        this.openInTextEditorAction.selectionChanged(event);
    }

    protected Collection<IAction> generateCreateChildActionsGen(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateChildAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        Collection<IAction> actions = this.generateCreateChildActionsGen(descriptors, selection);
        return this.addEnablementActions(descriptors, selection, false, actions);
    }

    protected Collection<IAction> generateCreateSiblingActionsGen(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateSiblingAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        Collection<IAction> actions = this.generateCreateSiblingActionsGen(descriptors, selection);
        return this.addEnablementActions(descriptors, selection, true, actions);
    }

    private Collection<IAction> addEnablementActions(Collection<?> descriptors, ISelection selection, boolean sibling, Collection<IAction> actions) {
        Object object;
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
            actions = new ArrayList<IAction>(actions);
            this.addEnablementActions(descriptors, object, sibling, actions);
        }
        return actions;
    }

    private void addEnablementActions(Collection<?> descriptors, Object object, boolean sibling, Collection<IAction> actions) {
        EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
        ResourceSet resourceSet = domain.getResourceSet();
        Object siblingObject = null;
        if (sibling) {
            siblingObject = object;
            if (!((object = domain.getParent(object)) instanceof EObject)) {
                return;
            }
        }
        ReflectiveItemProvider itemProvider = new ReflectiveItemProvider(null){

            protected void gatherAllMetaData(EObject eObject) {
                Resource mainResource = eObject.eResource();
                if (mainResource != null) {
                    ResourceSet resourceSet = mainResource.getResourceSet();
                    if (resourceSet == null) {
                        this.gatherAllMetaData(mainResource);
                    } else {
                        EList resources = resourceSet.getResources();
                        int i = 0;
                        while (i < resources.size()) {
                            this.gatherAllMetaData((Resource)resources.get(i));
                            ++i;
                        }
                    }
                }
            }

            protected void gatherAllMetaData(Resource resource) {
                for (EObject root : resource.getContents()) {
                    if (!(root instanceof EPackage)) continue;
                    this.gatherMetaData((EModelElement)((EPackage)root));
                }
            }
        };
        BaseEditUtil.IconReflectiveItemProvider iconItemProvider = ((SetupEditor)this.activeEditor).getReflectiveItemProvider();
        Shell shell = this.activeEditorPart.getSite().getShell();
        Collection newChildDescriptors = itemProvider.getNewChildDescriptors(object, domain, siblingObject);
        for (Object descriptor : newChildDescriptors) {
            EList enablementTasks;
            EClass eClass;
            Resource eResource;
            EObject eObject;
            Object value;
            if (!(descriptor instanceof CommandParameter) || !((value = ((CommandParameter)descriptor).getValue()) instanceof EObject) || !((eObject = (EObject)value) instanceof DynamicSetupTaskImpl) || (eResource = (eClass = eObject.eClass()).eResource()) == null || eResource.getResourceSet() != resourceSet || (enablementTasks = SetupTaskPerformer.createEnablementTasks((EModelElement)eClass, (boolean)true)) == null) continue;
            String typeText = EAnnotations.getText((EClass)eClass);
            if (typeText == null) {
                typeText = iconItemProvider.getTypeText((Object)eObject);
            }
            EnablementAction action = new EnablementAction(shell, eClass, typeText, (EList<SetupTask>)enablementTasks);
            actions.add((IAction)action);
        }
    }

    protected void populateManagerGen(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        manager.add((IContributionItem)new Separator("elements"));
        manager.add((IContributionItem)new Separator("elements-end"));
        manager.add((IContributionItem)new Separator("scopes"));
        manager.add((IContributionItem)new Separator("scopes-end"));
        manager.add((IContributionItem)new Separator("defaults"));
        manager.add((IContributionItem)new Separator("defaults-end"));
        manager.add((IContributionItem)new Separator("installations"));
        manager.add((IContributionItem)new Separator("installations-end"));
        manager.add((IContributionItem)new Separator("tasks"));
        manager.add((IContributionItem)new Separator("tasks-end"));
        manager.add((IContributionItem)new Separator("annotations"));
        manager.add((IContributionItem)new Separator("annotations-end"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("additions-end"));
        ArrayList<IAction> elements = new ArrayList<IAction>();
        ArrayList<IAction> scopes = new ArrayList<IAction>();
        ArrayList<IAction> defaults = new ArrayList<IAction>();
        ArrayList<IAction> installations = new ArrayList<IAction>();
        ArrayList<IAction> tasks = new ArrayList<IAction>();
        ArrayList<IAction> annotations = new ArrayList<IAction>();
        ArrayList<IAction> additions = new ArrayList<IAction>();
        ArrayList<EnablementAction> additionalTasks = new ArrayList<EnablementAction>();
        ArrayList<EnablementAction> additionalElements = new ArrayList<EnablementAction>();
        HashSet<String> installedClasses = new HashSet<String>();
        for (IAction iAction : actions) {
            Object descriptor;
            if (iAction instanceof EnablementAction) {
                EnablementAction additionalTaskAction = (EnablementAction)iAction;
                EClass eClass = additionalTaskAction.getEClass();
                if (SetupPackage.Literals.SETUP_TASK.isSuperTypeOf(eClass)) {
                    additionalTasks.add(additionalTaskAction);
                    continue;
                }
                additionalElements.add(additionalTaskAction);
                continue;
            }
            if (iAction instanceof CreateChildAction) {
                descriptor = ((CreateChildAction)iAction).getDescriptor();
            } else if (iAction instanceof CreateSiblingAction) {
                descriptor = ((CreateSiblingAction)iAction).getDescriptor();
            } else {
                additions.add(iAction);
                continue;
            }
            if (descriptor instanceof CommandParameter) {
                CommandParameter parameter = (CommandParameter)descriptor;
                Object value = parameter.getValue();
                if (value instanceof Scope) {
                    scopes.add(iAction);
                } else if (value instanceof CompoundTask || value instanceof VariableTask || value instanceof RedirectionTask) {
                    defaults.add(iAction);
                } else if (value instanceof InstallationTask || value instanceof WorkspaceTask) {
                    installations.add(iAction);
                } else if (value instanceof SetupTask) {
                    tasks.add(iAction);
                } else if (value instanceof Annotation) {
                    annotations.add(iAction);
                } else {
                    elements.add(iAction);
                }
                if (!(value instanceof EObject)) continue;
                EClass eClass = ((EObject)value).eClass();
                String installedClass = this.getInstalledClass(eClass);
                installedClasses.add(installedClass);
                continue;
            }
            additions.add(iAction);
        }
        this.removeInstalledClasses(installedClasses, additionalElements);
        Collections.sort(elements, ACTION_COMPARATOR);
        this.removeInstalledClasses(installedClasses, additionalTasks);
        Collections.sort(tasks, ACTION_COMPARATOR);
        this.populateManagerGen(manager, elements, "elements-end");
        if (!additionalElements.isEmpty()) {
            this.populateManagerEnablements(manager, SetupEditorPlugin.INSTANCE.getString("_UI_AdditionalElements_menu_item"), "elements-end", additionalElements);
        }
        this.populateManagerGen(manager, scopes, "scopes-end");
        this.populateManagerGen(manager, defaults, "defaults-end");
        this.populateManagerGen(manager, installations, "installations-end");
        this.populateManagerGen(manager, tasks, "tasks-end");
        if (!additionalTasks.isEmpty()) {
            this.populateManagerEnablements(manager, SetupEditorPlugin.INSTANCE.getString("_UI_AdditionalTasks_menu_item"), "tasks-end", additionalTasks);
        }
        this.populateManagerGen(manager, annotations, "annotations-end");
        this.populateManagerGen(manager, additions, "additions-end");
    }

    private String getInstalledClass(EClass eClass) {
        return String.valueOf(eClass.getEPackage().getNsURI()) + "#" + eClass.getName();
    }

    private void removeInstalledClasses(Set<String> installedClasses, List<EnablementAction> actions) {
        Iterator<EnablementAction> it = actions.iterator();
        while (it.hasNext()) {
            EnablementAction action = it.next();
            EClass eClass = action.getEClass();
            String installedClass = this.getInstalledClass(eClass);
            if (!installedClasses.contains(installedClass)) continue;
            it.remove();
        }
    }

    private void populateManagerEnablements(IContributionManager manager, String subMenuText, String insertBeforeID, final List<EnablementAction> additionalTasks) {
        int id = ++this.lastSubMenuID;
        String subMenuID = String.valueOf(ENABLEMENT_ITEM_PREFIX) + id;
        final MenuManager submenuManager = new MenuManager(subMenuText, subMenuID);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                UIUtil.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        final ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue(additionalTasks);
                        int jobs = Math.max(queue.size(), 10);
                        int i = 0;
                        while (i < jobs) {
                            Job iconLoader = new Job("IconLoader-" + i){

                                protected IStatus run(IProgressMonitor monitor) {
                                    EnablementAction action;
                                    while ((action = (EnablementAction)((Object)queue.poll())) != null && submenuManager.isVisible() && !monitor.isCanceled()) {
                                        action.loadImage();
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            iconLoader.setSystem(true);
                            iconLoader.schedule();
                            ++i;
                        }
                    }
                });
            }
        });
        Collections.sort(additionalTasks, ACTION_COMPARATOR);
        this.populateManagerGen((IContributionManager)submenuManager, additionalTasks, null);
        manager.insertBefore(insertBeforeID, (IContributionItem)submenuManager);
    }

    protected void depopulateManagerGen(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        IContributionItem[] items = manager.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                IContributionItem item = items[i];
                String id = item.getId();
                if (id != null && id.startsWith(ENABLEMENT_ITEM_PREFIX)) {
                    manager.remove(item);
                }
                ++i;
            }
        }
        this.depopulateManagerGen(manager, actions);
    }

    public void menuAboutToShowGen(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        MenuManager submenuManager = null;
        submenuManager = new MenuManager(SetupEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(SetupEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        this.menuAboutToShowGen(menuManager);
        menuManager.insertBefore("ui-actions", (IAction)new Action(){

            public String getText() {
                return "Working Sets Preview...";
            }

            public void run() {
                WorkingSetsActionBarContributor.PreviewDialog dialog = new WorkingSetsActionBarContributor.PreviewDialog(SetupActionBarContributor.this.activeEditorPart.getSite().getShell(), SetupActionBarContributor.this.activeEditorPart){
                    private List<WorkingSet> workingSets;
                    {
                        this.workingSets = new ArrayList<WorkingSet>();
                    }

                    protected void selectionChanged(IWorkbenchPart part, ISelection selection) {
                        if (part == (this).SetupActionBarContributor.this.activeEditorPart) {
                            List<WorkingSet> oldWorkingSets = this.workingSets;
                            this.workingSets = this.getWorkingSets();
                            if (this.workingSets != oldWorkingSets) {
                                this.reconcile();
                                this.tree.setInput((Object)this.input);
                                this.tree.expandAll();
                            }
                        }
                        super.selectionChanged(part, selection);
                    }

                    protected List<WorkingSet> getWorkingSets() {
                        IStructuredSelection selection = (IStructuredSelection)((ISelectionProvider)(this).SetupActionBarContributor.this.activeEditorPart).getSelection();
                        Object[] objectArray = selection.toArray();
                        int n = objectArray.length;
                        int n2 = 0;
                        block0: while (n2 < n) {
                            Object object = objectArray[n2];
                            if (object instanceof EObject) {
                                EObject eObject = (EObject)object;
                                while (eObject != null) {
                                    List<WorkingSet> workingSets = this.getWorkingSets(eObject);
                                    if (workingSets != null) {
                                        this.workingSets = workingSets;
                                        break block0;
                                    }
                                    eObject = eObject.eContainer();
                                }
                            }
                            ++n2;
                        }
                        return this.workingSets;
                    }

                    private List<WorkingSet> getWorkingSets(EObject eObject) {
                        for (EReference eReference : eObject.eClass().getEAllReferences()) {
                            if (!eReference.isMany() || eReference.getEType() != WorkingSetsPackage.Literals.WORKING_SET) continue;
                            EList value = (EList)eObject.eGet((EStructuralFeature)eReference);
                            return value;
                        }
                        return null;
                    }
                };
                dialog.open();
            }
        });
        menuManager.insertBefore("ui-actions", (IAction)this.openInSetupEditorAction);
        menuManager.insertBefore("ui-actions", (IAction)this.openInTextEditorAction);
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        super.addGlobalActions(menuManager);
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }

    private static final class CommandTableAction
    extends AbstractTableAction {
        public CommandTableAction() {
            super("Command Table");
            this.setImageDescriptor(SetupEditorPlugin.INSTANCE.getImageDescriptor("commands"));
            this.setToolTipText("Show a table of all available commands");
        }

        protected String renderHTML() {
            List commands;
            IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
            Binding[] bindings = bindingService.getBindings();
            HashMap<String, ArrayList<Command>> map = new HashMap<String, ArrayList<Command>>();
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command[] commandArray = commandService.getDefinedCommands();
            int n = commandArray.length;
            int n2 = 0;
            while (n2 < n) {
                Command command = commandArray[n2];
                try {
                    String category = command.getCategory().getName();
                    if (category == null || category.length() == 0) {
                        category = command.getCategory().getId();
                    }
                    if ((commands = (ArrayList<Command>)map.get(category)) == null) {
                        commands = new ArrayList<Command>();
                        map.put(category, (ArrayList<Command>)commands);
                    }
                    commands.add(command);
                }
                catch (NotDefinedException ex) {
                    SetupEditorPlugin.getPlugin().log((Object)ex);
                }
                ++n2;
            }
            ArrayList categories = new ArrayList(map.keySet());
            Collections.sort(categories);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(baos);
            out.println("<table border=\"1\">");
            for (String category : categories) {
                out.println("<tr><td colspan=\"3\" bgcolor=\"eae6ff\"><br><h2>" + category + "</h2></td></tr>");
                commands = (List)map.get(category);
                Collections.sort(commands);
                for (Command command : commands) {
                    String name;
                    StringBuilder keys = new StringBuilder();
                    Binding[] bindingArray = bindings;
                    int n3 = bindings.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Binding binding = bindingArray[n4];
                        ParameterizedCommand parameterizedCommand = binding.getParameterizedCommand();
                        if (parameterizedCommand != null && parameterizedCommand.getId().equals(command.getId())) {
                            if (keys.length() != 0) {
                                keys.append("<br>");
                            }
                            keys.append(binding.getTriggerSequence());
                        }
                        ++n4;
                    }
                    if (keys.length() == 0) {
                        keys.append("&nbsp;");
                    }
                    try {
                        name = command.getName();
                    }
                    catch (NotDefinedException notDefinedException) {
                        name = command.getId();
                    }
                    out.println("<tr><td valign=\"top\" width=\"200\">" + name + "</td><td valign=\"top\" width=\"400\">" + command.getId() + "</td><td valign=\"top\" width=\"100\">" + keys + "</td></tr>");
                }
            }
            out.println("</table>");
            try {
                out.flush();
                return baos.toString("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return "UTF-8 is unsupported";
            }
        }
    }

    private static final class CreateChildAction
    extends org.eclipse.emf.edit.ui.action.CreateChildAction {
        public CreateChildAction(EditingDomain editingDomain, ISelection selection, Object descriptor) {
            super(editingDomain, selection, descriptor);
        }

        public CreateChildAction(IEditorPart editorPart, ISelection selection, Object descriptor) {
            super(editorPart, selection, descriptor);
        }

        public CreateChildAction(IWorkbenchPart workbenchPart, ISelection selection, Object descriptor) {
            super(workbenchPart, selection, descriptor);
        }

        public Object getDescriptor() {
            return this.descriptor;
        }
    }

    private static final class CreateSiblingAction
    extends org.eclipse.emf.edit.ui.action.CreateSiblingAction {
        public CreateSiblingAction(EditingDomain editingDomain, ISelection selection, Object descriptor) {
            super(editingDomain, selection, descriptor);
        }

        public CreateSiblingAction(IEditorPart editorPart, ISelection selection, Object descriptor) {
            super(editorPart, selection, descriptor);
        }

        public CreateSiblingAction(IWorkbenchPart workbenchPart, ISelection selection, Object descriptor) {
            super(workbenchPart, selection, descriptor);
        }

        public Object getDescriptor() {
            return this.descriptor;
        }
    }

    private static final class EditorTableAction
    extends AbstractTableAction {
        public EditorTableAction() {
            super("Editor Table");
            this.setImageDescriptor(SetupEditorPlugin.INSTANCE.getImageDescriptor("FileEditor"));
            this.setToolTipText("Show a table of all available editors");
        }

        protected String renderHTML() {
            IEditorDescriptor[] editors;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(baos);
            out.println("<table border=\"1\">");
            out.println("<tr><td bgcolor=\"eae6ff\">ID</td><td bgcolor=\"eae6ff\">Label</td></tr>");
            EditorRegistry registry = (EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor[] iEditorDescriptorArray = editors = registry.getSortedEditorsFromPlugins();
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorDescriptor editor = iEditorDescriptorArray[n2];
                out.println("<tr><td>" + editor.getId() + "</td><td>" + editor.getLabel() + "</td></tr>");
                ++n2;
            }
            out.println("</table>");
            try {
                out.flush();
                return baos.toString("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return "UTF-8 is unsupported";
            }
        }
    }

    private static final class OpenInSetupEditorAction
    extends Action {
        private URI uri;
        private SetupEditor setupEditor;

        public OpenInSetupEditorAction() {
            this.setText("Open in Setup Editor");
        }

        public void run() {
            SetupEditorSupport.getEditor((IWorkbenchPage)this.setupEditor.getSite().getWorkbenchWindow().getActivePage(), (URI)this.uri, (boolean)true, (SetupEditorSupport.LoadHandler[])new SetupEditorSupport.LoadHandler[0]);
        }

        public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
            if (workbenchPart instanceof SetupEditor) {
                this.setupEditor = (SetupEditor)workbenchPart;
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
                this.setupEditor = null;
            }
        }

        public final void selectionChanged(SelectionChangedEvent event) {
            this.uri = null;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.size() == 1) {
                Object object = selection.getFirstElement();
                if ((object = AdapterFactoryEditingDomain.unwrap((Object)object)) instanceof EObject) {
                    ResourceSet resourceSet;
                    EObject eObject = (EObject)object;
                    Resource resource = eObject.eResource();
                    if (resource != null && ((resourceSet = resource.getResourceSet()) == null || resourceSet.getResources().indexOf((Object)resource) != 0)) {
                        this.uri = EcoreUtil.getURI((EObject)eObject);
                    }
                } else if (object instanceof Resource) {
                    Resource resource = (Resource)object;
                    this.uri = resource.getURI();
                }
            }
            this.setEnabled(this.uri != null);
        }
    }

    private static final class OpenInTextEditorAction
    extends Action {
        private URI uri;
        private SetupEditor setupEditor;

        public OpenInTextEditorAction() {
            this.setText("Open in Text Editor");
        }

        public void run() {
            SetupEditorSupport.getTextEditor((IWorkbenchPage)this.setupEditor.getSite().getWorkbenchWindow().getActivePage(), (URI)this.uri);
        }

        public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
            if (workbenchPart instanceof SetupEditor) {
                this.setupEditor = (SetupEditor)workbenchPart;
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
                this.setupEditor = null;
            }
        }

        public final void selectionChanged(SelectionChangedEvent event) {
            this.uri = null;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.size() == 1) {
                Object object = selection.getFirstElement();
                if ((object = AdapterFactoryEditingDomain.unwrap((Object)object)) instanceof EObject) {
                    EObject eObject = (EObject)object;
                    Resource resource = eObject.eResource();
                    if (resource != null) {
                        this.uri = resource.getURI();
                    }
                } else if (object instanceof Resource) {
                    Resource resource = (Resource)object;
                    this.uri = resource.getURI();
                }
            }
            this.setEnabled(this.uri != null);
        }
    }

    private class PreferenceCaptureToolbarAction
    extends Action {
        private SetupEditor setupEditor;
        private boolean fromEclipsePreferenceFile;

        public PreferenceCaptureToolbarAction(boolean fromEclipsePreferenceFile) {
            super(fromEclipsePreferenceFile ? "Import Preferences" : "Capture Preferences", SetupEditorPlugin.INSTANCE.getImageDescriptor(fromEclipsePreferenceFile ? "preference_importer" : "preference_picker"));
            this.fromEclipsePreferenceFile = fromEclipsePreferenceFile;
        }

        public void run() {
            PreferenceCaptureDialog preferenceCaptureDialog = new PreferenceCaptureDialog(null, this.setupEditor.getAdapterFactory(), this.fromEclipsePreferenceFile);
            if (preferenceCaptureDialog.open() == 0) {
                RecorderTransaction transaction = RecorderTransaction.open((boolean)false, (IEditorPart)this.setupEditor);
                try {
                    transaction.setPreferences(preferenceCaptureDialog.getResult());
                    transaction.commit();
                }
                finally {
                    transaction.close();
                }
            }
        }

        public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
            if (workbenchPart instanceof SetupEditor) {
                this.setupEditor = (SetupEditor)workbenchPart;
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
                this.setupEditor = null;
            }
        }
    }

    private class PreferenceRecorderToolbarAction
    extends Action {
        public PreferenceRecorderToolbarAction(boolean withDialog) {
            super("Record Preferences", SetupEditorPlugin.INSTANCE.getImageDescriptor("preference_recorder"));
        }

        public void run() {
            RecorderManager.INSTANCE.record(SetupActionBarContributor.this.getActiveEditor());
        }
    }

    private static final class RevertAction
    extends Action {
        private SetupEditor setupEditor;

        private RevertAction() {
        }

        public void run() {
            this.setupEditor.doRevert();
        }

        public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
            if (workbenchPart instanceof SetupEditor) {
                this.setupEditor = (SetupEditor)workbenchPart;
                this.setEnabled(true);
                this.setChecked(this.setupEditor.selectionViewer.getInput() instanceof ResourceSet);
            } else {
                this.setEnabled(false);
                this.setupEditor = null;
            }
        }
    }

    @Deprecated
    private class TestInstallAction
    extends Action {
        private Project project;

        public TestInstallAction() {
            super("Test Install", 1);
            this.setImageDescriptor(SetupEditorPlugin.INSTANCE.getImageDescriptor("run"));
            this.setToolTipText("Launch the installer with the current project");
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object element;
            IStructuredSelection structuredSelection;
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (element = structuredSelection.getFirstElement()) instanceof EObject) {
                this.project = this.getProject((EObject)element);
                if (this.project != null) {
                    this.setEnabled(true);
                    return;
                }
            }
            this.project = null;
            this.setEnabled(false);
        }

        public void run() {
        }

        private Project getProject(EObject object) {
            while (object != null && !(object instanceof Project)) {
                object = object.eContainer();
            }
            return (Project)object;
        }
    }

    protected static final class ToggleViewerInputAction
    extends Action {
        private SetupEditor setupEditor;

        public ToggleViewerInputAction() {
            super("Show Resources", 2);
            this.setImageDescriptor(SetupEditorPlugin.INSTANCE.getImageDescriptor("ToggleInput"));
            this.setToolTipText("Show all resources");
        }

        public void run() {
            this.setupEditor.toggleInput();
        }

        public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
            if (workbenchPart instanceof SetupEditor) {
                this.setupEditor = (SetupEditor)workbenchPart;
                this.setEnabled(true);
                this.setChecked(this.setupEditor.selectionViewer.getInput() instanceof ResourceSet);
            } else {
                this.setEnabled(false);
                this.setupEditor = null;
            }
        }
    }
}

