/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.impl.cookie.DateUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.oomph.internal.util.UtilPlugin;
import org.eclipse.oomph.util.HexUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.StringUtil;
import org.osgi.framework.Bundle;

public final class HTTPServer {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_REQUEST = false;
    private static final boolean DEBUG_RESPONSE = false;
    private static final Map<String, String> CONTENT_TYPES = new HashMap<String, String>();
    private static final ImageContext IMAGE_CONTEXT = new ImageContext();
    private static final String PATH_SEPARATOR = "/";
    private static final String STATUS_OK = "200 OK";
    private static final String STATUS_SEE_OTHER = "303 See Other";
    private static final String STATUS_BAD_REQUEST = "400 Bad Request";
    private static final String STATUS_FORBIDDEN = "403 Forbidden";
    private static final String STATUS_NOT_FOUND = "404 Not Found";
    private static final String STATUS_INTERNAL_SERVER_ERROR = "500 Internal Server Error";
    private static final String STATUS_NOT_IMPLEMENTED = "501 Not Implemented";
    private final List<Context> contexts = new ArrayList<Context>();
    private final ExecutorService threadPool = Executors.newCachedThreadPool();
    private Acceptor acceptor;

    static {
        HTTPServer.registerContentType("application/java-archive", "jar");
        HTTPServer.registerContentType("application/javascript", "js");
        HTTPServer.registerContentType("application/json", "json");
        HTTPServer.registerContentType("application/jsonml+json", "jsonml");
        HTTPServer.registerContentType("application/pdf", "pdf");
        HTTPServer.registerContentType("application/xaml+xml", "xaml");
        HTTPServer.registerContentType("application/xhtml+xml", "xhtml", "xht");
        HTTPServer.registerContentType("application/xml", "xml", "xsl");
        HTTPServer.registerContentType("application/xml-dtd", "dtd");
        HTTPServer.registerContentType("application/xslt+xml", "xslt");
        HTTPServer.registerContentType("application/zip", "zip");
        HTTPServer.registerContentType("image/bmp", "bmp");
        HTTPServer.registerContentType("image/gif", "gif");
        HTTPServer.registerContentType("image/jpeg", "jpeg", "jpg", "jpe");
        HTTPServer.registerContentType("image/png", "png");
        HTTPServer.registerContentType("image/svg+xml", "svg", "svgz");
        HTTPServer.registerContentType("image/tiff", "tiff", "tif");
        HTTPServer.registerContentType("image/x-icon", "ico");
        HTTPServer.registerContentType("text/css", "css");
        HTTPServer.registerContentType("text/html", "html", "htm");
        HTTPServer.registerContentType("text/plain", "txt", "text", "conf", "def", "list", "log", "in");
        HTTPServer.registerContentType("text/x-java-source", "java");
    }

    public HTTPServer() throws IOException {
        this(15000, 50000);
    }

    public HTTPServer(int minPort, int maxPort) throws IOException {
        this.addContext(IMAGE_CONTEXT);
        int port = minPort;
        while (port <= maxPort) {
            try {
                ServerSocket serverSocket = new ServerSocket(port, 500);
                this.acceptor = new Acceptor(serverSocket);
                return;
            }
            catch (BindException bindException) {
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("Start interrupted");
            }
            ++port;
        }
        throw new IOException("No port available between " + minPort + " and " + maxPort);
    }

    public int getPort() {
        if (this.acceptor != null) {
            return this.acceptor.getPort();
        }
        return 0;
    }

    public String getURL() {
        int port = this.acceptor != null ? this.acceptor.getPort() : 0;
        return "http://127.0.0.1:" + port;
    }

    public synchronized void addContext(Context context) {
        this.contexts.add(context);
        Collections.sort(this.contexts);
    }

    public synchronized void removeContext(Context context) {
        this.contexts.remove(context);
    }

    public synchronized Context getContext(String path) {
        for (Context context : this.contexts) {
            if (!path.startsWith(context.getPath())) continue;
            return context;
        }
        return null;
    }

    public void stop() throws IOException {
        if (this.acceptor != null) {
            this.acceptor.interrupt();
            this.threadPool.shutdown();
        }
    }

    public String toString() {
        return this.getURL();
    }

    private static void registerContentType(String contentType, String ... extensions) {
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            CONTENT_TYPES.put(extension, contentType);
            ++n2;
        }
    }

    public static void main(String[] args) throws Exception {
        HTTPServer server = new HTTPServer(80, 100);
        server.addContext(new FileContext("/file/c", true, new File("C:")));
        server.addContext(new FileContext("/file/e", true, new File("E:")));
        System.out.println("http://localhost:" + server.getPort());
        System.out.println();
        while (System.in.available() == 0) {
            Thread.sleep(50L);
        }
        server.stop();
    }

    private final class Acceptor
    extends Thread {
        private final ServerSocket serverSocket;
        private final CountDownLatch started;

        public Acceptor(ServerSocket serverSocket) throws InterruptedException {
            super("Httpd");
            this.started = new CountDownLatch(1);
            this.serverSocket = serverSocket;
            this.setDaemon(true);
            this.start();
            this.started.await();
        }

        public int getPort() {
            return this.serverSocket.getLocalPort();
        }

        public void run() {
            this.started.countDown();
            while (true) {
                try {
                    while (true) {
                        Socket socket = this.serverSocket.accept();
                        RequestHandler requestHandler = new RequestHandler(socket);
                        HTTPServer.this.threadPool.execute(requestHandler);
                    }
                }
                catch (Exception ex) {
                    if (Acceptor.interrupted()) {
                        return;
                    }
                    UtilPlugin.INSTANCE.log(ex);
                    continue;
                }
                break;
            }
        }

        public void interrupt() {
            try {
                super.interrupt();
            }
            finally {
                IOUtil.closeSilent(this.serverSocket);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Context
    implements Comparable<Context> {
        private static final String URL_ENCODING = "UTF-8";
        private final String path;
        private final boolean allowDirectory;

        protected Context(String path, boolean allowDirectory) {
            if (!path.startsWith(HTTPServer.PATH_SEPARATOR)) {
                throw new IllegalArgumentException("Path must start with a slash: " + path);
            }
            this.path = path;
            this.allowDirectory = allowDirectory;
        }

        public final String getPath() {
            return this.path;
        }

        public final boolean isAllowDirectory() {
            return this.allowDirectory;
        }

        @Override
        public final int compareTo(Context o) {
            return o.path.length() - this.path.length();
        }

        public Object getRoot() {
            return null;
        }

        public String getURL(HTTPServer server) {
            return String.valueOf(server.getURL()) + this.path;
        }

        public final String toString() {
            String string = String.valueOf(this.getClass().getSimpleName()) + "[" + this.path;
            Object root = this.getRoot();
            if (root != null) {
                string = String.valueOf(string) + " --> " + root;
            }
            return String.valueOf(string) + "]";
        }

        protected void handleRequest(String path, DataOutputStream output, boolean responseBody) throws IOException {
            if (this.isDirectory(path)) {
                if (!this.allowDirectory) {
                    Context.sendResponse(output, HTTPServer.STATUS_FORBIDDEN, null, 0L, false);
                } else {
                    String[] children;
                    if (!path.endsWith(HTTPServer.PATH_SEPARATOR)) {
                        path = String.valueOf(path) + HTTPServer.PATH_SEPARATOR;
                        Context.sendResponse(output, HTTPServer.STATUS_SEE_OTHER, path, 0L, false);
                    } else {
                        Context.sendResponse(output, HTTPServer.STATUS_OK, "index.html", 0L, false);
                    }
                    if (path.length() > 1) {
                        output.writeBytes("<img src=\"/~/folderup\" valign=\"middle\"/> <a href=\"../\">..</a><br>\r\n");
                    }
                    if ((children = this.getChildren(path)) != null) {
                        final String finalPath = path;
                        Arrays.sort(children, new Comparator<String>(){

                            @Override
                            public int compare(String n1, String n2) {
                                int t2;
                                int t1 = this.getType(n1);
                                int result = t1 - (t2 = this.getType(n2));
                                if (result == 0) {
                                    result = StringUtil.safe(n1).toLowerCase().compareTo(StringUtil.safe(n2).toLowerCase());
                                }
                                return result;
                            }

                            private int getType(String child) {
                                return Context.this.isDirectory(String.valueOf(finalPath) + child) ? 1 : 2;
                            }
                        });
                        String[] stringArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String child = stringArray[n2];
                            boolean directory = this.isDirectory(String.valueOf(path) + child);
                            output.writeBytes("<img src=\"/~" + (directory ? "/folder" : "/file") + "\" valign=\"middle\"/> ");
                            String trailingSlash = directory ? HTTPServer.PATH_SEPARATOR : "";
                            output.writeBytes("<a href=\"" + Context.encodePath(child) + trailingSlash + "\">" + child + trailingSlash + "</a><br>\r\n");
                            ++n2;
                        }
                    }
                }
                return;
            }
            if (!this.isFile(path)) {
                Context.sendResponse(output, HTTPServer.STATUS_NOT_FOUND, null, 0L, false);
                return;
            }
            long lastModified = this.getLastModified(path);
            Context.sendResponse(output, HTTPServer.STATUS_OK, path, lastModified, false);
            if (responseBody) {
                InputStream stream = null;
                try {
                    stream = this.getContents(path);
                    IOUtil.copy(stream, output);
                }
                finally {
                    IOUtil.close(stream);
                }
            }
        }

        protected abstract boolean isDirectory(String var1);

        protected abstract boolean isFile(String var1);

        protected abstract String[] getChildren(String var1) throws IOException;

        protected abstract InputStream getContents(String var1) throws IOException;

        protected long getLastModified(String path) throws IOException {
            return System.currentTimeMillis();
        }

        protected static String encodePath(String path) throws UnsupportedEncodingException {
            StringBuilder builder = new StringBuilder();
            StringTokenizer tokenizer = new StringTokenizer(path, HTTPServer.PATH_SEPARATOR);
            while (tokenizer.hasMoreTokens()) {
                if (builder.length() != 0) {
                    builder.append(HTTPServer.PATH_SEPARATOR);
                }
                String token = tokenizer.nextToken();
                builder.append(URLEncoder.encode(token, URL_ENCODING));
            }
            return builder.toString();
        }

        protected static String decodePath(String path) throws UnsupportedEncodingException {
            return URLDecoder.decode(path, URL_ENCODING);
        }

        protected static String formatDate(long lastModified) {
            return DateUtils.formatDate((Date)new Date(lastModified));
        }

        protected static void sendResponse(DataOutputStream output, String status, String fileName, long lastModified, boolean ignoreExceptions) {
            try {
                output.writeBytes("HTTP/1.0 ");
                output.writeBytes(status);
                output.writeBytes("\r\nConnection: close\r\nServer: ");
                output.writeBytes(HTTPServer.class.getName());
                output.writeBytes("\r\n");
                String location = null;
                if (status == HTTPServer.STATUS_SEE_OTHER) {
                    location = fileName;
                    fileName = "index.html";
                }
                int lastDot = fileName == null ? -1 : fileName.lastIndexOf(46);
                String extension = lastDot == -1 ? "txt" : fileName.substring(lastDot + 1);
                String contentType = (String)CONTENT_TYPES.get(extension);
                if (contentType == null) {
                    contentType = (String)CONTENT_TYPES.get("txt");
                }
                output.writeBytes("Content-Type: ");
                output.writeBytes(contentType);
                output.writeBytes("\r\n");
                if (lastModified != 0L) {
                    output.writeBytes("Last-Modified: ");
                    output.writeBytes(Context.formatDate(lastModified));
                    output.writeBytes("\r\n");
                }
                if (location != null) {
                    output.writeBytes("Location: /file/c");
                    output.writeBytes(location);
                    output.writeBytes("\r\n");
                    output.writeBytes("\r\n");
                    return;
                }
                output.writeBytes("\r\n");
                if (status == HTTPServer.STATUS_OK) {
                    return;
                }
                output.writeBytes(status);
                output.writeBytes("\r\n");
            }
            catch (IOException ex) {
                if (ignoreExceptions) {
                    return;
                }
                if (ex instanceof SocketException && ex.getMessage().equals("Software caused connection abort: socket write error")) {
                    return;
                }
                UtilPlugin.INSTANCE.log(ex);
            }
        }
    }

    public static class FileContext
    extends Context {
        private final File root;

        public FileContext(String path, boolean allowDirectory, File root) {
            super(path, allowDirectory);
            this.root = root;
        }

        public final File getRoot() {
            return this.root;
        }

        protected boolean isDirectory(String path) {
            return this.getFile(path).isDirectory();
        }

        protected boolean isFile(String path) {
            return this.getFile(path).isFile();
        }

        protected String[] getChildren(String path) throws IOException {
            return this.getFile(path).list();
        }

        protected InputStream getContents(String path) throws IOException {
            File file = this.getFile(path);
            return new FileInputStream(file);
        }

        protected long getLastModified(String path) throws IOException {
            File file = this.getFile(path);
            return file.lastModified();
        }

        private File getFile(String path) {
            if (this.root == null) {
                return new File(path);
            }
            return new File(this.root, path);
        }
    }

    public static class ImageContext
    extends Context {
        public static final String CONTEXT_PATH = "/~";
        public static final String NAME_CONTEXT = "/context";
        public static final String NAME_FOLDER_UP = "/folderup";
        public static final String NAME_FOLDER = "/folder";
        public static final String NAME_FILE = "/file";
        private static final byte[] ICON_CONTEXT = HexUtil.hexToBytes("47494638396110001000e600002d2b4f3c4967f2f6ff3c4a672e4162304262394a68002e77002b723146672f4363344a6d304362384d6f374c6d384c6d394b6a384a683d5070b3bdcd002f77003177344a6c324767304463354b6c384e6eb2bdcdb4bfceb4bcc7b3bfceb8c3d0246ebd2770be2870be2971be4e69874f69874f6a87b4bdc7f2f8ff256fbd2973c14e6c8af1f8fff3f9fff7fbff4e6d8aeef7fff0f8fff4faffeff8fff1f9fff6fbff448fc3448ec2448fc2f2fafff4fbfff7fcff529bbf519abe579cbff9fdfffcfeff539cbf549cbf579dbff8fefffdfffffeffffa1c3bea2c3bea1c2bda3c3bea2c2bdd1e8e4a3c3bdcbefc2cbeec2cbecbeccedbeeaefe7e9eee5eaeee5e9ede3e6eae0eaeee3ffffc4ffffcbffffd2ffffd7ffffdcebebe2c8c498c7c498cac59aecebe2e6e3d2e6e2cfe6e2d0e5e1cfe7e3d2e5e1d0f4f0e3f3efe3ffffffffffff00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000021f9040100006b002c00000000100010000007b3806b8283848583001f524c2a2636244169861f1a19604f62106749213e8552195c0b1b6a096a6a50013d844c600b5b161e5fa60447295d832a4e130b5a0d0e5346456a493c8326666a1c0d59120755406a6524833810175e0f12582b08450a1137832464443b54142f151d353fd2833c49322839570827562d2ec4835d2050053066e8a011830192146108f508a084c50c0c33044419a0aad090114dc61818b344c4104382d0082971a30424902853aa141408003b");
        private static final byte[] ICON_FOLDER_UP = HexUtil.hexToBytes("47494638396110001000841d009c6a3c41913b4a9045ac7a44ac7a4cac825cb48a54bc9264bc926cc4a274ccaa74d4b27cdcb2745edb63e4c27c72e57f93e596ecd28cfcd27cf4da949df3a7fcda8cfce29cfce2a4aff8b7fcea9cfceab4fcf2ccfcfefcffffffffffffffffff21f904010a001f002c000000001000100000056de0278e64699ee7b2280c3a1a5ccc19ae925951e42809df93898d7023180a13408de62280082e4b0d0178b1081e108ae0c0e5220e1f4345d0c05230024bc53289800d128120e094572a39f067203938e80212120e126e230007824d81827d2505908090902e8b2e2502979a2421003b");
        private static final byte[] ICON_FOLDER = HexUtil.hexToBytes("47494638396110001000c40000f8e898f8f0c8f8e8b0e8d088f0d890f8e098f8e0a0f8d888f8d078e0c078f8d890f8d080d8b070bc8532c38b36b47f32a56c24ad722bbc7f32c38536ad6c249e6627ad722f9e5f1d9e5f208f5219ffffffffffff00000000000000000000000021f9040100001b002c0000000010001000000555e0268e64699ea7a33ae84869b046b513001043c24c3c4f3681a070d8204904c8a412437a189e068b744add4414584b61cbdd0e2c1bc8e160199bcd5fd1056159b8dfeeb4286341d8ef76f9a8c2effb5b8081828021003b");
        private static final byte[] ICON_FILE = HexUtil.hexToBytes("47494638396110001000a529007b744f7e754e7e764e84784c867b4c8b7c4a8d7e4a9280489b83459d85449e8544a38842a38843a98a41ad8c3fb18f3eb4903dd4b268d4b269d5b269dabd7ce0c88fdde8f7e1ebf8e4edf9e8effaecf1faedf2faeef3faf0f4fbf3f7fbf5f7fbf6f7fcf5f8fbf5f8fcf6f8fbf7f9fbf8f9fbf8f9fcf7fafcf9fafcffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff21f904010a003f002c0000000010001000000669c09f10422c1285482404c56c4a2049e4c3442d9d4894c923fa73843e20d04854a1441cd18667cd6637a28c8e7c3e5f44159bfc86a3df24ee1a8182827f490819888989075106188f909005510417969797035102169d9e9e019b9fa3a14900a7a8a9005cacadae4941003b");
        private static final byte[] ICON_UNKNOWN = HexUtil.hexToBytes("47494638396110001000d50000f7f8fcf3f5fbf8f9fcf5f7fcf3f5faf1f4fbeef2faf2f5fbf5f7fbebf0f9f0f4fbe5ecf8e7eef9e9eff9edf2faf4f7fce5edf9e4ecf8e8eff9ebf1faf0f4faf6f8fbe3ecf8e6eef9e5edf8ebf1f9eef3fae4edf8e6eef8eaf1faf2f6fbf1f5fadbe4eee8f0f9edf3faf0f5fa2862964476a45d89b15f8ab16a92b76c94b8799dbe95b2cca2bbd35080aa7b745081774e928048897a4c85784d9782478e7d4aa68942a287439d8445b4903db18e3eaf8d3fab8b40ffffff00000000000000000021f9040100003c002c000000001000100000068d409e70482c0e71c8a41249cc099ed0688ea88b5a053ae20e5001954860107747ac211e27526a05460c6a44dbe1c0521d022d12c16323de280a2305232624261f0a3744331a06060e852822061a3344301913131d609a09133044342112a52c2c210d120d3444311c171c0c60b017173144320b18181110bf181b1132442f16c7c8c92f442ecdcecfcd46d24541003b");

        public ImageContext() {
            super(CONTEXT_PATH, false);
        }

        protected boolean isDirectory(String path) {
            return false;
        }

        protected boolean isFile(String path) {
            return true;
        }

        protected String[] getChildren(String path) throws IOException {
            return null;
        }

        protected InputStream getContents(String path) throws IOException {
            byte[] bytes = this.getImage(path);
            return new ByteArrayInputStream(bytes);
        }

        private byte[] getImage(String path) {
            if (NAME_CONTEXT.equals(path)) {
                return ICON_CONTEXT;
            }
            if (NAME_FOLDER_UP.equals(path)) {
                return ICON_FOLDER_UP;
            }
            if (NAME_FOLDER.equals(path)) {
                return ICON_FOLDER;
            }
            if (NAME_FILE.equals(path)) {
                return ICON_FILE;
            }
            return ICON_UNKNOWN;
        }

        public static void main(String[] args) {
            System.out.println("private static final byte[] ICON_CONTEXT = HexUtil.hexToBytes(\"" + HexUtil.bytesToHex(IOUtil.readFile(new File("/develop/icons/configuration_obj.gif"))) + "\");");
            System.out.println("private static final byte[] ICON_FOLDER_UP = HexUtil.hexToBytes(\"" + HexUtil.bytesToHex(IOUtil.readFile(new File("/develop/icons/FolderUp.gif"))) + "\");");
            System.out.println("private static final byte[] ICON_FOLDER = HexUtil.hexToBytes(\"" + HexUtil.bytesToHex(IOUtil.readFile(new File("/develop/icons/folder7.gif"))) + "\");");
            System.out.println("private static final byte[] ICON_FILE = HexUtil.hexToBytes(\"" + HexUtil.bytesToHex(IOUtil.readFile(new File("/develop/icons/file.gif"))) + "\");");
            System.out.println("private static final byte[] ICON_UNKNOWN = HexUtil.hexToBytes(\"" + HexUtil.bytesToHex(IOUtil.readFile(new File("/develop/icons/unknown_obj.gif"))) + "\");");
        }
    }

    public static class PluginContext
    extends Context {
        public PluginContext(String path, boolean allowDirectory) {
            super(path, allowDirectory);
        }

        protected boolean isDirectory(String path) {
            if (path.length() == 1) {
                return true;
            }
            try {
                OomphPlugin.BundleFile file = this.getFile(path);
                return file.isDirectory();
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
        }

        protected boolean isFile(String path) {
            try {
                OomphPlugin.BundleFile file = this.getFile(path);
                return !file.isDirectory();
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
        }

        protected String[] getChildren(String path) throws IOException {
            String[] result;
            if (path.length() == 1) {
                Bundle[] bundles = UtilPlugin.INSTANCE.getBundleContext().getBundles();
                result = new String[bundles.length];
                int i = 0;
                while (i < bundles.length) {
                    result[i] = bundles[i].getSymbolicName();
                    ++i;
                }
            } else {
                OomphPlugin.BundleFile file = this.getFile(path);
                List<OomphPlugin.BundleFile> children = file.getChildren();
                result = new String[children.size()];
                int i = 0;
                while (i < result.length) {
                    result[i] = children.get(i).getName();
                    ++i;
                }
            }
            return result;
        }

        protected InputStream getContents(String path) throws IOException {
            OomphPlugin.BundleFile file = this.getFile(path);
            return file.getContents();
        }

        protected long getLastModified(String path) throws IOException {
            OomphPlugin.BundleFile file = this.getFile(path);
            return file.getBundle().getLastModified();
        }

        private OomphPlugin.BundleFile getFile(String path) throws FileNotFoundException {
            String[] segments = path.split(HTTPServer.PATH_SEPARATOR);
            Bundle bundle = Platform.getBundle((String)segments[1]);
            OomphPlugin.BundleFile file = new RootBundleFile(bundle);
            int i = 2;
            while (file != null && i < segments.length) {
                String segment = segments[i];
                file = file.getChild(segment);
                ++i;
            }
            if (file == null) {
                throw new FileNotFoundException(path);
            }
            return file;
        }

        private static class RootBundleFile
        extends OomphPlugin.BundleFile {
            private Bundle bundle;

            public RootBundleFile(Bundle bundle) {
                super("", true, null);
                this.bundle = bundle;
            }

            public Bundle getBundle() {
                return this.bundle;
            }

            public String getPath() {
                return "";
            }
        }
    }

    private final class RequestHandler
    implements Runnable {
        private final Socket socket;

        public RequestHandler(Socket socket) {
            this.socket = socket;
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            block13: {
                inputStream = null;
                outputStream = null;
                try {
                    inputStream = this.socket.getInputStream();
                    outputStream = this.socket.getOutputStream();
                    ** GOTO lbl20
                }
                catch (Exception ex) {
                    if (this.isBadState()) {
                        IOUtil.closeSilent(outputStream);
                        IOUtil.closeSilent(inputStream);
                        IOUtil.closeSilent(this.socket);
                        return;
                    }
                    UtilPlugin.INSTANCE.log(ex);
lbl20:
                    // 2 sources

                    if (inputStream == null || outputStream == null) break block13;
                    input = new BufferedReader(new InputStreamReader(inputStream));
                    output = new DataOutputStream(outputStream);
                    try {
                        this.handleRequest(input, output);
                        ** GOTO lbl40
                    }
                    catch (Exception ex) {
                        if (this.isBadState()) {
                            IOUtil.closeSilent(outputStream);
                            IOUtil.closeSilent(inputStream);
                            IOUtil.closeSilent(this.socket);
                            return;
                        }
                        try {
                            if (!(ex instanceof SocketException)) {
                                UtilPlugin.INSTANCE.log(ex);
                            }
                            Context.sendResponse(output, "500 Internal Server Error", null, 0L, true);
lbl40:
                            // 2 sources

                            try {
                                output.flush();
                            }
                            catch (IOException var5_7) {}
                        }
                        catch (Throwable var6_8) {
                            IOUtil.closeSilent(outputStream);
                            IOUtil.closeSilent(inputStream);
                            IOUtil.closeSilent(this.socket);
                            throw var6_8;
                        }
                    }
                }
            }
            IOUtil.closeSilent(outputStream);
            IOUtil.closeSilent(inputStream);
            IOUtil.closeSilent(this.socket);
        }

        private void handleRequest(BufferedReader input, DataOutputStream output) throws Exception {
            String line = input.readLine();
            if (line == null) {
                return;
            }
            String[] tokens = (line = line.replace(" ", " ")).split(" ");
            if (tokens.length < 2) {
                Context.sendResponse(output, HTTPServer.STATUS_BAD_REQUEST, null, 0L, false);
                return;
            }
            String method = tokens[0];
            boolean head = "HEAD".equalsIgnoreCase(method);
            if (!head && !"GET".equalsIgnoreCase(method)) {
                Context.sendResponse(output, HTTPServer.STATUS_NOT_IMPLEMENTED, null, 0L, false);
                return;
            }
            URI uri = new URI("xxx:" + tokens[1]);
            String path = Context.decodePath(uri.getPath());
            Context context = HTTPServer.this.getContext(path);
            if (context == null) {
                if (HTTPServer.PATH_SEPARATOR.equals(path)) {
                    Context.sendResponse(output, HTTPServer.STATUS_OK, "index.html", 0L, false);
                    for (Context c : HTTPServer.this.contexts) {
                        if (c == IMAGE_CONTEXT) continue;
                        String href = c.getPath();
                        output.writeBytes("<img src=\"/~/context\" valign=\"middle\"/> <a href=\"" + href + HTTPServer.PATH_SEPARATOR + "\">" + href + "</a><br>\r\n");
                    }
                    return;
                }
                Context.sendResponse(output, HTTPServer.STATUS_NOT_FOUND, null, 0L, false);
                return;
            }
            if (!(path = path.substring(context.getPath().length())).startsWith(HTTPServer.PATH_SEPARATOR)) {
                path = HTTPServer.PATH_SEPARATOR + path;
            }
            context.handleRequest(path, output, !head);
        }

        private boolean isBadState() {
            return this.socket.isClosed() || !this.socket.isConnected() || this.socket.isInputShutdown() || this.socket.isOutputShutdown();
        }
    }
}

