/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.preferences.presentation;

import java.lang.reflect.Method;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.oomph.preferences.presentation.PreferencesEditorPlugin;
import org.eclipse.oomph.preferences.provider.PreferencesItemProviderAdapterFactory;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;

public class AllPreferencesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench workbench;

    public AllPreferencesPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
    }

    protected Control createContents(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        TreeViewer treeViewer = new TreeViewer(composite);
        PreferencesItemProviderAdapterFactory adapterFactory = new PreferencesItemProviderAdapterFactory();
        treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        treeViewer.setInput((Object)PreferencesUtil.getRootPreferenceNode());
        treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        return composite;
    }

    protected void contributeButtons(Composite parent) {
        super.contributeButtons(parent);
        GridLayout gridLayout = (GridLayout)parent.getLayout();
        ++gridLayout.numColumns;
        Button editButton = new Button(parent, 8);
        editButton.setText("Edit...");
        Dialog.applyDialogFont((Control)editButton);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minButtonSize = editButton.computeSize(-1, -1, true);
        GridData data = new GridData(256);
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        editButton.setLayoutData((Object)data);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPreferencePageContainer container = AllPreferencesPreferencePage.this.getContainer();
                try {
                    Method method = container.getClass().getMethod("close", new Class[0]);
                    method.invoke((Object)container, new Object[0]);
                }
                catch (Throwable ex) {
                    PreferencesEditorPlugin.INSTANCE.log(ex);
                }
                AllPreferencesPreferencePage.this.openWorkingSetsEditor();
            }
        });
    }

    protected void openWorkingSetsEditor() {
        final IWorkbenchWindow activeWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
        Display display = activeWorkbenchWindow.getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                try {
                    URIEditorInput editorInput = new URIEditorInput(PreferencesUtil.ROOT_PREFERENCE_NODE_URI.trimSegments(1).appendSegment("All.preferences"), "All Preferences");
                    IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                    activePage.openEditor((IEditorInput)editorInput, "org.eclipse.oomph.preferences.presentation.PreferencesEditorID");
                    activePage.showView("org.eclipse.ui.views.PropertySheet");
                }
                catch (Exception ex) {
                    PreferencesEditorPlugin.INSTANCE.log(ex);
                }
            }
        });
    }
}

