/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.internal.setup.SetupPrompter;
import org.eclipse.oomph.internal.setup.SetupProperties;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;
import org.eclipse.oomph.setup.internal.core.StringFilterRegistry;
import org.eclipse.oomph.setup.util.StringExpander;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.OfflineMode;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSetupTaskContext
extends StringExpander
implements SetupTaskContext,
SetupProperties {
    private static final Pattern setLauncherNamePattern = Pattern.compile("setLauncherName\\(name:([^)]*)\\)");
    private SetupPrompter prompter;
    private Trigger trigger;
    private SetupContext setupContext;
    private Boolean selfHosting;
    private boolean performing;
    private boolean mirrors = true;
    private Set<String> restartReasons = new LinkedHashSet<String>();
    private URIConverter uriConverter;
    private Map<Object, Object> map = new LinkedHashMap<Object, Object>();
    private String launcherName;

    protected AbstractSetupTaskContext(URIConverter uriConverter, SetupPrompter prompter, Trigger trigger, SetupContext setupContext) {
        this.uriConverter = uriConverter;
        this.prompter = prompter;
        this.trigger = trigger;
        this.initialize(setupContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(SetupContext setupContext) {
        this.setSetupContext(setupContext);
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        Properties properties = System.getProperties();
        Properties properties2 = properties;
        synchronized (properties2) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                this.put(key, value);
                if (!"eclipse.home.location".equals(key)) continue;
                URI eclipseHomeRootLocation = URI.createURI((String)value.toString()).trimSegments(OS.INSTANCE.isMac() ? 3 : 1);
                this.put("eclipse.home.root.location", eclipseHomeRootLocation.toString());
            }
        }
        this.put("oomph.update.url", SetupCorePlugin.UPDATE_URL);
        for (Map.Entry entry : CONTROL_CHARACTER_VALUES.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Map<Object, Object> getMap() {
        return this.map;
    }

    public SetupPrompter getPrompter() {
        return this.prompter;
    }

    public void setPrompter(SetupPrompter prompter) {
        this.prompter = prompter;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public void checkCancelation() {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public boolean isOffline() {
        return OfflineMode.isEnabled();
    }

    public void setOffline(boolean offline) {
        OfflineMode.setEnabled((boolean)offline);
    }

    public boolean isMirrors() {
        return this.mirrors;
    }

    public void setMirrors(boolean mirrors) {
        this.mirrors = mirrors;
    }

    public boolean isSelfHosting() {
        if (this.selfHosting == null) {
            try {
                Profile profile;
                Agent agent = P2Util.getAgentManager().getCurrentAgent();
                this.selfHosting = agent != null ? Boolean.valueOf((profile = agent.getCurrentProfile()) == null || profile.isSelfHosting()) : Boolean.valueOf(true);
            }
            catch (Throwable throwable) {
                this.selfHosting = true;
            }
        }
        return this.selfHosting;
    }

    public boolean isPerforming() {
        return this.performing;
    }

    public boolean isRestartNeeded() {
        return !this.restartReasons.isEmpty();
    }

    public void setRestartNeeded(String reason) {
        this.restartReasons.add(reason);
    }

    public Set<String> getRestartReasons() {
        return this.restartReasons;
    }

    public URI redirect(URI uri) {
        if (uri == null) {
            return null;
        }
        return this.getURIConverter().normalize(uri);
    }

    public String redirect(String uri) {
        if (!StringUtil.isEmpty((String)uri)) {
            try {
                return this.redirect(URI.createURI((String)uri)).toString();
            }
            catch (RuntimeException runtimeException) {}
        }
        return uri;
    }

    public URIConverter getURIConverter() {
        return this.uriConverter;
    }

    public OS getOS() {
        OS os = (OS)this.get(OS.class);
        if (os != null) {
            return os;
        }
        return OS.INSTANCE;
    }

    public File getProductLocation() {
        File installationLocation = this.getInstallationLocation();
        if (installationLocation == null) {
            return null;
        }
        String relativeProductFolder = this.getRelativeProductFolder();
        return new File(installationLocation, relativeProductFolder);
    }

    public File getProductConfigurationLocation() {
        File productLocation = this.getProductLocation();
        if (productLocation == null) {
            return null;
        }
        return new File(productLocation, "configuration");
    }

    public String getRelativeProductFolder() {
        String productFolderName = this.getProductFolderName();
        return this.getOS().getRelativeProductFolder(productFolderName);
    }

    private String getProductFolderName() {
        Installation installation = this.getInstallation();
        ProductVersion productVersion = installation.getProductVersion();
        OS os = this.getOS();
        String osgiOS = os.getOsgiOS();
        String osgiWS = os.getOsgiWS();
        String osgiArch = os.getOsgiArch();
        String[] keys = new String[]{"folderName." + osgiOS + '.' + osgiWS + '.' + osgiArch, "folderName." + osgiOS + '.' + osgiWS, "folderName." + osgiOS, "folderName"};
        return this.getProductFolderName((Scope)productVersion, keys);
    }

    private String getProductFolderName(Scope scope, String[] keys) {
        if (scope == null) {
            return "";
        }
        Annotation annotation = scope.getAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
        if (annotation != null) {
            EMap details = annotation.getDetails();
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String folderName = (String)details.get((Object)key);
                if (folderName != null) {
                    return folderName;
                }
                ++n2;
            }
        }
        return this.getProductFolderName(scope.getParentScope(), keys);
    }

    public String getLauncherName() {
        if (this.launcherName == null) {
            Profile profile = this.getProfile();
            this.launcherName = AbstractSetupTaskContext.getLauncherName((IProfile)profile);
        }
        return this.launcherName;
    }

    private static String getLauncherName(IProfile profile) {
        for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)profile.query(QueryUtil.createIUAnyQuery(), null))) {
            Collection touchpointDatas = iu.getTouchpointData();
            if (touchpointDatas == null) continue;
            for (ITouchpointData touchpointData : touchpointDatas) {
                Matcher matcher;
                String body;
                ITouchpointInstruction instruction = touchpointData.getInstruction("configure");
                if (instruction == null || (body = instruction.getBody()) == null || !(matcher = setLauncherNamePattern.matcher(body)).matches()) continue;
                return matcher.group(1);
            }
        }
        SetupCorePlugin.INSTANCE.log("Could not determine the launcher name from " + profile.getProfileId(), 4);
        return "eclipse";
    }

    public Profile getProfile() {
        Profile profile = (Profile)this.get(Profile.class);
        if (profile == null) {
            profile = P2Util.getAgentManager().getCurrentAgent().getCurrentProfile();
        }
        return profile;
    }

    public Workspace getWorkspace() {
        return this.setupContext.getWorkspace();
    }

    public SetupContext getSetupContext() {
        return this.setupContext;
    }

    protected final void setSetupContext(SetupContext setupContext) {
        this.setupContext = setupContext;
    }

    public User getUser() {
        return this.setupContext.getUser();
    }

    public Installation getInstallation() {
        return this.setupContext.getInstallation();
    }

    protected final void setPerforming(boolean performing) {
        this.performing = performing;
    }

    public Object get(Object key) {
        String name;
        Object value = this.map.get(key);
        if (value == null && key instanceof String && (name = (String)key).indexOf(46) != -1) {
            name = name.replace('.', '_');
            value = this.map.get(name);
        }
        return value;
    }

    public Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    public Set<Object> keySet() {
        return this.map.keySet();
    }

    protected String lookup(String key) {
        Object object = this.get(key);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    protected String filter(String value, String filterName) {
        return StringFilterRegistry.INSTANCE.filter(value, filterName);
    }
}

