/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.jdt.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.jdt.JDTPackage;
import org.eclipse.oomph.setup.jdt.JRELibrary;
import org.eclipse.oomph.setup.jdt.JRETask;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRETaskImpl
extends SetupTaskImpl
implements JRETask {
    protected static final String VERSION_EDEFAULT = null;
    protected String version = VERSION_EDEFAULT;
    protected static final String LOCATION_EDEFAULT = null;
    protected String location = LOCATION_EDEFAULT;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String VM_INSTALL_TYPE_EDEFAULT = "org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType";
    protected String vMInstallType = "org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType";
    protected static final boolean EXECUTION_ENVIRONMENT_DEFAULT_EDEFAULT = true;
    protected boolean executionEnvironmentDefault = true;
    protected static final String VM_ARGUMENTS_EDEFAULT = null;
    protected String vMArguments = VM_ARGUMENTS_EDEFAULT;
    protected EList<JRELibrary> jRELibraries;

    protected JRETaskImpl() {
    }

    protected EClass eStaticClass() {
        return JDTPackage.Literals.JRE_TASK;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldVersion, (Object)this.version));
        }
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String newLocation) {
        String oldLocation = this.location;
        this.location = newLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldLocation, (Object)this.location));
        }
    }

    public String getNameGen() {
        return this.name;
    }

    @Override
    public String getName() {
        String name = this.getNameGen();
        if (StringUtil.isEmpty((String)name)) {
            String version = this.getVersion();
            if (!StringUtil.isEmpty((String)version)) {
                return "JRE for " + version;
            }
            return null;
        }
        return name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public String getVMInstallType() {
        return this.vMInstallType;
    }

    @Override
    public void setVMInstallType(String newVMInstallType) {
        String oldVMInstallType = this.vMInstallType;
        this.vMInstallType = newVMInstallType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldVMInstallType, (Object)this.vMInstallType));
        }
    }

    @Override
    public boolean isExecutionEnvironmentDefault() {
        return this.executionEnvironmentDefault;
    }

    @Override
    public void setExecutionEnvironmentDefault(boolean newExecutionEnvironmentDefault) {
        boolean oldExecutionEnvironmentDefault = this.executionEnvironmentDefault;
        this.executionEnvironmentDefault = newExecutionEnvironmentDefault;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, oldExecutionEnvironmentDefault, this.executionEnvironmentDefault));
        }
    }

    @Override
    public String getVMArguments() {
        return this.vMArguments;
    }

    @Override
    public void setVMArguments(String newVMArguments) {
        String oldVMArguments = this.vMArguments;
        this.vMArguments = newVMArguments;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldVMArguments, (Object)this.vMArguments));
        }
    }

    @Override
    public EList<JRELibrary> getJRELibraries() {
        if (this.jRELibraries == null) {
            this.jRELibraries = new EObjectContainmentEList(JRELibrary.class, (InternalEObject)this, 16);
        }
        return this.jRELibraries;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 16: {
                return ((InternalEList)this.getJRELibraries()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getVersion();
            }
            case 11: {
                return this.getLocation();
            }
            case 12: {
                return this.getName();
            }
            case 13: {
                return this.getVMInstallType();
            }
            case 14: {
                return this.isExecutionEnvironmentDefault();
            }
            case 15: {
                return this.getVMArguments();
            }
            case 16: {
                return this.getJRELibraries();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setVersion((String)newValue);
                return;
            }
            case 11: {
                this.setLocation((String)newValue);
                return;
            }
            case 12: {
                this.setName((String)newValue);
                return;
            }
            case 13: {
                this.setVMInstallType((String)newValue);
                return;
            }
            case 14: {
                this.setExecutionEnvironmentDefault((Boolean)newValue);
                return;
            }
            case 15: {
                this.setVMArguments((String)newValue);
                return;
            }
            case 16: {
                this.getJRELibraries().clear();
                this.getJRELibraries().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setVersion(VERSION_EDEFAULT);
                return;
            }
            case 11: {
                this.setLocation(LOCATION_EDEFAULT);
                return;
            }
            case 12: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 13: {
                this.setVMInstallType(VM_INSTALL_TYPE_EDEFAULT);
                return;
            }
            case 14: {
                this.setExecutionEnvironmentDefault(true);
                return;
            }
            case 15: {
                this.setVMArguments(VM_ARGUMENTS_EDEFAULT);
                return;
            }
            case 16: {
                this.getJRELibraries().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return VERSION_EDEFAULT == null ? this.version != null : !VERSION_EDEFAULT.equals(this.version);
            }
            case 11: {
                return LOCATION_EDEFAULT == null ? this.location != null : !LOCATION_EDEFAULT.equals(this.location);
            }
            case 12: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 13: {
                return VM_INSTALL_TYPE_EDEFAULT == null ? this.vMInstallType != null : !VM_INSTALL_TYPE_EDEFAULT.equals(this.vMInstallType);
            }
            case 14: {
                return !this.executionEnvironmentDefault;
            }
            case 15: {
                return VM_ARGUMENTS_EDEFAULT == null ? this.vMArguments != null : !VM_ARGUMENTS_EDEFAULT.equals(this.vMArguments);
            }
            case 16: {
                return this.jRELibraries != null && !this.jRELibraries.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (version: ");
        result.append(this.version);
        result.append(", location: ");
        result.append(this.location);
        result.append(", name: ");
        result.append(this.name);
        result.append(", vMInstallType: ");
        result.append(this.vMInstallType);
        result.append(", executionEnvironmentDefault: ");
        result.append(this.executionEnvironmentDefault);
        result.append(", vMArguments: ");
        result.append(this.vMArguments);
        result.append(')');
        return result.toString();
    }

    public Object getOverrideToken() {
        return this.createToken(this.getName());
    }

    public void overrideFor(SetupTask overriddenSetupTask) {
        super.overrideFor(overriddenSetupTask);
        JRETask overriddenJRETask = (JRETask)overriddenSetupTask;
        this.mergeArguments(overriddenJRETask);
    }

    private void mergeArguments(JRETask overriddenJRETask) {
        String overridingValue = this.sanitizeArguments(this.getVMArguments());
        String overriddenValue = this.sanitizeArguments(overriddenJRETask.getVMArguments());
        if (overridingValue != null) {
            if (overriddenValue != null) {
                this.setVMArguments(String.valueOf(overriddenValue) + StringUtil.NL + overridingValue);
            } else {
                this.setVMArguments(overridingValue);
            }
        }
    }

    private String sanitizeArguments(String arguments) {
        if (StringUtil.isEmpty((String)arguments)) {
            return null;
        }
        return arguments.trim().replaceAll("(\n\r?|\r\n?)", StringUtil.NL);
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        return JREHelper.isNeeded(context, this.getName(), this.getVersion(), this.getLocation(), this.getVMInstallType(), this.isExecutionEnvironmentDefault(), this.sanitizeArguments(this.getVMArguments()), this.getJRELibraries());
    }

    public void perform(SetupTaskContext context) throws Exception {
        JREHelper.perform(context, this.getName(), this.getVersion(), this.getLocation(), this.getVMInstallType(), this.isExecutionEnvironmentDefault(), this.sanitizeArguments(this.getVMArguments()), this.getJRELibraries());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JREHelper {
        private JREHelper() {
        }

        public static void perform(SetupTaskContext context, String name, String version, String location, String vmInstallTypeID, boolean executionEnvironmentDefault, String vmArguments, Collection<JRELibrary> jreLibraries) throws Exception {
            IVMInstallType[] types;
            IVMInstallType[] iVMInstallTypeArray = types = JavaRuntime.getVMInstallTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstallType type = iVMInstallTypeArray[n2];
                if (vmInstallTypeID.equals(type.getId())) {
                    String[] vmStandinVMArguments;
                    String vmArgument;
                    int n3;
                    int n4;
                    String[] stringArray;
                    String[] vmArgumentsArray;
                    VMStandin vmStandin;
                    IVMInstall realVM = JREHelper.getVMInstall(name, vmInstallTypeID);
                    boolean setAsDefault = false;
                    if (realVM == null) {
                        setAsDefault = true;
                        context.log("Creating " + name + " with location " + location);
                        vmStandin = new VMStandin(type, EcoreUtil.generateUUID());
                        vmStandin.setName(name);
                    } else {
                        context.log("Updating " + name + " with location " + location);
                        vmStandin = new VMStandin(realVM);
                    }
                    File installLocation = new File(location);
                    IStatus validationStatus = type.validateInstallLocation(installLocation);
                    if (!validationStatus.isOK()) {
                        context.log("The location '" + location + "' is not valid");
                        context.log("Go back to the Variables page, be sure to select 'Show all variables', and change the location to a valid one");
                        throw new CoreException(validationStatus);
                    }
                    vmStandin.setInstallLocation(installLocation);
                    ArrayList<String> mergedVMArguments = new ArrayList<String>();
                    if (vmArguments != null && (vmArgumentsArray = new ExecutionArguments(vmArguments, "").getVMArgumentsArray()) != null) {
                        stringArray = vmArgumentsArray;
                        n4 = vmArgumentsArray.length;
                        n3 = 0;
                        while (n3 < n4) {
                            vmArgument = stringArray[n3];
                            mergedVMArguments.add(vmArgument);
                            ++n3;
                        }
                    }
                    if ((vmStandinVMArguments = vmStandin.getVMArguments()) != null) {
                        stringArray = vmStandinVMArguments;
                        n4 = vmStandinVMArguments.length;
                        n3 = 0;
                        while (n3 < n4) {
                            vmArgument = stringArray[n3];
                            if (!mergedVMArguments.contains(vmArgument)) {
                                mergedVMArguments.add(vmArgument);
                            }
                            ++n3;
                        }
                    }
                    vmStandin.setVMArguments(mergedVMArguments.toArray(new String[mergedVMArguments.size()]));
                    if (!mergedVMArguments.isEmpty()) {
                        context.log("Setting VM arguments of " + name + " to " + StringUtil.implode(mergedVMArguments, (char)'\u0000'));
                    }
                    if (!jreLibraries.isEmpty()) {
                        if (vmStandin.getLibraryLocations() == null) {
                            vmStandin.setLibraryLocations(new LibraryLocation[0]);
                            vmStandin.setLibraryLocations(type.getDefaultLibraryLocations(installLocation));
                        }
                        Path installPath = new Path(installLocation.getCanonicalPath());
                        block5: for (JRELibrary jreLibrary : jreLibraries) {
                            String libraryPath = jreLibrary.getLibraryPath();
                            String externalAnnotationsPathLiteral = jreLibrary.getExternalAnnotationsPath();
                            if (libraryPath == null || externalAnnotationsPathLiteral == null) continue;
                            IPath jreLibraryPath = installPath.append(libraryPath);
                            LibraryLocation[] libraryLocations = vmStandin.getLibraryLocations();
                            int i = 0;
                            while (i < libraryLocations.length) {
                                LibraryLocation libraryLocation = libraryLocations[i];
                                IPath systemLibraryPath = libraryLocation.getSystemLibraryPath();
                                if (jreLibraryPath.equals((Object)systemLibraryPath)) {
                                    Path externalAnnotationsPath = new Path(externalAnnotationsPathLiteral);
                                    try {
                                        LibraryLocation newLibraryLocation;
                                        if (externalAnnotationsPath.equals((Object)libraryLocation.getExternalAnnotationsPath())) continue block5;
                                        libraryLocations[i] = newLibraryLocation = new LibraryLocation(systemLibraryPath, libraryLocation.getSystemLibrarySourcePath(), libraryLocation.getPackageRootPath(), libraryLocation.getJavadocLocation(), libraryLocation.getIndexLocation(), (IPath)externalAnnotationsPath);
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {}
                                    continue block5;
                                }
                                ++i;
                            }
                        }
                    }
                    realVM = vmStandin.convertToRealVM();
                    if (setAsDefault) {
                        JavaRuntime.setDefaultVMInstall((IVMInstall)realVM, (IProgressMonitor)new NullProgressMonitor());
                    }
                    if (executionEnvironmentDefault) {
                        IExecutionEnvironment[] executionEnvironments;
                        IExecutionEnvironment[] iExecutionEnvironmentArray = executionEnvironments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
                        int n5 = executionEnvironments.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IExecutionEnvironment executionEnvironment = iExecutionEnvironmentArray[n6];
                            String id = executionEnvironment.getId();
                            if ((id.equals(version) || "CDC-1.1/Foundation-1.1".equals(id) && "J2SE-1.4".equals(version)) && executionEnvironment.getDefaultVM() == null) {
                                context.log("Setting the default execution environment to " + name);
                                executionEnvironment.setDefaultVM(realVM);
                            }
                            ++n6;
                        }
                    }
                    return;
                }
                ++n2;
            }
        }

        public static boolean isNeeded(SetupTaskContext context, String name, String version, String location, String vmInstallTypeID, boolean executionEnvironmentDefault, String vmArguments, Collection<JRELibrary> jreLibraries) throws Exception {
            IVMInstall vmInstall = JREHelper.getVMInstall(name, vmInstallTypeID);
            if (vmInstall != null) {
                String[] vmArgumentsArray;
                if (!vmInstall.getInstallLocation().equals(new File(location))) {
                    return true;
                }
                String[] vmInstallVMArguments = vmInstall.getVMArguments();
                if (vmInstallVMArguments == null ? vmArguments != null : vmArguments != null && (vmArgumentsArray = new ExecutionArguments(vmArguments, "").getVMArgumentsArray()) != null && !Arrays.asList(vmInstallVMArguments).containsAll(Arrays.asList(vmArgumentsArray))) {
                    return true;
                }
                if (executionEnvironmentDefault) {
                    IExecutionEnvironment[] executionEnvironments;
                    IExecutionEnvironment[] iExecutionEnvironmentArray = executionEnvironments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
                    int n = executionEnvironments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExecutionEnvironment executionEnvironment = iExecutionEnvironmentArray[n2];
                        String id = executionEnvironment.getId();
                        if ((id.equals(version) || "CDC-1.1/Foundation-1.1".equals(id) && "J2SE-1.4".equals(version)) && executionEnvironment.getDefaultVM() == null) {
                            return true;
                        }
                        ++n2;
                    }
                }
                if (!jreLibraries.isEmpty()) {
                    File installLocation = new File(location);
                    Path installPath = new Path(installLocation.getCanonicalPath());
                    block3: for (JRELibrary jreLibrary : jreLibraries) {
                        String libraryPath = jreLibrary.getLibraryPath();
                        String externalAnnotationsPathLiteral = jreLibrary.getExternalAnnotationsPath();
                        if (libraryPath == null || externalAnnotationsPathLiteral == null) continue;
                        IPath jreLibraryPath = installPath.append(libraryPath);
                        LibraryLocation[] libraryLocations = vmInstall.getLibraryLocations();
                        if (libraryLocations == null) {
                            return true;
                        }
                        int i = 0;
                        while (i < libraryLocations.length) {
                            LibraryLocation libraryLocation = libraryLocations[i];
                            if (jreLibraryPath.equals((Object)libraryLocation.getSystemLibraryPath())) {
                                Path externalAnnotationsPath = new Path(externalAnnotationsPathLiteral);
                                try {
                                    if (externalAnnotationsPath.equals((Object)libraryLocation.getExternalAnnotationsPath())) continue block3;
                                    return true;
                                }
                                catch (NoSuchMethodError noSuchMethodError) {
                                    continue block3;
                                }
                            }
                            ++i;
                        }
                    }
                }
                return false;
            }
            return true;
        }

        private static IVMInstall getVMInstall(String name, String vmInstallTypeID) throws Exception {
            IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
            int n = iVMInstallTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstallType vmInstallType = iVMInstallTypeArray[n2];
                if (vmInstallType.getId().equals(vmInstallTypeID)) {
                    IVMInstall[] iVMInstallArray = vmInstallType.getVMInstalls();
                    int n3 = iVMInstallArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IVMInstall vmInstall = iVMInstallArray[n4];
                        if (vmInstall.getName().equals(name)) {
                            return vmInstall;
                        }
                        ++n4;
                    }
                    break;
                }
                ++n2;
            }
            return null;
        }
    }
}

