/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.File;
import java.io.IOException;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.spi.IAgentServiceFactory;
import org.eclipse.oomph.p2.internal.core.LazyProfileRegistry;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.osgi.storage.StorageUtil;

public class LazyProfileRegistryComponent
implements IAgentServiceFactory {
    public Object createService(IProvisioningAgent agent) {
        IAgentLocation location = (IAgentLocation)agent.getService(IAgentLocation.SERVICE_NAME);
        File directory = LazyProfileRegistry.getDefaultRegistryDirectory((IAgentLocation)location);
        boolean isLazySupported = !"false".equals(PropertiesUtil.getProperty((String)"oomph.p2.lazy.profile.registry")) && OsgiHelper.canWrite(directory);
        LazyProfileRegistry registry = isLazySupported ? new LazyProfileRegistry(agent, directory) : new SimpleProfileRegistry(agent, directory);
        registry.setEventBus((IProvisioningEventBus)agent.getService(IProvisioningEventBus.SERVICE_NAME));
        return registry;
    }

    private static class OsgiHelper {
        private OsgiHelper() {
        }

        public static boolean canWrite(File installDir) {
            try {
                return StorageUtil.canWrite((File)installDir);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (!installDir.canWrite() || !installDir.isDirectory()) {
                    return false;
                }
                File fileTest = null;
                try {
                    try {
                        fileTest = File.createTempFile("test", ".dll", installDir);
                    }
                    catch (IOException iOException) {
                        if (fileTest != null) {
                            fileTest.delete();
                        }
                        return false;
                    }
                }
                finally {
                    if (fileTest != null) {
                        fileTest.delete();
                    }
                }
                return true;
            }
        }
    }
}

