/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.log;

public class ProgressLogFilter {
    private static final String[] IGNORED_PREFIXES = new String[]{"Scanning Git", "Re-indexing", "Calculating Decorations", "Decorating", "http://", "The user operation is waiting", "Git repository changed", "Refreshing ", "Opening ", "Connecting project ", "Connected project ", "Searching for associated repositories.", "Preparing type ", "Loading project description", "Generating cspec from PDE artifacts", "Reporting encoding changes", "Saving", "Downloading software", "Java indexing...", "Computing Git status for ", "Configuring ", "Invoking builder on ", "Invoking '", "Verifying ", "Updating ...", "Reading saved build state for project ", "Reading resource change information for ", "Cleaning output folder for ", "Copying resources to the output folder", " adding component ", "Preparing to build", "Compiling ", "Analyzing ", "Comparing ", "Checking ", "Build done", "Processing API deltas...", "Create.", "Reading plug-ins", "Processing", "Querying repository", "Synchronizing query: ", "Receiving related tasks", "Receiving task ", "Updating repository state", "Processing Local"};
    private String lastLine;

    public String filter(String line) {
        int index;
        if (line == null || line.length() == 0 || Character.isLowerCase(line.charAt(0)) || line.equals("Updating") || line.endsWith(" remaining.") || ProgressLogFilter.startsWithIgnoredPrefix(line)) {
            return null;
        }
        if (line.endsWith("/s)") && (index = line.lastIndexOf(" (")) != -1) {
            line = line.substring(0, index);
        }
        if (line.equals(this.lastLine)) {
            return null;
        }
        this.lastLine = line;
        return line;
    }

    private static boolean startsWithIgnoredPrefix(String line) {
        int i = 0;
        while (i < IGNORED_PREFIXES.length) {
            String prefix = IGNORED_PREFIXES[i];
            if (line.startsWith(prefix)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

