/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;
import org.osgi.service.prefs.Preferences;

public class UIPropertyTester
extends PropertyTester {
    public static final String SHOW_OFFLINE = "showOffline";
    private static final Preferences PREFERENCES = UIPlugin.INSTANCE.getInstancePreferences();

    public static void requestEvaluation(final String id, final boolean layout) {
        UIUtil.syncExec(new Runnable(){

            public void run() {
                IEvaluationService service;
                IWorkbench workbench;
                if (PlatformUI.isWorkbenchRunning() && (workbench = PlatformUI.getWorkbench()) != null && (service = (IEvaluationService)workbench.getService(IEvaluationService.class)) != null) {
                    service.requestEvaluation(id);
                    if (layout) {
                        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
                        int n = iWorkbenchWindowArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
                            Shell shell = workbenchWindow.getShell();
                            if (shell != null) {
                                shell.layout(true, true);
                            }
                            ++n2;
                        }
                    }
                }
            }
        });
    }

    public UIPropertyTester() {
        ((IEclipsePreferences)PREFERENCES).addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (UIPropertyTester.SHOW_OFFLINE.equals(event.getKey())) {
                    UIPropertyTester.requestEvaluation("org.eclipse.oomph.ui.showOffline", "true".equals(event.getNewValue()));
                }
            }
        });
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (expectedValue == null) {
            expectedValue = Boolean.TRUE;
        }
        if (SHOW_OFFLINE.equals(property)) {
            return expectedValue.equals(PREFERENCES.getBoolean(SHOW_OFFLINE, false));
        }
        return false;
    }
}

