/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.wizards;

import java.io.File;
import java.lang.reflect.Constructor;
import java.security.cert.Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedFontRegistry;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.internal.ui.AccessUtil;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.UnsignedPolicy;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.core.util.SetupUtil;
import org.eclipse.oomph.setup.log.ProgressLog;
import org.eclipse.oomph.setup.log.ProgressLogFilter;
import org.eclipse.oomph.setup.log.ProgressLogProvider;
import org.eclipse.oomph.setup.log.ProgressLogRunnable;
import org.eclipse.oomph.setup.ui.AbstractConfirmDialog;
import org.eclipse.oomph.setup.ui.AbstractDialogConfirmer;
import org.eclipse.oomph.setup.ui.LicenseDialog;
import org.eclipse.oomph.setup.ui.SetupPropertyTester;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.ToolTipLabelProvider;
import org.eclipse.oomph.setup.ui.UnsignedContentDialog;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.setup.ui.wizards.SetupWizardPage;
import org.eclipse.oomph.setup.util.FileUtil;
import org.eclipse.oomph.setup.util.OS;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.Confirmer;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.ProgressManager;

public class ProgressPage
extends SetupWizardPage {
    public static final Object PROGRESS_FAMILY = new Object();
    public static final String PROGRESS_STATUS = "org.eclipse.oomph.setup.status";
    public static final String PAGE_NAME = "ProgressPage";
    private static final SimpleDateFormat TIME = new SimpleDateFormat("HH:mm:ss");
    private final Map<SetupTask, Point> setupTaskSelections = new HashMap<SetupTask, Point>();
    private Constructor<? extends ProgressLog> progressLogWrapper;
    private TreeViewer treeViewer;
    private final ISelectionChangedListener treeViewerSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object element = selection.getFirstElement();
            if (element instanceof EObject) {
                EObject eObject = (EObject)element;
                while (eObject != null) {
                    Point textSelection;
                    if (eObject != ProgressPage.this.currentTask && eObject instanceof SetupTask && (textSelection = (Point)ProgressPage.this.setupTaskSelections.get(eObject)) != null) {
                        int start = textSelection.x;
                        int end = textSelection.y;
                        if (end == -1) {
                            end = ProgressPage.this.logText.getCharCount();
                        }
                        String selectedText = ProgressPage.this.logText.getText(start, end);
                        int index = 0;
                        int length = selectedText.length();
                        while (index < length) {
                            char c = selectedText.charAt(index);
                            if (c != '\n' && c != '\r') break;
                            ++start;
                            ++index;
                        }
                        ProgressPage.this.logText.setSelection(start, start);
                        int lineFeedCount = 0;
                        int carriageReturnCount = 0;
                        while (index < length) {
                            char c = selectedText.charAt(index);
                            if (c == '\n') {
                                ++lineFeedCount;
                            } else if (c == '\r') {
                                ++carriageReturnCount;
                            }
                            ++index;
                        }
                        int visibleLineCount = ((ProgressPage)ProgressPage.this).logText.getClientArea().height / ProgressPage.this.logText.getLineHeight();
                        if (lineFeedCount > visibleLineCount || carriageReturnCount > visibleLineCount) {
                            ProgressPage.this.logText.setSelection(end, start);
                        } else {
                            ProgressPage.this.logText.setSelection(start, end);
                        }
                    }
                    eObject = eObject.eContainer();
                }
            }
        }
    };
    private StyledText logText;
    private ProgressMonitorPart progressMonitorPart;
    private final Document logDocument = new Document();
    private final ProgressLogFilter logFilter = new ProgressLogFilter();
    private SetupTask currentTask;
    private ProgressPageLog progressPageLog;
    private boolean scrollLock;
    private boolean dismissAutomatically;
    private boolean launchAutomatically;
    private Button scrollLockButton;
    private Button dismissButton;
    private Button launchButton;
    private boolean hasLaunched;
    public static final Confirmer LICENSE_CONFIRMER = new AbstractDialogConfirmer(){

        protected AbstractConfirmDialog createDialog(boolean defaultConfirmed, Object info) {
            Map licensesToIUs = (Map)info;
            return new LicenseDialog(licensesToIUs);
        }
    };

    public ProgressPage() {
        super(PAGE_NAME);
        this.setTitle("Progress");
        this.setDescription("Wait for the setup to complete, or cancel the progress indicator and press Back to make changes.");
    }

    protected Control createUI(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginHeight = 0;
        mainLayout.marginBottom = 5;
        mainComposite.setLayout((Layout)mainLayout);
        SashForm sashForm = new SashForm(mainComposite, 512);
        sashForm.setLayoutData((Object)new GridData(1808));
        AccessUtil.setKey((Widget)sashForm, (Object)"sash");
        this.treeViewer = new TreeViewer((Composite)sashForm, 2048);
        Tree tree = this.treeViewer.getTree();
        this.addHelpCallout((Control)tree, 1);
        ILabelProvider labelProvider = this.createLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)this.getAdapterFactory());
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        this.treeViewer.addSelectionChangedListener(this.treeViewerSelectionChangedListener);
        new ColumnViewerInformationControlToolTipSupport((ColumnViewer)this.treeViewer, new LocationListener(){

            public void changing(LocationEvent event) {
            }

            public void changed(LocationEvent event) {
            }
        });
        tree.setLayoutData((Object)new GridData(1808));
        tree.setBackground(this.getShell().getDisplay().getSystemColor(1));
        TextViewer logTextViewer = new TextViewer((Composite)sashForm, 2818);
        logTextViewer.setDocument((IDocument)this.logDocument);
        this.logText = logTextViewer.getTextWidget();
        this.logText.setBackground(parent.getDisplay().getSystemColor(25));
        this.logText.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.logText.setEditable(false);
        this.logText.setLayoutData((Object)new GridData(1808));
        this.logText.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 1 && !ProgressPage.this.scrollLock) {
                    ProgressPage.this.scrollLockButton.setSelection(true);
                    ProgressPage.this.scrollLock = true;
                }
            }
        });
        this.addHelpCallout((Control)this.logText, 2);
        AccessUtil.setKey((Widget)this.logText, (Object)"log");
        return mainComposite;
    }

    protected void createCheckButtons() {
        this.scrollLockButton = this.addCheckButton("Scroll lock", "Keep the log from scrolling to the end when new messages are added", false, null);
        this.scrollLock = this.scrollLockButton.getSelection();
        this.scrollLockButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressPage.this.scrollLock = ProgressPage.this.scrollLockButton.getSelection();
            }
        });
        AccessUtil.setKey((Widget)this.scrollLockButton, (Object)"lock");
        this.dismissButton = this.addCheckButton("Dismiss automatically", "Dismiss this wizard when all setup tasks have performed successfully", false, "dismissAutomatically");
        this.dismissAutomatically = this.dismissButton.getSelection();
        this.dismissButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressPage.this.dismissAutomatically = ProgressPage.this.dismissButton.getSelection();
            }
        });
        AccessUtil.setKey((Widget)this.dismissButton, (Object)"dismiss");
        this.launchButton = this.getTrigger() == Trigger.BOOTSTRAP ? this.addCheckButton("Launch automatically", "Launch the installed product when all setup tasks have performed successfully", true, "launchAutomatically") : this.addCheckButton("Restart automatically if needed", "Restart the current product if the installation has been changed by setup tasks", false, "restartIfNeeded");
        this.launchAutomatically = this.launchButton.getSelection();
        this.launchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressPage.this.launchAutomatically = ProgressPage.this.launchButton.getSelection();
            }
        });
        AccessUtil.setKey((Widget)this.launchButton, (Object)"launch");
    }

    protected void createFooter(Composite parent) {
        this.progressMonitorPart = new ProgressMonitorPart(parent, null, true){

            protected void initialize(Layout layout, int progressIndicatorHeight) {
                super.initialize(layout, progressIndicatorHeight);
                this.fLabel.dispose();
                if (PlatformUI.isWorkbenchRunning()) {
                    Control[] controlArray = this.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control child = controlArray[n2];
                        if (child instanceof ToolBar) {
                            ToolBar toolBar = (ToolBar)child;
                            ToolItem minimizeButton = new ToolItem(toolBar, 8);
                            minimizeButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("hide"));
                            minimizeButton.setToolTipText("Minimize to the status area");
                            minimizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent event) {
                                    ProgressPage.this.getWizard().getShell().setVisible(false);
                                }
                            });
                            break;
                        }
                        ++n2;
                    }
                }
            }

            protected void updateLabel() {
            }

            public void done() {
                this.fProgressIndicator.sendRemainingWork();
                this.fProgressIndicator.done();
                this.removeFromCancelComponent(null);
                ProgressPage.this.progressMonitorPart.setLayoutData((Object)new GridData(0, 0));
                ProgressPage.this.progressMonitorPart.getParent().layout();
            }
        };
        this.progressMonitorPart.setLayoutData((Object)new GridData(768));
        AccessUtil.setKey((Widget)this.progressMonitorPart, (Object)"progress");
    }

    public void enterPage(boolean forward) {
        if (forward) {
            File configurationLocation;
            this.setPageComplete(false);
            this.setErrorMessage(null);
            this.setMessage(null);
            this.hasLaunched = false;
            this.progressPageLog = new ProgressPageLog(this.progressMonitorPart);
            this.logDocument.set("");
            ProgressPageLog progressLog = this.progressPageLog;
            if (this.progressLogWrapper != null) {
                try {
                    progressLog = this.progressLogWrapper.newInstance(progressLog);
                }
                catch (Throwable throwable) {}
            }
            final SetupTaskPerformer performer = this.getPerformer();
            performer.setProgress((ProgressLog)progressLog);
            performer.put(ILicense.class, (Object)LICENSE_CONFIRMER);
            performer.put(Certificate.class, (Object)UnsignedContentDialog.createUnsignedContentConfirmer(performer.getUser(), false));
            this.progressMonitorPart.beginTask("", performer.getNeededTasks().size() + 1);
            File renamed = null;
            if (this.getTrigger() == Trigger.BOOTSTRAP && (configurationLocation = performer.getProductConfigurationLocation()).exists()) {
                try {
                    renamed = FileUtil.rename((File)configurationLocation);
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    this.progressPageLog.log(ex);
                    this.setErrorMessage("Could not rename '" + configurationLocation + "'.  Press Back twice to choose a different installation location.");
                    this.progressPageLog.setFinished();
                    throw new IORuntimeException((Throwable)ex);
                }
            }
            this.treeViewer.setInput((Object)new ItemProvider((Collection)performer.getNeededTasks()));
            String jobName = "Executing " + this.getTrigger().toString().toLowerCase() + " tasks";
            performer.log(jobName);
            if (renamed != null) {
                performer.log("Renamed existing configuration folder to " + renamed);
            }
            this.run(jobName, new ProgressLogRunnable(){

                public Set<String> run(ProgressLog log) throws Exception {
                    final ProgressManager oldProgressProvider = ProgressManager.getInstance();
                    ProgressLogProvider newProgressLogProvider = new ProgressLogProvider((ProgressLog)ProgressPage.this.progressPageLog, (ProgressProvider)oldProgressProvider);
                    JobChangeAdapter jobChangeListener = PlatformUI.isWorkbenchRunning() ? null : new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            Job job = event.getJob();
                            JobInfo[] jobInfoArray = oldProgressProvider.getJobInfos(true);
                            int n = jobInfoArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                JobInfo jobInfo = jobInfoArray[n2];
                                if (jobInfo.getJob() == job) {
                                    oldProgressProvider.removeJobInfo(jobInfo);
                                    break;
                                }
                                ++n2;
                            }
                        }
                    };
                    IJobManager jobManager = Job.getJobManager();
                    jobManager.setProgressProvider((ProgressProvider)newProgressLogProvider);
                    if (jobChangeListener != null) {
                        jobManager.addJobChangeListener((IJobChangeListener)jobChangeListener);
                    }
                    try {
                        performer.perform();
                        Set set = performer.getRestartReasons();
                        return set;
                    }
                    finally {
                        jobManager.setProgressProvider((ProgressProvider)oldProgressProvider);
                        if (jobChangeListener != null) {
                            jobManager.removeJobChangeListener((IJobChangeListener)jobChangeListener);
                        }
                    }
                }
            });
        }
    }

    public void leavePage(boolean forward) {
        if (forward) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(false);
            this.hasLaunched = false;
            this.setButtonState(1, true);
        }
    }

    public boolean performCancel() {
        return this.progressPageLog == null || this.progressPageLog.isFinished() || this.progressPageLog.isCanceled();
    }

    private ILabelProvider createLabelProvider() {
        return new ToolTipLabelProvider(this.getAdapterFactory()){

            public Font getFont(Object element) {
                if (element == ProgressPage.this.currentTask) {
                    return ExtendedFontRegistry.INSTANCE.getFont(ProgressPage.this.treeViewer.getControl().getFont(), (Object)IItemFontProvider.BOLD_FONT);
                }
                return super.getFont(element);
            }
        };
    }

    private void run(final String jobName, final ProgressLogRunnable runnable) {
        try {
            final ProgressPageLog progressLog = this.progressPageLog;
            Runnable jobRunnable = new Runnable(){

                public void run() {
                    final SetupWizard wizard = ProgressPage.this.getWizard();
                    final Shell shell = ProgressPage.this.getWizard().getShell();
                    ProgressPage.this.setButtonState(1, false);
                    ProgressPage.this.setButtonState(14, false);
                    final Job job = new Job(jobName){

                        /*
                         * Exception decompiling
                         */
                        protected IStatus run(IProgressMonitor monitor) {
                            /*
                             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                             * 
                             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                             *     at org.benf.cfr.reader.Main.main(Main.java:54)
                             */
                            throw new IllegalStateException("Decompilation failed");
                        }

                        public boolean belongsTo(Object family) {
                            return family == PROGRESS_FAMILY;
                        }
                    };
                    UIUtil.asyncExec((Runnable)new Runnable(){

                        public void run() {
                            shell.setData(ProgressPage.PROGRESS_STATUS, null);
                            job.schedule();
                            if (wizard.getTrigger() != Trigger.BOOTSTRAP) {
                                SetupPropertyTester.setPerformingShell(shell);
                            }
                        }
                    });
                }
            };
            UIUtil.asyncExec((Runnable)jobRunnable);
        }
        catch (Throwable ex) {
            SetupUIPlugin.INSTANCE.log(ex);
            ErrorDialog.open((Throwable)ex);
        }
    }

    private void launchProduct(SetupTaskPerformer performer) throws Exception {
        OS os = performer.getOS();
        if (os.isCurrent()) {
            performer.log("Launching the installed product...");
            String eclipseDir = os.getEclipseDir();
            String eclipseExecutable = os.getEclipseExecutable();
            String eclipsePath = new File(performer.getInstallationLocation(), String.valueOf(eclipseDir) + "/" + eclipseExecutable).getAbsolutePath();
            File ws = performer.getWorkspaceLocation();
            SetupUIPlugin.initialStart(ws, performer.isOffline(), performer.isMirrors());
            ArrayList<String> command = new ArrayList<String>();
            command.add(eclipsePath);
            if (ws != null) {
                command.add("-data");
                command.add(ws.toString());
            }
            ProcessBuilder builder = new ProcessBuilder(command);
            Process process = builder.start();
            process.getInputStream().close();
            process.getOutputStream().close();
            process.getErrorStream().close();
            this.hasLaunched = true;
        } else {
            performer.log("Launching the installed product is not possible for cross-platform installs. Skipping.");
        }
    }

    private void saveLocalFiles(SetupTaskPerformer performer) {
        UnsignedPolicy performerUserUnsignedPolicy;
        User performerUser = performer.getUser();
        ResourceSet resourceSet = SetupUtil.createResourceSet();
        User user = SetupContext.createUserOnly((ResourceSet)resourceSet).getUser();
        boolean shouldSave = user.getAcceptedLicenses().addAll((Collection)performerUser.getAcceptedLicenses());
        UnsignedPolicy userUnsignedPolicy = user.getUnsignedPolicy();
        if (userUnsignedPolicy != (performerUserUnsignedPolicy = performerUser.getUnsignedPolicy())) {
            user.setUnsignedPolicy(performerUserUnsignedPolicy);
            shouldSave = true;
        }
        if (shouldSave) {
            BaseUtil.saveEObject((EObject)user);
        }
        SetupContext setupContext = this.getWizard().getSetupContext();
        Installation installation = setupContext.getInstallation();
        BaseUtil.saveEObject((EObject)installation);
        Workspace workspace = setupContext.getWorkspace();
        if (workspace != null) {
            BaseUtil.saveEObject((EObject)workspace);
        }
        SetupContext.associate((Installation)installation, (Workspace)workspace);
    }

    protected void setButtonState(int buttonID, boolean enabled) {
        super.setButtonState(buttonID, enabled);
        if (buttonID == 1 && this.getPerformer().hasSuccessfullyPerformed()) {
            this.scrollLockButton.setEnabled(enabled);
            this.dismissButton.setEnabled(enabled);
            if (this.launchButton != null) {
                this.launchButton.setEnabled(!this.hasLaunched);
            }
        }
    }

    static /* synthetic */ boolean access$20(ProgressPage progressPage) {
        return progressPage.dismissAutomatically;
    }

    static /* synthetic */ boolean access$22(ProgressPage progressPage) {
        return progressPage.hasLaunched;
    }

    static /* synthetic */ void access$24(ProgressPage progressPage, SetupTaskPerformer setupTaskPerformer) {
        progressPage.saveLocalFiles(setupTaskPerformer);
    }

    private class ProgressPageLog
    implements ProgressLog {
        private final StringBuilder queue = new StringBuilder();
        private boolean finished;
        private boolean terminating;
        private ProgressMonitorPart progressMonitorPart;
        private IProgressMonitor progressMonitor;
        private boolean isCanceled;
        private int time;

        public ProgressPageLog(ProgressMonitorPart progressMonitorPart) {
            this.progressMonitorPart = progressMonitorPart;
            progressMonitorPart.attachToCancelComponent(null);
            progressMonitorPart.setCanceled(false);
            progressMonitorPart.setLayoutData((Object)new GridData(768));
            progressMonitorPart.getParent().layout();
        }

        public void setProgressMonitor(IProgressMonitor progressMonitor) {
            this.progressMonitor = progressMonitor;
        }

        public void setTerminating() {
            this.terminating = true;
        }

        public boolean isCanceled() {
            if (this.isCanceled) {
                return true;
            }
            if (this.progressMonitorPart.isCanceled() || this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                this.isCanceled = true;
            }
            return this.isCanceled;
        }

        public void setFinished() {
            this.finished = true;
            this.task(null);
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void task(final SetupTask setupTask) {
            UIUtil.syncExec((Runnable)new Runnable(){

                public void run() {
                    if (setupTask == null) {
                        ProgressPageLog.this.progressMonitorPart.done();
                        if (ProgressPageLog.this.progressMonitor != null) {
                            ProgressPageLog.this.progressMonitor.done();
                        }
                    } else {
                        ProgressPageLog.this.progressMonitorPart.worked(1);
                        if (ProgressPageLog.this.progressMonitor != null) {
                            ProgressPageLog.this.progressMonitor.worked(1);
                        }
                    }
                    SetupTask previousCurrentTask = ProgressPage.this.currentTask;
                    ProgressPage.this.currentTask = setupTask;
                    int offset = 0;
                    if (previousCurrentTask != null) {
                        Point previousTextSelection = (Point)ProgressPage.this.setupTaskSelections.get(previousCurrentTask);
                        offset = ProgressPage.this.logText.getCharCount() - 1;
                        int start = previousTextSelection.x;
                        ProgressPage.this.setupTaskSelections.put(previousCurrentTask, new Point(start, offset));
                        ProgressPage.this.treeViewer.refresh((Object)previousCurrentTask, true);
                    }
                    if (setupTask != null) {
                        ProgressPage.this.setupTaskSelections.put(setupTask, new Point(offset, -1));
                        ProgressPage.this.treeViewer.refresh((Object)setupTask, true);
                        ProgressPage.this.treeViewer.removeSelectionChangedListener(ProgressPage.this.treeViewerSelectionChangedListener);
                        ProgressPage.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)setupTask), true);
                        ProgressPage.this.treeViewer.addSelectionChangedListener(ProgressPage.this.treeViewerSelectionChangedListener);
                    }
                }
            });
        }

        public void log(String line) {
            this.log(line, true);
        }

        public void log(IStatus status) {
            String string = SetupUIPlugin.toString((IStatus)status);
            this.log(string, false);
        }

        public void log(Throwable t) {
            String string = SetupUIPlugin.toString((Throwable)t);
            this.log(string, false);
        }

        public void log(String line, boolean filter) {
            if (this.finished) {
                return;
            }
            if (!this.terminating && this.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (filter) {
                line = ProgressPage.this.logFilter.filter(line);
            }
            if (line == null) {
                return;
            }
            boolean wasEmpty = this.enqueue(new Date(), line);
            if (wasEmpty) {
                UIUtil.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        String text = ProgressPageLog.this.dequeue();
                        ProgressPageLog.this.appendText(text);
                    }
                });
            }
        }

        private synchronized boolean enqueue(Date date, String line) {
            boolean wasEmpty = this.queue.length() == 0;
            this.queue.append('[');
            if (ProgressPage.this.progressLogWrapper == null) {
                this.queue.append(TIME.format(date));
            } else {
                this.queue.append("12:00:");
                if (this.time < 10) {
                    this.queue.append('0');
                }
                this.queue.append(this.time++);
            }
            this.queue.append("] ");
            this.queue.append(line);
            this.queue.append('\n');
            return wasEmpty;
        }

        private synchronized String dequeue() {
            String result = this.queue.toString();
            this.queue.setLength(0);
            return result;
        }

        private void appendText(String string) {
            try {
                int length = ProgressPage.this.logDocument.getLength();
                ProgressPage.this.logDocument.replace(length, 0, string);
                if (!ProgressPage.this.scrollLock && !ProgressPage.this.logText.isDisposed()) {
                    int lineCount = ProgressPage.this.logText.getLineCount();
                    ProgressPage.this.logText.setTopIndex(lineCount - 1);
                }
            }
            catch (Exception ex) {
                SetupUIPlugin.INSTANCE.log(ex);
            }
        }
    }
}

