/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.DownloadStatus;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.provisional.p2.repository.IStateful;
import org.eclipse.oomph.p2.internal.core.P2CorePlugin;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OfflineMode;
import org.eclipse.oomph.util.PropertiesUtil;

public class CachingTransport
extends Transport {
    private static final ThreadLocal<Stack<String>> REPOSITORY_LOCATIONS = new InheritableThreadLocal<Stack<String>>(){

        @Override
        protected Stack<String> initialValue() {
            return new Stack<String>();
        }
    };
    private static boolean DEBUG = false;
    private final Transport delegate;
    private final File cacheFolder;

    public CachingTransport(Transport delegate) {
        this.delegate = delegate;
        File folder = P2CorePlugin.getUserStateFolder(new File(PropertiesUtil.USER_HOME));
        this.cacheFolder = new File(folder, "cache");
        this.cacheFolder.mkdirs();
    }

    public File getCacheFile(java.net.URI uri) {
        return new File(this.cacheFolder, IOUtil.encodeFileName((String)uri.toString()));
    }

    public IStatus download(java.net.URI uri, OutputStream target, long startPos, IProgressMonitor monitor) {
        File cacheFile;
        boolean loadingRepository;
        if (DEBUG) {
            CachingTransport.log("  ! " + uri);
        }
        if ((loadingRepository = CachingTransport.isLoadingRepository(uri)) && OfflineMode.isEnabled() && (cacheFile = this.getCacheFile(uri)).exists()) {
            try {
                byte[] content = IOUtil.readFile((File)cacheFile);
                IOUtil.copy((InputStream)new ByteArrayInputStream(content), (OutputStream)target);
                return Status.OK_STATUS;
            }
            catch (Exception exception) {}
        }
        OutputStream oldTarget = target;
        class StatfulByteArrayOutputStream
        extends ByteArrayOutputStream
        implements IStateful {
            private IStatus status;

            StatfulByteArrayOutputStream() {
            }

            public IStatus getStatus() {
                return this.status;
            }

            public void setStatus(IStatus status) {
                this.status = status;
            }
        }
        StatfulByteArrayOutputStream statefulTarget = new StatfulByteArrayOutputStream();
        target = statefulTarget;
        try {
            IStatus status = this.delegate.download(uri, target, startPos, monitor);
            if (status.isOK()) {
                byte[] content = ((ByteArrayOutputStream)target).toByteArray();
                IOUtil.copy((InputStream)new ByteArrayInputStream(content), (OutputStream)oldTarget);
                if (loadingRepository) {
                    File cacheFile2 = this.getCacheFile(uri);
                    IOUtil.writeFile((File)cacheFile2, (byte[])content);
                    DownloadStatus downloadStatus = (DownloadStatus)status;
                    long lastModified = downloadStatus.getLastModified();
                    cacheFile2.setLastModified(lastModified);
                }
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            if (oldTarget instanceof IStateful) {
                ((IStateful)oldTarget).setStatus(statefulTarget.getStatus());
            }
        }
    }

    public IStatus download(java.net.URI uri, OutputStream target, IProgressMonitor monitor) {
        return this.download(uri, target, 0L, monitor);
    }

    public InputStream stream(java.net.URI uri, IProgressMonitor monitor) throws FileNotFoundException, CoreException, AuthenticationFailedException {
        return this.delegate.stream(uri, monitor);
    }

    public long getLastModified(java.net.URI uri, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException {
        boolean loadingRepository;
        if (DEBUG) {
            CachingTransport.log("  ? " + uri);
        }
        if ((loadingRepository = CachingTransport.isLoadingRepository(uri)) && OfflineMode.isEnabled()) {
            File cacheFile = this.getCacheFile(uri);
            if (cacheFile.exists()) {
                return cacheFile.lastModified();
            }
            try {
                return this.delegateGetLastModified(uri, monitor);
            }
            catch (FileNotFoundException ex) {
                throw ex;
            }
            catch (Exception ex) {
                FileNotFoundException exception = new FileNotFoundException(ex.getMessage());
                exception.initCause(ex);
                throw exception;
            }
        }
        return this.delegateGetLastModified(uri, monitor);
    }

    private long delegateGetLastModified(java.net.URI uri, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException {
        long lastModified = this.delegate.getLastModified(uri, monitor);
        File cacheFile = this.getCacheFile(uri);
        if (!cacheFile.exists() || cacheFile.lastModified() != lastModified) {
            return lastModified - 1L;
        }
        return lastModified;
    }

    private static boolean isLoadingRepository(java.net.URI uri) {
        String location = URI.createURI((String)uri.toString()).trimSegments(1).toString();
        Stack<String> stack = REPOSITORY_LOCATIONS.get();
        return !stack.isEmpty() && stack.peek().equals(location);
    }

    static void startLoadingRepository(java.net.URI location) {
        String uri = location.toString();
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        Stack<String> stack = REPOSITORY_LOCATIONS.get();
        stack.push(uri);
        if (DEBUG && !uri.startsWith("file:")) {
            CachingTransport.log("--> " + location);
        }
    }

    static void stopLoadingRepository() {
        String location;
        Stack<String> stack = REPOSITORY_LOCATIONS.get();
        if (DEBUG && !stack.isEmpty() && !(location = stack.peek()).startsWith("file:")) {
            CachingTransport.log("<-- " + location);
        }
        stack.pop();
    }

    private static void log(String message) {
        Stack<String> stack = REPOSITORY_LOCATIONS.get();
        int i = 1;
        while (i < stack.size()) {
            message = "   " + message;
            ++i;
        }
        System.out.println(message);
    }
}

