/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.pde.impl;

import java.io.File;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.log.ProgressLog;
import org.eclipse.oomph.setup.log.ProgressLogMonitor;
import org.eclipse.oomph.setup.pde.APIBaselineTask;
import org.eclipse.oomph.setup.pde.PDEPackage;
import org.eclipse.oomph.setup.util.DownloadUtil;
import org.eclipse.oomph.setup.util.FileUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.ZIPUtil;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.model.ApiModelFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiBaselineManager;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;

public class APIBaselineTaskImpl
extends SetupTaskImpl
implements APIBaselineTask {
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String VERSION_EDEFAULT = null;
    protected String version = VERSION_EDEFAULT;
    protected static final String LOCATION_EDEFAULT = "";
    protected String location = "";
    protected static final String REMOTE_URI_EDEFAULT = null;
    protected String remoteURI = REMOTE_URI_EDEFAULT;
    private transient File remoteURIFile;
    private transient String baselineName;
    private transient File baselineDir;
    private transient IApiBaseline baseline;

    protected APIBaselineTaskImpl() {
    }

    protected EClass eStaticClass() {
        return PDEPackage.Literals.API_BASELINE_TASK;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldName, (Object)this.name));
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldVersion, (Object)this.version));
        }
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String newLocation) {
        String oldLocation = this.location;
        this.location = newLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldLocation, (Object)this.location));
        }
    }

    public String getRemoteURI() {
        return this.remoteURI;
    }

    public void setRemoteURI(String newRemoteURI) {
        String oldRemoteURI = this.remoteURI;
        this.remoteURI = newRemoteURI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldRemoteURI, (Object)this.remoteURI));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getName();
            }
            case 10: {
                return this.getVersion();
            }
            case 11: {
                return this.getLocation();
            }
            case 12: {
                return this.getRemoteURI();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setName((String)newValue);
                return;
            }
            case 10: {
                this.setVersion((String)newValue);
                return;
            }
            case 11: {
                this.setLocation((String)newValue);
                return;
            }
            case 12: {
                this.setRemoteURI((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 10: {
                this.setVersion(VERSION_EDEFAULT);
                return;
            }
            case 11: {
                this.setLocation(LOCATION_EDEFAULT);
                return;
            }
            case 12: {
                this.setRemoteURI(REMOTE_URI_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 10: {
                return VERSION_EDEFAULT == null ? this.version != null : !VERSION_EDEFAULT.equals(this.version);
            }
            case 11: {
                return LOCATION_EDEFAULT == null ? this.location != null : !LOCATION_EDEFAULT.equals(this.location);
            }
            case 12: {
                return REMOTE_URI_EDEFAULT == null ? this.remoteURI != null : !REMOTE_URI_EDEFAULT.equals(this.remoteURI);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", version: ");
        result.append(this.version);
        result.append(", location: ");
        result.append(this.location);
        result.append(", remoteURI: ");
        result.append(this.remoteURI);
        result.append(')');
        return result.toString();
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        ApiPlugin apiPlugin = ApiPlugin.getDefault();
        if (apiPlugin == null) {
            return false;
        }
        this.baselineName = String.valueOf(this.getName()) + "-" + this.getVersion();
        this.baselineDir = new File(this.getLocation());
        this.remoteURIFile = new File(this.baselineDir, "remoteURI.txt");
        IApiBaselineManager baselineManager = apiPlugin.getApiBaselineManager();
        IApiBaseline baseline = baselineManager.getApiBaseline(this.baselineName);
        if (baseline == null) {
            return true;
        }
        ((ApiBaselineManager)baselineManager).loadBaselineInfos(baseline);
        if (!this.baselineDir.isDirectory() || !new File(baseline.getLocation()).equals(this.baselineDir)) {
            baselineManager.removeApiBaseline(this.baselineName);
            baseline.setName(String.valueOf(this.baselineName) + " " + System.currentTimeMillis());
            baselineManager.addApiBaseline(baseline);
            return true;
        }
        if (baselineManager.getDefaultApiBaseline() != baseline) {
            this.baseline = baseline;
            return true;
        }
        return this.isDifferentRemoteURI();
    }

    public void perform(SetupTaskContext context) throws Exception {
        IApiBaselineManager baselineManager = ApiPlugin.getDefault().getApiBaselineManager();
        if (this.baseline == null) {
            if (this.isDifferentRemoteURI()) {
                FileUtil.delete((File)this.baselineDir, (IProgressMonitor)new ProgressLogMonitor((ProgressLog)context));
            }
            if (!this.baselineDir.exists()) {
                this.downloadAndUnzip(context);
            }
            IOUtil.writeFile((File)this.remoteURIFile, (byte[])this.getRemoteURI().getBytes("UTF-8"));
            String location = this.baselineDir.toString();
            context.log("Creating API baseline from " + location);
            this.baseline = ApiModelFactory.newApiBaseline((String)this.baselineName, (String)location);
            ApiModelFactory.addComponents((IApiBaseline)this.baseline, (String)location, (IProgressMonitor)new ProgressLogMonitor((ProgressLog)context));
            baselineManager.addApiBaseline(this.baseline);
        }
        context.log("Activating API baseline: " + this.baselineName);
        baselineManager.setDefaultApiBaseline(this.baselineName);
    }

    private boolean isDifferentRemoteURI() throws Exception {
        String zipLocationURL;
        return this.remoteURIFile.exists() && !ObjectUtil.equals((Object)(zipLocationURL = new String(IOUtil.readFile((File)this.remoteURIFile), "UTF-8")), (Object)this.getRemoteURI());
    }

    private void downloadAndUnzip(final SetupTaskContext context) throws Exception {
        File zipFile = DownloadUtil.downloadURL((String)this.getRemoteURI(), (ProgressLog)context);
        this.baselineDir.mkdirs();
        ZIPUtil.unzip((File)zipFile, (ZIPUtil.UnzipHandler)new ZIPUtil.FileSystemUnzipHandler(this.baselineDir, 4096){

            public void unzipFile(String name, InputStream zipStream) {
                context.log("Unzipping " + name);
                super.unzipFile(name, zipStream);
            }
        });
    }
}

