/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.BasicResourceHandler;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.core.util.SetupUtil;
import org.eclipse.oomph.setup.internal.core.util.WorkerPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMirror
extends WorkerPool<ResourceMirror, URI, LoadJob> {
    private ResourceSet resourceSet;
    private DelegatingResourceLocator resourceLocator;

    public ResourceMirror() {
        this(SetupUtil.createResourceSet());
    }

    public ResourceMirror(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
        this.resourceLocator = new DelegatingResourceLocator((ResourceSetImpl)resourceSet);
    }

    @Override
    protected LoadJob createWorker(URI key, int workerID, boolean secondary) {
        return new LoadJob(this, key, workerID, secondary);
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void begin(final IProgressMonitor monitor) {
        final String taskName = this.resourceSet.getLoadOptions().get("OPTION_CACHE_HANDLING") == ECFURIHandlerImpl.CacheHandling.CACHE_WITHOUT_ETAG_CHECKING ? "Loading from local cache " : "Loading from internet ";
        ResourceSet resourceSet = this.getResourceSet();
        BasicResourceHandler resourceHandler = new BasicResourceHandler(){
            private int counter;
            private final Set<ResourceSet> resourceSets = new HashSet<ResourceSet>();

            public synchronized void preLoad(XMLResource resource, InputStream inputStream, Map<?, ?> options) {
                ResourceSet resourceSet = ResourceMirror.this.getResourceSet();
                this.resourceSets.add(resourceSet);
                int total = 0;
                for (ResourceSet rs : this.resourceSets) {
                    total += rs.getResources().size();
                }
                monitor.subTask("Loading " + resource.getURI());
                monitor.worked(1);
                ++this.counter;
                if (total < this.counter) {
                    total = this.counter;
                }
                monitor.setTaskName(String.valueOf(taskName) + this.counter + " of " + total);
            }
        };
        1 oldResourceHandler = resourceSet.getLoadOptions().put("RESOURCE_HANDLER", resourceHandler);
        EList resources = resourceSet.getResources();
        monitor.beginTask(taskName, resources.size() < 3 ? -1 : resources.size());
        super.begin(taskName, monitor);
        resourceSet.getLoadOptions().put("RESOURCE_HANDLER", oldResourceHandler);
    }

    @Override
    public void dispose() {
        this.resourceSet = null;
        this.resourceLocator.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isCompleted(URI uri) {
        if (this.resourceSet == null) {
            return true;
        }
        ResourceSet resourceSet = this.resourceSet;
        synchronized (resourceSet) {
            block5: {
                Resource resource = this.resourceSet.getResource(uri, false);
                if (resource == null || !resource.isLoaded()) break block5;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource createResource(URI uri) {
        Resource resource;
        ResourceSet resourceSet = this.resourceSet;
        synchronized (resourceSet) {
            resource = this.resourceSet.getResource(uri, false);
            if (resource == null) {
                resource = this.resourceSet.createResource(uri);
            }
        }
        return resource;
    }

    private final class DelegatingResourceLocator
    extends ResourceSetImpl.ResourceLocator {
        private DelegatingResourceLocator(ResourceSetImpl resourceSet) {
            super(resourceSet);
        }

        public Resource getResource(URI uri, boolean loadOnDemand) {
            if (loadOnDemand && "setup".equals(uri.fileExtension())) {
                return null;
            }
            return this.basicGetResource(uri, loadOnDemand);
        }

        public void dispose() {
            super.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LoadJob
    extends WorkerPool.Worker<URI, ResourceMirror> {
        private LoadJob(ResourceMirror resourceMirror, URI uri, int id, boolean secondary) {
            super("Load " + uri, resourceMirror, uri, id, secondary);
        }

        @Override
        protected IStatus perform(IProgressMonitor monitor) {
            Resource resource = ((ResourceMirror)this.getWorkPool()).createResource((URI)this.getKey());
            try {
                resource.load(((ResourceMirror)this.getWorkPool()).resourceSet.getLoadOptions());
            }
            catch (IOException ex) {
                new ResourceSetImpl(){

                    public void handleDemandLoadException(Resource resource, IOException exception) throws RuntimeException {
                        try {
                            super.handleDemandLoadException(resource, exception);
                        }
                        catch (RuntimeException runtimeException) {}
                    }
                }.handleDemandLoadException(resource, ex);
            }
            this.visit(resource);
            return Status.OK_STATUS;
        }

        private void delay() {
        }

        private void visit(Resource resource) {
            ResourceMirror workPool = (ResourceMirror)this.getWorkPool();
            TreeIterator it = EcoreUtil.getAllContents((Resource)resource, (boolean)false);
            block0: while (it.hasNext()) {
                this.delay();
                if (workPool.isCanceled()) break;
                EObject eObject = (EObject)it.next();
                if (eObject.eIsProxy()) {
                    URI proxyURI = ((InternalEObject)eObject).eProxyURI().trimFragment();
                    workPool.schedule(proxyURI, false);
                    continue;
                }
                ListIterator it2 = ((InternalEList)eObject.eCrossReferences()).basicListIterator();
                while (it2.hasNext()) {
                    this.delay();
                    if (workPool.isCanceled()) continue block0;
                    EObject eCrossReference = (EObject)it2.next();
                    if (!eCrossReference.eIsProxy()) continue;
                    URI proxyURI = ((InternalEObject)eCrossReference).eProxyURI().trimFragment();
                    workPool.schedule(proxyURI, true);
                }
            }
        }
    }
}

