/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.datapoints.StringDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.DoorState;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class DoorStatus
extends Module {
    private DoorState doorState;
    private StringDataPoint openDuration;
    private BooleanDataPoint openAlarm;

    public DoorStatus(String name, Domain domain, DoorState state) {
        super(name, domain, (Identifiers)ModuleType.doorStatus);
        if (state == null || !state.getShortDefinitionType().equals(DatapointType.doorState.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong doorState datapoint: " + (Object)((Object)state));
        }
        this.doorState = state;
        this.doorState.setWritable(false);
        this.doorState.setDoc("\"True\" indicates that door is closed, \"False\"indicates the door is open.");
        this.addDataPoint((DataPoint)this.doorState);
    }

    public DoorStatus(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (DoorState)dps.get(DatapointType.doorState.getShortName()));
        BooleanDataPoint openAlarm;
        StringDataPoint openDuration = (StringDataPoint)dps.get(DatapointType.openDuration.getShortName());
        if (openDuration != null) {
            this.setOpenDuration(openDuration);
        }
        if ((openAlarm = (BooleanDataPoint)dps.get(DatapointType.openAlarm.getShortName())) != null) {
            this.setOpenAlarm(openAlarm);
        }
    }

    public int getDoorState() throws DataPointException, AccessException {
        return (Integer)this.doorState.getValue();
    }

    public void setOpenDuration(StringDataPoint dp) {
        this.openDuration = dp;
        this.openDuration.setOptional(true);
        this.openDuration.setWritable(false);
        this.openDuration.setDoc("The time duration the door has been open. The type of openDuration is an ISO 8601 Time encoded string.");
        this.addDataPoint((DataPoint)this.openDuration);
    }

    public String getOpenDuration() throws DataPointException, AccessException {
        if (this.openDuration == null) {
            throw new DataPointException("Not implemented");
        }
        return (String)this.openDuration.getValue();
    }

    public void setOpenAlarm(BooleanDataPoint dp) {
        this.openAlarm = dp;
        this.openAlarm.setOptional(true);
        this.openAlarm.setWritable(true);
        this.openAlarm.setDoc("The state of the door open alarm. True indicates that the open alarm is active. False indicates that open alarm is not active.");
        this.addDataPoint((DataPoint)this.openAlarm);
    }

    public boolean getOpenAlarm() throws DataPointException, AccessException {
        if (this.openAlarm == null) {
            throw new DataPointException("Not implemented");
        }
        return (Boolean)this.openAlarm.getValue();
    }

    public void setOpenAlarm(boolean b) throws DataPointException, AccessException {
        if (this.openAlarm == null) {
            throw new DataPointException("Not implemented");
        }
        this.openAlarm.setValue((Object)b);
    }
}

