/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.List;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.ConflictException;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.utils.Util;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.notifier.Notifier;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.core.util.ControllerUtil;
import org.eclipse.om2m.persistence.service.DAO;

public class DynamicAuthorizationConsultationController
extends Controller {
    @Override
    public ResponsePrimitive doCreate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        Patterns patterns = new Patterns();
        DAO<?> dao = patterns.getDAO(request.getTo(), this.dbs);
        if (dao == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        ResourceEntity parentEntity = (ResourceEntity)dao.find(this.transaction, (Object)request.getTo());
        if (parentEntity == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        this.transaction.lock((Object)parentEntity);
        List acpsToCheck = null;
        List childDynamicAuthorizationConsultations = null;
        List subs = null;
        switch (parentEntity.getResourceType().intValue()) {
            case 5: {
                CSEBaseEntity cseBaseEntity = (CSEBaseEntity)parentEntity;
                acpsToCheck = cseBaseEntity.getAccessControlPolicies();
                childDynamicAuthorizationConsultations = cseBaseEntity.getChildDynamicAuthorizationConsultation();
                subs = cseBaseEntity.getSubscriptions();
                cseBaseEntity.getDynamicAuthorizationConsultations();
                break;
            }
            case 16: {
                RemoteCSEEntity remoteCseEntity = (RemoteCSEEntity)parentEntity;
                acpsToCheck = remoteCseEntity.getAccessControlPolicies();
                childDynamicAuthorizationConsultations = remoteCseEntity.getChildDynamicAuthorizationConsultation();
                subs = remoteCseEntity.getSubscriptions();
                remoteCseEntity.getDynamicAuthorizationConsultations();
                break;
            }
            case 2: {
                AeEntity aeEntity = (AeEntity)parentEntity;
                acpsToCheck = aeEntity.getAccessControlPolicies();
                childDynamicAuthorizationConsultations = aeEntity.getChildDynamicAuthorizationConsultations();
                subs = aeEntity.getSubscriptions();
                aeEntity.getDynamicAuthorizationConsultations();
            }
        }
        this.checkACP(acpsToCheck, request.getFrom(), Operation.CREATE);
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for AE creation");
        }
        DynamicAuthorizationConsultation dac = null;
        try {
            dac = request.getRequestContentType().equals("application/obj") ? (DynamicAuthorizationConsultation)request.getContent() : (DynamicAuthorizationConsultation)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (dac == null) {
            throw new BadRequestException("Error in provided content");
        }
        DynamicAuthorizationConsultationEntity dacEntity = new DynamicAuthorizationConsultationEntity();
        ControllerUtil.CreateUtil.fillEntityFromGenericResource((Resource)dac, (ResourceEntity)dacEntity);
        dacEntity.setExpirationTime(dac.getExpirationTime());
        if (!dac.getDynamicAuthorizationConsultationIDs().isEmpty()) {
            dacEntity.setDynamicAuthorizationConsultations(ControllerUtil.buildDacEntityList(dac.getDynamicAuthorizationConsultationIDs(), this.transaction));
        }
        if (dac.getDynamicAuthorizationEnabled() == null) {
            throw new BadRequestException("dynamicAuthorizationEnabled is Mandatory");
        }
        dacEntity.setDynamicAuthorizationEnabled(dac.getDynamicAuthorizationEnabled());
        dacEntity.setDynamicAuthorizationPoA(dac.getDynamicAuthorisationPoA());
        dacEntity.setDynamicAuthorizationLifetime(dac.getDynamicAuthorizationLifetime());
        String generatedId = DynamicAuthorizationConsultationController.generateId("", "");
        if (dac.getName() != null) {
            if (!patterns.checkResourceName(dac.getName())) {
                throw new BadRequestException("Name provided is incorrect. Must be:" + patterns.ID_STRING);
            }
            dacEntity.setName(dac.getName());
        } else {
            dacEntity.setName("dac_" + generatedId);
        }
        dacEntity.setResourceID("/" + Constants.CSE_ID + "/" + "dac" + Constants.PREFIX_SEPERATOR + generatedId);
        dacEntity.setHierarchicalURI(String.valueOf(parentEntity.getHierarchicalURI()) + "/" + dacEntity.getName());
        dacEntity.setResourceType(34);
        switch (parentEntity.getResourceType().intValue()) {
            case 5: {
                dacEntity.setParentCseBase((CSEBaseEntity)parentEntity);
                break;
            }
            case 16: {
                dacEntity.setParentRemoteCse((RemoteCSEEntity)parentEntity);
                break;
            }
            case 2: {
                dacEntity.setParentAe((AeEntity)parentEntity);
                break;
            }
            default: {
                throw new BadRequestException("invalid parent type");
            }
        }
        dacEntity.setParentID(parentEntity.getResourceID());
        if (!dac.getAccessControlPolicyIDs().isEmpty()) {
            dacEntity.setAccessControlPolicies(ControllerUtil.buildAcpEntityList(dac.getAccessControlPolicyIDs(), this.transaction));
        } else {
            dacEntity.setAccessControlPolicies(acpsToCheck);
        }
        if (!UriMapper.addNewUri(dacEntity.getHierarchicalURI(), dacEntity.getResourceID(), 34)) {
            throw new ConflictException("Name already present in the parent collection.");
        }
        this.dbs.getDAOFactory().getDynamicAuthorizationDAO().create(this.transaction, (Object)dacEntity);
        DynamicAuthorizationConsultationEntity dacFromDB = (DynamicAuthorizationConsultationEntity)this.dbs.getDAOFactory().getDynamicAuthorizationDAO().find(this.transaction, (Object)dacEntity.getResourceID());
        childDynamicAuthorizationConsultations.add(dacFromDB);
        dao.update(this.transaction, (Object)parentEntity);
        for (DynamicAuthorizationConsultationEntity dace : dacFromDB.getDynamicAuthorizationConsultations()) {
            DynamicAuthorizationConsultationEntity daceFromDB = (DynamicAuthorizationConsultationEntity)this.dbs.getDAOFactory().getDynamicAuthorizationDAO().find(this.transaction, (Object)dace.getResourceID());
            daceFromDB.getLinkedDynamicAuthorizationConsultationEntity().add(dacFromDB);
            this.dbs.getDAOFactory().getDynamicAuthorizationDAO().update(this.transaction, (Object)daceFromDB);
        }
        Notifier.notify(subs, (ResourceEntity)dacFromDB, 1);
        response.setResponseStatusCode(ResponseStatusCode.CREATED);
        this.setLocationAndCreationContent(request, response, (ResourceEntity)dacFromDB);
        return response;
    }

    @Override
    public ResponsePrimitive doRetrieve(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        DynamicAuthorizationConsultationEntity dacEntity = (DynamicAuthorizationConsultationEntity)this.dbs.getDAOFactory().getDynamicAuthorizationDAO().find(this.transaction, (Object)request.getTo());
        if (dacEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        List acpsToCheck = dacEntity.getAccessControlPolicies();
        this.checkACP(acpsToCheck, request.getFrom(), request.getOperation());
        DynamicAuthorizationConsultation dac = EntityMapperFactory.getDynamicAuthorizationConsultationMapper().mapEntityToResource(dacEntity, request);
        response.setContent((Object)dac);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    @Override
    public ResponsePrimitive doUpdate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        DynamicAuthorizationConsultationEntity dacEntity = (DynamicAuthorizationConsultationEntity)this.dbs.getDAOFactory().getDynamicAuthorizationDAO().find(this.transaction, (Object)request.getTo());
        if (dacEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        List acpsToCheck = dacEntity.getAccessControlPolicies();
        this.checkACP(acpsToCheck, request.getFrom(), request.getOperation());
        this.transaction.lock((Object)dacEntity);
        DynamicAuthorizationConsultation dac = null;
        try {
            dac = request.getRequestContentType().equals("application/obj") ? (DynamicAuthorizationConsultation)request.getContent() : (DynamicAuthorizationConsultation)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (dac == null) {
            throw new BadRequestException("Error in provided content");
        }
        DynamicAuthorizationConsultation modifiedDAC = new DynamicAuthorizationConsultation();
        if (dac.getExpirationTime() != null) {
            dacEntity.setExpirationTime(dac.getExpirationTime());
            modifiedDAC.setExpirationTime(dac.getExpirationTime());
        }
        if (!dac.getAccessControlPolicyIDs().isEmpty()) {
            dacEntity.getAccessControlPolicies().clear();
            dacEntity.setAccessControlPolicies(ControllerUtil.buildAcpEntityList(dac.getAccessControlPolicyIDs(), this.transaction));
            modifiedDAC.getAccessControlPolicyIDs().addAll(dac.getAccessControlPolicyIDs());
        }
        if (!dac.getLabels().isEmpty()) {
            dacEntity.getLabelsEntities().clear();
            dacEntity.setLabelsEntitiesFromSring(dac.getLabels());
            modifiedDAC.getLabels().addAll(dac.getLabels());
        }
        if (!dac.getDynamicAuthorizationConsultationIDs().isEmpty()) {
            dacEntity.setDynamicAuthorizationConsultations(ControllerUtil.buildDacEntityList(dac.getDynamicAuthorizationConsultationIDs(), this.transaction));
            for (DynamicAuthorizationConsultationEntity dace : dacEntity.getDynamicAuthorizationConsultations()) {
                DynamicAuthorizationConsultationEntity daceFromDB = (DynamicAuthorizationConsultationEntity)this.dbs.getDAOFactory().getDynamicAuthorizationDAO().find(this.transaction, (Object)dace.getResourceID());
                daceFromDB.getLinkedDynamicAuthorizationConsultationEntity().add(dacEntity);
                this.dbs.getDAOFactory().getDynamicAuthorizationDAO().update(this.transaction, (Object)daceFromDB);
            }
        }
        if (dac.getDynamicAuthorizationEnabled() != null) {
            dacEntity.setDynamicAuthorizationEnabled(dac.getDynamicAuthorizationEnabled());
            modifiedDAC.setDynamicAuthorizationEnabled(dac.getDynamicAuthorizationEnabled());
        }
        if (!dac.getDynamicAuthorisationPoA().isEmpty()) {
            dacEntity.setDynamicAuthorizationPoA(dac.getDynamicAuthorisationPoA());
            modifiedDAC.setDynamicAuthorisationPoA(dac.getDynamicAuthorisationPoA());
        }
        if (dac.getDynamicAuthorizationLifetime() != null) {
            dacEntity.setDynamicAuthorizationLifetime(dac.getDynamicAuthorizationLifetime());
            modifiedDAC.setDynamicAuthorizationLifetime(dac.getDynamicAuthorizationLifetime());
        }
        dacEntity.setLastModifiedTime(Util.DateUtil.now());
        modifiedDAC.setLastModifiedTime(dacEntity.getLastModifiedTime());
        this.dbs.getDAOFactory().getDynamicAuthorizationDAO().update(this.transaction, (Object)dacEntity);
        this.transaction.commit();
        response.setContent((Object)modifiedDAC);
        response.setResponseStatusCode(ResponseStatusCode.UPDATED);
        return response;
    }

    @Override
    public ResponsePrimitive doDelete(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        DynamicAuthorizationConsultationEntity dacEntity = (DynamicAuthorizationConsultationEntity)this.dbs.getDAOFactory().getDynamicAuthorizationDAO().find(this.transaction, (Object)request.getTo());
        if (dacEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        this.transaction.lock((Object)dacEntity);
        List acpsToCheck = dacEntity.getAccessControlPolicies();
        this.checkACP(acpsToCheck, request.getFrom(), request.getOperation());
        UriMapper.deleteUri(dacEntity.getHierarchicalURI());
        this.dbs.getDAOFactory().getDynamicAuthorizationDAO().delete(this.transaction, (Object)dacEntity);
        this.transaction.commit();
        response.setResponseStatusCode(ResponseStatusCode.DELETED);
        return response;
    }
}

