/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt.testsuite.module;

import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.BinarySwitchFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.ipe.sdt.testsuite.CSEUtil;
import org.eclipse.om2m.ipe.sdt.testsuite.TestReport;
import org.eclipse.om2m.ipe.sdt.testsuite.module.AbstractModuleTest;
import org.eclipse.om2m.ipe.sdt.testsuite.module.exception.FlexContainerNotFound;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;

public class BinarySwitchModuleTest
extends AbstractModuleTest {
    public BinarySwitchModuleTest(CseService pCseService, Module pModule) {
        super(pCseService, pModule);
    }

    public TestReport test() {
        String moduleUrl;
        TestReport report = new TestReport("Test module " + this.getModule().getName());
        System.out.println("start test module " + this.getModule().getName());
        try {
            moduleUrl = this.getModuleFlexContainerUrl();
        }
        catch (FlexContainerNotFound flexContainerNotFound) {
            report.setErrorMessage("unable to find out flexContainer for module " + this.getModule().getName());
            report.setState(TestReport.State.KO);
            return report;
        }
        ResponsePrimitive response = CSEUtil.retrieveEntity(this.getCseService(), moduleUrl);
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to retrieve flexContainer (url=" + moduleUrl + ")");
            report.setState(TestReport.State.KO);
            return report;
        }
        BinarySwitchFlexContainer retrievedFlexContainer = (BinarySwitchFlexContainer)response.getContent();
        CustomAttribute powerStateCA = retrievedFlexContainer.getCustomAttribute(DatapointType.powerState.getShortName());
        Boolean powerState = Boolean.parseBoolean(powerStateCA.getCustomAttributeValue());
        System.out.println("powerState=" + powerState);
        BinarySwitchFlexContainer toBeUpdatedFlexContainer = new BinarySwitchFlexContainer();
        Boolean newPowerState = new Boolean(powerState == false);
        powerStateCA.setCustomAttributeValue(newPowerState.toString());
        toBeUpdatedFlexContainer.getCustomAttributes().add(powerStateCA);
        response = CSEUtil.updateFlexContainerEntity(this.getCseService(), moduleUrl, (AbstractFlexContainer)toBeUpdatedFlexContainer);
        if (!ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to update flexContainer (url=" + moduleUrl + ")");
            report.setState(TestReport.State.KO);
            return report;
        }
        BooleanDataPoint powerStateDP = (BooleanDataPoint)this.getModule().getDataPoint(DatapointType.powerState.getShortName());
        try {
            Boolean valueFromModule = (Boolean)powerStateDP.getValue();
            if (!newPowerState.equals(valueFromModule)) {
                report.setErrorMessage("value from module (" + valueFromModule + ") is the same as the one set (" + newPowerState + ")");
                report.setState(TestReport.State.KO);
                return report;
            }
        }
        catch (DataPointException e) {
            report.setErrorMessage("unable to retrieve value from module :" + e.getMessage());
            report.setState(TestReport.State.KO);
            return report;
        }
        catch (AccessException e) {
            report.setErrorMessage("AccessException - unable to retrieve value from module :" + e.getMessage());
            report.setState(TestReport.State.KO);
            return report;
        }
        retrievedFlexContainer = (BinarySwitchFlexContainer)response.getContent();
        powerStateCA = retrievedFlexContainer.getCustomAttribute(DatapointType.powerState.getShortName());
        Boolean currentPowerStateValue = Boolean.parseBoolean(powerStateCA.getCustomAttributeValue());
        if (!currentPowerStateValue.equals(newPowerState)) {
            System.out.println("value from flexContainer (" + currentPowerStateValue + ") is the same as the one set (" + newPowerState + ")");
        }
        System.out.println("test module " + this.getModule().getName() + " __________________ OK ___________________________");
        report.setState(TestReport.State.OK);
        return report;
    }
}

