/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.devices;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.eclipse.om2m.sdt.Device;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Property;
import org.eclipse.om2m.sdt.exceptions.PropertyException;
import org.eclipse.om2m.sdt.home.types.DeviceType;
import org.eclipse.om2m.sdt.home.types.PropertyType;
import org.eclipse.om2m.sdt.types.SimpleType;

public class GenericDevice
extends Device {
    private Property deviceManufacturer;
    private Property deviceSerialNum;
    private Property deviceModelName;
    private Property deviceType;
    private DeviceType type;
    private Property deviceName;
    private Property deviceSubModelName;
    private Property deviceAliasName;
    private Property deviceFirmwareVersion;
    private Property hardwareVersion;
    private Property osVersion;
    private Property protocol;
    private Property country;
    private Property location;
    private Property systemTime;
    private Property manufacturerDetailsLink;
    private Property dateOfManufacture;
    private Property supportURL;
    private Property presentationURL;
    private Property cloud;

    public GenericDevice(String id, String serial, Domain domain) {
        this(id, serial, DeviceType.undefinedVendorExt, domain);
    }

    public GenericDevice(String id, String serial, DeviceType type, Domain domain) {
        super(id, domain, (Identifiers)type);
        this.type = type;
        this.deviceType = new Property((Identifiers)PropertyType.deviceType, Integer.toString(type.getValue()));
        this.deviceType.setType(SimpleType.Integer);
        this.deviceType.setDoc("Device type");
        super.addProperty(this.deviceType);
        this.deviceSerialNum = new Property((Identifiers)PropertyType.deviceSerialNum, serial);
        this.deviceSerialNum.setType(SimpleType.String);
        this.deviceSerialNum.setDoc("Device serial number (assigned by manufacturer)");
        super.addProperty(this.deviceSerialNum);
        this.deviceManufacturer = new Property((Identifiers)PropertyType.deviceManufacturer);
        this.deviceManufacturer.setType(SimpleType.String);
        this.deviceManufacturer.setDoc("Manufacturer name of the device");
        super.addProperty(this.deviceManufacturer);
        this.deviceModelName = new Property((Identifiers)PropertyType.deviceModelName);
        this.deviceModelName.setType(SimpleType.String);
        this.deviceModelName.setDoc("Device Model Name");
        super.addProperty(this.deviceModelName);
    }

    public void addProperty(Property property) {
        PropertyType type = PropertyType.fromShortName(property.getShortName());
        this.addProperty(type, property.getValue());
    }

    public void addProperty(PropertyType type, String val) {
        switch (type) {
            case deviceManufacturer: {
                this.setDeviceManufacturer(val);
                return;
            }
            case deviceModelName: {
                this.setDeviceModelName(val);
                return;
            }
            case deviceName: {
                this.setDeviceName(val);
                return;
            }
            case deviceSubModelName: {
                this.setDeviceSubModelName(val);
                return;
            }
            case deviceAliasName: {
                this.setDeviceAliasName(val);
                return;
            }
            case deviceFirmwareVersion: {
                this.setDeviceFirmwareVersion(val);
                return;
            }
            case hardwareVersion: {
                this.setHardwareVersion(val);
                return;
            }
            case osVersion: {
                this.setOsVersion(val);
                return;
            }
            case protocol: {
                this.setProtocol(val);
                return;
            }
            case country: {
                this.setCountry(val);
                return;
            }
            case location: {
                this.setLocation(val);
                return;
            }
            case systemTime: {
                this.setSystemTime(val);
                return;
            }
            case manufacturerDetailsLink: {
                this.setManufacturerDetailsLink(val);
                return;
            }
            case dateOfManufacture: {
                this.setDateOfManufacture(val);
                return;
            }
            case supportURL: {
                this.setSupportURL(val);
                return;
            }
            case presentationURL: {
                this.setPresentationURL(val);
                return;
            }
            case cloud: {
                this.setCloud(val);
                return;
            }
        }
        super.addProperty(new Property((Identifiers)type, val));
    }

    protected void setDeviceType(DeviceType type) {
        this.type = type;
        this.deviceType.setValue(Integer.toString(type.getValue()));
    }

    public DeviceType getDeviceType() {
        return this.type;
    }

    public String getSerialNumber() {
        return this.deviceSerialNum.getValue();
    }

    public String getDeviceManufacturer() {
        return this.deviceManufacturer.getValue();
    }

    public void setDeviceManufacturer(String s) {
        this.deviceManufacturer.setValue(s);
    }

    public String getDeviceModelName() {
        return this.deviceModelName.getValue();
    }

    public void setDeviceModelName(String s) {
        this.deviceModelName.setValue(s);
    }

    public String getDeviceName() {
        return this.deviceName == null ? null : this.deviceName.getValue();
    }

    public void setDeviceName(String s) {
        if (this.deviceName == null) {
            this.deviceName = new Property((Identifiers)PropertyType.deviceName);
            this.deviceName.setType(SimpleType.String);
            this.deviceName.setOptional(true);
            this.deviceName.setDoc("Device name");
            super.addProperty(this.deviceName);
        }
        this.deviceName.setValue(s);
    }

    public String getDeviceSubModelName() {
        return this.deviceSubModelName == null ? null : this.deviceSubModelName.getValue();
    }

    public void setDeviceSubModelName(String s) {
        if (this.deviceSubModelName == null) {
            this.deviceSubModelName = new Property((Identifiers)PropertyType.deviceSubModelName);
            this.deviceSubModelName.setType(SimpleType.String);
            this.deviceSubModelName.setOptional(true);
            this.deviceSubModelName.setDoc("Device sub-modelname");
            super.addProperty(this.deviceSubModelName);
        }
        this.deviceSubModelName.setValue(s);
    }

    public String getDeviceAliasName() {
        return this.deviceAliasName == null ? null : this.deviceAliasName.getValue();
    }

    public void setDeviceAliasName(String s) {
        if (this.deviceAliasName == null) {
            this.deviceAliasName = new Property((Identifiers)PropertyType.deviceAliasName);
            this.deviceAliasName.setType(SimpleType.String);
            this.deviceAliasName.setOptional(true);
            this.deviceAliasName.setDoc("Device alias name");
            super.addProperty(this.deviceAliasName);
        }
        this.deviceAliasName.setValue(s);
    }

    public String getDeviceFirmwareVersion() {
        return this.deviceFirmwareVersion == null ? null : this.deviceFirmwareVersion.getValue();
    }

    public void setDeviceFirmwareVersion(String s) {
        if (this.deviceFirmwareVersion == null) {
            this.deviceFirmwareVersion = new Property((Identifiers)PropertyType.deviceFirmwareVersion);
            this.deviceFirmwareVersion.setType(SimpleType.String);
            this.deviceFirmwareVersion.setOptional(true);
            this.deviceFirmwareVersion.setDoc("Device firmware version");
            super.addProperty(this.deviceFirmwareVersion);
        }
        this.deviceFirmwareVersion.setValue(s);
    }

    public String getHardwareVersion() {
        return this.hardwareVersion == null ? null : this.hardwareVersion.getValue();
    }

    public void setHardwareVersion(String s) {
        if (this.hardwareVersion == null) {
            this.hardwareVersion = new Property((Identifiers)PropertyType.hardwareVersion);
            this.hardwareVersion.setType(SimpleType.String);
            this.hardwareVersion.setOptional(true);
            this.hardwareVersion.setDoc("Device hardware version");
            super.addProperty(this.hardwareVersion);
        }
        this.hardwareVersion.setValue(s);
    }

    public String getOsVersion() {
        return this.osVersion == null ? null : this.osVersion.getValue();
    }

    public void setOsVersion(String s) {
        if (this.osVersion == null) {
            this.osVersion = new Property((Identifiers)PropertyType.osVersion);
            this.osVersion.setType(SimpleType.String);
            this.osVersion.setOptional(true);
            this.osVersion.setDoc("Version of the operation system (defined by manufacturer)");
            super.addProperty(this.osVersion);
        }
        this.osVersion.setValue(s);
    }

    public String getProtocol() {
        return this.protocol == null ? null : this.protocol.getValue();
    }

    public void setProtocol(String s) {
        if (this.protocol == null) {
            this.protocol = new Property((Identifiers)PropertyType.protocol);
            this.protocol.setType(SimpleType.String);
            this.protocol.setOptional(true);
            this.protocol.setDoc("A comma separated list of MIME types for all supported communication protocol(s) of the device. Example: \u201capplication/x-alljoin;version=1.0,application/x-echonet-lite;version=1.0\u201d indicates the device supports both AllJoyn v1.0 and Echonet Lite v1.0.");
            super.addProperty(this.protocol);
        }
        this.protocol.setValue(s);
    }

    public String getCountry() {
        return this.country == null ? null : this.country.getValue();
    }

    public void setCountry(String s) {
        if (this.country == null) {
            this.country = new Property((Identifiers)PropertyType.country);
            this.country.setType(SimpleType.String);
            this.country.setOptional(true);
            this.country.setDoc("Country code of the device");
            super.addProperty(this.country);
        }
        this.country.setValue(s);
    }

    public String getLocation() {
        return this.location == null ? null : this.location.getValue();
    }

    public void setLocation(String s) {
        if (this.location == null) {
            this.location = new Property((Identifiers)PropertyType.location);
            this.location.setType(SimpleType.String);
            this.location.setOptional(true);
            this.location.setDoc("Location where the device is installed. It may be configured via the user interface provided by  the \u2018presentationURL\u2019 property or any other means.");
            super.addProperty(this.location);
        }
        this.location.setValue(s);
    }

    public Date getSystemTime() throws PropertyException {
        if (this.systemTime == null) {
            return null;
        }
        try {
            String s = this.systemTime.getValue();
            return s == null ? null : new Date(Long.parseLong(s));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PropertyException("Implementation Error");
        }
    }

    public void setSystemTime(Date s) {
        if (s != null) {
            this.setSystemTime(Long.toString(s.getTime()));
        }
    }

    private void setSystemTime(String s) {
        if (this.systemTime == null) {
            this.systemTime = new Property((Identifiers)PropertyType.systemTime);
            this.systemTime.setType(SimpleType.Datetime);
            this.systemTime.setOptional(true);
            this.systemTime.setDoc("Reference time for the device");
            super.addProperty(this.systemTime);
        }
        if (s != null) {
            this.systemTime.setValue(s);
        }
    }

    public URL getManufacturerDetailsLink() throws PropertyException {
        if (this.manufacturerDetailsLink == null) {
            return null;
        }
        try {
            String s = this.manufacturerDetailsLink.getValue();
            return s == null ? null : new URL(s);
        }
        catch (MalformedURLException malformedURLException) {
            throw new PropertyException("Implementation Error");
        }
    }

    public void setManufacturerDetailsLink(URL s) {
        if (s != null) {
            this.setManufacturerDetailsLink(s.toString());
        }
    }

    private void setManufacturerDetailsLink(String s) {
        if (this.manufacturerDetailsLink == null) {
            this.manufacturerDetailsLink = new Property((Identifiers)PropertyType.manufacturerDetailsLink);
            this.manufacturerDetailsLink.setType(SimpleType.String);
            this.manufacturerDetailsLink.setOptional(true);
            this.manufacturerDetailsLink.setDoc("URL to manufacturer\u2019s website");
            super.addProperty(this.manufacturerDetailsLink);
        }
        if (s != null) {
            this.manufacturerDetailsLink.setValue(s);
        }
    }

    public Date getDateOfManufacture() throws PropertyException {
        if (this.dateOfManufacture == null) {
            return null;
        }
        try {
            String s = this.dateOfManufacture.getValue();
            return s == null ? null : new Date(Long.parseLong(s));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PropertyException("Implementation Error");
        }
    }

    public void setDateOfManufacture(Date s) {
        if (s != null) {
            this.setDateOfManufacture(Long.toString(s.getTime()));
        }
    }

    private void setDateOfManufacture(String s) {
        if (this.dateOfManufacture == null) {
            this.dateOfManufacture = new Property((Identifiers)PropertyType.dateOfManufacture);
            this.dateOfManufacture.setType(SimpleType.Datetime);
            this.dateOfManufacture.setOptional(true);
            this.dateOfManufacture.setDoc("Manufacturing date of device");
            super.addProperty(this.dateOfManufacture);
        }
        if (s != null) {
            this.dateOfManufacture.setValue(s);
        }
    }

    public URL getSupportURL() throws PropertyException {
        if (this.supportURL == null) {
            return null;
        }
        try {
            String s = this.supportURL.getValue();
            return s == null ? null : new URL(s);
        }
        catch (MalformedURLException malformedURLException) {
            throw new PropertyException("Implementation Error");
        }
    }

    public void setSupportURL(URL s) {
        if (s != null) {
            this.setSupportURL(s.toString());
        }
    }

    private void setSupportURL(String s) {
        if (this.supportURL == null) {
            this.supportURL = new Property((Identifiers)PropertyType.supportURL);
            this.supportURL.setType(SimpleType.String);
            this.supportURL.setOptional(true);
            this.supportURL.setDoc("URL that points to product support information of the device");
            super.addProperty(this.supportURL);
        }
        if (s != null) {
            this.supportURL.setValue(s);
        }
    }

    public URL getPresentationURL() throws PropertyException {
        if (this.presentationURL == null) {
            return null;
        }
        try {
            String s = this.presentationURL.getValue();
            return s == null ? null : new URL(s);
        }
        catch (MalformedURLException malformedURLException) {
            throw new PropertyException("Implementation Error");
        }
    }

    public void setPresentationURL(URL s) {
        if (s != null) {
            this.setPresentationURL(s.toString());
        }
    }

    private void setPresentationURL(String s) {
        if (this.presentationURL == null) {
            this.presentationURL = new Property((Identifiers)PropertyType.presentationURL);
            this.presentationURL.setType(SimpleType.String);
            this.presentationURL.setOptional(true);
            this.presentationURL.setDoc("To quote UPnP: \u201cthe control point can retrieve a page from this URL, load the page into a web browser, and depending on the capabilities of the page, allow a user to control the device and/or view device status. The degree to which each of these can be accomplished depends on the specific capabilities of the presentation page and device.\u201d");
            super.addProperty(this.presentationURL);
        }
        if (s != null) {
            this.presentationURL.setValue(s);
        }
    }

    public boolean getCloud() throws PropertyException {
        if (this.cloud == null) {
            throw new PropertyException("Not implemented");
        }
        return Boolean.parseBoolean(this.cloud.getValue());
    }

    public void setCloud(boolean s) {
        this.setCloud(Boolean.toString(s));
    }

    private void setCloud(String s) {
        if (this.cloud == null) {
            this.cloud = new Property((Identifiers)PropertyType.cloud);
            this.cloud.setType(SimpleType.Boolean);
            this.cloud.setOptional(true);
            this.cloud.setDoc("Device managed from the cloud");
            super.addProperty(this.cloud);
        }
        this.cloud.setValue(s);
    }
}

