/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.testsuite.flexcontainer;

import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.EnergyConsumptionFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.testsuite.flexcontainer.FlexContainerTestSuite;
import org.eclipse.om2m.testsuite.flexcontainer.TestReport;

public class EnergyConsumptionFlexContainerTest
extends FlexContainerTestSuite {
    public EnergyConsumptionFlexContainerTest(CseService pCseService) {
        super(pCseService);
    }

    @Override
    protected String getTestSuiteName() {
        return "EnergyConsumptionFlexContainer";
    }

    public void testCreateAndRetrieveEnergyConsumptionFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "EnergyConsumptionFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        EnergyConsumptionFlexContainer flexContainer = new EnergyConsumptionFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setOntologyRef("Ontology");
        flexContainer.setCreator("greg");
        CustomAttribute powerCustomAttribute = new CustomAttribute();
        powerCustomAttribute.setCustomAttributeName("power");
        powerCustomAttribute.setCustomAttributeValue("342");
        flexContainer.getCustomAttributes().add(powerCustomAttribute);
        CustomAttribute absoluteEnergyConsumptionDataCustomAttribute = new CustomAttribute();
        absoluteEnergyConsumptionDataCustomAttribute.setCustomAttributeName("abECn");
        absoluteEnergyConsumptionDataCustomAttribute.setCustomAttributeValue("3434");
        flexContainer.getCustomAttributes().add(absoluteEnergyConsumptionDataCustomAttribute);
        CustomAttribute roundingEnergyConsumptionDataCustomAttribute = new CustomAttribute();
        roundingEnergyConsumptionDataCustomAttribute.setCustomAttributeName("roECn");
        roundingEnergyConsumptionDataCustomAttribute.setCustomAttributeValue("43242");
        flexContainer.getCustomAttributes().add(roundingEnergyConsumptionDataCustomAttribute);
        CustomAttribute significantFigures = new CustomAttribute();
        significantFigures.setCustomAttributeName("sigDs");
        significantFigures.setCustomAttributeValue("3");
        flexContainer.getCustomAttributes().add(significantFigures);
        CustomAttribute multiplyingFactors = new CustomAttribute();
        multiplyingFactors.setCustomAttributeName("mulFs");
        multiplyingFactors.setCustomAttributeValue("100");
        flexContainer.getCustomAttributes().add(multiplyingFactors);
        CustomAttribute voltage = new CustomAttribute();
        voltage.setCustomAttributeName("volte");
        voltage.setCustomAttributeValue("3443");
        flexContainer.getCustomAttributes().add(voltage);
        CustomAttribute current = new CustomAttribute();
        current.setCustomAttributeName("currt");
        current.setCustomAttributeValue("45353");
        flexContainer.getCustomAttributes().add(current);
        CustomAttribute frequency = new CustomAttribute();
        frequency.setCustomAttributeName("freqy");
        frequency.setCustomAttributeValue("34");
        flexContainer.getCustomAttributes().add(frequency);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        EnergyConsumptionFlexContainer createdFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testCreateAndRetrieveEnergyConsumption", TestReport.Status.KO, "unable to create EnergyConsumption FlexContainer: " + response.getContent(), null);
            return;
        }
        createdFlexContainer = (EnergyConsumptionFlexContainer)response.getContent();
        if (!flexContainerName.equals(createdFlexContainer.getName())) {
            this.createTestReport("testCreateAndRetrieveEnergyConsumption", TestReport.Status.KO, "wrong name. Expecting: " + flexContainerName + ", found:" + createdFlexContainer.getName(), null);
            return;
        }
        try {
            this.checkFlexContainerCreator((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveEnergyConsumption", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        try {
            this.checkFlexContainerCustomAttribute((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveEnergyConsumption", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        try {
            this.checkFlexContainerDefinition((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveEnergyConsumption", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        try {
            this.checkFlexContainerOntologyRef((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveEnergyConsumption", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            this.createTestReport("testCreateAndRetrieveEnergyConsumption", TestReport.Status.KO, "unable to retrieve EnergyConsumption FlexContainer: " + response.getContent(), null);
            return;
        }
        EnergyConsumptionFlexContainer retrievedFlexContainer = (EnergyConsumptionFlexContainer)response.getContent();
        try {
            this.checkFlexContainer((AbstractFlexContainer)createdFlexContainer, (AbstractFlexContainer)retrievedFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveEnergyConsumption", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        this.createTestReport("testCreateAndRetrieveEnergyConsumptionFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testDeleteEnergyConsumptionFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "EnergyConsumptionFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        EnergyConsumptionFlexContainer flexContainer = new EnergyConsumptionFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setOntologyRef("Ontology");
        flexContainer.setCreator("greg");
        CustomAttribute powerCustomAttribute = new CustomAttribute();
        powerCustomAttribute.setCustomAttributeName("power");
        powerCustomAttribute.setCustomAttributeValue("342");
        flexContainer.getCustomAttributes().add(powerCustomAttribute);
        CustomAttribute absoluteEnergyConsumptionDataCustomAttribute = new CustomAttribute();
        absoluteEnergyConsumptionDataCustomAttribute.setCustomAttributeName("abECn");
        absoluteEnergyConsumptionDataCustomAttribute.setCustomAttributeValue("3434");
        flexContainer.getCustomAttributes().add(absoluteEnergyConsumptionDataCustomAttribute);
        CustomAttribute roundingEnergyConsumptionDataCustomAttribute = new CustomAttribute();
        roundingEnergyConsumptionDataCustomAttribute.setCustomAttributeName("roECn");
        roundingEnergyConsumptionDataCustomAttribute.setCustomAttributeValue("43242");
        flexContainer.getCustomAttributes().add(roundingEnergyConsumptionDataCustomAttribute);
        CustomAttribute significantFigures = new CustomAttribute();
        significantFigures.setCustomAttributeName("sigDs");
        significantFigures.setCustomAttributeValue("3");
        flexContainer.getCustomAttributes().add(significantFigures);
        CustomAttribute multiplyingFactors = new CustomAttribute();
        multiplyingFactors.setCustomAttributeName("mulFs");
        multiplyingFactors.setCustomAttributeValue("100");
        flexContainer.getCustomAttributes().add(multiplyingFactors);
        CustomAttribute voltage = new CustomAttribute();
        voltage.setCustomAttributeName("volte");
        voltage.setCustomAttributeValue("3443");
        flexContainer.getCustomAttributes().add(voltage);
        CustomAttribute current = new CustomAttribute();
        current.setCustomAttributeName("currt");
        current.setCustomAttributeValue("45353");
        flexContainer.getCustomAttributes().add(current);
        CustomAttribute frequency = new CustomAttribute();
        frequency.setCustomAttributeName("freqy");
        frequency.setCustomAttributeValue("34");
        flexContainer.getCustomAttributes().add(frequency);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testDeleteEnergyConsumptionFlexContainer", TestReport.Status.KO, "unable to create EnergyConsumption FlexContainer: " + response.getContent(), null);
            return;
        }
        response = this.sendDeleteRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.DELETED)) {
            this.createTestReport("testDeleteEnergyConsumptionFlexContainer", TestReport.Status.KO, "unable to delete EnergyConsumption FlexContainer: " + response.getContent(), null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.NOT_FOUND)) {
            this.createTestReport("testDeleteEnergyConsumptionFlexContainer", TestReport.Status.KO, "expecting: " + ResponseStatusCode.NOT_FOUND + ", found:" + response.getResponseStatusCode(), null);
            return;
        }
        this.createTestReport("testDeleteEnergyConsumptionFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testUpdateEnergyConsumptionFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "EnergyConsumptionFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        EnergyConsumptionFlexContainer flexContainer = new EnergyConsumptionFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setOntologyRef("Ontology");
        flexContainer.setCreator("greg");
        CustomAttribute powerCustomAttribute = new CustomAttribute();
        powerCustomAttribute.setCustomAttributeName("power");
        powerCustomAttribute.setCustomAttributeValue("342");
        flexContainer.getCustomAttributes().add(powerCustomAttribute);
        CustomAttribute absoluteEnergyConsumptionDataCustomAttribute = new CustomAttribute();
        absoluteEnergyConsumptionDataCustomAttribute.setCustomAttributeName("abECn");
        absoluteEnergyConsumptionDataCustomAttribute.setCustomAttributeValue("3434");
        flexContainer.getCustomAttributes().add(absoluteEnergyConsumptionDataCustomAttribute);
        CustomAttribute roundingEnergyConsumptionDataCustomAttribute = new CustomAttribute();
        roundingEnergyConsumptionDataCustomAttribute.setCustomAttributeName("roECn");
        roundingEnergyConsumptionDataCustomAttribute.setCustomAttributeValue("43242");
        flexContainer.getCustomAttributes().add(roundingEnergyConsumptionDataCustomAttribute);
        CustomAttribute significantFigures = new CustomAttribute();
        significantFigures.setCustomAttributeName("sigDs");
        significantFigures.setCustomAttributeValue("3");
        flexContainer.getCustomAttributes().add(significantFigures);
        CustomAttribute multiplyingFactors = new CustomAttribute();
        multiplyingFactors.setCustomAttributeName("mulFs");
        multiplyingFactors.setCustomAttributeValue("100");
        flexContainer.getCustomAttributes().add(multiplyingFactors);
        CustomAttribute voltage = new CustomAttribute();
        voltage.setCustomAttributeName("volte");
        voltage.setCustomAttributeValue("3443");
        flexContainer.getCustomAttributes().add(voltage);
        CustomAttribute current = new CustomAttribute();
        current.setCustomAttributeName("currt");
        current.setCustomAttributeValue("45353");
        flexContainer.getCustomAttributes().add(current);
        CustomAttribute frequency = new CustomAttribute();
        frequency.setCustomAttributeName("freqy");
        frequency.setCustomAttributeValue("34");
        flexContainer.getCustomAttributes().add(frequency);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        EnergyConsumptionFlexContainer createdFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testUpdateEnergyConsumptionFlexContainer", TestReport.Status.KO, "unable to create EnergyConsumption FlexContainer: " + response.getContent(), null);
            return;
        }
        createdFlexContainer = (EnergyConsumptionFlexContainer)response.getContent();
        EnergyConsumptionFlexContainer toBeUpdated = new EnergyConsumptionFlexContainer();
        CustomAttribute updatedVoltage = new CustomAttribute();
        updatedVoltage.setCustomAttributeName("volte");
        updatedVoltage.setCustomAttributeValue("0");
        toBeUpdated.getCustomAttributes().add(updatedVoltage);
        response = this.sendUpdateFlexContainerRequest(flexContainerLocation, (AbstractFlexContainer)toBeUpdated);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.UPDATED)) {
            this.createTestReport("testUpdateEnergyConsumptionFlexContainer", TestReport.Status.KO, "unable to update EnergyConsumption FlexContainer: " + response.getContent(), null);
            return;
        }
        EnergyConsumptionFlexContainer updatedFlexContainer = (EnergyConsumptionFlexContainer)response.getContent();
        if (updatedFlexContainer.getCustomAttributes().size() != 1) {
            this.createTestReport("testUpdateEnergyConsumptionFlexContainer", TestReport.Status.KO, "expecting 1 customAttribute, found " + updatedFlexContainer.getCustomAttributes().size() + " customAttributes", null);
            return;
        }
        if (!updatedFlexContainer.getCustomAttribute("volte").getCustomAttributeValue().equals(updatedVoltage.getCustomAttributeValue())) {
            this.createTestReport("testUpdateEnergyConsumptionFlexContainer", TestReport.Status.KO, "wrong voltage customAttribute value. Expecting: " + updatedVoltage.getCustomAttributeValue() + " , found: " + updatedFlexContainer.getCustomAttribute("volte").getCustomAttributeValue(), null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            this.createTestReport("testUpdateEnergyConsumptionFlexContainer", TestReport.Status.KO, "unable to retrieve EnergyConsumption FlexContainer: " + response.getContent(), null);
            return;
        }
        EnergyConsumptionFlexContainer retrievedFlexContainer = (EnergyConsumptionFlexContainer)response.getContent();
        createdFlexContainer.setName(flexContainerName);
        createdFlexContainer.getCustomAttribute("volte").setCustomAttributeValue("0");
        try {
            this.checkFlexContainer((AbstractFlexContainer)createdFlexContainer, (AbstractFlexContainer)retrievedFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testUpdateEnergyConsumptionFlexContainer", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        this.createTestReport("testUpdateEnergyConsumptionFlexContainer", TestReport.Status.OK, null, null);
    }
}

