/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.ModuleClass;
import org.eclipse.om2m.sdt.datapoints.ValuedDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;

public class Module
extends ModuleClass {
    private final String definition;
    private final String longDefinitionName;
    private final String shortDefinitionName;
    private DatapointHandler handler = new DatapointHandler(){

        @Override
        public void setValues(Map<String, Object> values) throws DataPointException, AccessException {
            Module.this.dosetValues(values);
        }

        @Override
        public Map<String, Object> getValues(List<String> names) throws DataPointException, AccessException {
            return Module.this.dogetValues(names);
        }
    };

    public Module(String id, Domain domain, Identifiers ids) {
        super(String.valueOf(ids.getDefinition()) + "__" + id, domain);
        this.definition = ids.getDefinition();
        this.longDefinitionName = ids.getLongName();
        this.shortDefinitionName = ids.getShortName();
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getLongDefinitionName() {
        return this.longDefinitionName;
    }

    public String getShortDefinitionName() {
        return this.shortDefinitionName;
    }

    public void setDatapointHandler(DatapointHandler handler) {
        this.handler = handler;
    }

    public DatapointHandler getDatapointHandler() {
        return this.handler;
    }

    private void dosetValues(Map<String, Object> values) throws DataPointException, AccessException {
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            DataPoint dp = this.getDataPointByShortName(entry.getKey());
            if (dp == null) continue;
            ((ValuedDataPoint)dp).setValue(entry.getValue());
        }
    }

    private Map<String, Object> dogetValues(List<String> names) throws DataPointException, AccessException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String name : names) {
            DataPoint dp = this.getDataPointByShortName(name);
            if (dp == null) continue;
            ret.put(name, ((ValuedDataPoint)dp).getValue());
        }
        return ret;
    }

    public static interface DatapointHandler {
        public void setValues(Map<String, Object> var1) throws DataPointException, AccessException;

        public Map<String, Object> getValues(List<String> var1) throws DataPointException, AccessException;
    }
}

