/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.mocked.devices;

import java.util.List;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.home.devices.Door;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.mocked.devices.Activator;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedDevice;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedBattery;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedDoorStatus;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedLock;
import org.osgi.framework.ServiceRegistration;

public class MockedDoor
extends Door
implements MockedDevice {
    private List<ServiceRegistration> serviceRegistrations;

    public MockedDoor(String id, String serial, Domain domain, boolean openOnly) {
        super(id, serial, domain);
        this.addModule(new MockedBattery("battery_" + id, domain));
        this.addModule(new MockedDoorStatus("doorStatus_" + id, domain));
        this.addModule(new MockedLock("lock_" + id, domain, openOnly));
        this.setLocation("Porte d'entree");
    }

    @Override
    public void registerDevice() {
        if (this.serviceRegistrations != null && !this.serviceRegistrations.isEmpty()) {
            return;
        }
        this.serviceRegistrations = Activator.register((GenericDevice)this);
    }

    @Override
    public void unregisterDevice() {
        if (this.serviceRegistrations == null) {
            return;
        }
        for (ServiceRegistration reg : this.serviceRegistrations) {
            reg.unregister();
        }
        this.serviceRegistrations.clear();
    }
}

