/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.mocked.devices;

import java.util.Arrays;
import java.util.List;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.ArrayDataPoint;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.devices.Camera;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.mocked.devices.Activator;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedDevice;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedStreaming;
import org.eclipse.om2m.sdt.home.modules.PersonSensor;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.osgi.framework.ServiceRegistration;

public class MockedCamera
extends Camera
implements MockedDevice {
    private List<ServiceRegistration> serviceRegistrations;

    public MockedCamera(String id, String serial, Domain domain) {
        super(id, serial, domain);
        this.addModule((Module)new MockedStreaming("streaming_" + id, domain));
        this.addModule((Module)new PersonSensor("personSensor_" + id, domain, (ArrayDataPoint)new ArrayDataPoint<String>((Identifiers)DatapointType.detectedPersons){

            public List<String> doGetValue() throws DataPointException {
                return Arrays.asList("admin", "Phil");
            }
        }));
    }

    @Override
    public void registerDevice() {
        if (this.serviceRegistrations != null && !this.serviceRegistrations.isEmpty()) {
            return;
        }
        this.serviceRegistrations = Activator.register((GenericDevice)this);
    }

    @Override
    public void unregisterDevice() {
        if (this.serviceRegistrations == null) {
            return;
        }
        for (ServiceRegistration reg : this.serviceRegistrations) {
            reg.unregister();
        }
        this.serviceRegistrations.clear();
    }
}

