/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class HotWaterSupply
extends Module {
    private BooleanDataPoint status;
    private BooleanDataPoint bath;

    public HotWaterSupply(String name, Domain domain, BooleanDataPoint status) {
        super(name, domain, (Identifiers)ModuleType.hotWaterSupply);
        if (status == null || !status.getShortDefinitionType().equals(DatapointType.status.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong status datapoint: " + status);
        }
        this.status = status;
        this.status.setWritable(false);
        this.status.setDoc("The status of watering operation");
        this.addDataPoint((DataPoint)this.status);
    }

    public HotWaterSupply(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (BooleanDataPoint)dps.get(DatapointType.status.getShortName()));
        BooleanDataPoint bath = (BooleanDataPoint)dps.get(DatapointType.bath.getShortName());
        if (bath != null) {
            this.setBath(bath);
        }
    }

    public boolean getStatus() throws DataPointException, AccessException {
        return (Boolean)this.status.getValue();
    }

    public void setBath(BooleanDataPoint dp) {
        this.bath = dp;
        this.bath.setDoc("The status of filling bath tub");
        this.bath.setOptional(true);
        this.addDataPoint((DataPoint)this.bath);
    }

    public boolean getBath() throws DataPointException, AccessException {
        if (this.bath == null) {
            throw new DataPointException("Not implemented");
        }
        return (Boolean)this.bath.getValue();
    }

    public void setBath(boolean v) throws DataPointException, AccessException {
        if (this.bath == null) {
            throw new DataPointException("Not implemented");
        }
        this.bath.setValue((Object)v);
    }
}

