/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hierarchical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.grid.command.ClientAreaResizeCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ColumnHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowPositionHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hierarchical.HierarchicalTraversalStrategy;
import org.eclipse.nebula.widgets.nattable.hierarchical.HierarchicalWrapper;
import org.eclipse.nebula.widgets.nattable.hierarchical.command.HierarchicalTreeCollapseAllCommandHandler;
import org.eclipse.nebula.widgets.nattable.hierarchical.command.HierarchicalTreeExpandAllCommandHandler;
import org.eclipse.nebula.widgets.nattable.hierarchical.command.HierarchicalTreeExpandCollapseCommandHandler;
import org.eclipse.nebula.widgets.nattable.hierarchical.command.HierarchicalTreeExpandToLevelCommandHandler;
import org.eclipse.nebula.widgets.nattable.hierarchical.config.DefaultHierarchicalTreeLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.hover.command.ClearHoverStylingCommand;
import org.eclipse.nebula.widgets.nattable.hover.command.HoverStylingCommand;
import org.eclipse.nebula.widgets.nattable.layer.IDpiConverter;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.SpanningLayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.TranslatedLayerCell;
import org.eclipse.nebula.widgets.nattable.layer.command.ConfigureScalingCommand;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.search.event.SearchEvent;
import org.eclipse.nebula.widgets.nattable.selection.ITraversalStrategy;
import org.eclipse.nebula.widgets.nattable.selection.MoveCellSelectionCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectCellCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectColumnCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectRegionCommand;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.tree.config.TreeConfigAttributes;
import org.eclipse.nebula.widgets.nattable.tree.painter.IndentedTreeImagePainter;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;
import org.eclipse.swt.graphics.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchicalTreeLayer
extends AbstractRowHideShowLayer {
    private static final Logger LOG = LoggerFactory.getLogger(HierarchicalTreeLayer.class);
    public static final String LEVEL_HEADER_CELL = "LEVEL_HEADER_CELL";
    public static final String COLLAPSED_CHILD = "COLLAPSED_CHILD";
    public static final String NO_OBJECT_IN_LEVEL = "NO_OBJECT_IN_LEVEL";
    private List<HierarchicalWrapper> underlyingList;
    private final String[] propertyNames;
    private final SelectionLayer selectionLayer;
    private int[] levelHeaderPositions;
    private Map<Integer, Integer> nodeColumnMapping = new LinkedHashMap<Integer, Integer>();
    private Map<Integer, List<Integer>> levelIndexMapping = new LinkedHashMap<Integer, List<Integer>>();
    protected final Set<HierarchicalTreeNode> collapsedNodes = new HashSet<HierarchicalTreeNode>();
    private MutableIntSet hiddenRowIndexes = IntSets.mutable.empty();
    private int leafLevelColumnIndex = 0;
    private int levelHeaderWidth = 20;
    private IDpiConverter dpiConverter;
    private boolean useTreeColumnIndex = false;
    private boolean showTreeLevelHeader = true;
    private boolean handleCollapsedChildren = true;
    private boolean handleNoObjectsInLevel = true;
    private boolean retainRemovedRowObjectNodes = true;
    private boolean expandOnSearch = true;
    private boolean selectSubLevels = false;

    public HierarchicalTreeLayer(IUniqueIndexLayer underlyingLayer, List<HierarchicalWrapper> underlyingList, String[] propertyNames) {
        this(underlyingLayer, underlyingList, propertyNames, null, true);
    }

    public HierarchicalTreeLayer(IUniqueIndexLayer underlyingLayer, List<HierarchicalWrapper> underlyingList, String[] propertyNames, boolean useDefaultConfiguration) {
        this(underlyingLayer, underlyingList, propertyNames, null, useDefaultConfiguration);
    }

    public HierarchicalTreeLayer(IUniqueIndexLayer underlyingLayer, List<HierarchicalWrapper> underlyingList, String[] propertyNames, SelectionLayer selectionLayer) {
        this(underlyingLayer, underlyingList, propertyNames, selectionLayer, true);
    }

    public HierarchicalTreeLayer(IUniqueIndexLayer underlyingLayer, List<HierarchicalWrapper> underlyingList, String[] propertyNames, SelectionLayer selectionLayer, boolean useDefaultConfiguration) {
        super(underlyingLayer);
        this.underlyingList = underlyingList;
        this.propertyNames = propertyNames;
        this.selectionLayer = selectionLayer;
        if (propertyNames.length > 0) {
            int currentLevel = 1;
            this.nodeColumnMapping.put(0, 0);
            ArrayList<Integer> columns = new ArrayList<Integer>();
            columns.add(0);
            this.levelIndexMapping.put(0, columns);
            int col = 1;
            while (col < propertyNames.length) {
                String[] split = propertyNames[col].split("\\.");
                if (split.length == currentLevel) {
                    columns.add(col);
                } else if (split.length > currentLevel) {
                    this.nodeColumnMapping.put(currentLevel, col);
                    columns = new ArrayList();
                    columns.add(col);
                    this.levelIndexMapping.put(currentLevel, columns);
                    ++currentLevel;
                    this.leafLevelColumnIndex = col;
                }
                ++col;
            }
            this.calculateLevelColumnHeaderPositions();
        }
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultHierarchicalTreeLayerConfiguration(this));
        }
        this.registerCommandHandler(new HierarchicalTreeExpandCollapseCommandHandler(this));
        this.registerCommandHandler(new HierarchicalTreeExpandAllCommandHandler(this));
        this.registerCommandHandler(new HierarchicalTreeCollapseAllCommandHandler(this));
        this.registerCommandHandler(new HierarchicalTreeExpandToLevelCommandHandler(this));
        if (this.selectionLayer != null) {
            this.registerCommandHandler(new MoveCellSelectionCommandHandler(this.selectionLayer, new HierarchicalTraversalStrategy(ITraversalStrategy.AXIS_TRAVERSAL_STRATEGY, this)));
        }
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command.convertToTargetLayer(this)) {
            if (command instanceof SelectCellCommand) {
                SelectCellCommand selection = (SelectCellCommand)command;
                if (this.isLevelHeaderColumn(selection.getColumnPosition())) {
                    ILayerCell clickedCell = this.getCellByPosition(selection.getColumnPosition(), selection.getRowPosition());
                    SelectRegionCommand selectRegion = new SelectRegionCommand(this, clickedCell.getColumnPosition() + 1, clickedCell.getOriginRowPosition(), this.getNumberOfColumnsToSelect(selection.getColumnPosition()), clickedCell.getRowSpan(), selection.isShiftMask(), selection.isControlMask());
                    return this.underlyingLayer.doCommand(selectRegion);
                }
            } else if (command instanceof SelectColumnCommand) {
                SelectColumnCommand selection = (SelectColumnCommand)command;
                if (this.isLevelHeaderColumn(selection.getColumnPosition())) {
                    int level = 0;
                    while (level < this.levelHeaderPositions.length) {
                        int pos = this.levelHeaderPositions[level];
                        if (pos == selection.getColumnPosition()) break;
                        ++level;
                    }
                    SelectRegionCommand selectRegion = new SelectRegionCommand(this, selection.getColumnPosition() + 1, 0, this.getNumberOfColumnsToSelect(selection.getColumnPosition()), Integer.MAX_VALUE, selection.isWithShiftMask(), selection.isWithControlMask());
                    return this.underlyingLayer.doCommand(selectRegion);
                }
            } else if (command instanceof ConfigureScalingCommand) {
                this.dpiConverter = ((ConfigureScalingCommand)command).getHorizontalDpiConverter();
            } else if (command instanceof ClientAreaResizeCommand && command.convertToTargetLayer(this)) {
                ClientAreaResizeCommand clientAreaResizeCommand = (ClientAreaResizeCommand)command;
                Rectangle possibleArea = clientAreaResizeCommand.getScrollable().getClientArea();
                possibleArea.width -= this.levelHeaderPositions.length * this.getScaledLevelHeaderWidth();
                clientAreaResizeCommand.setCalcArea(possibleArea);
            } else if (command instanceof ColumnReorderCommand) {
                ColumnReorderCommand crCommand = (ColumnReorderCommand)command;
                if (!this.isValidTargetColumnPosition(crCommand.getFromColumnPosition(), crCommand.getToColumnPosition())) {
                    return true;
                }
                if (this.isLevelHeaderColumn(crCommand.getToColumnPosition())) {
                    return super.doCommand(new ColumnReorderCommand(this, crCommand.getFromColumnPosition(), crCommand.getToColumnPosition() + 1));
                }
            } else if (command instanceof MultiColumnReorderCommand) {
                MultiColumnReorderCommand crCommand = (MultiColumnReorderCommand)command;
                for (int fromColumnPosition : crCommand.getFromColumnPositions()) {
                    if (this.isValidTargetColumnPosition(fromColumnPosition, crCommand.getToColumnPosition())) continue;
                    return true;
                }
                if (this.isLevelHeaderColumn(crCommand.getToColumnPosition())) {
                    return super.doCommand(new MultiColumnReorderCommand((ILayer)this, crCommand.getFromColumnPositionsArray(), crCommand.getToColumnPosition() + 1));
                }
            } else if (command instanceof ColumnHideCommand) {
                if (this.isLevelHeaderColumn(((ColumnHideCommand)command).getColumnPosition())) {
                    return true;
                }
            } else if (command instanceof MultiColumnHideCommand) {
                Collection<Integer> positions = ((MultiColumnHideCommand)command).getColumnPositions();
                boolean modified = false;
                Iterator<Integer> it = positions.iterator();
                while (it.hasNext()) {
                    Integer pos = it.next();
                    if (!this.isLevelHeaderColumn(pos)) continue;
                    modified = true;
                    it.remove();
                }
                if (modified && !positions.isEmpty()) {
                    int[] newPositions = new int[positions.size()];
                    int i = 0;
                    Iterator<Integer> iterator = positions.iterator();
                    while (iterator.hasNext()) {
                        int p;
                        newPositions[i] = p = iterator.next().intValue();
                        ++i;
                    }
                    return this.doCommand(new MultiColumnHideCommand((ILayer)this, newPositions));
                }
            } else {
                if (command instanceof RowPositionHideCommand) {
                    RowPositionHideCommand cmd = (RowPositionHideCommand)command;
                    if (this.isLevelHeaderColumn(cmd.getColumnPosition())) {
                        return super.doCommand(new RowPositionHideCommand(this, cmd.getColumnPosition() + 1, cmd.getRowPosition()));
                    }
                    return this.doCommand(new RowHideCommand(this, cmd.getRowPosition()));
                }
                if (command instanceof HoverStylingCommand && this.isLevelHeaderColumn(((HoverStylingCommand)command).getColumnPosition())) {
                    return super.doCommand(new ClearHoverStylingCommand());
                }
            }
        }
        return super.doCommand(command);
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        PositionCoordinate coord;
        if (event instanceof IStructuralChangeEvent) {
            IStructuralChangeEvent structuralChangeEvent = (IStructuralChangeEvent)event;
            if (structuralChangeEvent.isVerticalStructureChanged()) {
                int negativeIndex = -1;
                HashSet<HierarchicalTreeNode> updatedCollapsedNodes = new HashSet<HierarchicalTreeNode>();
                for (HierarchicalTreeNode node2 : this.collapsedNodes) {
                    int newRowIndex = this.findTopRowIndex(node2.columnIndex, node2.rowObject);
                    if (newRowIndex >= 0) {
                        updatedCollapsedNodes.add(new HierarchicalTreeNode(node2.columnIndex, newRowIndex, this.underlyingList.get(newRowIndex)));
                        continue;
                    }
                    if (!this.retainRemovedRowObjectNodes) continue;
                    updatedCollapsedNodes.add(new HierarchicalTreeNode(node2.columnIndex, negativeIndex, node2.rowObject));
                    --negativeIndex;
                }
                this.collapsedNodes.clear();
                this.collapsedNodes.addAll(updatedCollapsedNodes);
                int[] updatedHiddenRows = this.collapsedNodes.stream().map(node -> this.getChildIndexes(node.columnIndex, node.rowIndex)).flatMapToInt(Arrays::stream).toArray();
                this.hiddenRowIndexes = IntSets.mutable.of(updatedHiddenRows);
            } else if (structuralChangeEvent.isHorizontalStructureChanged()) {
                this.calculateLevelColumnHeaderPositions();
            }
        } else if (event instanceof SearchEvent && (coord = ((SearchEvent)event).getCellCoordinate()) != null) {
            int foundIndex = coord.getLayer().getRowIndexByPosition(coord.rowPosition);
            if (this.hiddenRowIndexes.contains(foundIndex)) {
                if (this.expandOnSearch) {
                    int level = this.nodeColumnMapping.size() - 2;
                    while (level >= 0) {
                        int rowIdx;
                        ILayerCell nodeCell = coord.getLayer().getCellByPosition(this.nodeColumnMapping.get(level), coord.rowPosition);
                        int colIdx = coord.getLayer().getColumnIndexByPosition(nodeCell.getOriginColumnPosition());
                        if (this.collapsedNodes.contains(new HierarchicalTreeNode(colIdx, rowIdx = coord.getLayer().getRowIndexByPosition(nodeCell.getOriginRowPosition()), null))) {
                            this.expandOrCollapse(colIdx, rowIdx);
                        }
                        --level;
                    }
                } else {
                    this.hiddenRowIndexes.remove(foundIndex);
                }
            } else {
                int lvl = this.getLevelByColumnIndex(coord.getLayer().getColumnIndexByPosition(coord.columnPosition));
                int level = 0;
                while (level <= lvl) {
                    int rowIdx;
                    ILayerCell nodeCell = coord.getLayer().getCellByPosition(this.nodeColumnMapping.get(level), coord.rowPosition);
                    int colIdx = coord.getLayer().getColumnIndexByPosition(nodeCell.getOriginColumnPosition());
                    if (this.collapsedNodes.contains(new HierarchicalTreeNode(colIdx, rowIdx = coord.getLayer().getRowIndexByPosition(nodeCell.getOriginRowPosition()), null))) {
                        this.expandOrCollapse(colIdx, rowIdx);
                    }
                    ++level;
                }
            }
            this.invalidateCache();
            this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, new int[]{foundIndex}));
        }
        super.handleLayerEvent(event);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        if (this.isLevelHeaderColumn(columnPosition)) {
            LabelStack labelStack = new LabelStack(LEVEL_HEADER_CELL);
            if (columnPosition + 1 == this.getColumnCount() || this.getStartXOfColumnPosition(columnPosition + 1) == this.getWidth()) {
                labelStack.addLabel("COLUMN_RIGHT_HIDDEN");
            }
            return labelStack;
        }
        LabelStack configLabels = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        if (this.isTreeColumn(columnPosition)) {
            configLabels.addLabelOnTop("TREE_COLUMN_CELL");
            ILayerCell cell = this.getCellByPosition(columnPosition, rowPosition);
            if (cell != null) {
                configLabels.addLabelOnTop("TREE_DEPTH_0");
                if (cell.getRowSpan() > 1) {
                    configLabels.addLabelOnTop("TREE_EXPANDED");
                } else if (this.isCollapsed(columnPosition, rowPosition)) {
                    configLabels.addLabelOnTop("TREE_COLLAPSED");
                } else {
                    configLabels.addLabelOnTop("TREE_LEAF");
                }
            }
        }
        if (this.handleCollapsedChildren) {
            boolean directLevelHeader = true;
            boolean headerCollapsed = false;
            int i = this.levelHeaderPositions.length - 1;
            while (i >= 0) {
                int pos = this.levelHeaderPositions[i];
                if (pos < columnPosition) {
                    int firstLevelColumnPosition = pos + (this.isShowTreeLevelHeader() ? 1 : 0);
                    if (directLevelHeader) {
                        directLevelHeader = false;
                    } else if (this.isCollapsed(firstLevelColumnPosition, rowPosition)) {
                        headerCollapsed = true;
                    }
                }
                --i;
            }
            if (headerCollapsed) {
                configLabels.addLabelOnTop(COLLAPSED_CHILD);
                configLabels.removeLabel("TREE_COLUMN_CELL");
                configLabels.removeLabel("TREE_DEPTH_0");
                configLabels.removeLabel("TREE_EXPANDED");
                configLabels.removeLabel("TREE_COLLAPSED");
                configLabels.removeLabel("TREE_LEAF");
            }
        }
        if (this.handleNoObjectsInLevel && !this.hasLevelObject(columnPosition, rowPosition)) {
            configLabels.addLabelOnTop(NO_OBJECT_IN_LEVEL);
        }
        return configLabels;
    }

    @Override
    public ICellPainter getCellPainter(int columnPosition, int rowPosition, ILayerCell cell, IConfigRegistry configRegistry) {
        ICellPainter cellPainter = super.getCellPainter(columnPosition, rowPosition, cell, configRegistry);
        if (cell.getConfigLabels().hasLabel("TREE_COLUMN_CELL") && !cell.getConfigLabels().hasLabel(NO_OBJECT_IN_LEVEL)) {
            ICellPainter treeCellPainter = configRegistry.getConfigAttribute(TreeConfigAttributes.TREE_STRUCTURE_PAINTER, cell.getDisplayMode(), (List<String>)cell.getConfigLabels());
            if (treeCellPainter != null) {
                IndentedTreeImagePainter treePainter = this.findIndentedTreeImagePainter(treeCellPainter);
                if (treePainter != null) {
                    treePainter.setBaseCellPainter(cellPainter);
                    cellPainter = treeCellPainter;
                } else {
                    LOG.warn("There is no IndentedTreeImagePainter found for TREE_STRUCTURE_PAINTER");
                }
            } else {
                LOG.warn("There is no IndentedTreeImagePainter found for TREE_STRUCTURE_PAINTER");
            }
        }
        return cellPainter;
    }

    private IndentedTreeImagePainter findIndentedTreeImagePainter(ICellPainter painter) {
        IndentedTreeImagePainter result = null;
        if (painter instanceof IndentedTreeImagePainter) {
            result = (IndentedTreeImagePainter)painter;
        } else if (painter instanceof CellPainterWrapper && ((CellPainterWrapper)painter).getWrappedPainter() != null) {
            result = this.findIndentedTreeImagePainter(((CellPainterWrapper)painter).getWrappedPainter());
        } else if (painter instanceof CellPainterDecorator && (result = this.findIndentedTreeImagePainter(((CellPainterDecorator)painter).getBaseCellPainter())) == null) {
            result = this.findIndentedTreeImagePainter(((CellPainterDecorator)painter).getDecoratorCellPainter());
        }
        return result;
    }

    @Override
    public ILayerCell getCellByPosition(int columnPosition, int rowPosition) {
        int underlyingRowPosition;
        if (this.isLevelHeaderColumn(columnPosition)) {
            ILayerCell right = this.getCellByPosition(columnPosition + 1, rowPosition);
            if (right != null) {
                return new LayerCell(this, columnPosition, right.getOriginRowPosition(), columnPosition, rowPosition, 1, right.getRowSpan());
            }
            return null;
        }
        int underlyingColumnPosition = this.localToUnderlyingColumnPosition(columnPosition);
        ILayerCell cell = this.underlyingLayer.getCellByPosition(underlyingColumnPosition, underlyingRowPosition = this.localToUnderlyingRowPosition(rowPosition));
        if (cell != null) {
            TranslatedLayerCell localCell = new TranslatedLayerCell(cell, this, this.underlyingToLocalColumnPosition(this.underlyingLayer, cell.getOriginColumnPosition()), this.underlyingToLocalRowPosition(this.underlyingLayer, cell.getOriginRowPosition()), this.underlyingToLocalColumnPosition(this.underlyingLayer, cell.getColumnPosition()), this.underlyingToLocalRowPosition(this.underlyingLayer, cell.getRowPosition()));
            if (cell.isSpannedCell()) {
                boolean rowSpanUpdated = false;
                int rowSpan = cell.getRowSpan();
                int rowIndex = this.underlyingLayer.getRowIndexByPosition(cell.getOriginRowPosition());
                int row = 0;
                while (row < cell.getRowSpan()) {
                    if (this.isRowIndexHidden(rowIndex) && !this.isHiddenInUnderlyingLayer(rowIndex)) {
                        --rowSpan;
                        rowSpanUpdated = true;
                    }
                    ++rowIndex;
                    ++row;
                }
                cell = rowSpanUpdated ? new SpanningLayerCell(localCell, localCell.getColumnSpan(), rowSpan) : localCell;
            } else {
                cell = localCell;
            }
        }
        return cell;
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        if (this.isLevelHeaderColumn(columnPosition)) {
            return null;
        }
        return super.getDataValueByPosition(columnPosition, rowPosition);
    }

    @Override
    public DisplayMode getDisplayModeByPosition(int columnPosition, int rowPosition) {
        if (this.isLevelHeaderColumn(columnPosition)) {
            if (this.isRowPositionInLevelSelected(columnPosition, rowPosition)) {
                return DisplayMode.SELECT;
            }
            return DisplayMode.NORMAL;
        }
        return super.getDisplayModeByPosition(columnPosition, rowPosition);
    }

    protected boolean isRowPositionInLevelSelected(int levelHeaderColumnPosition, int rowPosition) {
        ILayerCell headerCell;
        int selectionLayerRowPosition;
        if (this.selectionLayer != null && this.selectionLayer.isRowPositionSelected(selectionLayerRowPosition = LayerUtil.convertRowPosition(this, (headerCell = this.getCellByPosition(levelHeaderColumnPosition, rowPosition)).getOriginRowPosition(), this.selectionLayer))) {
            int level = 0;
            int i = 0;
            while (i < this.levelHeaderPositions.length) {
                int levelHeaderPos = this.levelHeaderPositions[i];
                if (levelHeaderPos == levelHeaderColumnPosition) {
                    level = i;
                    break;
                }
                ++i;
            }
            List<Integer> levelColumns = this.getColumnIndexesForLevel(level);
            for (int columnIndex : levelColumns) {
                int column = this.selectionLayer.getColumnPositionByIndex(columnIndex);
                if (column < 0 || !this.selectionLayer.isCellPositionSelected(column, selectionLayerRowPosition)) continue;
                return true;
            }
        }
        return false;
    }

    protected int getNumberOfColumnsToSelect(int levelHeaderPosition) {
        int columnsToSelect = 0;
        if (this.isSelectSubLevels()) {
            int levelHeaderCount = 0;
            int i = this.levelHeaderPositions.length - 1;
            while (i >= 0) {
                if (this.levelHeaderPositions[i] >= levelHeaderPosition) {
                    ++levelHeaderCount;
                }
                --i;
            }
            columnsToSelect = this.getColumnCount() - levelHeaderCount - levelHeaderPosition;
        } else {
            int i = 0;
            while (i < this.levelHeaderPositions.length) {
                int pos = this.levelHeaderPositions[i];
                if (pos == levelHeaderPosition) {
                    columnsToSelect = this.getLevelIndexMapping().get(i).size();
                }
                ++i;
            }
        }
        return columnsToSelect;
    }

    protected boolean isTreeColumn(int columnPosition) {
        int col = this.localToUnderlyingColumnPosition(columnPosition);
        if (this.isUseTreeColumnIndex()) {
            col = this.getColumnIndexByPosition(columnPosition);
        }
        return this.nodeColumnMapping.containsValue(col) && this.leafLevelColumnIndex != col;
    }

    public boolean isLevelHeaderColumn(int columnPosition) {
        int[] nArray = this.levelHeaderPositions;
        int n = this.levelHeaderPositions.length;
        int n2 = 0;
        while (n2 < n) {
            int pos = nArray[n2];
            if (pos == columnPosition) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean hasLevelObject(int columnPosition, int rowPosition) {
        int rowIndex;
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        int level = -1;
        if (columnIndex >= 0) {
            level = this.getLevelByColumnIndex(columnIndex);
        } else {
            int[] positions = this.levelHeaderPositions;
            int i = 0;
            while (i < positions.length) {
                int pos = positions[i];
                if (pos == columnPosition) {
                    level = i;
                }
                ++i;
            }
        }
        if (level >= 0 && (rowIndex = this.getRowIndexByPosition(rowPosition)) >= 0 && rowIndex < this.underlyingList.size()) {
            HierarchicalWrapper rowObject = this.underlyingList.get(rowIndex);
            return rowObject.getObject(level) != null;
        }
        return false;
    }

    public int getLevelByColumnIndex(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.propertyNames.length) {
            String propertyName = this.propertyNames[columnIndex];
            String[] split = propertyName.split("\\.");
            return split.length - 1;
        }
        return -1;
    }

    public List<Integer> getColumnIndexesForLevel(int level) {
        return this.levelIndexMapping.get(level);
    }

    public Map<Integer, List<Integer>> getLevelIndexMapping() {
        return this.levelIndexMapping;
    }

    @Override
    public boolean isRowIndexHidden(int rowIndex) {
        return this.hiddenRowIndexes.contains(rowIndex) || this.isHiddenInUnderlyingLayer(rowIndex);
    }

    @Override
    public Collection<Integer> getHiddenRowIndexes() {
        return ArrayUtil.asIntegerList(this.hiddenRowIndexes.toSortedArray());
    }

    @Override
    public int[] getHiddenRowIndexesArray() {
        return this.hiddenRowIndexes.toSortedArray();
    }

    @Override
    public boolean hasHiddenRows() {
        return !this.hiddenRowIndexes.isEmpty();
    }

    private boolean isHiddenInUnderlyingLayer(int rowIndex) {
        IUniqueIndexLayer underlyingLayer = this.getUnderlyingLayer();
        return underlyingLayer.getRowPositionByIndex(rowIndex) == -1;
    }

    public void expandOrCollapse(int columnIndex, int rowIndex) {
        this.expandOrCollapse(columnIndex, rowIndex, -1);
    }

    public void expandOrCollapse(int columnIndex, int rowIndex, int toLevel) {
        MutableIntList toProcess = IntLists.mutable.of(this.getChildIndexes(columnIndex, rowIndex)).sortThis();
        if (toProcess.isEmpty()) {
            return;
        }
        HierarchicalTreeNode coord = new HierarchicalTreeNode(columnIndex, rowIndex, null);
        if (this.collapsedNodes.contains(coord)) {
            this.collapsedNodes.remove(coord);
            Range children = new Range(rowIndex, toProcess.get(toProcess.size() - 1));
            int toLevelColumnIndex = toLevel >= 0 ? this.nodeColumnMapping.get(toLevel) : -1;
            Iterator<HierarchicalTreeNode> it = this.collapsedNodes.iterator();
            while (it.hasNext()) {
                HierarchicalTreeNode p = it.next();
                if (!children.contains(p.rowIndex)) continue;
                if (p.columnIndex > toLevelColumnIndex) {
                    toProcess.removeAll(this.getChildIndexes(p.columnIndex, p.rowIndex));
                    continue;
                }
                it.remove();
            }
            this.hiddenRowIndexes.removeAll((IntIterable)toProcess);
            this.invalidateCache();
            this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, toProcess.primitiveStream().map(this::getRowPositionByIndex).filter(r -> r >= 0).sorted().toArray()));
        } else {
            int[] rowPositions = toProcess.primitiveStream().map(this::getRowPositionByIndex).filter(rowPos -> rowPos >= 0).sorted().toArray();
            int[] hiddenIndexes = Arrays.stream(rowPositions).map(this::getRowIndexByPosition).sorted().toArray();
            coord.rowObject = this.underlyingList.get(coord.rowIndex);
            this.collapsedNodes.add(coord);
            this.hiddenRowIndexes.addAll((IntIterable)toProcess);
            this.invalidateCache();
            this.fireLayerEvent(new HideRowPositionsEvent((ILayer)this, rowPositions, hiddenIndexes));
        }
    }

    public void collapseAll() {
        MutableIntList rowsToHide = IntLists.mutable.empty();
        int[] nodeColumns = this.nodeColumnMapping.values().stream().sorted().mapToInt(Integer::intValue).toArray();
        int columnIndex = nodeColumns[0];
        int columnPosition = this.getColumnPositionByIndex(columnIndex);
        ILayerCell cell = null;
        int row = 0;
        while (row < this.getRowCount()) {
            cell = this.getCellByPosition(columnPosition, row);
            if (cell.getRowSpan() > 1) {
                int rowIndex = this.getRowIndexByPosition(row);
                this.collapsedNodes.add(new HierarchicalTreeNode(columnIndex, rowIndex, this.underlyingList.get(rowIndex)));
                rowsToHide.addAll(this.getChildIndexes(columnIndex, rowIndex));
                row += cell.getRowSpan() - 1;
            }
            ++row;
        }
        int col = 1;
        while (col < nodeColumns.length - 1) {
            columnIndex = nodeColumns[col];
            columnPosition = this.getColumnPositionByIndex(columnIndex);
            int row2 = 0;
            while (row2 < this.getRowCount()) {
                cell = this.getCellByPosition(columnPosition, row2);
                if (cell.getRowSpan() > 1) {
                    int rowIndex = this.getRowIndexByPosition(row2);
                    this.collapsedNodes.add(new HierarchicalTreeNode(columnIndex, rowIndex, this.underlyingList.get(rowIndex)));
                    row2 += cell.getRowSpan() - 1;
                }
                ++row2;
            }
            ++col;
        }
        int[] rowPositions = rowsToHide.primitiveStream().map(this::getRowPositionByIndex).filter(rowPos -> rowPos >= 0).sorted().toArray();
        int[] hiddenIndexes = Arrays.stream(rowPositions).map(this::getRowIndexByPosition).sorted().toArray();
        this.hiddenRowIndexes.addAll((IntIterable)rowsToHide);
        this.invalidateCache();
        this.fireLayerEvent(new HideRowPositionsEvent((ILayer)this, rowPositions, hiddenIndexes));
    }

    public void expandAll() {
        MutableIntList rowsToShow = IntLists.mutable.ofAll((IntIterable)this.hiddenRowIndexes);
        this.hiddenRowIndexes = IntSets.mutable.empty();
        this.collapsedNodes.clear();
        this.invalidateCache();
        this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, rowsToShow.primitiveStream().map(this::getRowPositionByIndex).filter(r -> r >= 0).sorted().toArray()));
    }

    public void expandAllToLevel(int toLevel) {
        int toLevelColumnIndex = toLevel >= 0 ? this.nodeColumnMapping.get(toLevel) : 0;
        Iterator<HierarchicalTreeNode> it = this.collapsedNodes.iterator();
        while (it.hasNext()) {
            HierarchicalTreeNode coord = it.next();
            if (coord.columnIndex > toLevelColumnIndex) continue;
            it.remove();
        }
        int[] remain = this.collapsedNodes.stream().map(node -> this.getChildIndexes(node.columnIndex, node.rowIndex)).flatMapToInt(Arrays::stream).toArray();
        MutableIntSet toProcess = IntSets.mutable.ofAll((IntIterable)this.hiddenRowIndexes);
        toProcess.removeAll(remain);
        this.hiddenRowIndexes = IntSets.mutable.of(remain);
        this.invalidateCache();
        this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, toProcess.toSortedArray()));
    }

    protected int[] getChildIndexes(int columnIndex, int rowIndex) {
        if (rowIndex >= 0) {
            HierarchicalWrapper rowObject = this.underlyingList.get(rowIndex);
            int level = this.getLevelByColumnIndex(columnIndex);
            Object levelObject = rowObject.getObject(level);
            MutableIntList children = IntLists.mutable.empty();
            int i = rowIndex + 1;
            while (i < this.underlyingList.size()) {
                HierarchicalWrapper child = this.underlyingList.get(i);
                if (levelObject != child.getObject(level)) break;
                children.add(i);
                ++i;
            }
            return children.toArray();
        }
        return new int[0];
    }

    public int findTopRowIndex(int columnIndex, HierarchicalWrapper rowObject) {
        int rowIndex = this.underlyingList.indexOf(rowObject);
        int level = this.getLevelByColumnIndex(columnIndex);
        Object levelObject = rowObject.getObject(level);
        int topRowIndex = rowIndex - 1;
        while (topRowIndex >= 0) {
            HierarchicalWrapper child = this.underlyingList.get(topRowIndex);
            if (levelObject != child.getObject(level)) break;
            --topRowIndex;
        }
        return topRowIndex + 1;
    }

    public boolean isCollapsed(int columnPosition, int rowPosition) {
        return this.collapsedNodes.contains(new HierarchicalTreeNode(this.getColumnIndexByPosition(columnPosition), this.getRowIndexByPosition(rowPosition), null));
    }

    public Set<HierarchicalTreeNode> getCollapsedNodes() {
        return this.collapsedNodes;
    }

    public boolean isUseTreeColumnIndex() {
        return this.useTreeColumnIndex;
    }

    public void setUseTreeColumnIndex(boolean useTreeColumnIndex) {
        this.useTreeColumnIndex = useTreeColumnIndex;
    }

    public boolean isShowTreeLevelHeader() {
        return this.showTreeLevelHeader;
    }

    public void setShowTreeLevelHeader(boolean show) {
        this.showTreeLevelHeader = show;
        this.calculateLevelColumnHeaderPositions();
    }

    public boolean isHandleCollapsedChildren() {
        return this.handleCollapsedChildren;
    }

    public void setHandleCollapsedChildren(boolean handleCollapsedChildren) {
        this.handleCollapsedChildren = handleCollapsedChildren;
    }

    public boolean isHandleNoObjectsInLevel() {
        return this.handleNoObjectsInLevel;
    }

    public void setHandleNoObjectsInLevel(boolean handleNoObjectsInLevel) {
        this.handleNoObjectsInLevel = handleNoObjectsInLevel;
    }

    public boolean isRetainRemovedRowObjectNodes() {
        return this.retainRemovedRowObjectNodes;
    }

    public void setRetainRemovedRowObjectNodes(boolean retainRemovedRowObjectNodes) {
        this.retainRemovedRowObjectNodes = retainRemovedRowObjectNodes;
    }

    public void cleanupRetainedCollapsedNodes() {
        Iterator<HierarchicalTreeNode> it = this.collapsedNodes.iterator();
        while (it.hasNext()) {
            HierarchicalTreeNode node = it.next();
            if (node.rowIndex >= 0) continue;
            it.remove();
        }
    }

    public void cleanupRetainedCollapsedNodes(HierarchicalWrapper rowObject) {
        Iterator<HierarchicalTreeNode> it = this.collapsedNodes.iterator();
        while (it.hasNext()) {
            HierarchicalTreeNode node = it.next();
            if (node.rowObject != rowObject) continue;
            it.remove();
            break;
        }
    }

    public boolean isExpandOnSearch() {
        return this.expandOnSearch;
    }

    public void setExpandOnSearch(boolean expandOnSearch) {
        this.expandOnSearch = expandOnSearch;
    }

    public boolean isSelectSubLevels() {
        return this.selectSubLevels;
    }

    public void setSelectSubLevels(boolean selectSubLevels) {
        this.selectSubLevels = selectSubLevels;
    }

    private void calculateLevelColumnHeaderPositions() {
        if (this.isShowTreeLevelHeader()) {
            this.levelHeaderPositions = new int[this.nodeColumnMapping.size()];
            int pos = 0;
            for (Map.Entry<Integer, Integer> entry : this.nodeColumnMapping.entrySet()) {
                int hiddenColumns = 0;
                int i = entry.getValue() - 1;
                while (i >= 0) {
                    if (this.getUnderlyingLayer().getColumnPositionByIndex(i) < 0) {
                        ++hiddenColumns;
                    }
                    --i;
                }
                this.levelHeaderPositions[pos++] = entry.getValue() + entry.getKey() - hiddenColumns;
            }
        } else {
            this.levelHeaderPositions = new int[0];
        }
    }

    @Override
    protected IUniqueIndexLayer getUnderlyingLayer() {
        return (IUniqueIndexLayer)this.underlyingLayer;
    }

    @Override
    public int getColumnCount() {
        return super.getColumnCount() + this.levelHeaderPositions.length;
    }

    @Override
    public int getColumnIndexByPosition(int columnPosition) {
        if (columnPosition < 0 || columnPosition >= this.getColumnCount()) {
            return -1;
        }
        if (this.isLevelHeaderColumn(columnPosition)) {
            int level = 0;
            int[] nArray = this.levelHeaderPositions;
            int n = this.levelHeaderPositions.length;
            int n2 = 0;
            while (n2 < n) {
                int pos = nArray[n2];
                ++level;
                if (pos == columnPosition) break;
                ++n2;
            }
            return level * -13;
        }
        return super.getColumnIndexByPosition(columnPosition);
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        if (columnIndex < 0 && columnIndex % -13 == 0) {
            return this.levelHeaderPositions[columnIndex / -13 - 1];
        }
        int columnPosition = super.getColumnPositionByIndex(columnIndex);
        if (this.isShowTreeLevelHeader()) {
            int[] nArray = this.levelHeaderPositions;
            int n = this.levelHeaderPositions.length;
            int n2 = 0;
            while (n2 < n) {
                int pos = nArray[n2];
                if (columnPosition < pos) break;
                ++columnPosition;
                ++n2;
            }
        }
        return columnPosition;
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        if (this.isShowTreeLevelHeader()) {
            int i = 0;
            while (i < this.levelHeaderPositions.length) {
                if (localColumnPosition < this.levelHeaderPositions[i]) break;
                ++i;
            }
            return super.localToUnderlyingColumnPosition(localColumnPosition - i);
        }
        return super.localToUnderlyingColumnPosition(localColumnPosition);
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        if (this.isShowTreeLevelHeader()) {
            int pos = sourceUnderlyingLayer.getColumnIndexByPosition(underlyingColumnPosition);
            return this.getColumnPositionByIndex(pos);
        }
        return super.underlyingToLocalColumnPosition(sourceUnderlyingLayer, underlyingColumnPosition);
    }

    @Override
    public Collection<Range> underlyingToLocalColumnPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingColumnPositionRanges) {
        if (this.isShowTreeLevelHeader()) {
            ArrayList<Range> localColumnPositionRanges = new ArrayList<Range>();
            for (Range underlyingColumnPositionRange : underlyingColumnPositionRanges) {
                int start = this.underlyingToLocalColumnPosition(sourceUnderlyingLayer, underlyingColumnPositionRange.start);
                int end = this.underlyingToLocalColumnPosition(sourceUnderlyingLayer, underlyingColumnPositionRange.end - 1);
                ++end;
                int[] nArray = this.levelHeaderPositions;
                int n = this.levelHeaderPositions.length;
                int n2 = 0;
                while (n2 < n) {
                    int pos = nArray[n2];
                    if (pos == end - 1) {
                        --end;
                    }
                    ++n2;
                }
                localColumnPositionRanges.add(new Range(start, end));
            }
            return localColumnPositionRanges;
        }
        return super.underlyingToLocalColumnPositions(sourceUnderlyingLayer, underlyingColumnPositionRanges);
    }

    public boolean isValidTargetColumnPosition(int fromColumnPosition, int toColumnPosition) {
        int fromIndex = this.getColumnIndexByPosition(fromColumnPosition);
        int toIndex = this.getColumnIndexByPosition(toColumnPosition);
        if (fromIndex < 0) {
            return false;
        }
        if (toIndex < 0 && fromColumnPosition < toColumnPosition) {
            toIndex = this.getColumnIndexByPosition(toColumnPosition - 1);
        } else if (toIndex < 0 && fromColumnPosition > toColumnPosition) {
            return false;
        }
        int fromLevel = this.getLevelByColumnIndex(fromIndex);
        int toLevel = this.getLevelByColumnIndex(toIndex);
        if (fromLevel != toLevel && this.isShowTreeLevelHeader()) {
            return false;
        }
        return fromLevel == toLevel || this.isShowTreeLevelHeader() || fromLevel == (toLevel = this.getLevelByColumnIndex(toIndex - 1));
    }

    public int getLevelHeaderWidth() {
        return this.levelHeaderWidth;
    }

    public void setLevelHeaderWidth(int width) {
        this.levelHeaderWidth = width;
    }

    protected int getScaledLevelHeaderWidth() {
        if (this.dpiConverter != null) {
            return this.dpiConverter.convertPixelToDpi(this.levelHeaderWidth);
        }
        return this.levelHeaderWidth;
    }

    @Override
    public int getWidth() {
        return super.getWidth() + this.levelHeaderPositions.length * this.getScaledLevelHeaderWidth();
    }

    @Override
    public int getPreferredWidth() {
        return super.getPreferredWidth() + this.levelHeaderPositions.length * this.getScaledLevelHeaderWidth();
    }

    @Override
    public int getColumnWidthByPosition(int columnPosition) {
        if (this.isShowTreeLevelHeader() && this.isLevelHeaderColumn(columnPosition)) {
            return this.getScaledLevelHeaderWidth();
        }
        return super.getColumnWidthByPosition(columnPosition);
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        if (this.isShowTreeLevelHeader()) {
            if (this.isLevelHeaderColumn(columnPosition)) {
                if (columnPosition + 1 < this.getColumnCount()) {
                    int start = this.getStartXOfColumnPosition(columnPosition + 1);
                    return start - this.getScaledLevelHeaderWidth();
                }
                int start = this.getStartXOfColumnPosition(columnPosition - 1);
                return start + this.getColumnWidthByPosition(columnPosition - 1);
            }
            int start = super.getStartXOfColumnPosition(columnPosition);
            int[] nArray = this.levelHeaderPositions;
            int n = this.levelHeaderPositions.length;
            int n2 = 0;
            while (n2 < n) {
                int pos = nArray[n2];
                if (columnPosition < pos) break;
                start += this.getScaledLevelHeaderWidth();
                ++n2;
            }
            return start;
        }
        return super.getStartXOfColumnPosition(columnPosition);
    }

    @Override
    public int getColumnPositionByX(int x) {
        return LayerUtil.getColumnPositionByX(this, x);
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> result = super.getProvidedLabels();
        result.add("TREE_COLUMN_CELL");
        result.add("TREE_LEAF");
        result.add("TREE_COLLAPSED");
        result.add("TREE_EXPANDED");
        result.add("TREE_DEPTH_0");
        result.add(LEVEL_HEADER_CELL);
        result.add(COLLAPSED_CHILD);
        result.add(NO_OBJECT_IN_LEVEL);
        return result;
    }

    public static class HierarchicalTreeNode {
        public final int columnIndex;
        public final int rowIndex;
        public HierarchicalWrapper rowObject;

        public HierarchicalTreeNode(int columnIndex, int rowIndex, HierarchicalWrapper rowObject) {
            this.columnIndex = columnIndex;
            this.rowIndex = rowIndex;
            this.rowObject = rowObject;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.columnIndex;
            result = 31 * result + this.rowIndex;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HierarchicalTreeNode other = (HierarchicalTreeNode)obj;
            if (this.columnIndex != other.columnIndex) {
                return false;
            }
            return this.rowIndex == other.rowIndex;
        }

        public String toString() {
            return "HierarchicalTreeNode [columnIndex=" + this.columnIndex + ", rowIndex=" + this.rowIndex + "]";
        }
    }
}

