/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.command;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.command.CreateColumnGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.DisplayColumnGroupRenameDialogCommand;
import org.eclipse.nebula.widgets.nattable.group.command.IColumnGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.RemoveColumnGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.UngroupColumnCommand;
import org.eclipse.nebula.widgets.nattable.group.event.GroupColumnsEvent;
import org.eclipse.nebula.widgets.nattable.group.event.UngroupColumnsEvent;
import org.eclipse.nebula.widgets.nattable.group.performance.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.command.ColumnGroupExpandCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.event.VisualRefreshEvent;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.rename.HeaderRenameDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

public class ColumnGroupsCommandHandler
extends AbstractLayerCommandHandler<IColumnGroupCommand> {
    private final ColumnGroupHeaderLayer contextLayer;
    private final SelectionLayer selectionLayer;
    private boolean clearSelection = true;

    public ColumnGroupsCommandHandler(ColumnGroupHeaderLayer contextLayer, SelectionLayer selectionLayer) {
        this(contextLayer, selectionLayer, true);
    }

    public ColumnGroupsCommandHandler(ColumnGroupHeaderLayer contextLayer, SelectionLayer selectionLayer, boolean clearSelection) {
        this.contextLayer = contextLayer;
        this.selectionLayer = selectionLayer;
        this.clearSelection = clearSelection;
    }

    @Override
    public boolean doCommand(IColumnGroupCommand command) {
        if (command instanceof CreateColumnGroupCommand) {
            CreateColumnGroupCommand createCommand = (CreateColumnGroupCommand)command;
            if (!this.handleCreateColumnGroupCommand(createCommand.getColumnGroupName())) {
                MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 33);
                messageBox.setText(Messages.getString("ErrorDialog.title"));
                messageBox.setMessage(Messages.getString("ColumnGroups.selectNonGroupedColumns"));
                messageBox.open();
            }
            return true;
        }
        if (command instanceof RemoveColumnGroupCommand) {
            RemoveColumnGroupCommand removeColumnGroupCommand = (RemoveColumnGroupCommand)command;
            int columnIndex = removeColumnGroupCommand.getColumnIndex();
            this.handleRemoveColumnGroupCommand(columnIndex);
            return true;
        }
        if (command instanceof UngroupColumnCommand) {
            this.handleUngroupCommand();
            return true;
        }
        if (command instanceof DisplayColumnGroupRenameDialogCommand) {
            return this.displayColumnGroupRenameDialog((DisplayColumnGroupRenameDialogCommand)command);
        }
        return false;
    }

    protected boolean handleCreateColumnGroupCommand(String columnGroupName) {
        GroupModel model = this.contextLayer.getGroupModel();
        MutableIntList positionsToGroup = this.getPositionsToProcess();
        if (!positionsToGroup.isEmpty()) {
            HashSet<GroupModel.Group> existingGroups = new HashSet<GroupModel.Group>();
            MutableIntIterator it = positionsToGroup.intIterator();
            while (it.hasNext()) {
                int column = it.next();
                GroupModel.Group group = model.getGroupByPosition(column);
                if (group == null) continue;
                if (!group.isUnbreakable()) {
                    existingGroups.add(group);
                    continue;
                }
                it.remove();
            }
            if (!existingGroups.isEmpty()) {
                this.contextLayer.doCommand(new ColumnGroupExpandCommand(model, existingGroups));
                for (GroupModel.Group group : existingGroups) {
                    positionsToGroup.addAll(group.getVisiblePositions());
                    this.contextLayer.removeGroup(group);
                }
            }
            positionsToGroup.sortThis();
            MutableIntList selectedPositions = IntLists.mutable.ofAll((IntIterable)positionsToGroup.distinct());
            if (selectedPositions.size() > 1) {
                this.selectionLayer.doCommand(new MultiColumnReorderCommand((ILayer)this.selectionLayer, selectedPositions.toArray(), selectedPositions.get(0)));
            }
            this.contextLayer.addGroup(columnGroupName, this.selectionLayer.getColumnIndexByPosition(selectedPositions.get(0)), selectedPositions.size());
            if (this.clearSelection) {
                this.selectionLayer.clear();
            }
            this.contextLayer.fireLayerEvent(new GroupColumnsEvent(this.contextLayer));
            return true;
        }
        return false;
    }

    protected void handleRemoveColumnGroupCommand(int columnIndex) {
        int selectedPosition = this.selectionLayer.getColumnPositionByIndex(columnIndex);
        int converted = LayerUtil.convertColumnPosition(this.selectionLayer, selectedPosition, this.contextLayer.getPositionLayer());
        GroupModel model = this.contextLayer.getGroupModel();
        GroupModel.Group group = model.getGroupByPosition(converted);
        if (group != null && !group.isUnbreakable()) {
            if (group.isCollapsed()) {
                this.contextLayer.doCommand(new ColumnGroupExpandCommand(model, group));
            }
            model.removeGroup(group);
            this.contextLayer.fireLayerEvent(new GroupColumnsEvent(this.contextLayer));
        }
    }

    protected void handleUngroupCommand() {
        MutableIntList positionsToUngroup = this.getPositionsToProcess();
        if (!positionsToUngroup.isEmpty()) {
            GroupModel model = this.contextLayer.getGroupModel();
            HashMap toRemove = new HashMap();
            positionsToUngroup.forEach((IntProcedure & Serializable)pos -> {
                GroupModel.Group group = model.getGroupByPosition(pos);
                if (group != null) {
                    int endPos = group.getVisibleStartPosition() + group.getVisibleSpan();
                    if (pos < endPos && !group.isGroupStart(pos)) {
                        MutableIntList remove = (MutableIntList)toRemove.get(group);
                        if (remove == null) {
                            remove = IntLists.mutable.empty();
                            toRemove.put(group, remove);
                        }
                        remove.add(pos);
                    } else {
                        model.removePositionsFromGroup(group, pos);
                    }
                }
            });
            if (!toRemove.isEmpty()) {
                toRemove.entrySet().forEach(entry -> {
                    GroupModel.Group group = (GroupModel.Group)entry.getKey();
                    int endPos = group.getVisibleStartPosition() + group.getVisibleSpan();
                    this.selectionLayer.doCommand(new MultiColumnReorderCommand((ILayer)this.selectionLayer, ((MutableIntList)entry.getValue()).toArray(), endPos));
                    MutableIntList value = (MutableIntList)entry.getValue();
                    int start = endPos - value.size();
                    int[] positionsToRemove = new int[value.size()];
                    int i = 0;
                    while (i < ((MutableIntList)entry.getValue()).size()) {
                        positionsToRemove[i] = start + i;
                        ++i;
                    }
                    model.removePositionsFromGroup(group, positionsToRemove);
                });
            }
            if (this.clearSelection) {
                this.selectionLayer.clear();
            }
            this.contextLayer.fireLayerEvent(new UngroupColumnsEvent(this.contextLayer));
        }
    }

    protected MutableIntList getPositionsToProcess() {
        MutableIntList positionsToProcess = IntLists.mutable.empty();
        int[] fullySelectedColumns = this.selectionLayer.getFullySelectedColumnPositions();
        if (fullySelectedColumns != null && fullySelectedColumns.length > 0) {
            int[] nArray = fullySelectedColumns;
            int n = fullySelectedColumns.length;
            int n2 = 0;
            while (n2 < n) {
                int column = nArray[n2];
                int converted = LayerUtil.convertColumnPosition(this.selectionLayer, column, this.contextLayer.getPositionLayer());
                if (converted > -1) {
                    positionsToProcess.add(converted);
                }
                ++n2;
            }
        }
        return positionsToProcess;
    }

    protected boolean displayColumnGroupRenameDialog(DisplayColumnGroupRenameDialogCommand command) {
        int columnPosition = command.getColumnPosition();
        HeaderRenameDialog dialog = new HeaderRenameDialog(Display.getDefault().getActiveShell(), null, null, HeaderRenameDialog.RenameDialogLabels.COLUMN_RENAME);
        Rectangle colHeaderBounds = this.contextLayer.getBoundsByPosition(columnPosition, 0);
        Point point = new Point(colHeaderBounds.x, colHeaderBounds.y + colHeaderBounds.height);
        dialog.setLocation(command.toDisplayCoordinates(point));
        dialog.open();
        if (!dialog.isCancelPressed()) {
            GroupModel.Group columnGroup = this.contextLayer.getGroupByPosition(columnPosition);
            columnGroup.setName(dialog.getNewLabel());
            this.contextLayer.fireLayerEvent(new VisualRefreshEvent(this.contextLayer));
        }
        return true;
    }

    @Override
    public Class<IColumnGroupCommand> getCommandClass() {
        return IColumnGroupCommand.class;
    }
}

