/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableObjectDoubleMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ObjectDoubleMap;
import org.eclipse.collections.impl.factory.primitive.ObjectDoubleMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectDoubleEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectDoubleHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectDoubleSingletonMap;

public enum ImmutableObjectDoubleMapFactoryImpl implements ImmutableObjectDoubleMapFactory
{
    INSTANCE;


    @Override
    public <K> ImmutableObjectDoubleMap<K> empty() {
        return ImmutableObjectDoubleEmptyMap.INSTANCE;
    }

    @Override
    public <K> ImmutableObjectDoubleMap<K> of() {
        return this.empty();
    }

    @Override
    public <K> ImmutableObjectDoubleMap<K> with() {
        return this.empty();
    }

    @Override
    public <K> ImmutableObjectDoubleMap<K> of(K key, double value) {
        return this.with(key, value);
    }

    @Override
    public <K> ImmutableObjectDoubleMap<K> with(K key, double value) {
        return new ImmutableObjectDoubleSingletonMap<K>(key, value);
    }

    @Override
    public <K> ImmutableObjectDoubleMap<K> ofAll(ObjectDoubleMap<? extends K> map) {
        return this.withAll(map);
    }

    @Override
    public <K> ImmutableObjectDoubleMap<K> withAll(ObjectDoubleMap<? extends K> map) {
        if (map instanceof ImmutableObjectDoubleMap) {
            return (ImmutableObjectDoubleMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            Object[] array = new Object[1];
            map.forEachKey(each -> {
                array[0] = each;
            });
            return new ImmutableObjectDoubleSingletonMap<Object>(array[0], map.get(array[0]));
        }
        return new ImmutableObjectDoubleHashMap<K>(map);
    }

    @Override
    public <T, K> ImmutableObjectDoubleMap<K> from(Iterable<T> iterable, Function<? super T, ? extends K> keyFunction, DoubleFunction<? super T> valueFunction) {
        MutableObjectDoubleMap<K> map = ObjectDoubleMaps.mutable.from(iterable, keyFunction, valueFunction);
        return map.toImmutable();
    }
}

