/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow;

import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.ComboBoxGlazedListsFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxDataProvider;

public class ComboBoxGlazedListsWithExcludeFilterStrategy<T>
extends ComboBoxGlazedListsFilterStrategy<T> {
    private final CompositeMatcherEditor<T> compositeMatcherEditor;
    protected Map<Matcher<T>, MatcherEditor<T>> excludeMatcherEditor = new HashMap<Matcher<T>, MatcherEditor<T>>();

    public ComboBoxGlazedListsWithExcludeFilterStrategy(FilterRowComboBoxDataProvider<T> comboBoxDataProvider, FilterList<T> filterList, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry) {
        super(comboBoxDataProvider, filterList, columnAccessor, configRegistry);
        this.compositeMatcherEditor = new CompositeMatcherEditor();
        this.compositeMatcherEditor.setMode(24);
        this.compositeMatcherEditor.getMatcherEditors().add(this.getMatcherEditor());
        this.filterList.setMatcherEditor(this.compositeMatcherEditor);
    }

    public void addExcludeFilter(Matcher<T> matcher) {
        MatcherEditor matcherEditor = GlazedLists.fixedMatcherEditor(matcher);
        this.addExcludeFilter(matcherEditor);
    }

    public void addExcludeFilter(MatcherEditor<T> matcherEditor) {
        if (this.isActive()) {
            this.filterLock.writeLock().lock();
            try {
                this.compositeMatcherEditor.getMatcherEditors().add(matcherEditor);
            }
            finally {
                this.filterLock.writeLock().unlock();
            }
        }
        this.excludeMatcherEditor.put(matcherEditor.getMatcher(), matcherEditor);
    }

    public void removeExcludeFilter(Matcher<T> matcher) {
        MatcherEditor<T> removed = this.excludeMatcherEditor.remove(matcher);
        if (removed != null && this.isActive()) {
            this.filterLock.writeLock().lock();
            try {
                this.compositeMatcherEditor.getMatcherEditors().remove(removed);
            }
            finally {
                this.filterLock.writeLock().unlock();
            }
        }
    }

    public void removeExcludeFilter(MatcherEditor<T> matcherEditor) {
        this.removeExcludeFilter(matcherEditor.getMatcher());
    }

    public void clearExcludeFilter() {
        Collection<MatcherEditor<T>> excludeMatcher = this.excludeMatcherEditor.values();
        if (!excludeMatcher.isEmpty() && this.isActive()) {
            this.filterLock.writeLock().lock();
            try {
                this.compositeMatcherEditor.getMatcherEditors().removeAll(excludeMatcher);
            }
            finally {
                this.filterLock.writeLock().unlock();
            }
        }
        this.excludeMatcherEditor.clear();
    }

    @Override
    public void activateFilterStrategy() {
        Collection<MatcherEditor<T>> excludeMatcher;
        if (!this.isActive() && !(excludeMatcher = this.excludeMatcherEditor.values()).isEmpty()) {
            this.filterLock.writeLock().lock();
            try {
                this.compositeMatcherEditor.getMatcherEditors().addAll(excludeMatcher);
            }
            finally {
                this.filterLock.writeLock().unlock();
            }
        }
        super.activateFilterStrategy();
    }

    @Override
    public void deactivateFilterStrategy() {
        Collection<MatcherEditor<T>> excludeMatcher;
        if (this.isActive() && !(excludeMatcher = this.excludeMatcherEditor.values()).isEmpty()) {
            this.filterLock.writeLock().lock();
            try {
                this.compositeMatcherEditor.getMatcherEditors().removeAll(excludeMatcher);
            }
            finally {
                this.filterLock.writeLock().unlock();
            }
        }
        super.deactivateFilterStrategy();
    }
}

