/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.nebula.widgets.nattable.util.ComparatorChain;

public class SortableTreeComparator<T>
implements Comparator<T> {
    private final Comparator<T> treeComparator;
    private final ISortModel sortModel;

    public SortableTreeComparator(Comparator<T> treeComparator, ISortModel sortModel) {
        this.treeComparator = treeComparator;
        this.sortModel = sortModel;
    }

    @Override
    public int compare(T o1, T o2) {
        int treeComparatorResult = this.treeComparator.compare(o1, o2);
        if (treeComparatorResult == 0) {
            return 0;
        }
        List<Integer> sortedColumnIndexes = this.sortModel.getSortedColumnIndexes();
        if (sortedColumnIndexes != null && !sortedColumnIndexes.isEmpty()) {
            ArrayList comparators = new ArrayList();
            for (int sortedColumnIndex : sortedColumnIndexes) {
                List<Comparator> columnComparators = this.sortModel.getComparatorsForColumnIndex(sortedColumnIndex);
                if (columnComparators.isEmpty()) continue;
                SortDirectionEnum sortDirection = this.sortModel.getSortDirection(sortedColumnIndex);
                for (Comparator columnComparator : columnComparators) {
                    if (sortDirection == SortDirectionEnum.ASC) {
                        comparators.add(columnComparator);
                        continue;
                    }
                    if (sortDirection != SortDirectionEnum.DESC) continue;
                    comparators.add(Collections.reverseOrder(columnComparator));
                }
            }
            comparators.add(this.treeComparator);
            return new ComparatorChain<T>(comparators).compare(o1, o2);
        }
        return treeComparatorResult;
    }
}

