/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.data.command;

import ca.odell.glazedlists.EventList;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.data.command.RowInsertCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowInsertEvent;

public class GlazedListsRowInsertCommandHandler<T>
implements ILayerCommandHandler<RowInsertCommand> {
    protected EventList<T> bodyData;

    public GlazedListsRowInsertCommandHandler(EventList<T> bodyData) {
        this.bodyData = bodyData;
    }

    public boolean doCommand(ILayer targetLayer, RowInsertCommand command) {
        if (command.convertToTargetLayer(targetLayer)) {
            RowInsertEvent event = null;
            this.bodyData.getReadWriteLock().writeLock().lock();
            try {
                if (command.getRowIndex() < 0 || command.getRowIndex() >= this.bodyData.size()) {
                    this.bodyData.addAll((Collection)command.getObjects());
                    event = new RowInsertEvent(targetLayer, new Range[]{new Range(this.bodyData.size() - command.getObjects().size(), this.bodyData.size())});
                } else {
                    this.bodyData.addAll(command.getRowIndex(), (Collection)command.getObjects());
                    event = new RowInsertEvent(targetLayer, new Range[]{new Range(command.getRowIndex(), command.getRowIndex() + command.getObjects().size())});
                }
            }
            finally {
                this.bodyData.getReadWriteLock().writeLock().unlock();
            }
            targetLayer.fireLayerEvent((ILayerEvent)event);
            return true;
        }
        return false;
    }

    public Class<RowInsertCommand> getCommandClass() {
        return RowInsertCommand.class;
    }
}

