/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow.combobox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboUpdateEvent;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.IFilterRowComboUpdateListener;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.event.CellVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;

public class FilterRowComboBoxDataProvider<T>
implements IComboBoxDataProvider,
ILayerListener {
    private Collection<T> baseCollection;
    private IColumnAccessor<T> columnAccessor;
    private final Map<Integer, List<?>> valueCache = new HashMap();
    private List<IFilterRowComboUpdateListener> cacheUpdateListener = new ArrayList<IFilterRowComboUpdateListener>();
    protected final boolean lazyLoading;
    protected boolean cachingEnabled = true;
    private boolean updateEventsEnabled = true;
    private final ReadWriteLock valueCacheLock = new ReentrantReadWriteLock();

    public FilterRowComboBoxDataProvider(ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> columnAccessor) {
        this(bodyLayer, baseCollection, columnAccessor, true);
    }

    public FilterRowComboBoxDataProvider(ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> columnAccessor, boolean lazy) {
        this.baseCollection = baseCollection;
        this.columnAccessor = columnAccessor;
        this.lazyLoading = lazy;
        if (!this.lazyLoading) {
            this.valueCacheLock.writeLock().lock();
            try {
                this.buildValueCache();
            }
            finally {
                this.valueCacheLock.writeLock().unlock();
            }
        }
        bodyLayer.addLayerListener(this);
    }

    @Override
    public List<?> getValues(int columnIndex, int rowIndex) {
        if (this.cachingEnabled) {
            this.valueCacheLock.readLock().lock();
            List<?> result = null;
            try {
                result = this.valueCache.get(columnIndex);
            }
            finally {
                this.valueCacheLock.readLock().unlock();
            }
            if (result == null) {
                this.valueCacheLock.writeLock().lock();
                try {
                    result = this.collectValues(columnIndex);
                    this.valueCache.put(columnIndex, result);
                }
                finally {
                    this.valueCacheLock.writeLock().unlock();
                }
                if (this.isUpdateEventsEnabled()) {
                    this.fireCacheUpdateEvent(this.buildUpdateEvent(columnIndex, null, result));
                }
            }
            return result;
        }
        return this.collectValues(columnIndex);
    }

    protected void buildValueCache() {
        int i = 0;
        while (i < this.columnAccessor.getColumnCount()) {
            this.valueCache.put(i, this.collectValues(i));
            ++i;
        }
    }

    public Collection<Integer> getCachedColumnIndexes() {
        this.valueCacheLock.readLock().lock();
        try {
            Set<Integer> set = this.valueCache.keySet();
            return set;
        }
        finally {
            this.valueCacheLock.readLock().unlock();
        }
    }

    protected List<?> collectValues(int columnIndex) {
        HashSet<Object> uniqueValues = new HashSet<Object>();
        boolean nullFound = false;
        for (T rowObject : this.baseCollection) {
            Object dataValue = this.columnAccessor.getDataValue(rowObject, columnIndex);
            if (dataValue != null) {
                uniqueValues.add(dataValue);
                continue;
            }
            nullFound = true;
        }
        ArrayList result = new ArrayList(uniqueValues);
        if (!result.isEmpty() && result.get(0) instanceof Comparable) {
            Collections.sort(result);
        }
        if (nullFound) {
            result.add(0, null);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleLayerEvent(ILayerEvent event) {
        if (!this.cachingEnabled) return;
        if (event instanceof CellVisualChangeEvent) {
            this.valueCacheLock.writeLock().lock();
            try {
                int column = ((CellVisualChangeEvent)event).getColumnPosition();
                List<?> cacheBefore = this.valueCache.get(column);
                if (!this.lazyLoading || cacheBefore != null) {
                    this.valueCache.put(column, this.collectValues(column));
                }
                if (!this.isUpdateEventsEnabled()) return;
                this.fireCacheUpdateEvent(this.buildUpdateEvent(column, cacheBefore, this.valueCache.get(column)));
                return;
            }
            finally {
                this.valueCacheLock.writeLock().unlock();
            }
        }
        if (!(event instanceof IStructuralChangeEvent) || !((IStructuralChangeEvent)event).isVerticalStructureChanged()) return;
        this.valueCacheLock.writeLock().lock();
        try {
            HashMap cacheBefore = new HashMap(this.valueCache);
            this.valueCache.clear();
            if (!this.lazyLoading) {
                this.buildValueCache();
            }
            if (!this.isUpdateEventsEnabled()) return;
            for (Map.Entry entry : cacheBefore.entrySet()) {
                this.fireCacheUpdateEvent(this.buildUpdateEvent((Integer)entry.getKey(), (List)entry.getValue(), this.valueCache.get(entry.getKey())));
            }
            return;
        }
        finally {
            this.valueCacheLock.writeLock().unlock();
        }
    }

    protected FilterRowComboUpdateEvent buildUpdateEvent(int columnIndex, List<?> cacheBefore, List<?> cacheAfter) {
        HashSet addedValues = new HashSet();
        HashSet removedValues = new HashSet();
        if (cacheAfter != null && cacheBefore != null) {
            for (Object after : cacheAfter) {
                if (cacheBefore.contains(after)) continue;
                addedValues.add(after);
            }
            for (Object before : cacheBefore) {
                if (cacheAfter.contains(before)) continue;
                removedValues.add(before);
            }
        } else if ((cacheBefore == null || cacheBefore.isEmpty()) && cacheAfter != null) {
            addedValues.addAll(cacheAfter);
        } else if (cacheBefore != null && (cacheAfter == null || cacheAfter.isEmpty())) {
            removedValues.addAll(cacheBefore);
        }
        if (!addedValues.isEmpty() || !removedValues.isEmpty()) {
            return new FilterRowComboUpdateEvent(columnIndex, addedValues, removedValues);
        }
        return null;
    }

    protected void fireCacheUpdateEvent(FilterRowComboUpdateEvent event) {
        if (event != null) {
            for (IFilterRowComboUpdateListener listener : this.cacheUpdateListener) {
                listener.handleEvent(event);
            }
        }
    }

    public void addCacheUpdateListener(IFilterRowComboUpdateListener listener) {
        this.cacheUpdateListener.add(listener);
    }

    @Deprecated
    public void removeCacheUdpateListener(IFilterRowComboUpdateListener listener) {
        this.cacheUpdateListener.remove(listener);
    }

    public void removeCacheUpdateListener(IFilterRowComboUpdateListener listener) {
        this.cacheUpdateListener.remove(listener);
    }

    protected Map<Integer, List<?>> getValueCache() {
        return this.valueCache;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
    }

    public void dispose() {
    }

    public boolean isUpdateEventsEnabled() {
        return this.updateEventsEnabled;
    }

    public void enableUpdateEvents() {
        this.updateEventsEnabled = true;
    }

    public void disableUpdateEvents() {
        this.updateEventsEnabled = false;
    }

    public ReadWriteLock getValueCacheLock() {
        return this.valueCacheLock;
    }
}

