/*******************************************************************************
 * Copyright (c) 2015 Dirk Fauth.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Dirk Fauth <dirk.fauth@googlemail.com> - initial API and implementation
 ******************************************************************************/
package org.eclipse.nebula.widgets.nattable.edit;

/**
 * Definition of editing related constants.
 *
 * @since 1.4
 * @noextend This class is not intended to be subclassed by clients.
 * @noinstantiate This class is not intended to be instantiated by clients.
 */
public interface EditConstants {

    /**
     * Value constant that is used in conjunction with multi select combo boxes
     * with checkboxes. Indicates that all values in the combo box are selected.
     */
    String SELECT_ALL_ITEMS_VALUE = "SELECT_ALL"; //$NON-NLS-1$

}
