/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.fillhandle.action;

import java.util.Date;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.Direction;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataToClipboardCommand;
import org.eclipse.nebula.widgets.nattable.fillhandle.command.FillHandlePasteCommand;
import org.eclipse.nebula.widgets.nattable.fillhandle.config.FillHandleConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportDragCommand;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class FillHandleDragMode
implements IDragMode {
    protected MouseEvent startEvent;
    protected Point startIndex;
    protected SelectionLayer.MoveDirectionEnum direction;
    protected SelectionLayer selectionLayer;
    protected ILayerCell selectionCell;
    protected InternalCellClipboard clipboard;
    protected Menu menu;

    public FillHandleDragMode(SelectionLayer selectionLayer, InternalCellClipboard clipboard) {
        if (selectionLayer == null) {
            throw new IllegalArgumentException("SelectionLayer can not be null");
        }
        this.selectionLayer = selectionLayer;
        this.clipboard = clipboard;
    }

    @Override
    public void mouseDown(NatTable natTable, MouseEvent event) {
        PositionCoordinate[] selectedCellPositions = this.selectionLayer.getSelectedCellPositions();
        if (selectedCellPositions.length > 0) {
            this.startEvent = event;
            this.selectionCell = this.selectionLayer.getCellByPosition(selectedCellPositions[0].columnPosition, selectedCellPositions[0].rowPosition);
            this.startIndex = new Point(this.selectionCell.getColumnIndex(), this.selectionCell.getRowIndex());
        }
    }

    @Override
    public void mouseMove(NatTable natTable, MouseEvent event) {
        Rectangle clientArea = natTable.getClientAreaProvider().getClientArea();
        int x = event.x;
        int y = event.y;
        SelectionLayer.MoveDirectionEnum horizontal = SelectionLayer.MoveDirectionEnum.NONE;
        if (event.x < 0) {
            horizontal = SelectionLayer.MoveDirectionEnum.LEFT;
            x = 0;
        } else if (event.x > clientArea.width) {
            horizontal = SelectionLayer.MoveDirectionEnum.RIGHT;
            x = clientArea.width;
        }
        SelectionLayer.MoveDirectionEnum vertical = SelectionLayer.MoveDirectionEnum.NONE;
        if (event.y < 0) {
            vertical = SelectionLayer.MoveDirectionEnum.UP;
            y = 0;
        } else if (event.y > clientArea.height) {
            vertical = SelectionLayer.MoveDirectionEnum.DOWN;
            y = clientArea.height;
        }
        if (natTable.doCommand(new ViewportDragCommand(horizontal, vertical))) {
            int selectedColumnPosition = natTable.getColumnPositionByX(x);
            int selectedRowPosition = natTable.getRowPositionByY(y);
            int selectedColumnIndex = natTable.getColumnIndexByPosition(selectedColumnPosition);
            int selectedRowIndex = natTable.getRowIndexByPosition(selectedRowPosition);
            if (selectedColumnPosition > -1 && selectedRowPosition > -1) {
                Rectangle actionBounds = null;
                int xStart = this.startIndex.x;
                int yStart = this.startIndex.y;
                Rectangle region = this.selectionLayer.getLastSelectedRegion();
                int xDiff = this.calculateIncreasedPositiveDiff(event.x, event.x < this.startEvent.x ? this.selectionCell.getBounds().x : this.startEvent.x);
                int yDiff = this.calculateIncreasedPositiveDiff(event.y, event.y < this.startEvent.y ? this.selectionCell.getBounds().y : this.startEvent.y);
                if (selectedColumnIndex >= region.x && selectedColumnIndex < region.x + region.width) {
                    xDiff = 0;
                }
                if (selectedRowIndex >= region.y && selectedRowIndex < region.y + region.height) {
                    yDiff = 0;
                }
                int width = -1;
                int height = -1;
                Direction direction = natTable.getConfigRegistry().getConfigAttribute(FillHandleConfigAttributes.ALLOWED_FILL_DIRECTION, "NORMAL", this.selectionCell.getConfigLabels().getLabels());
                if (direction == null) {
                    direction = Direction.BOTH;
                }
                if (direction != Direction.NONE) {
                    if (direction == Direction.VERTICAL || direction == Direction.BOTH && yDiff >= xDiff) {
                        int diff = this.calculateIncreasedPositiveDiff(selectedRowIndex, this.startIndex.y);
                        height = Math.max(diff, this.selectionLayer.getSelectedRowCount());
                        width = this.selectionLayer.getSelectedColumnPositions().length;
                        this.direction = SelectionLayer.MoveDirectionEnum.DOWN;
                        if (selectedRowIndex - this.startIndex.y < 0) {
                            yStart = selectedRowIndex;
                            height = diff + this.selectionLayer.getSelectedRowCount() - 1;
                            this.direction = SelectionLayer.MoveDirectionEnum.UP;
                        }
                    } else {
                        int diff = this.calculateIncreasedPositiveDiff(selectedColumnIndex, this.startIndex.x);
                        height = this.selectionLayer.getSelectedRowCount();
                        width = Math.max(diff, this.selectionLayer.getSelectedColumnPositions().length);
                        this.direction = SelectionLayer.MoveDirectionEnum.RIGHT;
                        if (selectedColumnIndex - this.startIndex.x < 0) {
                            xStart = selectedColumnIndex;
                            width = diff + this.selectionLayer.getSelectedColumnPositions().length - 1;
                            this.direction = SelectionLayer.MoveDirectionEnum.LEFT;
                        }
                    }
                    actionBounds = new Rectangle(xStart, yStart, width, height);
                    this.selectionLayer.setFillHandleRegion(actionBounds);
                    natTable.redraw();
                }
            }
        }
    }

    protected int calculateIncreasedPositiveDiff(int selectedIndex, int relativeIndex) {
        int diff = selectedIndex - relativeIndex;
        if (diff < 0) {
            diff *= -1;
        }
        return ++diff;
    }

    @Override
    public void mouseUp(NatTable natTable, MouseEvent event) {
        if (natTable.doCommand(new CopyDataToClipboardCommand("\t", System.getProperty("line.separator"), natTable.getConfigRegistry()))) {
            if (this.clipboard != null) {
                if (this.showMenu(natTable)) {
                    this.openMenu(natTable);
                } else {
                    natTable.doCommand(new FillHandlePasteCommand(FillHandlePasteCommand.FillHandleOperation.COPY, this.direction, natTable.getConfigRegistry()));
                    this.reset(natTable);
                }
            } else {
                natTable.doCommand(new FillHandlePasteCommand(FillHandlePasteCommand.FillHandleOperation.COPY, this.direction, natTable.getConfigRegistry()));
                this.reset(natTable);
            }
        } else {
            this.reset(natTable);
        }
    }

    protected boolean showMenu(NatTable natTable) {
        if (this.clipboard == null || this.clipboard.getCopiedCells() == null) {
            return false;
        }
        Class<?> type = null;
        ILayerCell[][] iLayerCellArray = this.clipboard.getCopiedCells();
        int n = iLayerCellArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILayerCell[] cells;
            ILayerCell[] iLayerCellArray2 = cells = iLayerCellArray[n2];
            int n3 = cells.length;
            int n4 = 0;
            while (n4 < n3) {
                ILayerCell cell = iLayerCellArray2[n4];
                if (cell.getDataValue() == null) {
                    return false;
                }
                if (type == null ? !Number.class.isAssignableFrom(type = cell.getDataValue().getClass()) && !Date.class.isAssignableFrom(type) : type != cell.getDataValue().getClass()) {
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }

    protected void openMenu(final NatTable natTable) {
        if (this.menu == null || this.menu.isDisposed()) {
            this.menu = new Menu((Control)natTable);
            MenuItem copyItem = new MenuItem(this.menu, 8);
            copyItem.setText(Messages.getLocalizedMessage("%FillHandleDragMode.menu.item.copy"));
            copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    natTable.doCommand(new FillHandlePasteCommand(FillHandlePasteCommand.FillHandleOperation.COPY, FillHandleDragMode.this.direction, natTable.getConfigRegistry()));
                }
            });
            MenuItem seriesItem = new MenuItem(this.menu, 8);
            seriesItem.setText(Messages.getLocalizedMessage("%FillHandleDragMode.menu.item.series"));
            seriesItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    natTable.doCommand(new FillHandlePasteCommand(FillHandlePasteCommand.FillHandleOperation.SERIES, FillHandleDragMode.this.direction, natTable.getConfigRegistry()));
                }
            });
            this.menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuHidden(MenuEvent e) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            FillHandleDragMode.this.reset(natTable);
                        }
                    });
                }
            });
            natTable.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    FillHandleDragMode.this.menu.dispose();
                }
            });
        }
        this.menu.setVisible(true);
    }

    protected void reset(NatTable natTable) {
        this.selectionCell = null;
        this.startEvent = null;
        this.startIndex = null;
        this.direction = null;
        this.selectionLayer.setFillHandleRegion(null);
        this.clipboard.clear();
        natTable.redraw();
    }
}

