/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._103_Events;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.RowDataFixture;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.RowDataListFixture;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.fixtures.GlazedListsGridLayer;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.selection.ISelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.RowSelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.config.RowOnlySelectionBindings;
import org.eclipse.nebula.widgets.nattable.selection.config.RowOnlySelectionConfiguration;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class Real_time_data_updates
extends AbstractNatExample {
    private int updatesPerSecond = 1;
    private final int defaultDatasetSize = 20;
    private ScheduledExecutorService scheduledThreadPool;
    private NatTable nattable;
    private EventList<RowDataFixture> eventList;

    public static void main(String[] args) {
        StandaloneNatExampleRunner.run(500, 700, new Real_time_data_updates());
    }

    @Override
    public String getDescription() {
        return "Grid demonstrates data being added/removed. You can experiment with different data set sizes and update speeds.\nSelect row by clicking on row header. Row selection is preserved when data is updated and sorted.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        this.eventList = GlazedLists.eventList((Collection)RowDataListFixture.getList((int)20));
        ConfigRegistry configRegistry = new ConfigRegistry();
        GlazedListsGridLayer<RowDataFixture> glazedListsGridLayer = new GlazedListsGridLayer<RowDataFixture>(this.eventList, RowDataListFixture.getPropertyNames(), RowDataListFixture.getPropertyToLabelMap(), (IConfigRegistry)configRegistry);
        this.nattable = new NatTable(parent, glazedListsGridLayer, false);
        this.nattable.setConfigRegistry((IConfigRegistry)configRegistry);
        this.nattable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        this.nattable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        SelectionLayer selectionLayer = glazedListsGridLayer.getBodyLayerStack().getSelectionLayer();
        ListDataProvider<RowDataFixture> bodyDataProvider = glazedListsGridLayer.getBodyDataProvider();
        RowOnlySelectionConfiguration selectionConfig = new RowOnlySelectionConfiguration();
        selectionLayer.addConfiguration((IConfiguration)selectionConfig);
        this.nattable.addConfiguration((IConfiguration)new RowOnlySelectionBindings());
        selectionLayer.setSelectionModel((ISelectionModel)new RowSelectionModel(selectionLayer, bodyDataProvider, (IRowIdAccessor)new IRowIdAccessor<RowDataFixture>(){

            public Serializable getRowId(RowDataFixture rowObject) {
                return rowObject.getSecurity_id();
            }
        }));
        this.nattable.configure();
        parent.setLayout((Layout)new GridLayout(1, true));
        this.nattable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setupTextArea(parent);
        this.setupButtons(parent);
        return this.nattable;
    }

    @Override
    public void onStart() {
        this.scheduledThreadPool = Executors.newScheduledThreadPool(1);
        this.scheduledThreadPool.scheduleAtFixedRate(new ListEventsPublisher(), 100L, 1000L / (long)this.updatesPerSecond, TimeUnit.MILLISECONDS);
    }

    @Override
    public void onStop() {
        this.scheduledThreadPool.shutdown();
        this.nattable.dispose();
    }

    private void setupButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)new GridLayout(3, false));
        buttonComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label(buttonComposite, 0).setText("Clear and add records");
        final Text clearText = new Text(buttonComposite, 2048);
        clearText.setText(Integer.toString(20));
        clearText.setLayoutData((Object)new GridData(100, 14));
        clearText.setSize(100, 20);
        Button clearButton = new Button(buttonComposite, 8);
        clearButton.setText("Apply");
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Integer newRecordCount = Integer.valueOf(clearText.getText());
                try {
                    Real_time_data_updates.this.eventList.getReadWriteLock().writeLock().lock();
                    Real_time_data_updates.this.eventList.clear();
                    Real_time_data_updates.this.eventList.addAll((Collection)RowDataListFixture.getList((int)newRecordCount));
                }
                finally {
                    Real_time_data_updates.this.eventList.getReadWriteLock().writeLock().unlock();
                    Real_time_data_updates.this.log(">> List cleared. Added " + newRecordCount + " new records.");
                }
            }
        });
        new Label(buttonComposite, 8).setText("Updates/sec");
        final Text updateSpeedText = new Text(buttonComposite, 2048);
        updateSpeedText.setLayoutData((Object)new GridData(100, 14));
        updateSpeedText.setText(Integer.toString(this.updatesPerSecond));
        Button updateSpeedButton = new Button(buttonComposite, 8);
        updateSpeedButton.setText("Apply");
        updateSpeedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Real_time_data_updates.this.updatesPerSecond = Integer.parseInt(updateSpeedText.getText());
                Real_time_data_updates.this.log(">> Update speed: " + Real_time_data_updates.this.updatesPerSecond);
                Real_time_data_updates.this.scheduledThreadPool.shutdownNow();
                Real_time_data_updates.this.onStart();
            }
        });
        final Button pauseButton = new Button(buttonComposite, 8);
        pauseButton.setLayoutData((Object)new GridData(100, 20));
        pauseButton.setText("Pause updates");
        pauseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            boolean updatesPaused = false;

            public void widgetSelected(SelectionEvent e) {
                if (this.updatesPaused) {
                    Real_time_data_updates.this.log(">> Starting updates");
                    this.updatesPaused = false;
                    pauseButton.setText("Pause updates");
                    Real_time_data_updates.this.onStart();
                } else {
                    Real_time_data_updates.this.log(">> Pausing updates");
                    this.updatesPaused = true;
                    pauseButton.setText("Start updates");
                    Real_time_data_updates.this.scheduledThreadPool.shutdownNow();
                }
            }
        });
    }

    class ListEventsPublisher
    implements Runnable {
        ListEventsPublisher() {
        }

        @Override
        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    block6: {
                        try {
                            try {
                                boolean removeElements;
                                Real_time_data_updates.this.eventList.getReadWriteLock().writeLock().lock();
                                int elementIndexToRemove = ObjectUtils.getRandomNumber((int)(Real_time_data_updates.this.eventList.size() - 1));
                                elementIndexToRemove = elementIndexToRemove < 0 ? 0 : elementIndexToRemove;
                                boolean bl = removeElements = ObjectUtils.getRandomNumber((int)1000) % 2 == 0;
                                if (removeElements) {
                                    RowDataFixture remove = (RowDataFixture)Real_time_data_updates.this.eventList.remove(elementIndexToRemove);
                                    Real_time_data_updates.this.log("Removed record: " + remove.getSecurity_id());
                                    break block6;
                                }
                                RowDataFixture added = RowDataFixture.getInstance((String)"Added by test", (String)"AAA");
                                Real_time_data_updates.this.eventList.add((Object)added);
                                Real_time_data_updates.this.log("Added record: " + added.getSecurity_id());
                            }
                            catch (Exception e) {
                                Real_time_data_updates.this.log("Ignoring exception: " + e.getMessage());
                                Real_time_data_updates.this.eventList.getReadWriteLock().writeLock().unlock();
                            }
                        }
                        finally {
                            Real_time_data_updates.this.eventList.getReadWriteLock().writeLock().unlock();
                        }
                    }
                }
            });
        }
    }
}

