/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._800_Integration;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.columnChooser.command.DisplayColumnChooserCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.VisualRefreshCommand;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.ExtendedReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDoubleDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.person.Address;
import org.eclipse.nebula.widgets.nattable.dataset.person.ExtendedPersonWithAddress;
import org.eclipse.nebula.widgets.nattable.dataset.person.Person;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsSortModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.DefaultGlazedListsFilterStrategy;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByConfigAttributes;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByConfigLabelModifier;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByDataLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByHeaderLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByHeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.ModernGroupByThemeExtension;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.summary.IGroupBySummaryProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.summary.SummationGroupBySummaryProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowHeaderComposite;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.freeze.CompositeFreezeLayer;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeLayer;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultSummaryRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupExpandCollapseLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupReorderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.AbstractOverrider;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.NatTableBorderOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.persistence.command.DisplayPersistenceDialogCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.theme.IThemeExtension;
import org.eclipse.nebula.widgets.nattable.style.theme.ModernNatTableThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.style.theme.ThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.summaryrow.ISummaryProvider;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryDisplayConverter;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryRowLayer;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummationSummaryProvider;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeCollapseAllCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandAllCommand;
import org.eclipse.nebula.widgets.nattable.ui.menu.AbstractHeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class _810_SortableGroupByFilterColumnGroupAndFreezeExample
extends AbstractNatExample {
    private static final String ROW_HEADER_SUMMARY_ROW = "rowHeaderSummaryRowLabel";
    private IGroupBySummaryProvider<ExtendedPersonWithAddress> sumMoneySummaryProvider;
    private IGroupBySummaryProvider<ExtendedPersonWithAddress> avgMoneySummaryProvider;
    private boolean useMoneySum = true;
    private ColumnGroupModel columnGroupModel = new ColumnGroupModel();
    public static final String PROPERTIES_FILE = "myState.properties";
    public NatTable natTable;

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new _810_SortableGroupByFilterColumnGroupAndFreezeExample());
    }

    @Override
    public String getDescription() {
        return "This example shows the usage of the group by feature in conjunction with summary values of the groupings.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        final ConfigRegistry configRegistry = new ConfigRegistry();
        String[] propertyNames = new String[]{"firstName", "lastName", "age", "money", "married", "gender", "birthday"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("age", "Age");
        propertyToLabelMap.put("money", "Money");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("birthday", "Birthday");
        ExtendedReflectiveColumnPropertyAccessor columnPropertyAccessor = new ExtendedReflectiveColumnPropertyAccessor(propertyNames);
        final BodyLayerStack bodyLayerStack = new BodyLayerStack(PersonService.getExtendedPersonsWithAddress((int)10), columnPropertyAccessor, configRegistry);
        bodyLayerStack.getBodyDataLayer().setConfigLabelAccumulator((IConfigLabelAccumulator)new ColumnLabelAccumulator());
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, bodyLayerStack, bodyLayerStack.getSelectionLayer());
        SortHeaderLayer sortHeaderLayer = new SortHeaderLayer((ILayer)columnHeaderLayer, (ISortModel)new GlazedListsSortModel(bodyLayerStack.getSortedList(), (IColumnPropertyAccessor)columnPropertyAccessor, (IConfigRegistry)configRegistry, (ILayer)columnHeaderDataLayer), false);
        bodyLayerStack.getBodyDataLayer().initializeTreeComparator(sortHeaderLayer.getSortModel(), (IUniqueIndexLayer)bodyLayerStack.getTreeLayer(), true);
        ColumnGroupHeaderLayer columnGroupHeaderLayer = new ColumnGroupHeaderLayer((ILayer)sortHeaderLayer, bodyLayerStack.getSelectionLayer(), this.columnGroupModel);
        columnGroupHeaderLayer.setCalculateHeight(true);
        final FilterRowHeaderComposite filterRowHeaderLayer = new FilterRowHeaderComposite((IFilterStrategy)new DefaultGlazedListsFilterStrategy(bodyLayerStack.getFilterList(), (IColumnAccessor)columnPropertyAccessor, (IConfigRegistry)configRegistry), (ILayer)columnGroupHeaderLayer, columnHeaderDataLayer.getDataProvider(), (IConfigRegistry)configRegistry);
        DefaultSummaryRowHeaderDataProvider rowHeaderDataProvider = new DefaultSummaryRowHeaderDataProvider(bodyLayerStack.getBodyDataLayer().getDataProvider(), "\u2211");
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        rowHeaderDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new AbstractOverrider((DataLayer)rowHeaderDataLayer){
            private final /* synthetic */ DataLayer val$rowHeaderDataLayer;
            {
                this.val$rowHeaderDataLayer = dataLayer;
            }

            public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
                if (rowPosition + 1 == this.val$rowHeaderDataLayer.getRowCount()) {
                    configLabels.addLabel(_810_SortableGroupByFilterColumnGroupAndFreezeExample.ROW_HEADER_SUMMARY_ROW);
                    configLabels.addLabel("SummaryRow");
                }
            }
        });
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, bodyLayerStack, bodyLayerStack.getSelectionLayer());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)filterRowHeaderLayer);
        GridLayer gridLayer = new GridLayer(bodyLayerStack, (ILayer)filterRowHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        CompositeLayer compositeGridLayer = new CompositeLayer(1, 2);
        final GroupByHeaderLayer groupByHeaderLayer = new GroupByHeaderLayer(bodyLayerStack.getGroupByModel(), (ILayer)gridLayer, (IDataProvider)columnHeaderDataProvider);
        compositeGridLayer.setChildLayer("GROUP_BY_REGION", (ILayer)groupByHeaderLayer, 0, 0);
        compositeGridLayer.setChildLayer("Grid", (ILayer)gridLayer, 0, 1);
        final NatTable natTable = new NatTable(container, (ILayer)compositeGridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CheckBoxPainter(), "NORMAL", "COLUMN_4");
                configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDoubleDisplayConverter(), "NORMAL", "COLUMN_3");
            }
        });
        natTable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        this.sumMoneySummaryProvider = new SummationGroupBySummaryProvider((IColumnAccessor)columnPropertyAccessor);
        this.avgMoneySummaryProvider = new AverageMoneyGroupBySummaryProvider();
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(GroupByConfigAttributes.GROUP_BY_SUMMARY_PROVIDER, (Object)_810_SortableGroupByFilterColumnGroupAndFreezeExample.this.sumMoneySummaryProvider, "NORMAL", "GROUP_BY_COLUMN_3");
                configRegistry.registerConfigAttribute(GroupByConfigAttributes.GROUP_BY_SUMMARY_PROVIDER, (Object)new AverageAgeGroupBySummaryProvider(), "NORMAL", "GROUP_BY_COLUMN_2");
                configRegistry.registerConfigAttribute(GroupByConfigAttributes.GROUP_BY_CHILD_COUNT_PATTERN, (Object)"[{0}] - ({1})");
                configRegistry.registerConfigAttribute(GroupByConfigAttributes.GROUP_BY_HINT, (Object)"Drag columns here");
                Style hintStyle = new Style();
                hintStyle.setAttributeValue(CellStyleAttributes.FONT, (Object)GUIHelper.getFont((FontData[])new FontData[]{new FontData("Arial", 10, 2)}));
                configRegistry.registerConfigAttribute(GroupByConfigAttributes.GROUP_BY_HINT_STYLE, (Object)hintStyle);
                configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, (Object)new SummationSummaryProvider(bodyLayerStack.bodyDataProvider, false), "NORMAL", "SummaryColumn_3");
                configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, (Object)new AverageAgeSummaryProvider(bodyLayerStack.bodyDataProvider), "NORMAL", "SummaryColumn_2");
                configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new SummaryDisplayConverter((IDisplayConverter)new DefaultDoubleDisplayConverter()), "NORMAL", "SummaryColumn_3");
                Style style = new Style();
                style.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.CENTER);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "NORMAL", _810_SortableGroupByFilterColumnGroupAndFreezeExample.ROW_HEADER_SUMMARY_ROW);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "SELECT", _810_SortableGroupByFilterColumnGroupAndFreezeExample.ROW_HEADER_SUMMARY_ROW);
            }
        });
        natTable.addConfiguration((IConfiguration)new GroupByHeaderMenuConfiguration(natTable, groupByHeaderLayer));
        natTable.addConfiguration((IConfiguration)new AbstractHeaderMenuConfiguration(natTable){

            protected PopupMenuBuilder createColumnHeaderMenu(NatTable natTable) {
                return super.createColumnHeaderMenu(natTable).withHideColumnMenuItem().withShowAllColumnsMenuItem().withColumnChooserMenuItem().withCreateColumnGroupsMenuItem().withUngroupColumnsMenuItem().withAutoResizeSelectedColumnsMenuItem().withColumnRenameDialog().withClearAllFilters().withStateManagerMenuItemProvider();
            }

            protected PopupMenuBuilder createCornerMenu(NatTable natTable) {
                return super.createCornerMenu(natTable).withShowAllColumnsMenuItem().withStateManagerMenuItemProvider();
            }
        });
        natTable.configure();
        natTable.registerCommandHandler((ILayerCommandHandler)new DisplayPersistenceDialogCommandHandler(natTable));
        DisplayColumnChooserCommandHandler columnChooserCommandHandler = new DisplayColumnChooserCommandHandler(bodyLayerStack.getSelectionLayer(), bodyLayerStack.getColumnHideShowLayer(), columnHeaderLayer, (DataLayer)columnHeaderDataLayer, null, null);
        natTable.registerCommandHandler((ILayerCommandHandler)columnChooserCommandHandler);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        Composite buttonPanel = new Composite(container, 0);
        buttonPanel.setLayout((Layout)new RowLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        Button toggleHeaderButton = new Button(buttonPanel, 8);
        toggleHeaderButton.setText("Toggle Group By Header");
        toggleHeaderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                groupByHeaderLayer.setVisible(!groupByHeaderLayer.isVisible());
            }
        });
        Button toggleFilterButton = new Button(buttonPanel, 8);
        toggleFilterButton.setText("Toggle Filter Row");
        toggleFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                filterRowHeaderLayer.setFilterRowVisible(!filterRowHeaderLayer.isFilterRowVisible());
            }
        });
        Button collapseAllButton = new Button(buttonPanel, 8);
        collapseAllButton.setText("Collapse All");
        collapseAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                natTable.doCommand((ILayerCommand)new TreeCollapseAllCommand());
            }
        });
        Button expandAllButton = new Button(buttonPanel, 8);
        expandAllButton.setText("Expand All");
        expandAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                natTable.doCommand((ILayerCommand)new TreeExpandAllCommand());
            }
        });
        Button toggleMoneySummaryButton = new Button(buttonPanel, 8);
        toggleMoneySummaryButton.setText("Toggle Money Group Summary (SUM/AVG)");
        toggleMoneySummaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                bodyLayerStack.getBodyDataLayer().clearCache();
                _810_SortableGroupByFilterColumnGroupAndFreezeExample.this.useMoneySum = !_810_SortableGroupByFilterColumnGroupAndFreezeExample.this.useMoneySum;
                if (_810_SortableGroupByFilterColumnGroupAndFreezeExample.this.useMoneySum) {
                    configRegistry.registerConfigAttribute(GroupByConfigAttributes.GROUP_BY_SUMMARY_PROVIDER, (Object)_810_SortableGroupByFilterColumnGroupAndFreezeExample.this.sumMoneySummaryProvider, "NORMAL", "GROUP_BY_COLUMN_3");
                } else {
                    configRegistry.registerConfigAttribute(GroupByConfigAttributes.GROUP_BY_SUMMARY_PROVIDER, (Object)_810_SortableGroupByFilterColumnGroupAndFreezeExample.this.avgMoneySummaryProvider, "NORMAL", "GROUP_BY_COLUMN_3");
                }
                natTable.doCommand((ILayerCommand)new VisualRefreshCommand());
            }
        });
        Button addDynamicDataButton = new Button(buttonPanel, 8);
        addDynamicDataButton.setText("Add Data");
        addDynamicDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Address address = new Address();
                address.setStreet("Some Street");
                address.setHousenumber(42);
                address.setPostalCode(12345);
                address.setCity("In the clouds");
                Person person = new Person(42, "Ralph", "Wiggum", Person.Gender.MALE, false, new Date());
                ExtendedPersonWithAddress entry = new ExtendedPersonWithAddress(person, address, "0000", "The little Ralphy", PersonService.createRandomMoneyAmount().doubleValue(), new ArrayList(), new ArrayList());
                bodyLayerStack.getEventList().add((Object)entry);
                person = new Person(42, "Clancy", "Wiggum", Person.Gender.MALE, true, new Date());
                entry = new ExtendedPersonWithAddress(person, address, "XXXL", "It is Chief Wiggum", PersonService.createRandomMoneyAmount().doubleValue(), new ArrayList(), new ArrayList());
                bodyLayerStack.getEventList().add((Object)entry);
                person = new Person(42, "Sarah", "Wiggum", Person.Gender.FEMALE, true, new Date());
                entry = new ExtendedPersonWithAddress(person, address, "mommy", "Little Ralphy's mother", PersonService.createRandomMoneyAmount().doubleValue(), new ArrayList(), new ArrayList());
                bodyLayerStack.getEventList().add((Object)entry);
            }
        });
        ModernNatTableThemeConfiguration theme = new ModernNatTableThemeConfiguration();
        theme.addThemeExtension((IThemeExtension)new ModernGroupByThemeExtension());
        natTable.setTheme((ThemeConfiguration)theme);
        natTable.addOverlayPainter((IOverlayPainter)new NatTableBorderOverlayPainter());
        this.natTable = natTable;
        return container;
    }

    @Override
    public void onStart() {
        Properties properties = new Properties();
        try {
            System.out.println("Loading NatTable state from myState.properties");
            properties.load(new FileInputStream(new File(PROPERTIES_FILE)));
            this.natTable.loadState("", properties);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("myState.properties not found, skipping load");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onStop() {
        Properties properties = new Properties();
        this.natTable.saveState("", properties);
        try {
            System.out.println("Saving NatTable state to myState.properties");
            properties.store(new FileOutputStream(new File(PROPERTIES_FILE)), "NatTable state");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    class AverageAgeGroupBySummaryProvider
    implements IGroupBySummaryProvider<ExtendedPersonWithAddress> {
        AverageAgeGroupBySummaryProvider() {
        }

        public Object summarize(int columnIndex, List<ExtendedPersonWithAddress> children) {
            int summaryValue = 0;
            for (ExtendedPersonWithAddress child : children) {
                summaryValue += child.getAge();
            }
            return summaryValue / (children.size() > 0 ? children.size() : 1);
        }
    }

    class AverageAgeSummaryProvider
    implements ISummaryProvider {
        private IDataProvider dataProvider;

        public AverageAgeSummaryProvider(IDataProvider dataProvider) {
            this.dataProvider = dataProvider;
        }

        public Object summarize(int columnIndex) {
            double total = 0.0;
            int rowCount = this.dataProvider.getRowCount();
            int valueRows = 0;
            int rowIndex = 0;
            while (rowIndex < rowCount) {
                Object dataValue = this.dataProvider.getDataValue(columnIndex, rowIndex);
                if (dataValue instanceof Number) {
                    total += Double.parseDouble(dataValue.toString());
                    ++valueRows;
                }
                ++rowIndex;
            }
            return "Avg: " + String.format("%.2f", total / (double)valueRows);
        }
    }

    class AverageMoneyGroupBySummaryProvider
    implements IGroupBySummaryProvider<ExtendedPersonWithAddress> {
        AverageMoneyGroupBySummaryProvider() {
        }

        public Object summarize(int columnIndex, List<ExtendedPersonWithAddress> children) {
            int summaryValue = 0;
            for (ExtendedPersonWithAddress child : children) {
                summaryValue = (int)((double)summaryValue + child.getMoney());
            }
            return summaryValue / (children.size() > 0 ? children.size() : 1);
        }
    }

    class AverageMoneySummaryProvider
    implements ISummaryProvider {
        private IDataProvider dataProvider;

        public AverageMoneySummaryProvider(IDataProvider dataProvider) {
            this.dataProvider = dataProvider;
        }

        public Object summarize(int columnIndex) {
            double total = 0.0;
            int rowCount = this.dataProvider.getRowCount();
            int valueRows = 0;
            int rowIndex = 0;
            while (rowIndex < rowCount) {
                Object dataValue = this.dataProvider.getDataValue(columnIndex, rowIndex);
                if (dataValue instanceof Number) {
                    total += Double.parseDouble(dataValue.toString());
                    ++valueRows;
                }
                ++rowIndex;
            }
            return "Avg: " + String.format("%.2f", total / (double)valueRows);
        }
    }

    class BodyLayerStack<T>
    extends AbstractLayerTransform {
        private final EventList<T> eventList;
        private final SortedList<T> sortedList;
        private final FilterList<T> filterList;
        private final IDataProvider bodyDataProvider;
        private final GroupByDataLayer<T> bodyDataLayer;
        private final ColumnHideShowLayer columnHideShowLayer;
        private final SelectionLayer selectionLayer;
        private final TreeLayer treeLayer;
        private final GroupByModel groupByModel = new GroupByModel();

        public BodyLayerStack(List<T> values, IColumnPropertyAccessor<T> columnPropertyAccessor, ConfigRegistry configRegistry) {
            this.eventList = GlazedLists.eventList(values);
            TransformedList rowObjectsGlazedList = GlazedLists.threadSafeList(this.eventList);
            this.sortedList = new SortedList((EventList)rowObjectsGlazedList, null);
            this.filterList = new FilterList(this.sortedList);
            this.bodyDataLayer = new GroupByDataLayer(this.getGroupByModel(), this.filterList, columnPropertyAccessor, (IConfigRegistry)configRegistry);
            this.bodyDataProvider = this.bodyDataLayer.getDataProvider();
            GlazedListsEventLayer glazedListsEventLayer = new GlazedListsEventLayer(this.bodyDataLayer, this.filterList);
            glazedListsEventLayer.addLayerListener(new ILayerListener(){

                public void handleLayerEvent(ILayerEvent event) {
                    if (event instanceof IVisualChangeEvent) {
                        BodyLayerStack.this.bodyDataLayer.clearCache();
                    }
                }
            });
            SummaryRowLayer summaryRowLayer = new SummaryRowLayer((IUniqueIndexLayer)glazedListsEventLayer, (IConfigRegistry)configRegistry, false);
            ColumnReorderLayer columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)summaryRowLayer);
            ColumnGroupReorderLayer columnGroupReorderLayer = new ColumnGroupReorderLayer((IUniqueIndexLayer)columnReorderLayer, _810_SortableGroupByFilterColumnGroupAndFreezeExample.this.columnGroupModel);
            this.columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)columnGroupReorderLayer);
            ColumnGroupExpandCollapseLayer columnGroupExpandCollapseLayer = new ColumnGroupExpandCollapseLayer((IUniqueIndexLayer)this.columnHideShowLayer, _810_SortableGroupByFilterColumnGroupAndFreezeExample.this.columnGroupModel);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)columnGroupExpandCollapseLayer);
            this.treeLayer = new TreeLayer((IUniqueIndexLayer)this.selectionLayer, (ITreeRowModel)this.bodyDataLayer.getTreeRowModel());
            ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.treeLayer);
            viewportLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new GroupByConfigLabelModifier(this.getGroupByModel()));
            FreezeLayer freezeLayer = new FreezeLayer((IUniqueIndexLayer)this.treeLayer);
            CompositeFreezeLayer compositeFreezeLayer = new CompositeFreezeLayer(freezeLayer, viewportLayer, this.selectionLayer);
            this.setUnderlyingLayer((ILayer)compositeFreezeLayer);
        }

        public ColumnHideShowLayer getColumnHideShowLayer() {
            return this.columnHideShowLayer;
        }

        public TreeLayer getTreeLayer() {
            return this.treeLayer;
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }

        public EventList<T> getEventList() {
            return this.eventList;
        }

        public SortedList<T> getSortedList() {
            return this.sortedList;
        }

        public FilterList<T> getFilterList() {
            return this.filterList;
        }

        public IDataProvider getBodyDataProvider() {
            return this.bodyDataProvider;
        }

        public GroupByDataLayer<T> getBodyDataLayer() {
            return this.bodyDataLayer;
        }

        public GroupByModel getGroupByModel() {
            return this.groupByModel;
        }
    }
}

