/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._600_GlazedLists._603_Filter;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.ExtendedReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultIntegerDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.person.Person;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.DefaultGlazedListsFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowHeaderComposite;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowRegularExpressionConverter;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowTextCellEditor;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.TextMatchingMode;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.persistence.command.DisplayPersistenceDialogCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class _6031_GlazedListsFilterExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new _6031_GlazedListsFilterExample());
    }

    @Override
    public String getDescription() {
        return "This example shows the usage of the filter row within a grid that is using GlazedLists FilterList for filtering.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        ConfigRegistry configRegistry = new ConfigRegistry();
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday", "address.street", "address.housenumber", "address.postalCode", "address.city"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("birthday", "Birthday");
        propertyToLabelMap.put("address.street", "Street");
        propertyToLabelMap.put("address.housenumber", "Housenumber");
        propertyToLabelMap.put("address.postalCode", "Postal Code");
        propertyToLabelMap.put("address.city", "City");
        ExtendedReflectiveColumnPropertyAccessor columnPropertyAccessor = new ExtendedReflectiveColumnPropertyAccessor(propertyNames);
        BodyLayerStack bodyLayerStack = new BodyLayerStack(PersonService.getPersonsWithAddress((int)50), columnPropertyAccessor);
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, bodyLayerStack, bodyLayerStack.getSelectionLayer());
        FilterRowHeaderComposite filterRowHeaderLayer = new FilterRowHeaderComposite((IFilterStrategy)new DefaultGlazedListsFilterStrategy(bodyLayerStack.getFilterList(), (IColumnAccessor)columnPropertyAccessor, (IConfigRegistry)configRegistry), (ILayer)columnHeaderLayer, columnHeaderDataLayer.getDataProvider(), (IConfigRegistry)configRegistry);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(bodyLayerStack.getBodyDataProvider());
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, bodyLayerStack, bodyLayerStack.getSelectionLayer());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)filterRowHeaderLayer);
        GridLayer gridLayer = new GridLayer(bodyLayerStack, (ILayer)filterRowHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new FilterRowConfiguration());
        natTable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(natTable){

            protected PopupMenuBuilder createCornerMenu(NatTable natTable) {
                return super.createCornerMenu(natTable).withStateManagerMenuItemProvider();
            }
        });
        natTable.configure();
        natTable.registerCommandHandler((ILayerCommandHandler)new DisplayPersistenceDialogCommandHandler(natTable));
        return natTable;
    }

    class BodyLayerStack<T>
    extends AbstractLayerTransform {
        private final FilterList<T> filterList;
        private final IDataProvider bodyDataProvider;
        private final SelectionLayer selectionLayer;

        public BodyLayerStack(List<T> values, IColumnPropertyAccessor<T> columnPropertyAccessor) {
            EventList eventList = GlazedLists.eventList(values);
            TransformedList rowObjectsGlazedList = GlazedLists.threadSafeList((EventList)eventList);
            SortedList sortedList = new SortedList((EventList)rowObjectsGlazedList, null);
            this.filterList = new FilterList((EventList)sortedList);
            this.bodyDataProvider = new ListDataProvider(this.filterList, columnPropertyAccessor);
            DataLayer bodyDataLayer = new DataLayer(this.getBodyDataProvider());
            GlazedListsEventLayer glazedListsEventLayer = new GlazedListsEventLayer((IUniqueIndexLayer)bodyDataLayer, this.filterList);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)glazedListsEventLayer);
            ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.getSelectionLayer());
            this.setUnderlyingLayer((ILayer)viewportLayer);
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }

        public FilterList<T> getFilterList() {
            return this.filterList;
        }

        public IDataProvider getBodyDataProvider() {
            return this.bodyDataProvider;
        }
    }

    class FilterRowConfiguration
    extends AbstractRegistryConfiguration {
        FilterRowConfiguration() {
        }

        public void configureRegistry(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new FilterRowTextCellEditor(), "NORMAL", "FILTER_COLUMN_0");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.TEXT_MATCHING_MODE, (Object)TextMatchingMode.REGULAR_EXPRESSION, "NORMAL", "FILTER_COLUMN_0");
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new FilterRowRegularExpressionConverter(), "NORMAL", "FILTER_COLUMN_0");
            ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor(Arrays.asList(Person.Gender.FEMALE, Person.Gender.MALE));
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)comboBoxCellEditor, "NORMAL", "FILTER_COLUMN_2");
            comboBoxCellEditor = new ComboBoxCellEditor(Arrays.asList(Boolean.TRUE, Boolean.FALSE));
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)comboBoxCellEditor, "NORMAL", "FILTER_COLUMN_3");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, (Object)new DefaultIntegerDisplayConverter(), "NORMAL", "FILTER_COLUMN_6");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.TEXT_MATCHING_MODE, (Object)TextMatchingMode.EXACT, "NORMAL", "FILTER_COLUMN_2");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.TEXT_MATCHING_MODE, (Object)TextMatchingMode.REGULAR_EXPRESSION, "NORMAL", "FILTER_COLUMN_6");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.TEXT_DELIMITER, (Object)"&");
        }
    }
}

