/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._500_Layers._504_Viewport;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.data.ExtendedReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.GridLineCellLayerPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.print.command.MultiTurnViewportOffCommandHandler;
import org.eclipse.nebula.widgets.nattable.print.command.MultiTurnViewportOnCommandHandler;
import org.eclipse.nebula.widgets.nattable.util.ClientAreaAdapter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;
import org.eclipse.nebula.widgets.nattable.viewport.IScroller;
import org.eclipse.nebula.widgets.nattable.viewport.SliderScroller;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;

public class _5043_VerticalSplitViewportExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 400, new _5043_VerticalSplitViewportExample());
    }

    @Override
    public String getDescription() {
        return "This example shows a NatTable that contains two separately scrollable vertical split viewports.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday", "address.street", "address.housenumber", "address.postalCode", "address.city"};
        ExtendedReflectiveColumnPropertyAccessor columnPropertyAccessor = new ExtendedReflectiveColumnPropertyAccessor(propertyNames);
        ListDataProvider bodyDataProvider = new ListDataProvider(PersonService.getPersonsWithAddress((int)50), (IColumnAccessor)columnPropertyAccessor);
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        bodyDataLayer.setLayerPainter((ILayerPainter)new GridLineCellLayerPainter(false, true));
        final ViewportLayer viewportLayerTop = new ViewportLayer((IUniqueIndexLayer)bodyDataLayer);
        viewportLayerTop.setMaxRowPosition(10);
        ViewportLayer viewportLayerBottom = new ViewportLayer((IUniqueIndexLayer)bodyDataLayer);
        viewportLayerBottom.setMinRowPosition(10);
        CompositeLayer compositeLayer = new CompositeLayer(1, 2);
        compositeLayer.setChildLayer("REGION_A", (ILayer)viewportLayerTop, 0, 0);
        compositeLayer.setChildLayer("REGION_B", (ILayer)viewportLayerBottom, 0, 1);
        compositeLayer.registerCommandHandler((ILayerCommandHandler)new MultiTurnViewportOnCommandHandler(new ViewportLayer[]{viewportLayerTop, viewportLayerBottom}));
        compositeLayer.registerCommandHandler((ILayerCommandHandler)new MultiTurnViewportOffCommandHandler(new ViewportLayer[]{viewportLayerTop, viewportLayerBottom}));
        int topHeight = bodyDataLayer.getStartYOfRowPosition(2);
        ClientAreaAdapter topClientAreaAdapter = new ClientAreaAdapter(viewportLayerTop.getClientAreaProvider());
        topClientAreaAdapter.setHeight(topHeight);
        viewportLayerTop.setClientAreaProvider((IClientAreaProvider)topClientAreaAdapter);
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        NatTable natTable = new NatTable(composite, (ILayer)compositeLayer);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        natTable.setLayoutData((Object)gridData);
        this.createSplitSliders(composite, viewportLayerTop, viewportLayerBottom);
        natTable.addOverlayPainter(new IOverlayPainter(){

            public void paintOverlay(GC gc, ILayer layer) {
                Color beforeColor = gc.getForeground();
                gc.setForeground(GUIHelper.COLOR_GRAY);
                int viewportBorderY = viewportLayerTop.getHeight() - 1;
                gc.drawLine(0, viewportBorderY, layer.getWidth() - 1, viewportBorderY);
                gc.setForeground(beforeColor);
            }
        });
        return composite;
    }

    private void createSplitSliders(Composite natTableParent, final ViewportLayer top, ViewportLayer bottom) {
        Composite sliderComposite = new Composite(natTableParent, 0);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 17;
        sliderComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        sliderComposite.setLayout((Layout)gridLayout);
        Composite sliderTopComposite = new Composite(sliderComposite, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                int height = ((ClientAreaAdapter)top.getClientAreaProvider()).getHeight();
                return new Point(17, height);
            }
        };
        sliderTopComposite.setLayout((Layout)new FillLayout());
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 1;
        sliderTopComposite.setLayoutData((Object)gridData);
        Slider sliderTop = new Slider(sliderTopComposite, 512);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        sliderTop.setLayoutData((Object)gridData);
        top.setVerticalScroller((IScroller)new SliderScroller(sliderTop));
        Slider sliderBottom = new Slider(sliderComposite, 512);
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = true;
        sliderBottom.setLayoutData((Object)gridData);
        bottom.setVerticalScroller((IScroller)new SliderScroller(sliderBottom));
    }
}

