/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.ScheduledFuture;
import org.eclipse.nebula.widgets.nattable.command.DisposeResourcesCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.PropertyUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.VisualRefreshEvent;
import org.eclipse.nebula.widgets.nattable.util.Scheduler;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlazedListsEventLayer<T>
extends AbstractLayerTransform
implements IUniqueIndexLayer,
ListEventListener<T>,
PropertyChangeListener {
    private static final Scheduler scheduler = new Scheduler("GlazedListsEventLayer");
    private final IUniqueIndexLayer underlyingLayer;
    private final ScheduledFuture<?> future;
    private EventList<T> eventList;
    private boolean testMode = false;
    private boolean structuralChangeEventsToProcess = false;
    private boolean eventsToProcess = false;
    private boolean terminated;

    public GlazedListsEventLayer(IUniqueIndexLayer underlyingLayer, EventList<T> eventList) {
        super((ILayer)underlyingLayer);
        this.underlyingLayer = underlyingLayer;
        this.eventList = eventList;
        this.eventList.addListEventListener((ListEventListener)this);
        this.future = scheduler.scheduleAtFixedRate(this.getEventNotifier(), 0L, 100L);
    }

    protected Runnable getEventNotifier() {
        return new Runnable(){

            public void run() {
                if (GlazedListsEventLayer.this.eventsToProcess) {
                    Object layerEvent = GlazedListsEventLayer.this.structuralChangeEventsToProcess ? new RowStructuralRefreshEvent(GlazedListsEventLayer.this.getUnderlyingLayer()) : new VisualRefreshEvent(GlazedListsEventLayer.this.getUnderlyingLayer());
                    GlazedListsEventLayer.this.fireEventFromSWTDisplayThread((ILayerEvent)layerEvent);
                }
                GlazedListsEventLayer.this.eventsToProcess = false;
                GlazedListsEventLayer.this.structuralChangeEventsToProcess = false;
            }
        };
    }

    public void listChanged(ListEvent<T> event) {
        while (event.next()) {
            int eventType = event.getType();
            if (eventType != 0 && eventType != 2) continue;
            this.structuralChangeEventsToProcess = true;
        }
        this.eventsToProcess = true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        PropertyUpdateEvent updateEvent = new PropertyUpdateEvent((ILayer)this, event.getSource(), event.getPropertyName(), event.getOldValue(), event.getNewValue());
        this.fireEventFromSWTDisplayThread((ILayerEvent)updateEvent);
    }

    protected void fireEventFromSWTDisplayThread(final ILayerEvent event) {
        if (!this.testMode && Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    GlazedListsEventLayer.this.fireLayerEvent(event);
                }
            });
        } else {
            this.fireLayerEvent(event);
        }
    }

    public boolean doCommand(ILayerCommand command) {
        if (!this.terminated && command instanceof DisposeResourcesCommand) {
            this.terminated = true;
            scheduler.unschedule(this.future);
        }
        return super.doCommand(command);
    }

    public boolean isDisposed() {
        return this.terminated;
    }

    public void setEventList(EventList<T> newEventList) {
        this.eventList.removeListEventListener((ListEventListener)this);
        this.eventList = newEventList;
        this.eventList.addListEventListener((ListEventListener)this);
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    public int getColumnPositionByIndex(int columnIndex) {
        return this.underlyingLayer.getColumnPositionByIndex(columnIndex);
    }

    public int getRowPositionByIndex(int rowIndex) {
        return this.underlyingLayer.getRowPositionByIndex(rowIndex);
    }
}

