/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.MoveSelectionCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.MoveSelectionCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveCellSelectionCommandHandler
extends MoveSelectionCommandHandler<MoveSelectionCommand> {
    protected PositionCoordinate lastSelectedCellPosition;
    protected int newSelectedColumnPosition;
    protected int newSelectedRowPosition;

    public MoveCellSelectionCommandHandler(SelectionLayer selectionLayer) {
        super(selectionLayer);
    }

    @Override
    protected void moveLastSelectedLeft(int stepSize, boolean withShiftMask, boolean withControlMask) {
        if (this.selectionLayer.hasColumnSelection()) {
            this.lastSelectedCellPosition = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
            ILayerCell lastSelectedCell = this.selectionLayer.getCellByPosition(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition);
            int n = this.newSelectedColumnPosition = stepSize >= 0 ? lastSelectedCell.getOriginColumnPosition() - stepSize : 0;
            if (this.newSelectedColumnPosition < 0) {
                this.newSelectedColumnPosition = 0;
            }
            this.newSelectedRowPosition = this.lastSelectedCellPosition.rowPosition;
            if (this.newSelectedColumnPosition != this.lastSelectedCellPosition.columnPosition) {
                if (stepSize == -1 && !withShiftMask) {
                    this.selectionLayer.clear(false);
                }
                this.selectionLayer.selectCell(this.newSelectedColumnPosition, this.newSelectedRowPosition, withShiftMask, withControlMask);
                this.selectionLayer.fireCellSelectionEvent(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition, false, withShiftMask, withControlMask);
            }
        }
    }

    @Override
    protected void moveLastSelectedRight(int stepSize, boolean withShiftMask, boolean withControlMask) {
        if (this.selectionLayer.hasColumnSelection()) {
            this.lastSelectedCellPosition = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
            ILayerCell lastSelectedCell = this.selectionLayer.getCellByPosition(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition);
            int n = this.newSelectedColumnPosition = stepSize >= 0 ? lastSelectedCell.getOriginColumnPosition() + lastSelectedCell.getColumnSpan() - 1 + stepSize : this.selectionLayer.getColumnCount() - 1;
            if (this.newSelectedColumnPosition >= this.selectionLayer.getColumnCount()) {
                this.newSelectedColumnPosition = this.selectionLayer.getColumnCount() - 1;
            }
            this.newSelectedRowPosition = this.lastSelectedCellPosition.rowPosition;
            if (this.newSelectedColumnPosition != this.lastSelectedCellPosition.columnPosition) {
                if (stepSize == -1 && !withShiftMask) {
                    this.selectionLayer.clear(false);
                }
                this.selectionLayer.selectCell(this.newSelectedColumnPosition, this.newSelectedRowPosition, withShiftMask, withControlMask);
                this.selectionLayer.fireCellSelectionEvent(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition, false, withShiftMask, withControlMask);
            }
        }
    }

    @Override
    protected void moveLastSelectedUp(int stepSize, boolean withShiftMask, boolean withControlMask) {
        if (this.selectionLayer.hasRowSelection()) {
            this.lastSelectedCellPosition = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
            ILayerCell lastSelectedCell = this.selectionLayer.getCellByPosition(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition);
            this.newSelectedColumnPosition = this.lastSelectedCellPosition.columnPosition;
            int n = this.newSelectedRowPosition = stepSize >= 0 ? lastSelectedCell.getOriginRowPosition() - stepSize : 0;
            if (this.newSelectedRowPosition < 0) {
                this.newSelectedRowPosition = 0;
            }
            if (this.newSelectedRowPosition != this.lastSelectedCellPosition.rowPosition) {
                this.selectionLayer.selectCell(this.lastSelectedCellPosition.columnPosition, this.newSelectedRowPosition, withShiftMask, withControlMask);
                this.selectionLayer.fireCellSelectionEvent(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition, false, withShiftMask, withControlMask);
            }
        }
    }

    @Override
    protected void moveLastSelectedDown(int stepSize, boolean withShiftMask, boolean withControlMask) {
        if (this.selectionLayer.hasRowSelection()) {
            this.lastSelectedCellPosition = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
            ILayerCell lastSelectedCell = this.selectionLayer.getCellByPosition(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition);
            this.newSelectedColumnPosition = this.lastSelectedCellPosition.columnPosition;
            int n = this.newSelectedRowPosition = stepSize >= 0 ? lastSelectedCell.getOriginRowPosition() + lastSelectedCell.getRowSpan() - 1 + stepSize : this.selectionLayer.getRowCount() - 1;
            if (this.newSelectedRowPosition >= this.selectionLayer.getRowCount()) {
                this.newSelectedRowPosition = this.selectionLayer.getRowCount() - 1;
            }
            if (this.newSelectedRowPosition != this.lastSelectedCellPosition.rowPosition) {
                this.selectionLayer.selectCell(this.lastSelectedCellPosition.columnPosition, this.newSelectedRowPosition, withShiftMask, withControlMask);
                this.selectionLayer.fireCellSelectionEvent(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition, false, withShiftMask, withControlMask);
            }
        }
    }

    @Override
    public Class<MoveSelectionCommand> getCommandClass() {
        return MoveSelectionCommand.class;
    }
}

