/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.search.command;

import java.util.Comparator;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.search.strategy.ISearchStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchCommand
implements ILayerCommand {
    private ILayer context;
    private final ISearchStrategy searchStrategy;
    private final String searchText;
    private final boolean isWrapSearch;
    private final boolean isCaseSensitive;
    private final String searchDirection;
    private final Comparator<?> comparator;
    private ILayerListener searchEventListener;

    public SearchCommand(ILayer layer, ISearchStrategy searchStrategy, String searchDirection, boolean isWrapSearch, boolean isCaseSensitive, Comparator<?> comparator) {
        this(null, layer, searchStrategy, searchDirection, isWrapSearch, isCaseSensitive, comparator);
    }

    public SearchCommand(String searchText, ILayer layer, ISearchStrategy searchStrategy, String searchDirection, boolean isWrapSearch, boolean isCaseSensitive, Comparator<?> comparator) {
        this.context = layer;
        this.searchStrategy = searchStrategy;
        this.searchText = searchText;
        this.isWrapSearch = isWrapSearch;
        this.isCaseSensitive = isCaseSensitive;
        this.searchDirection = searchDirection;
        this.comparator = comparator;
    }

    protected SearchCommand(SearchCommand command) {
        this.context = command.context;
        this.searchStrategy = command.searchStrategy;
        this.searchText = command.searchText;
        this.isWrapSearch = command.isWrapSearch;
        this.isCaseSensitive = command.isCaseSensitive;
        this.searchDirection = command.searchDirection;
        this.comparator = command.comparator;
        this.searchEventListener = command.searchEventListener;
    }

    public ILayer getContext() {
        return this.context;
    }

    public ISearchStrategy getSearchStrategy() {
        return this.searchStrategy;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public String getSearchDirection() {
        return this.searchDirection;
    }

    public boolean isWrapSearch() {
        return this.isWrapSearch;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public ILayerListener getSearchEventListener() {
        return this.searchEventListener;
    }

    public void setSearchEventListener(ILayerListener listener) {
        this.searchEventListener = listener;
    }

    public Comparator<?> getComparator() {
        return this.comparator;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        this.context = targetLayer;
        return true;
    }

    @Override
    public SearchCommand cloneCommand() {
        return new SearchCommand(this);
    }
}

