/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.print;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.print.command.PrintEntireGridCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOnCommand;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class GridLayerPrinter {
    private final IConfigRegistry configRegistry;
    private final ILayer gridLayer;
    private final IClientAreaProvider originalClientAreaProvider;
    public static final int FOOTER_HEIGHT_IN_PRINTER_DPI = 300;
    final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm a");
    private final String footerDate;

    public GridLayerPrinter(GridLayer gridLayer, IConfigRegistry configRegistry) {
        this.gridLayer = gridLayer;
        this.configRegistry = configRegistry;
        this.originalClientAreaProvider = gridLayer.getClientAreaProvider();
        this.footerDate = this.dateFormat.format(new Date());
    }

    private Point computeScaleFactor(Printer printer) {
        Point screenDPI = Display.getDefault().getDPI();
        Point printerDPI = printer.getDPI();
        int scaleFactorX = printerDPI.x / screenDPI.x;
        int scaleFactorY = printerDPI.y / screenDPI.y;
        return new Point(scaleFactorX, scaleFactorY);
    }

    private Rectangle getTotalGridArea() {
        return new Rectangle(0, 0, this.gridLayer.getWidth(), this.gridLayer.getHeight());
    }

    private Point getPageCount(Printer printer) {
        Rectangle gridArea = this.getTotalGridArea();
        Rectangle printArea = GridLayerPrinter.computePrintArea(printer);
        Point scaleFactor = this.computeScaleFactor(printer);
        int numOfHorizontalPages = gridArea.width / (printArea.width / scaleFactor.x);
        int numOfVerticalPages = gridArea.height / (printArea.height / scaleFactor.y);
        return new Point(numOfHorizontalPages + 1, numOfVerticalPages + 1);
    }

    public void print(Shell shell) {
        final Printer printer = this.setupPrinter(shell);
        if (printer == null) {
            return;
        }
        this.setGridLayerSize(printer.getPrinterData());
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (printer.startJob("NatTable")) {
                    Rectangle printerClientArea = GridLayerPrinter.computePrintArea(printer);
                    Point scaleFactor = GridLayerPrinter.this.computeScaleFactor(printer);
                    Point pageCount = GridLayerPrinter.this.getPageCount(printer);
                    GC gc = new GC((Drawable)printer);
                    int currentPage = 1;
                    int verticalPageNumber = 0;
                    while (verticalPageNumber < pageCount.y) {
                        int horizontalPageNumber = 0;
                        while (horizontalPageNumber < pageCount.x) {
                            Rectangle printBounds = new Rectangle(printerClientArea.width / scaleFactor.x * horizontalPageNumber, (printerClientArea.height - 300) / scaleFactor.y * verticalPageNumber, printerClientArea.width / scaleFactor.x, (printerClientArea.height - 300) / scaleFactor.y);
                            if (GridLayerPrinter.this.shouldPrint(printer.getPrinterData(), currentPage)) {
                                printer.startPage();
                                Transform printerTransform = new Transform((Device)printer);
                                printerTransform.scale((float)scaleFactor.x, (float)scaleFactor.y);
                                printerTransform.translate((float)(printerClientArea.x / scaleFactor.x), (float)(printerClientArea.y / scaleFactor.y));
                                printerTransform.translate((float)(-1 * printBounds.x), (float)(-1 * printBounds.y));
                                gc.setTransform(printerTransform);
                                this.printGrid(gc, printBounds);
                                this.printFooter(gc, currentPage, printBounds);
                                printer.endPage();
                                printerTransform.dispose();
                            }
                            ++currentPage;
                            ++horizontalPageNumber;
                        }
                        ++verticalPageNumber;
                    }
                    printer.endJob();
                    gc.dispose();
                    printer.dispose();
                }
                GridLayerPrinter.this.restoreGridLayerState();
            }

            private void printGrid(GC gc, Rectangle printBounds) {
                GridLayerPrinter.this.gridLayer.getLayerPainter().paintLayer(GridLayerPrinter.this.gridLayer, gc, 0, 0, printBounds, GridLayerPrinter.this.configRegistry);
            }

            private void printFooter(GC gc, int totalPageCount, Rectangle printBounds) {
                gc.setForeground(Display.getCurrent().getSystemColor(2));
                gc.setBackground(Display.getCurrent().getSystemColor(1));
                gc.drawLine(printBounds.x, printBounds.y + printBounds.height + 10, printBounds.x + printBounds.width, printBounds.y + printBounds.height + 10);
                gc.drawText(String.valueOf(Messages.getString("Printer.page")) + " " + totalPageCount, printBounds.x, printBounds.y + printBounds.height + 15);
                gc.drawText(GridLayerPrinter.this.footerDate, printBounds.x + printBounds.width - 140, printBounds.y + printBounds.height + 15);
            }
        });
    }

    private boolean shouldPrint(PrinterData printerData, int totalPageCount) {
        if (printerData.scope == 1) {
            return totalPageCount >= printerData.startPage && totalPageCount <= printerData.endPage;
        }
        return true;
    }

    private Printer setupPrinter(Shell shell) {
        Printer defaultPrinter = new Printer();
        Point pageCount = this.getPageCount(defaultPrinter);
        defaultPrinter.dispose();
        PrintDialog printDialog = new PrintDialog(shell);
        printDialog.setStartPage(1);
        printDialog.setEndPage(pageCount.x * pageCount.y);
        printDialog.setScope(0);
        PrinterData printerData = printDialog.open();
        if (printerData == null) {
            return null;
        }
        return new Printer(printerData);
    }

    private void setGridLayerSize(PrinterData printerData) {
        if (printerData.scope == 2) {
            this.gridLayer.setClientAreaProvider(this.originalClientAreaProvider);
            return;
        }
        final Rectangle fullGridSize = this.getTotalGridArea();
        this.gridLayer.setClientAreaProvider(new IClientAreaProvider(){

            public Rectangle getClientArea() {
                return fullGridSize;
            }
        });
        this.gridLayer.doCommand(new PrintEntireGridCommand());
    }

    private void restoreGridLayerState() {
        this.gridLayer.setClientAreaProvider(this.originalClientAreaProvider);
        this.gridLayer.doCommand(new TurnViewportOnCommand());
    }

    private static Rectangle computePrintArea(Printer printer) {
        int bottom;
        int top;
        int right;
        Rectangle rect = printer.getClientArea();
        Rectangle trim = printer.computeTrim(0, 0, 0, 0);
        Point dpi = printer.getDPI();
        dpi.x /= 2;
        dpi.y /= 2;
        int left = trim.x + dpi.x;
        if (left < rect.x) {
            left = rect.x;
        }
        if ((right = rect.width + trim.x + trim.width - dpi.x) > rect.width) {
            right = rect.width;
        }
        if ((top = trim.y + dpi.y) < rect.y) {
            top = rect.y;
        }
        if ((bottom = rect.height + trim.y + trim.height - dpi.y) > rect.height) {
            bottom = rect.height;
        }
        return new Rectangle(left, top, right - left, bottom - top);
    }
}

