/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow.event;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowPainter;
import org.eclipse.nebula.widgets.nattable.filterrow.event.FilterRowMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.swt.events.MouseEvent;

public class ClearFilterIconMouseEventMatcher
extends FilterRowMouseEventMatcher {
    private final FilterRowPainter filterRowPainter;

    public ClearFilterIconMouseEventMatcher(FilterRowPainter filterRowPainter) {
        this.filterRowPainter = filterRowPainter;
    }

    public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
        ILayerCell cell = natTable.getCellByPosition(natTable.getColumnPositionByX(event.x), natTable.getRowPositionByY(event.y));
        if (cell == null) {
            return false;
        }
        IConfigRegistry configRegistry = natTable.getConfigRegistry();
        boolean clearFilterIconClicked = false;
        if (ObjectUtils.isNotNull(cell.getDataValue())) {
            clearFilterIconClicked = this.filterRowPainter.containsRemoveFilterImage(event.x, event.y, cell, configRegistry);
        }
        return super.matches(natTable, event, regionLabels) && clearFilterIconClicked;
    }
}

