/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.mediawiki.internal.token;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.mediawiki.MediaWikiLanguage;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElementProcessor;

public class ImageReplacementToken
extends PatternBasedElement {
    private static Pattern widthHeightPart = Pattern.compile("(\\d+)(x(\\d+))?px");
    private static Pattern altPattern = Pattern.compile("\\s*alt\\s*=\\s*(.+)");

    protected String getPattern(int groupOffset) {
        return "(?:\\[\\[(?:[Ii]mage|[Ff]ile):\\s*([^\\]\\|]+)(?:\\|(([^\\[\\]]|(\\[\\[[^\\[\\]]+\\]\\]))*))?\\]\\])";
    }

    protected int getPatternGroupCount() {
        return 4;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new ImageReplacementTokenProcessor();
    }

    private static class ImageReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private ImageReplacementTokenProcessor() {
        }

        public MediaWikiLanguage getMarkupLanguage() {
            return (MediaWikiLanguage)super.getMarkupLanguage();
        }

        public void emit() {
            String imageUrl = this.group(1);
            if (imageUrl.indexOf(47) == -1) {
                imageUrl = imageUrl.replace(' ', '_');
            }
            imageUrl = this.getMarkupLanguage().mapImageName(imageUrl);
            String optionsString = this.group(2);
            boolean thumbnail = false;
            ImageAttributes attributes = new ImageAttributes();
            if (optionsString != null) {
                String[] options = optionsString.split("\\s*\\|\\s*");
                for (int optionIndex = 0; optionIndex < options.length; ++optionIndex) {
                    String option = options[optionIndex];
                    if ("center".equals(option)) {
                        attributes.setAlign(ImageAttributes.Align.Middle);
                        continue;
                    }
                    if ("left".equals(option)) {
                        attributes.setAlign(ImageAttributes.Align.Left);
                        continue;
                    }
                    if ("right".equals(option)) {
                        attributes.setAlign(ImageAttributes.Align.Right);
                        continue;
                    }
                    if ("none".equals(option)) {
                        attributes.setAlign(null);
                        continue;
                    }
                    if ("thumb".equals(option) || "thumbnail".equals(option)) {
                        thumbnail = true;
                        continue;
                    }
                    Matcher matcher = widthHeightPart.matcher(option);
                    if (matcher.matches()) {
                        try {
                            String sizePart = matcher.group(1);
                            String heightPart = matcher.group(3);
                            int size = Integer.parseInt(sizePart);
                            attributes.setWidth(size);
                            if (heightPart == null) continue;
                            int height = Integer.parseInt(heightPart);
                            attributes.setHeight(height);
                        }
                        catch (NumberFormatException sizePart) {}
                        continue;
                    }
                    if ("frameless".equals(option)) {
                        attributes.setBorder(0);
                        continue;
                    }
                    if ("frame".equals(option)) {
                        attributes.setBorder(1);
                        continue;
                    }
                    Matcher altMatcher = altPattern.matcher(option);
                    if (altMatcher.matches()) {
                        attributes.setAlt(altMatcher.group(1));
                        continue;
                    }
                    if (optionIndex == options.length - 1) {
                        attributes.setTitle(option);
                        continue;
                    }
                    attributes.setAlt(option);
                }
            }
            if (thumbnail) {
                String caption = attributes.getTitle();
                attributes.setTitle(null);
                Attributes outerDivAttributes = new Attributes(null, "thumb", null, null);
                if (attributes.getAlign() != null) {
                    outerDivAttributes.appendCssClass(attributes.getAlign().name().toLowerCase());
                }
                this.builder.beginBlock(DocumentBuilder.BlockType.DIV, outerDivAttributes);
                Attributes thumbInnerDivAttributes = new Attributes(null, "thumbinner", attributes.getWidth() > 0 ? String.format("width:%spx;", attributes.getWidth() + 2) : null, null);
                this.builder.beginBlock(DocumentBuilder.BlockType.DIV, thumbInnerDivAttributes);
                LinkAttributes linkAttributes = new LinkAttributes();
                linkAttributes.setCssClass("image");
                attributes.appendCssClass("thumbimage");
                this.builder.imageLink((Attributes)linkAttributes, (Attributes)attributes, imageUrl, imageUrl);
                if (caption != null) {
                    this.builder.beginBlock(DocumentBuilder.BlockType.DIV, new Attributes(null, "thumbcaption", null, null));
                    this.markupLanguage.emitMarkupText(this.parser, this.state, caption);
                    this.builder.endBlock();
                }
                this.builder.endBlock();
                this.builder.endBlock();
            } else {
                this.builder.image((Attributes)attributes, imageUrl);
            }
        }
    }
}

