/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.net.UrlEscapers;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Characters;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Cursor;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Link;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.SourceSpan;

public class AutoLinkWithoutDemarcationSpan
extends SourceSpan {
    private final Pattern linkPattern = Pattern.compile("(https?://[a-zA-Z0-9%._~!$&?#'()*+,;:@/=-]*[a-zA-Z0-9_~!$&?#'(*+@/=-]).*", 32);

    @Override
    public Optional<? extends Inline> createInline(Cursor cursor) {
        Matcher matcher;
        if (cursor.getChar() == 'h' && (matcher = cursor.matcher(this.linkPattern)).matches()) {
            String href;
            String link = href = matcher.group(1);
            int endOffset = cursor.getOffset(matcher.end(1));
            int linkLength = endOffset - cursor.getOffset();
            return Optional.of((Object)new Link(cursor.getLineAtOffset(), cursor.getOffset(), linkLength, this.escapeUri(link), null, (List<Inline>)ImmutableList.of((Object)new Characters(cursor.getLineAtOffset(), cursor.getOffset(), linkLength, href))));
        }
        return Optional.absent();
    }

    private String escapeUri(String link) {
        return UrlEscapers.urlFragmentEscaper().escape(link).replace("%23", "#").replace("%25", "%");
    }
}

