/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.web;

import com.google.common.base.Objects;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.mwe2.runtime.Mandatory;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.util.XtextVersion;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xtext.generator.AbstractXtextGeneratorFragment;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.Issues;
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming;
import org.eclipse.xtext.xtext.generator.model.FileAccessFactory;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.TextFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.model.XtendFileAccess;
import org.eclipse.xtext.xtext.generator.model.project.IWebProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.IXtextProjectConfig;
import org.eclipse.xtext.xtext.generator.parser.antlr.ContentAssistGrammarNaming;
import org.eclipse.xtext.xtext.generator.util.BooleanGeneratorOption;
import org.eclipse.xtext.xtext.generator.util.GeneratorOption;
import org.eclipse.xtext.xtext.generator.util.GrammarUtil2;
import org.eclipse.xtext.xtext.generator.web.RegexpExtensions;
import org.eclipse.xtext.xtext.generator.xbase.XbaseUsageDetector;

public class WebIntegrationFragment
extends AbstractXtextGeneratorFragment {
    private static final String REQUIREJS_VERSION = "2.1.20";
    private static final String REQUIREJS_TEXT_VERSION = "2.0.14";
    private static final String JQUERY_VERSION = "2.1.4";
    private static final String ACE_VERSION = "1.2.0";
    private static final String CODEMIRROR_VERSION = "5.7";
    @Inject
    private FileAccessFactory fileAccessFactory;
    @Inject
    private CodeConfig codeConfig;
    @Inject
    @Extension
    private XtextGeneratorNaming _xtextGeneratorNaming;
    @Inject
    private ContentAssistGrammarNaming caNaming;
    @Inject
    @Extension
    private XbaseUsageDetector _xbaseUsageDetector;
    private final HashSet<String> enabledPatterns = new HashSet();
    private final HashSet<String> suppressedPatterns = new HashSet();
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final GeneratorOption<Framework> framework = new GeneratorOption();
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final BooleanGeneratorOption generateJsHighlighting = new BooleanGeneratorOption(true);
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final BooleanGeneratorOption generateServlet = new BooleanGeneratorOption(false);
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final BooleanGeneratorOption generateJettyLauncher = new BooleanGeneratorOption(false);
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final BooleanGeneratorOption generateWebXml = new BooleanGeneratorOption(false);
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final BooleanGeneratorOption generateHtmlExample = new BooleanGeneratorOption(false);
    private String highlightingModuleName;
    private String highlightingPath;
    private String keywordsFilter = "\\w+";
    private boolean useServlet3Api = true;
    private boolean ignoreCase = false;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String requireJsVersion = "2.1.20";
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String requireJsTextVersion = "2.0.14";
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String jQueryVersion = "2.1.4";
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String aceVersion = "1.2.0";
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String codeMirrorVersion = "5.7";
    private static final String DELIMITERS_PATTERN = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"[\\\\s.:;,!?+\\\\-*/&|<>()[\\\\]{}]");
            return _builder.toString();
        }
    }.apply();

    @Mandatory
    public void setFramework(String frameworkName) {
        String _upperCase = frameworkName.toUpperCase();
        Framework _valueOf = Framework.valueOf(_upperCase);
        this.framework.set(_valueOf);
    }

    public void setGenerateJsHighlighting(boolean generateJsHighlighting) {
        this.generateJsHighlighting.set(generateJsHighlighting);
    }

    public void setHighlightingModuleName(String moduleName) {
        this.highlightingModuleName = moduleName;
    }

    public void setHighlightingPath(String path) {
        this.highlightingPath = path;
    }

    public void setKeywordsFilter(String keywordsFilter) {
        this.keywordsFilter = keywordsFilter;
    }

    public void setGenerateServlet(boolean generateServlet) {
        this.generateServlet.set(generateServlet);
    }

    public void setGenerateWebXml(boolean generateWebXml) {
        this.generateWebXml.set(generateWebXml);
    }

    public void setUseServlet3Api(boolean useServlet3Api) {
        this.useServlet3Api = useServlet3Api;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setGenerateJettyLauncher(boolean generateJettyLauncher) {
        this.generateJettyLauncher.set(generateJettyLauncher);
    }

    public void setGenerateHtmlExample(boolean generateHtmlExample) {
        this.generateHtmlExample.set(generateHtmlExample);
    }

    public void addEnablePattern(String pattern) {
        this.enabledPatterns.add(pattern);
    }

    public void addSuppressPattern(String pattern) {
        this.suppressedPatterns.add(pattern);
    }

    protected TypeReference getServerLauncherClass(Grammar grammar) {
        String _webBasePackage = this._xtextGeneratorNaming.getWebBasePackage(grammar);
        String _plus = String.valueOf(_webBasePackage) + ".";
        String _plus_1 = String.valueOf(_plus) + "ServerLauncher";
        return new TypeReference(_plus_1);
    }

    protected TypeReference getServletClass(Grammar grammar) {
        String _webBasePackage = this._xtextGeneratorNaming.getWebBasePackage(grammar);
        String _plus = String.valueOf(_webBasePackage) + ".";
        String _simpleName = GrammarUtil.getSimpleName((Grammar)grammar);
        String _plus_1 = String.valueOf(_plus) + _simpleName;
        String _plus_2 = String.valueOf(_plus_1) + "Servlet";
        return new TypeReference(_plus_2);
    }

    @Override
    public void checkConfiguration(Issues issues) {
        boolean _not;
        super.checkConfiguration(issues);
        boolean _isSet = this.framework.isSet();
        boolean bl = _not = !_isSet;
        if (_not) {
            issues.addError("The property 'framework' is required.");
        }
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                return WebIntegrationFragment.this.suppressedPatterns.contains(it);
            }
        };
        Iterable _filter = IterableExtensions.filter(this.enabledPatterns, (Functions.Function1)_function);
        for (String pattern : _filter) {
            issues.addError("The pattern '" + pattern + "' cannot be enabled and suppressed.");
        }
    }

    @Override
    public void generate() {
        StringConcatenationClient _client;
        IXtextProjectConfig _projectConfig_4;
        IWebProjectConfig _web_4;
        IXtextGeneratorFileSystemAccess _assets_2;
        boolean _tripleNotEquals_4;
        IXtextProjectConfig _projectConfig_3;
        IWebProjectConfig _web_3;
        IXtextGeneratorFileSystemAccess _assets_1;
        boolean _tripleNotEquals_3;
        IXtextProjectConfig _projectConfig_2;
        IWebProjectConfig _web_2;
        IXtextGeneratorFileSystemAccess _src_1;
        boolean _tripleNotEquals_2;
        IXtextProjectConfig _projectConfig_1;
        IWebProjectConfig _web_1;
        IXtextGeneratorFileSystemAccess _src;
        boolean _tripleNotEquals_1;
        IXtextProjectConfig _projectConfig;
        IWebProjectConfig _web;
        IXtextGeneratorFileSystemAccess _assets;
        boolean _tripleNotEquals;
        boolean _endsWith;
        boolean _and = false;
        _and = this.highlightingModuleName == null ? false : (_endsWith = this.highlightingModuleName.endsWith(".js"));
        if (_and) {
            String _substring;
            int _length = this.highlightingModuleName.length();
            int _minus = _length - 3;
            this.highlightingModuleName = _substring = this.highlightingModuleName.substring(0, _minus);
        }
        IXtextGeneratorLanguage _language = this.getLanguage();
        List<String> _fileExtensions = _language.getFileExtensions();
        String langId = (String)IterableExtensions.head(_fileExtensions);
        String _elvis = null;
        if (this.highlightingModuleName != null) {
            _elvis = this.highlightingModuleName;
        } else {
            String _switchResult = null;
            Framework _get = this.framework.get();
            if (_get != null) {
                switch (_get) {
                    case ORION: {
                        _switchResult = "xtext-resources/generated/" + langId + "-syntax";
                        break;
                    }
                    case ACE: 
                    case CODEMIRROR: {
                        _switchResult = "xtext-resources/generated/mode-" + langId;
                        break;
                    }
                }
            }
            _elvis = _switchResult;
        }
        String hlModName = _elvis;
        boolean _and_1 = false;
        boolean _get_1 = this.generateJsHighlighting.get();
        _and_1 = !_get_1 ? false : (_tripleNotEquals = (_assets = (_web = (_projectConfig = this.getProjectConfig()).getWeb()).getAssets()) != null);
        if (_and_1) {
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.highlightingPath);
            if (_isNullOrEmpty) {
                this.highlightingPath = String.valueOf(hlModName) + ".js";
            }
            this.generateJsHighlighting(langId);
        }
        boolean _and_2 = false;
        boolean _get_2 = this.generateServlet.get();
        _and_2 = !_get_2 ? false : (_tripleNotEquals_1 = (_src = (_web_1 = (_projectConfig_1 = this.getProjectConfig()).getWeb()).getSrc()) != null);
        if (_and_2) {
            this.generateServlet();
        }
        boolean _and_3 = false;
        boolean _get_3 = this.generateJettyLauncher.get();
        _and_3 = !_get_3 ? false : (_tripleNotEquals_2 = (_src_1 = (_web_2 = (_projectConfig_2 = this.getProjectConfig()).getWeb()).getSrc()) != null);
        if (_and_3) {
            this.generateServerLauncher();
        }
        boolean _and_4 = false;
        boolean _get_4 = this.generateHtmlExample.get();
        _and_4 = !_get_4 ? false : (_tripleNotEquals_3 = (_assets_1 = (_web_3 = (_projectConfig_3 = this.getProjectConfig()).getWeb()).getAssets()) != null);
        if (_and_4) {
            this.generateIndexDoc(hlModName);
            this.generateStyleSheet();
        }
        boolean _and_5 = false;
        boolean _get_5 = this.generateWebXml.get();
        _and_5 = !_get_5 ? false : (_tripleNotEquals_4 = (_assets_2 = (_web_4 = (_projectConfig_4 = this.getProjectConfig()).getWeb()).getAssets()) != null);
        if (_and_5) {
            this.generateWebXml();
        }
        StringConcatenationClient lexerStatement = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"binder.bind(");
                TypeReference _typeRef = TypeReference.typeRef("org.eclipse.xtext.ide.editor.contentassist.antlr.internal.Lexer", new TypeReference[0]);
                _builder.append((Object)_typeRef, "");
                _builder.append((Object)".class).annotatedWith(");
                _builder.append(Names.class, "");
                _builder.append((Object)".named(");
                TypeReference _typeRef_1 = TypeReference.typeRef("org.eclipse.xtext.ide.LexerIdeBindings", new TypeReference[0]);
                _builder.append((Object)_typeRef_1, "");
                _builder.append((Object)".CONTENT_ASSIST)).to(");
                Grammar _grammar = WebIntegrationFragment.this.getGrammar();
                TypeReference _lexerClass = WebIntegrationFragment.this.caNaming.getLexerClass(_grammar);
                _builder.append((Object)_lexerClass, "");
                _builder.append((Object)".class);");
            }
        };
        GuiceModuleAccess.BindingFactory _bindingFactory = new GuiceModuleAccess.BindingFactory();
        GuiceModuleAccess.BindingFactory _addConfiguredBinding = _bindingFactory.addConfiguredBinding("ContentAssistLexer", lexerStatement);
        TypeReference _typeRef = TypeReference.typeRef("org.eclipse.xtext.ide.editor.contentassist.antlr.IContentAssistParser", new TypeReference[0]);
        Grammar _grammar = this.getGrammar();
        TypeReference _parserClass = this.caNaming.getParserClass(_grammar);
        GuiceModuleAccess.BindingFactory _addTypeToType = _addConfiguredBinding.addTypeToType(_typeRef, _parserClass);
        IXtextGeneratorLanguage _language_1 = this.getLanguage();
        GuiceModuleAccess _webGenModule = _language_1.getWebGenModule();
        _addTypeToType.contributeTo(_webGenModule);
    }

    protected void generateJsHighlighting(final String langId) {
        Grammar _grammar = this.getGrammar();
        Set allKeywords = GrammarUtil.getAllKeywords((Grammar)_grammar);
        final ArrayList wordKeywords = CollectionLiterals.newArrayList((Object[])new String[0]);
        final ArrayList nonWordKeywords = CollectionLiterals.newArrayList((Object[])new String[0]);
        final Pattern keywordsFilterPattern = Pattern.compile(this.keywordsFilter);
        final Pattern wordKeywordPattern = Pattern.compile("\\w(.*\\w)?");
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                Matcher _matcher = keywordsFilterPattern.matcher(it);
                return _matcher.matches();
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)allKeywords, (Functions.Function1)_function);
        Procedures.Procedure1<String> _function_1 = new Procedures.Procedure1<String>(){

            public void apply(String it) {
                Matcher _matcher = wordKeywordPattern.matcher(it);
                boolean _matches = _matcher.matches();
                if (_matches) {
                    wordKeywords.add(it);
                } else {
                    nonWordKeywords.add(it);
                }
            }
        };
        IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function_1);
        Collections.sort(wordKeywords);
        Collections.sort(nonWordKeywords);
        TextFileAccess jsFile = this.fileAccessFactory.createTextFile();
        jsFile.setPath(this.highlightingPath);
        Framework _get = this.framework.get();
        if (_get != null) {
            switch (_get) {
                case ORION: {
                    boolean _isEmpty_1;
                    boolean _not_1;
                    boolean _not;
                    final Collection<String> patterns = this.createOrionPatterns(langId, allKeywords);
                    boolean _isEmpty = wordKeywords.isEmpty();
                    boolean bl = _not = !_isEmpty;
                    if (_not) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"{name: \"keyword.");
                        _builder.append((Object)langId, "");
                        _builder.append((Object)"\", match: ");
                        CharSequence _generateKeywordsRegExp = this.generateKeywordsRegExp();
                        _builder.append((Object)_generateKeywordsRegExp, "");
                        _builder.append((Object)"}");
                        patterns.add(_builder.toString());
                    }
                    boolean bl2 = _not_1 = !(_isEmpty_1 = nonWordKeywords.isEmpty());
                    if (_not_1) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append((Object)"{name: \"keyword.extra.");
                        _builder_1.append((Object)langId, "");
                        _builder_1.append((Object)"\", match: ");
                        CharSequence _generateExtraKeywordsRegExp = this.generateExtraKeywordsRegExp();
                        _builder_1.append((Object)_generateExtraKeywordsRegExp, "");
                        _builder_1.append((Object)"}");
                        patterns.add(_builder_1.toString());
                    }
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            boolean _not;
                            _builder.append((Object)"define(");
                            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)WebIntegrationFragment.this.highlightingModuleName);
                            boolean bl = _not = !_isNullOrEmpty;
                            if (_not) {
                                _builder.append((Object)"\"");
                                _builder.append((Object)WebIntegrationFragment.this.highlightingModuleName, "");
                                _builder.append((Object)"\", ");
                            }
                            _builder.append((Object)"[], function() {");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            CharSequence _generateKeywords = WebIntegrationFragment.this.generateKeywords(wordKeywords, nonWordKeywords);
                            _builder.append((Object)_generateKeywords, "\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"return {");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"id: \"xtext.");
                            _builder.append((Object)langId, "\t\t");
                            _builder.append((Object)"\",");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"contentTypes: [\"xtext/");
                            _builder.append((Object)langId, "\t\t");
                            _builder.append((Object)"\"],");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"patterns: [");
                            _builder.newLine();
                            _builder.append((Object)"\t\t\t");
                            boolean _hasElements = false;
                            for (String pattern : patterns) {
                                if (!_hasElements) {
                                    _hasElements = true;
                                } else {
                                    _builder.appendImmediate((Object)",\n", "\t\t\t");
                                }
                                _builder.append((Object)pattern, "\t\t\t");
                            }
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"]");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"};");
                            _builder.newLine();
                            _builder.append((Object)"});");
                            _builder.newLine();
                        }
                    };
                    jsFile.setContent(_client);
                    break;
                }
                case ACE: {
                    boolean _isEmpty_3;
                    boolean _not_3;
                    boolean _not_2;
                    final Multimap<String, String> patterns_1 = this.createCodeMirrorPatterns(langId, allKeywords);
                    boolean _isEmpty_2 = wordKeywords.isEmpty();
                    boolean bl = _not_2 = !_isEmpty_2;
                    if (_not_2) {
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append((Object)"{token: \"keyword\", regex: ");
                        CharSequence _generateKeywordsRegExp_1 = this.generateKeywordsRegExp();
                        _builder_2.append((Object)_generateKeywordsRegExp_1, "");
                        _builder_2.append((Object)"}");
                        patterns_1.put((Object)"start", (Object)_builder_2.toString());
                    }
                    boolean bl3 = _not_3 = !(_isEmpty_3 = nonWordKeywords.isEmpty());
                    if (_not_3) {
                        StringConcatenation _builder_3 = new StringConcatenation();
                        _builder_3.append((Object)"{token: \"keyword\", regex: ");
                        CharSequence _generateExtraKeywordsRegExp_1 = this.generateExtraKeywordsRegExp();
                        _builder_3.append((Object)_generateExtraKeywordsRegExp_1, "");
                        _builder_3.append((Object)"}");
                        patterns_1.put((Object)"start", (Object)_builder_3.toString());
                    }
                    StringConcatenationClient _client_1 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            boolean _not;
                            _builder.append((Object)"define(");
                            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)WebIntegrationFragment.this.highlightingModuleName);
                            boolean bl = _not = !_isNullOrEmpty;
                            if (_not) {
                                _builder.append((Object)"\"");
                                _builder.append((Object)WebIntegrationFragment.this.highlightingModuleName, "");
                                _builder.append((Object)"\", ");
                            }
                            _builder.append((Object)"[\"ace/lib/oop\", \"ace/mode/text\", \"ace/mode/text_highlight_rules\"], function(oop, mText, mTextHighlightRules) {");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"var HighlightRules = function() {");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            CharSequence _generateKeywords = WebIntegrationFragment.this.generateKeywords(wordKeywords, nonWordKeywords);
                            _builder.append((Object)_generateKeywords, "\t\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"this.$rules = {");
                            _builder.newLine();
                            Set _keySet = patterns_1.keySet();
                            boolean _hasElements = false;
                            for (String state : _keySet) {
                                if (!_hasElements) {
                                    _hasElements = true;
                                } else {
                                    _builder.appendImmediate((Object)",", "\t\t\t");
                                }
                                _builder.append((Object)"\t\t\t");
                                _builder.append((Object)"\"");
                                _builder.append((Object)state, "\t\t\t");
                                _builder.append((Object)"\": [");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"\t\t\t");
                                _builder.append((Object)"\t");
                                Collection _get = patterns_1.get((Object)state);
                                boolean _hasElements_1 = false;
                                for (String rule : _get) {
                                    if (!_hasElements_1) {
                                        _hasElements_1 = true;
                                    } else {
                                        _builder.appendImmediate((Object)",\n", "\t\t\t\t");
                                    }
                                    _builder.append((Object)rule, "\t\t\t\t");
                                }
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"\t\t\t");
                                _builder.append((Object)"]");
                                _builder.newLine();
                            }
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"};");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"};");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"oop.inherits(HighlightRules, mTextHighlightRules.TextHighlightRules);");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"var Mode = function() {");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"this.HighlightRules = HighlightRules;");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"};");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"oop.inherits(Mode, mText.Mode);");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"Mode.prototype.$id = \"xtext/");
                            _builder.append((Object)langId, "\t");
                            _builder.append((Object)"\";");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"Mode.prototype.getCompletions = function(state, session, pos, prefix) {");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"return [];");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"return {");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"Mode: Mode");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"};");
                            _builder.newLine();
                            _builder.append((Object)"});");
                            _builder.newLine();
                        }
                    };
                    jsFile.setContent(_client_1);
                    break;
                }
                case CODEMIRROR: {
                    boolean _isEmpty_5;
                    boolean _not_5;
                    boolean _not_4;
                    final Multimap<String, String> patterns_2 = this.createCodeMirrorPatterns(langId, allKeywords);
                    boolean _isEmpty_4 = wordKeywords.isEmpty();
                    boolean bl = _not_4 = !_isEmpty_4;
                    if (_not_4) {
                        StringConcatenation _builder_4 = new StringConcatenation();
                        _builder_4.append((Object)"{token: \"keyword\", regex: ");
                        CharSequence _generateKeywordsRegExp_2 = this.generateKeywordsRegExp();
                        _builder_4.append((Object)_generateKeywordsRegExp_2, "");
                        _builder_4.append((Object)"}");
                        patterns_2.put((Object)"start", (Object)_builder_4.toString());
                    }
                    boolean bl4 = _not_5 = !(_isEmpty_5 = nonWordKeywords.isEmpty());
                    if (_not_5) {
                        StringConcatenation _builder_5 = new StringConcatenation();
                        _builder_5.append((Object)"{token: \"keyword\", regex: ");
                        CharSequence _generateExtraKeywordsRegExp_2 = this.generateExtraKeywordsRegExp();
                        _builder_5.append((Object)_generateExtraKeywordsRegExp_2, "");
                        _builder_5.append((Object)"}");
                        patterns_2.put((Object)"start", (Object)_builder_5.toString());
                    }
                    StringConcatenationClient _client_2 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            boolean _not;
                            _builder.append((Object)"define(");
                            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)WebIntegrationFragment.this.highlightingModuleName);
                            boolean bl = _not = !_isNullOrEmpty;
                            if (_not) {
                                _builder.append((Object)"\"");
                                _builder.append((Object)WebIntegrationFragment.this.highlightingModuleName, "");
                                _builder.append((Object)"\", ");
                            }
                            _builder.append((Object)"[\"codemirror\", \"codemirror/addon/mode/simple\"], function(CodeMirror, SimpleMode) {");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            CharSequence _generateKeywords = WebIntegrationFragment.this.generateKeywords(wordKeywords, nonWordKeywords);
                            _builder.append((Object)_generateKeywords, "\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"CodeMirror.defineSimpleMode(\"xtext/");
                            _builder.append((Object)langId, "\t");
                            _builder.append((Object)"\", {");
                            _builder.newLineIfNotEmpty();
                            Set _keySet = patterns_2.keySet();
                            boolean _hasElements = false;
                            for (String state : _keySet) {
                                if (!_hasElements) {
                                    _hasElements = true;
                                } else {
                                    _builder.appendImmediate((Object)",", "\t\t");
                                }
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)state, "\t\t");
                                _builder.append((Object)": ");
                                boolean _equals = Objects.equal((Object)state, (Object)"meta");
                                if (_equals) {
                                    _builder.append((Object)"{");
                                } else {
                                    _builder.append((Object)"[");
                                }
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"\t");
                                Collection _get = patterns_2.get((Object)state);
                                boolean _hasElements_1 = false;
                                for (String rule : _get) {
                                    if (!_hasElements_1) {
                                        _hasElements_1 = true;
                                    } else {
                                        _builder.appendImmediate((Object)",\n", "\t\t\t");
                                    }
                                    _builder.append((Object)rule, "\t\t\t");
                                }
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"\t\t");
                                boolean _equals_1 = Objects.equal((Object)state, (Object)"meta");
                                if (_equals_1) {
                                    _builder.append((Object)"}");
                                } else {
                                    _builder.append((Object)"]");
                                }
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append((Object)"\t");
                            _builder.append((Object)"});");
                            _builder.newLine();
                            _builder.append((Object)"});");
                            _builder.newLine();
                        }
                    };
                    jsFile.setContent(_client_2);
                    break;
                }
            }
        }
        IXtextProjectConfig _projectConfig = this.getProjectConfig();
        IWebProjectConfig _web = _projectConfig.getWeb();
        IXtextGeneratorFileSystemAccess _assets = _web.getAssets();
        jsFile.writeTo(_assets);
    }

    protected CharSequence generateKeywords(List<String> wordKeywords, List<String> nonWordKeywords) {
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = wordKeywords.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)"var keywords = \"");
            boolean _hasElements = false;
            for (String kw : wordKeywords) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"|", "");
                }
                boolean _and = false;
                Framework _get = this.framework.get();
                boolean _notEquals = !Objects.equal((Object)((Object)_get), (Object)((Object)Framework.CODEMIRROR));
                _and = !_notEquals ? false : this.ignoreCase;
                String _regexpString = RegexpExtensions.toRegexpString(kw, _and);
                _builder.append((Object)_regexpString, "");
            }
            _builder.append((Object)"\";");
            _builder.newLineIfNotEmpty();
        }
        boolean bl2 = _not_1 = !(_isEmpty_1 = nonWordKeywords.isEmpty());
        if (_not_1) {
            _builder.append((Object)"var extraKeywords = \"");
            boolean _hasElements_1 = false;
            for (String kw_1 : nonWordKeywords) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)"|", "");
                }
                boolean _and_1 = false;
                Framework _get_1 = this.framework.get();
                boolean _notEquals_1 = !Objects.equal((Object)((Object)_get_1), (Object)((Object)Framework.CODEMIRROR));
                _and_1 = !_notEquals_1 ? false : this.ignoreCase;
                String _regexpString_1 = RegexpExtensions.toRegexpString(kw_1, _and_1);
                _builder.append((Object)_regexpString_1, "");
            }
            _builder.append((Object)"\";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateKeywordsRegExp() {
        StringConcatenation _xifexpression = null;
        boolean _and = false;
        Framework _get = this.framework.get();
        boolean _equals = Objects.equal((Object)((Object)_get), (Object)((Object)Framework.CODEMIRROR));
        _and = !_equals ? false : this.ignoreCase;
        if (_and) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"new RegExp(\"\\\\b(?:\" + keywords + \")\\\\b\", \"gi\")");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"\"\\\\b(?:\" + keywords + \")\\\\b\"");
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    protected CharSequence generateExtraKeywordsRegExp() {
        StringConcatenation _xifexpression = null;
        boolean _and = false;
        Framework _get = this.framework.get();
        boolean _equals = Objects.equal((Object)((Object)_get), (Object)((Object)Framework.CODEMIRROR));
        _and = !_equals ? false : this.ignoreCase;
        if (_and) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"new RegExp(\"(?:^|\\\\s)(?:\" + extraKeywords + \")(?=");
            _builder.append((Object)DELIMITERS_PATTERN, "");
            _builder.append((Object)"|$)\", \"gi\")");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"\"(?:^|\\\\s)(?:\" + extraKeywords + \")(?=");
            _builder_1.append((Object)DELIMITERS_PATTERN, "");
            _builder_1.append((Object)"|$)\"");
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    protected Collection<String> createOrionPatterns(String langId, Set<String> keywords) {
        boolean _contains_30;
        Grammar _grammar = this.getGrammar();
        boolean inheritsTerminals = GrammarUtil2.inherits(_grammar, "org.eclipse.xtext.common.Terminals");
        Grammar _grammar_1 = this.getGrammar();
        boolean inheritsXbase = this._xbaseUsageDetector.inheritsXbase(_grammar_1);
        ArrayList<String> patterns = new ArrayList<String>();
        boolean _or = false;
        boolean _contains = this.enabledPatterns.contains("comment_singleLine");
        if (_contains) {
            _or = true;
        } else {
            boolean _contains_1;
            boolean _not;
            boolean _and = false;
            _and = !inheritsTerminals && !inheritsXbase ? false : (_not = !(_contains_1 = this.suppressedPatterns.contains("comment_singleLine")));
            _or = _and;
        }
        if (_or) {
            patterns.add("{include: \"orion.c-like#comment_singleLine\"}");
        }
        boolean _or_1 = false;
        boolean _contains_2 = this.enabledPatterns.contains("comment_block");
        if (_contains_2) {
            _or_1 = true;
        } else {
            boolean _contains_3;
            boolean _not_1;
            boolean _and_1 = false;
            _and_1 = !inheritsTerminals && !inheritsXbase ? false : (_not_1 = !(_contains_3 = this.suppressedPatterns.contains("comment_block")));
            _or_1 = _and_1;
        }
        if (_or_1) {
            patterns.add("{include: \"orion.c-like#comment_block\"}");
        }
        boolean _or_2 = false;
        boolean _contains_4 = this.enabledPatterns.contains("string_doubleQuote");
        if (_contains_4) {
            _or_2 = true;
        } else {
            boolean _contains_5;
            boolean _not_2;
            boolean _and_2 = false;
            _and_2 = !inheritsTerminals && !inheritsXbase ? false : (_not_2 = !(_contains_5 = this.suppressedPatterns.contains("string_doubleQuote")));
            _or_2 = _and_2;
        }
        if (_or_2) {
            patterns.add("{include: \"orion.lib#string_doubleQuote\"}");
        }
        boolean _or_3 = false;
        boolean _contains_6 = this.enabledPatterns.contains("string_singleQuote");
        if (_contains_6) {
            _or_3 = true;
        } else {
            boolean _contains_7;
            boolean _not_3;
            boolean _and_3 = false;
            _and_3 = !inheritsTerminals && !inheritsXbase ? false : (_not_3 = !(_contains_7 = this.suppressedPatterns.contains("string_singleQuote")));
            _or_3 = _and_3;
        }
        if (_or_3) {
            patterns.add("{include: \"orion.lib#string_singleQuote\"}");
        }
        boolean _or_4 = false;
        boolean _contains_8 = this.enabledPatterns.contains("number_decimal");
        if (_contains_8) {
            _or_4 = true;
        } else {
            boolean _contains_9;
            boolean _not_4;
            boolean _and_4 = false;
            _and_4 = !inheritsTerminals && !inheritsXbase ? false : (_not_4 = !(_contains_9 = this.suppressedPatterns.contains("number_decimal")));
            _or_4 = _and_4;
        }
        if (_or_4) {
            patterns.add("{include: \"orion.lib#number_decimal\"}");
        }
        boolean _or_5 = false;
        boolean _contains_10 = this.enabledPatterns.contains("number_hex");
        if (_contains_10) {
            _or_5 = true;
        } else {
            boolean _contains_11;
            boolean _not_5;
            boolean _and_5 = false;
            _and_5 = !inheritsXbase ? false : (_not_5 = !(_contains_11 = this.suppressedPatterns.contains("number_hex")));
            _or_5 = _and_5;
        }
        if (_or_5) {
            patterns.add("{include: \"orion.lib#number_hex\"}");
        }
        boolean _or_6 = false;
        boolean _contains_12 = this.enabledPatterns.contains("brace_open");
        if (_contains_12) {
            _or_6 = true;
        } else {
            boolean _contains_14;
            boolean _not_6;
            boolean _and_6 = false;
            boolean _contains_13 = keywords.contains("{");
            _and_6 = !_contains_13 ? false : (_not_6 = !(_contains_14 = this.suppressedPatterns.contains("brace_open")));
            _or_6 = _and_6;
        }
        if (_or_6) {
            patterns.add("{include: \"orion.lib#brace_open\"}");
        }
        boolean _or_7 = false;
        boolean _contains_15 = this.enabledPatterns.contains("brace_close");
        if (_contains_15) {
            _or_7 = true;
        } else {
            boolean _contains_17;
            boolean _not_7;
            boolean _and_7 = false;
            boolean _contains_16 = keywords.contains("}");
            _and_7 = !_contains_16 ? false : (_not_7 = !(_contains_17 = this.suppressedPatterns.contains("brace_close")));
            _or_7 = _and_7;
        }
        if (_or_7) {
            patterns.add("{include: \"orion.lib#brace_close\"}");
        }
        boolean _or_8 = false;
        boolean _contains_18 = this.enabledPatterns.contains("bracket_open");
        if (_contains_18) {
            _or_8 = true;
        } else {
            boolean _contains_20;
            boolean _not_8;
            boolean _and_8 = false;
            boolean _contains_19 = keywords.contains("[");
            _and_8 = !_contains_19 ? false : (_not_8 = !(_contains_20 = this.suppressedPatterns.contains("bracket_open")));
            _or_8 = _and_8;
        }
        if (_or_8) {
            patterns.add("{include: \"orion.lib#bracket_open\"}");
        }
        boolean _or_9 = false;
        boolean _contains_21 = this.enabledPatterns.contains("bracket_close");
        if (_contains_21) {
            _or_9 = true;
        } else {
            boolean _contains_23;
            boolean _not_9;
            boolean _and_9 = false;
            boolean _contains_22 = keywords.contains("]");
            _and_9 = !_contains_22 ? false : (_not_9 = !(_contains_23 = this.suppressedPatterns.contains("bracket_close")));
            _or_9 = _and_9;
        }
        if (_or_9) {
            patterns.add("{include: \"orion.lib#bracket_close\"}");
        }
        boolean _or_10 = false;
        boolean _contains_24 = this.enabledPatterns.contains("parenthesis_open");
        if (_contains_24) {
            _or_10 = true;
        } else {
            boolean _contains_26;
            boolean _not_10;
            boolean _and_10 = false;
            boolean _contains_25 = keywords.contains("(");
            _and_10 = !_contains_25 ? false : (_not_10 = !(_contains_26 = this.suppressedPatterns.contains("parenthesis_open")));
            _or_10 = _and_10;
        }
        if (_or_10) {
            patterns.add("{include: \"orion.lib#parenthesis_open\"}");
        }
        boolean _or_11 = false;
        boolean _contains_27 = this.enabledPatterns.contains("parenthesis_close");
        if (_contains_27) {
            _or_11 = true;
        } else {
            boolean _contains_29;
            boolean _not_11;
            boolean _and_11 = false;
            boolean _contains_28 = keywords.contains(")");
            _and_11 = !_contains_28 ? false : (_not_11 = !(_contains_29 = this.suppressedPatterns.contains("parenthesis_close")));
            _or_11 = _and_11;
        }
        if (_or_11) {
            patterns.add("{include: \"orion.lib#parenthesis_close\"}");
        }
        if (_contains_30 = this.enabledPatterns.contains("doc_block")) {
            patterns.add("{include: \"orion.lib#doc_block\"}");
        }
        return patterns;
    }

    protected Multimap<String, String> createCodeMirrorPatterns(String langId, Set<String> keywords) {
        boolean _containsKey;
        Grammar _grammar = this.getGrammar();
        boolean inheritsTerminals = GrammarUtil2.inherits(_grammar, "org.eclipse.xtext.common.Terminals");
        Grammar _grammar_1 = this.getGrammar();
        boolean inheritsXbase = this._xbaseUsageDetector.inheritsXbase(_grammar_1);
        LinkedHashMultimap patterns = LinkedHashMultimap.create();
        boolean _or = false;
        boolean _contains = this.enabledPatterns.contains("comment_singleLine");
        if (_contains) {
            _or = true;
        } else {
            boolean _contains_1;
            boolean _not;
            boolean _and = false;
            _and = !inheritsTerminals && !inheritsXbase ? false : (_not = !(_contains_1 = this.suppressedPatterns.contains("comment_singleLine")));
            _or = _and;
        }
        boolean hasSingleLineComment = _or;
        if (hasSingleLineComment) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"{token: \"comment\", regex: \"\\\\/\\\\/.*$\"}");
            patterns.put((Object)"start", (Object)_builder.toString());
        }
        boolean _or_1 = false;
        boolean _contains_2 = this.enabledPatterns.contains("comment_block");
        if (_contains_2) {
            _or_1 = true;
        } else {
            boolean _contains_3;
            boolean _not_1;
            boolean _and_1 = false;
            _and_1 = !inheritsTerminals && !inheritsXbase ? false : (_not_1 = !(_contains_3 = this.suppressedPatterns.contains("comment_block")));
            _or_1 = _and_1;
        }
        if (_or_1) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"{token: \"comment\", regex: \"\\\\/\\\\*\", next : \"comment\"}");
            patterns.put((Object)"start", (Object)_builder_1.toString());
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append((Object)"{token: \"comment\", regex: \".*?\\\\*\\\\/\", next : \"start\"}");
            patterns.put((Object)"comment", (Object)_builder_2.toString());
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append((Object)"{token: \"comment\", regex: \".+\"}");
            patterns.put((Object)"comment", (Object)_builder_3.toString());
        }
        boolean _or_2 = false;
        boolean _contains_4 = this.enabledPatterns.contains("string_doubleQuote");
        if (_contains_4) {
            _or_2 = true;
        } else {
            boolean _contains_5;
            boolean _not_2;
            boolean _and_2 = false;
            _and_2 = !inheritsTerminals && !inheritsXbase ? false : (_not_2 = !(_contains_5 = this.suppressedPatterns.contains("string_doubleQuote")));
            _or_2 = _and_2;
        }
        if (_or_2) {
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append((Object)"{token: \"string\", regex: '[\"](?:(?:\\\\\\\\.)|(?:[^\"\\\\\\\\]))*?[\"]'}");
            patterns.put((Object)"start", (Object)_builder_4.toString());
        }
        boolean _or_3 = false;
        boolean _contains_6 = this.enabledPatterns.contains("string_singleQuote");
        if (_contains_6) {
            _or_3 = true;
        } else {
            boolean _contains_7;
            boolean _not_3;
            boolean _and_3 = false;
            _and_3 = !inheritsTerminals && !inheritsXbase ? false : (_not_3 = !(_contains_7 = this.suppressedPatterns.contains("string_singleQuote")));
            _or_3 = _and_3;
        }
        if (_or_3) {
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append((Object)"{token: \"string\", regex: \"['](?:(?:\\\\\\\\.)|(?:[^'\\\\\\\\]))*?[']\"}");
            patterns.put((Object)"start", (Object)_builder_5.toString());
        }
        boolean _or_4 = false;
        boolean _contains_8 = this.enabledPatterns.contains("number_decimal");
        if (_contains_8) {
            _or_4 = true;
        } else {
            boolean _contains_9;
            boolean _not_4;
            boolean _and_4 = false;
            _and_4 = !inheritsTerminals && !inheritsXbase ? false : (_not_4 = !(_contains_9 = this.suppressedPatterns.contains("number_decimal")));
            _or_4 = _and_4;
        }
        if (_or_4) {
            StringConcatenation _builder_6 = new StringConcatenation();
            _builder_6.append((Object)"{token: \"constant.numeric\", regex: \"[+-]?\\\\d+(?:(?:\\\\.\\\\d*)?(?:[eE][+-]?\\\\d+)?)?\\\\b\"}");
            patterns.put((Object)"start", (Object)_builder_6.toString());
        }
        boolean _or_5 = false;
        boolean _contains_10 = this.enabledPatterns.contains("number_hex");
        if (_contains_10) {
            _or_5 = true;
        } else {
            boolean _contains_11;
            boolean _not_5;
            boolean _and_5 = false;
            _and_5 = !inheritsXbase ? false : (_not_5 = !(_contains_11 = this.suppressedPatterns.contains("number_hex")));
            _or_5 = _and_5;
        }
        if (_or_5) {
            StringConcatenation _builder_7 = new StringConcatenation();
            _builder_7.append((Object)"{token: \"constant.numeric\", regex: \"0[xX][0-9a-fA-F]+\\\\b\"}");
            patterns.put((Object)"start", (Object)_builder_7.toString());
        }
        boolean _or_6 = false;
        boolean _contains_12 = this.enabledPatterns.contains("bracket_open");
        if (_contains_12) {
            _or_6 = true;
        } else {
            boolean _contains_14;
            boolean _not_6;
            boolean _and_6 = false;
            boolean _contains_13 = keywords.contains("[");
            _and_6 = !_contains_13 ? false : (_not_6 = !(_contains_14 = this.suppressedPatterns.contains("bracket_open")));
            _or_6 = _and_6;
        }
        boolean bracketOpen = _or_6;
        boolean _or_7 = false;
        boolean _contains_15 = this.enabledPatterns.contains("parenthesis_open");
        if (_contains_15) {
            _or_7 = true;
        } else {
            boolean _contains_17;
            boolean _not_7;
            boolean _and_7 = false;
            boolean _contains_16 = keywords.contains("(");
            _and_7 = !_contains_16 ? false : (_not_7 = !(_contains_17 = this.suppressedPatterns.contains("parenthesis_open")));
            _or_7 = _and_7;
        }
        boolean parenOpen = _or_7;
        boolean _or_8 = false;
        boolean _contains_18 = this.enabledPatterns.contains("brace_open");
        if (_contains_18) {
            _or_8 = true;
        } else {
            boolean _contains_20;
            boolean _not_8;
            boolean _and_8 = false;
            boolean _contains_19 = keywords.contains("{");
            _and_8 = !_contains_19 ? false : (_not_8 = !(_contains_20 = this.suppressedPatterns.contains("brace_open")));
            _or_8 = _and_8;
        }
        boolean braceOpen = _or_8;
        boolean _or_9 = false;
        _or_9 = bracketOpen || parenOpen ? true : braceOpen;
        if (_or_9) {
            StringConcatenation _builder_8 = new StringConcatenation();
            _builder_8.append((Object)"{token: \"lparen\", regex: \"[");
            if (bracketOpen) {
                _builder_8.append((Object)"\\\\[");
            }
            if (parenOpen) {
                _builder_8.append((Object)"(");
            }
            if (braceOpen) {
                _builder_8.append((Object)"{");
            }
            _builder_8.append((Object)"]\"}");
            patterns.put((Object)"start", (Object)_builder_8.toString());
        }
        boolean _or_10 = false;
        boolean _contains_21 = this.enabledPatterns.contains("bracket_close");
        if (_contains_21) {
            _or_10 = true;
        } else {
            boolean _contains_23;
            boolean _not_9;
            boolean _and_9 = false;
            boolean _contains_22 = keywords.contains("]");
            _and_9 = !_contains_22 ? false : (_not_9 = !(_contains_23 = this.suppressedPatterns.contains("bracket_close")));
            _or_10 = _and_9;
        }
        boolean bracketClose = _or_10;
        boolean _or_11 = false;
        boolean _contains_24 = this.enabledPatterns.contains("parenthesis_close");
        if (_contains_24) {
            _or_11 = true;
        } else {
            boolean _contains_26;
            boolean _not_10;
            boolean _and_10 = false;
            boolean _contains_25 = keywords.contains(")");
            _and_10 = !_contains_25 ? false : (_not_10 = !(_contains_26 = this.suppressedPatterns.contains("parenthesis_close")));
            _or_11 = _and_10;
        }
        boolean parenClose = _or_11;
        boolean _or_12 = false;
        boolean _contains_27 = this.enabledPatterns.contains("brace_close");
        if (_contains_27) {
            _or_12 = true;
        } else {
            boolean _contains_29;
            boolean _not_11;
            boolean _and_11 = false;
            boolean _contains_28 = keywords.contains("}");
            _and_11 = !_contains_28 ? false : (_not_11 = !(_contains_29 = this.suppressedPatterns.contains("brace_close")));
            _or_12 = _and_11;
        }
        boolean braceClose = _or_12;
        boolean _or_13 = false;
        _or_13 = bracketClose || parenClose ? true : braceClose;
        if (_or_13) {
            StringConcatenation _builder_9 = new StringConcatenation();
            _builder_9.append((Object)"{token: \"rparen\", regex: \"[");
            if (bracketClose) {
                _builder_9.append((Object)"\\\\]");
            }
            if (parenClose) {
                _builder_9.append((Object)")");
            }
            if (braceClose) {
                _builder_9.append((Object)"}");
            }
            _builder_9.append((Object)"]\"}");
            patterns.put((Object)"start", (Object)_builder_9.toString());
        }
        boolean _and_12 = false;
        Framework _get = this.framework.get();
        boolean _equals = Objects.equal((Object)((Object)_get), (Object)((Object)Framework.CODEMIRROR));
        _and_12 = !_equals ? false : (_containsKey = patterns.containsKey((Object)"comment"));
        if (_and_12) {
            StringConcatenation _builder_10 = new StringConcatenation();
            _builder_10.append((Object)"dontIndentStates: [\"comment\"]");
            patterns.put((Object)"meta", (Object)_builder_10.toString());
        }
        boolean _and_13 = false;
        Framework _get_1 = this.framework.get();
        boolean _equals_1 = Objects.equal((Object)((Object)_get_1), (Object)((Object)Framework.CODEMIRROR));
        _and_13 = !_equals_1 ? false : hasSingleLineComment;
        if (_and_13) {
            StringConcatenation _builder_11 = new StringConcatenation();
            _builder_11.append((Object)"lineComment: \"//\"");
            patterns.put((Object)"meta", (Object)_builder_11.toString());
        }
        return patterns;
    }

    protected void generateIndexDoc(final String hlModName) {
        IXtextProjectConfig _projectConfig = this.getProjectConfig();
        IWebProjectConfig _web = _projectConfig.getWeb();
        IXtextGeneratorFileSystemAccess _assets = _web.getAssets();
        boolean _isFile = _assets.isFile("index.html");
        if (_isFile) {
            return;
        }
        TextFileAccess indexFile = this.fileAccessFactory.createTextFile();
        indexFile.setPath("index.html");
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"<html>");
                _builder.newLine();
                _builder.append((Object)"<head>");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"<meta http-equiv=\"Content-Language\" content=\"en-us\">");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"<title>Example Web Editor</title>");
                _builder.newLine();
                Framework _get = (Framework)((Object)WebIntegrationFragment.this.framework.get());
                boolean _equals = Objects.equal((Object)((Object)_get), (Object)((Object)Framework.ORION));
                if (_equals) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<link rel=\"stylesheet\" type=\"text/css\" href=\"orion/code_edit/built-codeEdit.css\"/>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<link rel=\"stylesheet\" type=\"text/css\" href=\"xtext/");
                    XtextVersion _xtextVersion = WebIntegrationFragment.this.codeConfig.getXtextVersion();
                    _builder.append((Object)_xtextVersion, "\t");
                    _builder.append((Object)"/xtext-orion.css\"/>");
                    _builder.newLineIfNotEmpty();
                } else {
                    Framework _get_1 = (Framework)((Object)WebIntegrationFragment.this.framework.get());
                    boolean _equals_1 = Objects.equal((Object)((Object)_get_1), (Object)((Object)Framework.ACE));
                    if (_equals_1) {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"<link rel=\"stylesheet\" type=\"text/css\" href=\"xtext/");
                        XtextVersion _xtextVersion_1 = WebIntegrationFragment.this.codeConfig.getXtextVersion();
                        _builder.append((Object)_xtextVersion_1, "\t");
                        _builder.append((Object)"/xtext-ace.css\"/>");
                        _builder.newLineIfNotEmpty();
                    } else {
                        Framework _get_2 = (Framework)((Object)WebIntegrationFragment.this.framework.get());
                        boolean _equals_2 = Objects.equal((Object)((Object)_get_2), (Object)((Object)Framework.CODEMIRROR));
                        if (_equals_2) {
                            _builder.append((Object)"\t");
                            _builder.append((Object)"<link rel=\"stylesheet\" type=\"text/css\" href=\"webjars/codemirror/");
                            _builder.append((Object)WebIntegrationFragment.this.codeMirrorVersion, "\t");
                            _builder.append((Object)"/lib/codemirror.css\"/>");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"<link rel=\"stylesheet\" type=\"text/css\" href=\"webjars/codemirror/");
                            _builder.append((Object)WebIntegrationFragment.this.codeMirrorVersion, "\t");
                            _builder.append((Object)"/addon/hint/show-hint.css\"/>");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"<link rel=\"stylesheet\" type=\"text/css\" href=\"xtext/");
                            XtextVersion _xtextVersion_2 = WebIntegrationFragment.this.codeConfig.getXtextVersion();
                            _builder.append((Object)_xtextVersion_2, "\t");
                            _builder.append((Object)"/xtext-codemirror.css\"/>");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"<link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\"/>");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"<script src=\"webjars/requirejs/");
                _builder.append((Object)WebIntegrationFragment.this.requireJsVersion, "\t");
                _builder.append((Object)"/require.min.js\"></script>");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"<script type=\"text/javascript\">");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"var baseUrl = window.location.pathname;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"var fileIndex = baseUrl.indexOf(\"index.html\");");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (fileIndex > 0)");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"baseUrl = baseUrl.slice(0, fileIndex);");
                _builder.newLine();
                Framework _get_3 = (Framework)((Object)WebIntegrationFragment.this.framework.get());
                boolean _equals_3 = Objects.equal((Object)((Object)_get_3), (Object)((Object)Framework.ORION));
                if (_equals_3) {
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"require.config({");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"baseUrl: baseUrl,");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"paths: {");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\"text\": \"webjars/requirejs-text/");
                    _builder.append((Object)WebIntegrationFragment.this.requireJsTextVersion, "\t\t\t\t");
                    _builder.append((Object)"/text\",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\"jquery\": \"webjars/jquery/");
                    _builder.append((Object)WebIntegrationFragment.this.jQueryVersion, "\t\t\t\t");
                    _builder.append((Object)"/jquery.min\",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\"xtext/xtext-orion\": \"xtext/");
                    XtextVersion _xtextVersion_3 = WebIntegrationFragment.this.codeConfig.getXtextVersion();
                    _builder.append((Object)_xtextVersion_3, "\t\t\t\t");
                    _builder.append((Object)"/xtext-orion\"");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"});");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"require([\"orion/code_edit/built-codeEdit-amd\"], function() {");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"require([\"xtext/xtext-orion\"], function(xtext) {");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"xtext.createEditor({");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"baseUrl: baseUrl,");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"syntaxDefinition: \"");
                    String _xifexpression = null;
                    boolean _get_4 = WebIntegrationFragment.this.generateJsHighlighting.get();
                    _xifexpression = _get_4 ? hlModName : "none";
                    _builder.append((Object)_xifexpression, "\t\t\t\t\t");
                    _builder.append((Object)"\"");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"});");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"});");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"});");
                    _builder.newLine();
                } else {
                    Framework _get_5 = (Framework)((Object)WebIntegrationFragment.this.framework.get());
                    boolean _equals_4 = Objects.equal((Object)((Object)_get_5), (Object)((Object)Framework.ACE));
                    if (_equals_4) {
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"require.config({");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"baseUrl: baseUrl,");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"paths: {");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\"jquery\": \"webjars/jquery/");
                        _builder.append((Object)WebIntegrationFragment.this.jQueryVersion, "\t\t\t\t");
                        _builder.append((Object)"/jquery.min\",");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\"ace/ext/language_tools\": \"webjars/ace/");
                        _builder.append((Object)WebIntegrationFragment.this.aceVersion, "\t\t\t\t");
                        _builder.append((Object)"/src/ext-language_tools\",");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\"xtext/xtext-ace\": \"xtext/");
                        XtextVersion _xtextVersion_4 = WebIntegrationFragment.this.codeConfig.getXtextVersion();
                        _builder.append((Object)_xtextVersion_4, "\t\t\t\t");
                        _builder.append((Object)"/xtext-ace\"");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"});");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"require([\"webjars/ace/");
                        _builder.append((Object)WebIntegrationFragment.this.aceVersion, "\t\t");
                        _builder.append((Object)"/src/ace\"], function() {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"require([\"xtext/xtext-ace\"], function(xtext) {");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"xtext.createEditor({");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t\t\t");
                        _builder.append((Object)"baseUrl: baseUrl,");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t\t\t");
                        _builder.append((Object)"syntaxDefinition: \"");
                        String _xifexpression_1 = null;
                        boolean _get_6 = WebIntegrationFragment.this.generateJsHighlighting.get();
                        _xifexpression_1 = _get_6 ? hlModName : "none";
                        _builder.append((Object)_xifexpression_1, "\t\t\t\t\t");
                        _builder.append((Object)"\"");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"});");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"});");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"});");
                        _builder.newLine();
                    } else {
                        Framework _get_7 = (Framework)((Object)WebIntegrationFragment.this.framework.get());
                        boolean _equals_5 = Objects.equal((Object)((Object)_get_7), (Object)((Object)Framework.CODEMIRROR));
                        if (_equals_5) {
                            boolean _not;
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"require.config({");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"baseUrl: baseUrl,");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"paths: {");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\"jquery\": \"webjars/jquery/");
                            _builder.append((Object)WebIntegrationFragment.this.jQueryVersion, "\t\t\t\t");
                            _builder.append((Object)"/jquery.min\",");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\"xtext/xtext-codemirror\": \"xtext/");
                            XtextVersion _xtextVersion_5 = WebIntegrationFragment.this.codeConfig.getXtextVersion();
                            _builder.append((Object)_xtextVersion_5, "\t\t\t\t");
                            _builder.append((Object)"/xtext-codemirror\"");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"},");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"packages: [{");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"name: \"codemirror\",");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"location: \"webjars/codemirror/");
                            _builder.append((Object)WebIntegrationFragment.this.codeMirrorVersion, "\t\t\t\t");
                            _builder.append((Object)"\",");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"main: \"lib/codemirror\"");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"}]");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"});");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"require([");
                            boolean _get_8 = WebIntegrationFragment.this.generateJsHighlighting.get();
                            if (_get_8) {
                                _builder.append((Object)"\"");
                                _builder.append((Object)hlModName, "\t\t");
                                _builder.append((Object)"\", ");
                            }
                            _builder.append((Object)"\"xtext/xtext-codemirror\"], function(");
                            boolean _get_9 = WebIntegrationFragment.this.generateJsHighlighting.get();
                            if (_get_9) {
                                _builder.append((Object)"mode, ");
                            }
                            _builder.append((Object)"xtext) {");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"xtext.createEditor({");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"baseUrl: baseUrl");
                            boolean _get_10 = WebIntegrationFragment.this.generateJsHighlighting.get();
                            boolean bl = _not = !_get_10;
                            if (_not) {
                                _builder.append((Object)",");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"syntaxDefinition: \"none\"");
                                _builder.newLine();
                            }
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"});");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"});");
                            _builder.newLine();
                        }
                    }
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"</script>");
                _builder.newLine();
                _builder.append((Object)"</head>");
                _builder.newLine();
                _builder.append((Object)"<body>");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"<div class=\"container\">");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"<div class=\"header\">");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"<h1>Example ");
                Grammar _grammar = WebIntegrationFragment.this.getGrammar();
                String _simpleName = GrammarUtil.getSimpleName((Grammar)_grammar);
                _builder.append((Object)_simpleName, "\t\t");
                _builder.append((Object)" Web Editor</h1>");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"</div>");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"<div class=\"content\">");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"<div id=\"xtext-editor\" data-editor-xtext-lang=\"");
                IXtextGeneratorLanguage _language = WebIntegrationFragment.this.getLanguage();
                List<String> _fileExtensions = _language.getFileExtensions();
                String _head = (String)IterableExtensions.head(_fileExtensions);
                _builder.append((Object)_head, "\t\t");
                _builder.append((Object)"\"></div>");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"</div>");
                _builder.newLine();
                _builder.append((Object)"</div>");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"</body>");
                _builder.newLine();
                _builder.append((Object)"</html>");
                _builder.newLine();
            }
        };
        indexFile.setContent(_client);
        IXtextProjectConfig _projectConfig_1 = this.getProjectConfig();
        IWebProjectConfig _web_1 = _projectConfig_1.getWeb();
        IXtextGeneratorFileSystemAccess _assets_1 = _web_1.getAssets();
        indexFile.writeTo(_assets_1);
    }

    protected void generateStyleSheet() {
        IXtextProjectConfig _projectConfig = this.getProjectConfig();
        IWebProjectConfig _web = _projectConfig.getWeb();
        IXtextGeneratorFileSystemAccess _assets = _web.getAssets();
        boolean _isFile = _assets.isFile("style.css");
        if (_isFile) {
            return;
        }
        TextFileAccess styleFile = this.fileAccessFactory.createTextFile();
        styleFile.setPath("style.css");
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"body {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"width: 100%;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"height: 100%;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"overflow: hidden;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"font: 16px Helvetica,sans-serif;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"a {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"color: #22a;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"text-decoration: none;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"a:hover {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"text-decoration: underline;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)".container {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"display: block;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"position: absolute;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"top: 0;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"bottom: 0;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"left: 0;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"right: 0;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"margin: 20px;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)".header {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"display: block;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"position: absolute;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"background-color: #e8e8e8;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"top: 0;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"left: 0;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"right: 0;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"height: 60px;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"padding: 10px;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)".content {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"display: block;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"position: absolute;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"top: 90px;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"bottom: 0;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"left: 0;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"width: 640px;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"#xtext-editor {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"display: block;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"position: absolute;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"top: 0;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"bottom: 0;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"left: 0;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"right: 0;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"padding: 4px;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"border: 1px solid #aaa;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                Framework _get = (Framework)((Object)WebIntegrationFragment.this.framework.get());
                boolean _equals = Objects.equal((Object)((Object)_get), (Object)((Object)Framework.ORION));
                if (_equals) {
                    _builder.newLine();
                    _builder.append((Object)"/************* Examples for custom icons *************/");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"/* For all elements of type Greeting or its subtypes */ ");
                    _builder.newLine();
                    _builder.append((Object)"/*");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)".Greeting-icon {");
                    _builder.newLine();
                    _builder.append((Object)"  \t\t");
                    _builder.append((Object)"background-image: url('images/Greeting.gif');");
                    _builder.newLine();
                    _builder.append((Object)"  \t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"/* Only in hovers */ ");
                    _builder.newLine();
                    _builder.append((Object)"/*");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)".xtext-hover .Greeting-icon {");
                    _builder.newLine();
                    _builder.append((Object)"  \t\t");
                    _builder.append((Object)"background-image: url('images/Greeting.gif');");
                    _builder.newLine();
                    _builder.append((Object)"  \t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/");
                    _builder.newLine();
                }
            }
        };
        styleFile.setContent(_client);
        IXtextProjectConfig _projectConfig_1 = this.getProjectConfig();
        IWebProjectConfig _web_1 = _projectConfig_1.getWeb();
        IXtextGeneratorFileSystemAccess _assets_1 = _web_1.getAssets();
        styleFile.writeTo(_assets_1);
    }

    protected void generateServerLauncher() {
        Grammar _grammar = this.getGrammar();
        TypeReference _serverLauncherClass = this.getServerLauncherClass(_grammar);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* This program starts an HTTP server for testing the web integration of your DSL.");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* Just execute it and point a web browser to http://localhost:8080/");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)"class ");
                Grammar _grammar = WebIntegrationFragment.this.getGrammar();
                TypeReference _serverLauncherClass = WebIntegrationFragment.this.getServerLauncherClass(_grammar);
                String _simpleName = _serverLauncherClass.getSimpleName();
                _builder.append((Object)_simpleName, "");
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"def static void main(String[] args) {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"val server = new ");
                TypeReference _typeRef = TypeReference.typeRef("org.eclipse.jetty.server.Server", new TypeReference[0]);
                _builder.append((Object)_typeRef, "\t\t");
                _builder.append((Object)"(new ");
                TypeReference _typeRef_1 = TypeReference.typeRef("java.net.InetSocketAddress", new TypeReference[0]);
                _builder.append((Object)_typeRef_1, "\t\t");
                _builder.append((Object)"('localhost', 8080))");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"server.handler = new ");
                TypeReference _typeRef_2 = TypeReference.typeRef("org.eclipse.jetty.webapp.WebAppContext", new TypeReference[0]);
                _builder.append((Object)_typeRef_2, "\t\t");
                _builder.append((Object)" => [");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"resourceBase = '");
                IXtextProjectConfig _projectConfig = WebIntegrationFragment.this.getProjectConfig();
                IWebProjectConfig _web = _projectConfig.getWeb();
                IXtextGeneratorFileSystemAccess _assets = _web.getAssets();
                String _path = _assets.getPath();
                IXtextProjectConfig _projectConfig_1 = WebIntegrationFragment.this.getProjectConfig();
                IWebProjectConfig _web_1 = _projectConfig_1.getWeb();
                IXtextGeneratorFileSystemAccess _root = _web_1.getRoot();
                String _path_1 = _root.getPath();
                String _plus = String.valueOf(_path_1) + "/";
                String _replace = _path.replace(_plus, "");
                _builder.append((Object)_replace, "\t\t\t");
                _builder.append((Object)"'");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"welcomeFiles = #[\"index.html\"]");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"contextPath = \"/\"");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"configurations = #[");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"new ");
                TypeReference _typeRef_3 = TypeReference.typeRef("org.eclipse.jetty.annotations.AnnotationConfiguration", new TypeReference[0]);
                _builder.append((Object)_typeRef_3, "\t\t\t\t");
                _builder.append((Object)",");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"new ");
                TypeReference _typeRef_4 = TypeReference.typeRef("org.eclipse.jetty.webapp.WebXmlConfiguration", new TypeReference[0]);
                _builder.append((Object)_typeRef_4, "\t\t\t\t");
                _builder.append((Object)",");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"new ");
                TypeReference _typeRef_5 = TypeReference.typeRef("org.eclipse.jetty.webapp.WebInfConfiguration", new TypeReference[0]);
                _builder.append((Object)_typeRef_5, "\t\t\t\t");
                _builder.append((Object)",");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"new ");
                TypeReference _typeRef_6 = TypeReference.typeRef("org.eclipse.jetty.webapp.MetaInfConfiguration", new TypeReference[0]);
                _builder.append((Object)_typeRef_6, "\t\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"]");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"setAttribute(");
                TypeReference _typeRef_7 = TypeReference.typeRef("org.eclipse.jetty.webapp.WebInfConfiguration", new TypeReference[0]);
                _builder.append((Object)_typeRef_7, "\t\t\t");
                _builder.append((Object)".CONTAINER_JAR_PATTERN, '.*/");
                IXtextProjectConfig _projectConfig_2 = WebIntegrationFragment.this.getProjectConfig();
                IWebProjectConfig _web_2 = _projectConfig_2.getWeb();
                String _name = _web_2.getName();
                String _replace_1 = _name.replace(".", "\\\\.");
                _builder.append((Object)_replace_1, "\t\t\t");
                _builder.append((Object)"/.*,.*\\\\.jar')");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"]");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"val log = new ");
                TypeReference _typeRef_8 = TypeReference.typeRef("org.eclipse.jetty.util.log.Slf4jLog", new TypeReference[0]);
                _builder.append((Object)_typeRef_8, "\t\t");
                _builder.append((Object)"(");
                Grammar _grammar_1 = WebIntegrationFragment.this.getGrammar();
                TypeReference _serverLauncherClass_1 = WebIntegrationFragment.this.getServerLauncherClass(_grammar_1);
                String _simpleName_1 = _serverLauncherClass_1.getSimpleName();
                _builder.append((Object)_simpleName_1, "\t\t");
                _builder.append((Object)".name)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"try {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"server.start");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"log.info('Server started ' + server.getURI + '...')");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"new Thread[");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"log.info('Press enter to stop the server...')");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"val key = System.in.read");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"if (key !== -1) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t\t");
                _builder.append((Object)"server.stop");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"} else {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t\t");
                _builder.append((Object)"log.warn('Console input is not available. In order to stop the server, you need to cancel process manually.')");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"].start");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"server.join");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"} catch (Exception exception) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"log.warn(exception.message)");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"System.exit(1)");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        XtendFileAccess _createXtendFile = this.fileAccessFactory.createXtendFile(_serverLauncherClass, _client);
        IXtextProjectConfig _projectConfig = this.getProjectConfig();
        IWebProjectConfig _web = _projectConfig.getWeb();
        IXtextGeneratorFileSystemAccess _src = _web.getSrc();
        _createXtendFile.writeTo(_src);
    }

    protected void generateServlet() {
        Grammar _grammar = this.getGrammar();
        TypeReference _servletClass = this.getServletClass(_grammar);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* Deploy this class into a servlet container to enable DSL-specific services.");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                if (WebIntegrationFragment.this.useServlet3Api) {
                    _builder.append((Object)"@");
                    TypeReference _typeReference = new TypeReference("javax.servlet.annotation.WebServlet");
                    _builder.append((Object)_typeReference, "");
                    _builder.append((Object)"(name = 'XtextServices', urlPatterns = '/xtext-service/*')");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"class ");
                Grammar _grammar = WebIntegrationFragment.this.getGrammar();
                TypeReference _servletClass = WebIntegrationFragment.this.getServletClass(_grammar);
                String _simpleName = _servletClass.getSimpleName();
                _builder.append((Object)_simpleName, "");
                _builder.append((Object)" extends ");
                TypeReference _typeRef = TypeReference.typeRef("org.eclipse.xtext.web.servlet.XtextServlet", new TypeReference[0]);
                _builder.append((Object)_typeRef, "");
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"val ");
                _builder.append(List.class, "\t");
                _builder.append((Object)"<");
                _builder.append(ExecutorService.class, "\t");
                _builder.append((Object)"> executorServices = newArrayList");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"override init() {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"super.init()");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"val ");
                _builder.append(Provider.class, "\t\t");
                _builder.append((Object)"<");
                _builder.append(ExecutorService.class, "\t\t");
                _builder.append((Object)"> executorServiceProvider = [");
                _builder.append(Executors.class, "\t\t");
                _builder.append((Object)".newCachedThreadPool => [executorServices += it]]");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"new ");
                Grammar _grammar_1 = WebIntegrationFragment.this.getGrammar();
                TypeReference _webSetup = WebIntegrationFragment.this._xtextGeneratorNaming.getWebSetup(_grammar_1);
                _builder.append((Object)_webSetup, "\t\t");
                _builder.append((Object)"(executorServiceProvider).createInjectorAndDoEMFRegistration()");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"override destroy() {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"executorServices.forEach[shutdown()]");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"executorServices.clear()");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"super.destroy()");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        XtendFileAccess _createXtendFile = this.fileAccessFactory.createXtendFile(_servletClass, _client);
        IXtextProjectConfig _projectConfig = this.getProjectConfig();
        IWebProjectConfig _web = _projectConfig.getWeb();
        IXtextGeneratorFileSystemAccess _src = _web.getSrc();
        _createXtendFile.writeTo(_src);
    }

    protected void generateWebXml() {
        IXtextProjectConfig _projectConfig = this.getProjectConfig();
        IWebProjectConfig _web = _projectConfig.getWeb();
        IXtextGeneratorFileSystemAccess _assets = _web.getAssets();
        boolean _isFile = _assets.isFile("WEB-INF/web.xml");
        if (_isFile) {
            return;
        }
        TextFileAccess xmlFile = this.fileAccessFactory.createTextFile();
        xmlFile.setPath("WEB-INF/web.xml");
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                boolean _get_1;
                _builder.append((Object)"<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                _builder.newLine();
                _builder.append((Object)"<web-app version=\"");
                if (WebIntegrationFragment.this.useServlet3Api) {
                    _builder.append((Object)"3.0");
                } else {
                    _builder.append((Object)"2.3");
                }
                _builder.append((Object)"\">");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"<display-name>Xtext Example Application</display-name>");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"<description>");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"This Example demonstrates the usage of Xtext with a servlet container.");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"</description>");
                _builder.newLine();
                boolean _get = WebIntegrationFragment.this.generateServlet.get();
                if (_get) {
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<servlet>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<servlet-name>XtextServices</servlet-name>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<description>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"Back-end for the DSL-specific services of Xtext.");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"</description>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<servlet-class>");
                    Grammar _grammar = WebIntegrationFragment.this.getGrammar();
                    TypeReference _servletClass = WebIntegrationFragment.this.getServletClass(_grammar);
                    _builder.append((Object)_servletClass, "\t\t");
                    _builder.append((Object)"</servlet-class>");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"</servlet>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<servlet-mapping>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<servlet-name>XtextServices</servlet-name>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<url-pattern>/xtext-service/*</url-pattern>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"</servlet-mapping>");
                    _builder.newLine();
                }
                if (!WebIntegrationFragment.this.useServlet3Api) {
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<servlet>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<servlet-name>XtextResourcesServlet</servlet-name>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<servlet-class>org.eclipse.xtext.web.servlet.XtextResourcesServlet</servlet-class>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"</servlet>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<servlet-mapping>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<servlet-name>XtextResourcesServlet</servlet-name>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<url-pattern>/xtext/*</url-pattern>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"</servlet-mapping>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<servlet>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<servlet-name>WebjarsServlet</servlet-name>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<servlet-class>org.webjars.servlet.WebjarsServlet</servlet-class>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"</servlet>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<servlet-mapping>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<servlet-name>WebjarsServlet</servlet-name>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<url-pattern>/webjars/*</url-pattern>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"</servlet-mapping>");
                    _builder.newLine();
                }
                if (_get_1 = WebIntegrationFragment.this.generateHtmlExample.get()) {
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<welcome-file-list>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<welcome-file>index.html</welcome-file>");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"</welcome-file-list>");
                    _builder.newLine();
                }
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"<session-config>");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"<session-timeout>30</session-timeout>");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"</session-config>");
                _builder.newLine();
                _builder.append((Object)"</web-app>");
                _builder.newLine();
            }
        };
        xmlFile.setContent(_client);
        IXtextProjectConfig _projectConfig_1 = this.getProjectConfig();
        IWebProjectConfig _web_1 = _projectConfig_1.getWeb();
        IXtextGeneratorFileSystemAccess _assets_1 = _web_1.getAssets();
        xmlFile.writeTo(_assets_1);
    }

    @Pure
    public GeneratorOption<Framework> getFramework() {
        return this.framework;
    }

    @Pure
    public BooleanGeneratorOption getGenerateJsHighlighting() {
        return this.generateJsHighlighting;
    }

    @Pure
    public BooleanGeneratorOption getGenerateServlet() {
        return this.generateServlet;
    }

    @Pure
    public BooleanGeneratorOption getGenerateJettyLauncher() {
        return this.generateJettyLauncher;
    }

    @Pure
    public BooleanGeneratorOption getGenerateWebXml() {
        return this.generateWebXml;
    }

    @Pure
    public BooleanGeneratorOption getGenerateHtmlExample() {
        return this.generateHtmlExample;
    }

    public void setRequireJsVersion(String requireJsVersion) {
        this.requireJsVersion = requireJsVersion;
    }

    public void setRequireJsTextVersion(String requireJsTextVersion) {
        this.requireJsTextVersion = requireJsTextVersion;
    }

    public void setJQueryVersion(String jQueryVersion) {
        this.jQueryVersion = jQueryVersion;
    }

    public void setAceVersion(String aceVersion) {
        this.aceVersion = aceVersion;
    }

    public void setCodeMirrorVersion(String codeMirrorVersion) {
        this.codeMirrorVersion = codeMirrorVersion;
    }

    public static enum Framework {
        ORION,
        ACE,
        CODEMIRROR;

    }
}

