/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.mwe.utils.DirectoryCleaner;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xtext.generator.IGuiceAwareGeneratorComponent;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.project.IRuntimeProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.ISubProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.IXtextProjectConfig;

public class XtextDirectoryCleaner
implements IGuiceAwareGeneratorComponent {
    @Inject
    private IXtextProjectConfig config;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean enabled = true;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean useDefaultExcludes = true;
    private List<String> excludes = CollectionLiterals.newArrayList((Object[])new String[0]);
    private List<String> extraDirectories = CollectionLiterals.newArrayList((Object[])new String[0]);

    public void addExtraDirectory(String directory) {
        this.extraDirectories.add(directory);
    }

    public void addExclude(String exclude) {
        this.excludes.add(exclude);
    }

    public void clean() {
        if (!this.enabled) {
            return;
        }
        ArrayList directories = CollectionLiterals.newArrayList((Object[])new String[0]);
        List<? extends ISubProjectConfig> _enabledProjects = this.config.getEnabledProjects();
        Functions.Function1<ISubProjectConfig, IXtextGeneratorFileSystemAccess> _function = new Functions.Function1<ISubProjectConfig, IXtextGeneratorFileSystemAccess>(){

            public IXtextGeneratorFileSystemAccess apply(ISubProjectConfig it) {
                return it.getSrcGen();
            }
        };
        List _map = ListExtensions.map(_enabledProjects, (Functions.Function1)_function);
        IRuntimeProjectConfig _runtime = this.config.getRuntime();
        IXtextGeneratorFileSystemAccess _ecoreModel = _runtime.getEcoreModel();
        Iterable _plus = Iterables.concat((Iterable)_map, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IXtextGeneratorFileSystemAccess[]{_ecoreModel})));
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)_plus);
        Functions.Function1<IXtextGeneratorFileSystemAccess, String> _function_1 = new Functions.Function1<IXtextGeneratorFileSystemAccess, String>(){

            public String apply(IXtextGeneratorFileSystemAccess it) {
                return it.getPath();
            }
        };
        Iterable _map_1 = IterableExtensions.map((Iterable)_filterNull, (Functions.Function1)_function_1);
        Functions.Function1<String, Boolean> _function_2 = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                File _file = new File(it);
                return _file.isDirectory();
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_map_1, (Functions.Function1)_function_2);
        Iterables.addAll((Collection)directories, (Iterable)_filter);
        Iterables.addAll((Collection)directories, this.extraDirectories);
        final DirectoryCleaner delegate = new DirectoryCleaner();
        delegate.setUseDefaultExcludes(this.useDefaultExcludes);
        Procedures.Procedure1<String> _function_3 = new Procedures.Procedure1<String>(){

            public void apply(String it) {
                delegate.addExclude(it);
            }
        };
        IterableExtensions.forEach(this.excludes, (Procedures.Procedure1)_function_3);
        Procedures.Procedure1<String> _function_4 = new Procedures.Procedure1<String>(){

            public void apply(String it) {
                try {
                    delegate.cleanFolder(it);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        IterableExtensions.forEach((Iterable)directories, (Procedures.Procedure1)_function_4);
    }

    @Override
    public void initialize(Injector injector) {
        injector.injectMembers((Object)this);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setUseDefaultExcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }
}

